/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeInfoOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeParser {
    private static final ParameterizedCachedValueProvider<JSRecordType, JSClass> BUILD_CLASS_PROVIDER = currentClass -> {
        JSRecordType result2 = (JSRecordType)RecursionManager.doPreventingRecursion((Object)currentClass, (boolean)false, () -> TypeScriptTypeParser.buildTypeFromClass(currentClass, false, true));
        if (result2 == null) {
            result2 = new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)currentClass, false), ContainerUtil.emptyList());
        }
        return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    };
    private static final Key<ParameterizedCachedValue<JSRecordType, JSClass>> BUILD_CLASS_CACHE_KEY = Key.create((String)"ts.create.record.cl");
    private static final Key<CachedValue<JSFunctionType>> TS_FULL_FUNCTION_CACHE_KEY = Key.create((String)"ts.fn.full.type.cache");

    @Deprecated
    @NotNull
    public static JSType buildTypeFromTypeScript(@NotNull JSTypeDeclaration type) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(0);
        }
        JSType jSType = type.getJSType();
        if (jSType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @NotNull
    public static JSType buildTypeForFunctionItem(@NotNull JSFunctionItem type, JSTypeSource source) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(2);
        }
        JSFunctionType jsType = TypeScriptTypeParser.buildFunctionType(type);
        if (((JSFunction)type).isConstructor() && jsType instanceof JSFunctionTypeImpl) {
            SmartList typeMembers = new SmartList((Object)new JSRecordTypeImpl.CallSignatureImpl(true, jsType));
            JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, (List<? extends JSRecordType.TypeMember>)typeMembers);
            if (jSRecordTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(3);
            }
            return jSRecordTypeImpl;
        }
        JSFunctionType jSFunctionType = jsType;
        if (jSFunctionType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(4);
        }
        return jSFunctionType;
    }

    @NotNull
    public static JSFunctionType buildFunctionType(@NotNull JSFunctionItem function) {
        if (function == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(5);
        }
        JSFunctionType jSFunctionType = (JSFunctionType)CachedValuesManager.getCachedValue((PsiElement)function, TS_FULL_FUNCTION_CACHE_KEY, () -> CachedValueProvider.Result.create((Object)TypeScriptTypeParser.buildFunctionTypeImpl(function), (Object[])new Object[]{function}));
        if (jSFunctionType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(6);
        }
        return jSFunctionType;
    }

    @NotNull
    private static JSFunctionType buildFunctionTypeImpl(@NotNull JSFunctionItem function) {
        if (function == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(7);
        }
        TypeScriptJSFunctionTypeImpl typeScriptJSFunctionTypeImpl = TypeScriptTypeParser.buildFunctionTypeImpl(function, function.getReturnType());
        if (typeScriptJSFunctionTypeImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(8);
        }
        return typeScriptJSFunctionTypeImpl;
    }

    static TypeScriptJSFunctionTypeImpl buildFunctionTypeImpl(@NotNull JSFunctionItem type, @Nullable JSType returnType) {
        JSClass jsClass;
        JSParameterItem[] parameters;
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(9);
        }
        SmartList decorators = new SmartList();
        for (JSParameterItem p : parameters = type.getParameters()) {
            decorators.add(p.getTypeDecorator());
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)type, true);
        JSType thisType = type instanceof TypeScriptFunction ? ((TypeScriptFunction)type).getExplicitThisType() : null;
        TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)type);
        if (typeParameters.length == 0 && type instanceof JSFunction && ((JSFunction)type).isConstructor() && (jsClass = JSUtils.getMemberContainingClass((PsiElement)type)) != null && !jsClass.isInterface()) {
            typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)jsClass);
        }
        List<TypeScriptGenericDeclarationTypeImpl> generics = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(typeParameters);
        return new TypeScriptJSFunctionTypeImpl(source, generics, (List<JSParameterTypeDecorator>)decorators, thisType, returnType);
    }

    public static void addObjectTypeProperties(@NotNull List<JSRecordType.TypeMember> typeMembers, @Nullable TypeScriptObjectType type, @Nullable JSTypeSubstitutor typeSubstitutor, boolean skipNewSignatures) {
        if (typeMembers == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(10);
        }
        if (type == null) {
            return;
        }
        Object[] candidates = type.getTypeMembers();
        List members = StreamEx.of((Object[])candidates).map(el -> TypeScriptTypeMemberParser.buildTypeMember(el, typeSubstitutor)).nonNull().toList();
        TypeScriptTypeParser.filterAndFillTypeMembers(members, typeMembers, skipNewSignatures);
    }

    private static void filterAndFillTypeMembers(@NotNull List<JSRecordType.TypeMember> candidates, @NotNull List<JSRecordType.TypeMember> result2, boolean skipNewSignatures) {
        if (candidates == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(12);
        }
        for (JSRecordType.TypeMember typeMember : candidates) {
            if (skipNewSignatures && typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)typeMember).hasNew()) continue;
            result2.add(typeMember);
        }
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(13);
        }
        if (!isStatic) {
            JSRecordType jSRecordType = (JSRecordType)CachedValuesManager.getManager((Project)clazz.getProject()).getParameterizedCachedValue((UserDataHolder)clazz, BUILD_CLASS_CACHE_KEY, BUILD_CLASS_PROVIDER, false, (Object)clazz);
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(14);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildTypeFromClass(clazz, true, true);
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(15);
        }
        return jSRecordType;
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic, boolean includeSupers) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(16);
        }
        JSRecordType type = TypeScriptTypeParser.buildTypeFromClass(clazz, isStatic, includeSupers, true, true);
        JSRecordType jSRecordType = TypeScriptTypeParser.overrideSourceForLibrarySymbols((PsiElement)clazz, type);
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(17);
        }
        return jSRecordType;
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(final @NotNull JSClass clazz, final boolean isStatic, boolean includeSupers, final boolean includeAbstractMembers, boolean includeInterfaceMembers) {
        JSType declaration;
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(18);
        }
        if (clazz instanceof TypeScriptTypeAlias && (declaration = ((TypeScriptTypeAlias)clazz).getParsedTypeDeclaration()) != null) {
            JSRecordType jSRecordType = declaration.asRecordType();
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(19);
            }
            return jSRecordType;
        }
        final JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)clazz, true);
        final ArrayList<Object> typeMembers = new ArrayList<Object>();
        if (clazz instanceof TypeScriptEnum) {
            typeMembers.add(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSNumberType(true, source, JSTypeContext.INSTANCE), (JSType)new JSStringType(true, source, JSTypeContext.INSTANCE), (PsiElement)clazz, false));
        }
        JSClassUtils.JSClassHierarchyProcessor processor = new JSClassUtils.JSClassHierarchyProcessor(){
            private boolean isFunctionProcessed = false;

            @Override
            public boolean process(@NotNull JSClass<?> currentClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements, boolean fromStaticContext, int depth) {
                if (currentClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (fromStaticContext && !isStatic) {
                    return true;
                }
                if (currentClass != clazz && TypeScriptTypeParser.isFunctionClass(currentClass)) {
                    if (this.isFunctionProcessed) {
                        return true;
                    }
                    JSRecordType recordFunction = TypeScriptUtil.getFunctionTypeMembers((PsiElement)clazz);
                    if (recordFunction != null) {
                        typeMembers.addAll(recordFunction.getTypeMembers());
                    }
                    this.isFunctionProcessed = true;
                    return true;
                }
                if (currentClass instanceof TypeScriptTypeAlias) {
                    JSRecordType recordType;
                    if ((!isStatic || fromStaticContext) && (recordType = TypeScriptUtil.getTypeAliasRecordTypeForSubstitutor((TypeScriptTypeAlias)currentClass, typeSubstitutor)) != null) {
                        TypeScriptTypeParser.filterAndFillTypeMembers(recordType.getTypeMembers(), typeMembers, fromStaticContext);
                    }
                } else if (currentClass instanceof TypeScriptInterface) {
                    if (!isStatic || fromStaticContext) {
                        TypeScriptObjectType body = ((TypeScriptInterface)currentClass).getBody();
                        TypeScriptTypeParser.addObjectTypeProperties(typeMembers, body, typeSubstitutor, fromStaticContext);
                    }
                } else {
                    String classQName;
                    for (JSElement element : currentClass.getMembers()) {
                        JSRecordType.TypeMember typeMember;
                        JSAttributeListOwner function;
                        JSAttributeList list2;
                        if (element instanceof JSAttributeListOwner && !includeAbstractMembers && (list2 = (function = (JSAttributeListOwner)element).getAttributeList()) != null && list2.hasModifier(JSAttributeList.ModifierType.ABSTRACT) || (typeMember = TypeScriptTypeMemberParser.buildTypeMemberFromClassMember(clazz, element, isStatic, source, typeSubstitutor)) == null) continue;
                        typeMembers.add(typeMember);
                    }
                    if (DialectDetector.isJavaScript(currentClass) && (classQName = currentClass.getQualifiedName()) != null) {
                        JSClassResolver.getInstance().processNamespaceMembers(classQName, clazz.getContainingFile(), true, (Processor<JSPsiElementBase>)((Processor)e -> {
                            if (e instanceof JSDefinitionExpression && e.getName() != null) {
                                typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(e.getName(), ((JSDefinitionExpression)e).getJSType(), false, false, (PsiElement)e));
                            }
                            return true;
                        }));
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "currentClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (includeSupers) {
            JSClassUtils.processClassesInHierarchy(clazz, includeInterfaceMembers, processor);
        } else {
            processor.process(clazz, JSTypeSubstitutor.EMPTY, false, false, 0);
        }
        if (!(clazz instanceof TypeScriptCompileTimeType) && isStatic) {
            boolean hasConstructor = false;
            boolean hasPrototype = false;
            for (JSRecordType.TypeMember typeMember : typeMembers) {
                if (typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)typeMember).hasNew()) {
                    hasConstructor = true;
                }
                if (!(typeMember instanceof JSRecordType.PropertySignature) || !"prototype".equals(((JSRecordType.PropertySignature)typeMember).getMemberName())) continue;
                hasPrototype = true;
            }
            if (!hasConstructor) {
                JSFunctionTypeImpl functionType = TypeScriptTypeParser.createConstructorType(clazz, source);
                typeMembers.add(new JSRecordTypeImpl.CallSignatureImpl(true, functionType));
            }
            if (!hasPrototype) {
                JSImplicitPrototypeElement property = JSClassUtils.getImplicitPrototypeProperty(clazz);
                typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(property.getName(), property.getJSType(), false, false, (PsiElement)property));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = clazz.getName() == null && !isStatic ? new JSSimpleRecordTypeImpl(source, typeMembers) : new JSRecordTypeImpl(source, typeMembers);
        if (jSRecordTypeImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(20);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    public static JSFunctionTypeImpl createConstructorType(@NotNull JSClass clazz, @NotNull JSTypeSource source) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(21);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(22);
        }
        JSType returnType = TypeScriptTypeParser.createConstructorReturnType(clazz, source);
        TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)clazz);
        if (typeParameters.length > 0) {
            List<TypeScriptGenericDeclarationTypeImpl> generics = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(typeParameters);
            TypeScriptJSFunctionTypeImpl typeScriptJSFunctionTypeImpl = new TypeScriptJSFunctionTypeImpl(source, generics, ContainerUtil.emptyList(), null, returnType);
            if (typeScriptJSFunctionTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(23);
            }
            return typeScriptJSFunctionTypeImpl;
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(source, ContainerUtil.emptyList(), returnType);
        if (jSFunctionTypeImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(24);
        }
        return jSFunctionTypeImpl;
    }

    @NotNull
    static JSType createConstructorReturnType(@NotNull JSClass clazz, @NotNull JSTypeSource source) {
        Object rawConstructorType;
        String name;
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(25);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(26);
        }
        if (StringUtil.isEmpty((String)(name = clazz.getQualifiedName()))) {
            rawConstructorType = TypeScriptTypeParser.buildTypeFromClass(clazz, false, true);
        } else {
            rawConstructorType = JSNamedTypeFactory.createType(name, source, JSContext.INSTANCE);
            TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)clazz);
            if (typeParameters.length > 0) {
                List<JSType> types2 = TypeScriptGenericTypesEvaluator.buildGenericParameters(typeParameters);
                rawConstructorType = new JSGenericTypeImpl(source, (JSType)rawConstructorType, types2);
            }
        }
        JSType mixinType = TypeScriptTypeParser.getMixinInstanceType(clazz, source);
        if (mixinType == null) {
            JSRecordType jSRecordType = rawConstructorType;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(27);
            }
            return jSRecordType;
        }
        JSType jSType = JSIntersectionTypeImpl.getIntersectionType(StreamEx.of((Object[])new JSType[]{rawConstructorType, mixinType}).nonNull().toList(), source);
        if (jSType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    @Nullable
    private static JSType getMixinInstanceType(@NotNull JSClass clazz, @NotNull JSTypeSource source) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(29);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(30);
        }
        if (!(clazz instanceof TypeScriptClass) || !ES6PsiUtil.isLocalClass(clazz)) {
            return null;
        }
        JSReferenceList list2 = clazz.getExtendsList();
        if (!(list2 instanceof ES6ReferenceList)) {
            return null;
        }
        Object[] members = list2.getMembers();
        JSReferenceListMember member = (JSReferenceListMember)ArrayUtil.getFirstElement((Object[])members);
        if (member == null) {
            return null;
        }
        ES6ReferenceListImpl.ClassExpressionResolve resolve = ES6ReferenceListImpl.resolveReferenceListMember(member);
        JSType type = resolve.constructorType;
        if (type == null || !JSTypeUtils.hasForeignGenericParameter(type)) {
            return null;
        }
        return type instanceof JSFunctionType ? JSTypeUtils.getNewOrReturnType(type, true) : new JSApplyNewType(type, source);
    }

    private static boolean isFunctionClass(JSClass<?> currentClass) {
        String fileName = currentClass.getContainingFile().getName();
        return JSCommonTypeNames.FUNCTION_CLASS_NAMES.contains(currentClass.getName()) && TypeScriptLibraryProvider.getService(currentClass.getProject()).isLibraryFileName(fileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static JSType buildTypeFromClassMember(PsiElement element) {
        if (element instanceof JSFunction) {
            if (((JSFunction)element).isGetProperty()) {
                return ((JSFunction)element).getReturnType();
            }
            if (!((JSFunction)element).isSetProperty()) return TypeScriptTypeParser.buildFunctionType((JSFunctionItem)((JSFunction)element));
            JSParameterListElement[] parameters = ((JSFunction)element).getParameters();
            if (parameters.length != 1) return null;
            return parameters[0].getSimpleType();
        }
        if (!(element instanceof JSTypeInfoOwner)) return null;
        return ((JSTypeInfoOwner)element).getJSType();
    }

    public static JSRecordType buildResolvedType(@NotNull Collection<? extends PsiElement> elements, @NotNull JSType type) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(31);
        }
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(32);
        }
        return TypeScriptTypeParser.buildResolvedType(elements, type, (Set<PsiElement>)new THashSet());
    }

    private static JSRecordType buildResolvedType(@NotNull Collection<? extends PsiElement> elements, @NotNull JSType type, @NotNull Set<PsiElement> visited) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(33);
        }
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(34);
        }
        if (visited == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(35);
        }
        boolean isStatic = type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC;
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>();
        for (PsiElement psiElement : TypeScriptTypeParser.sortElements(elements)) {
            TypeScriptTypeParser.addTypeMembersFromClass(type, isStatic, members, psiElement, visited);
        }
        return new JSRecordTypeImpl(type.getSource(), members);
    }

    @NotNull
    private static Collection<? extends PsiElement> sortElements(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(36);
        }
        if (elements.size() <= 1) {
            Collection<? extends PsiElement> collection = elements;
            if (collection == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(37);
            }
            return collection;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements.size());
        ArrayList<PsiElement> restElements = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            ArrayList<PsiElement> toAdd = psiElement instanceof JSClass && ((JSClass)psiElement).getSupers().length == 0 ? result2 : restElements;
            toAdd.add(psiElement);
        }
        result2.addAll(restElements);
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    private static JSRecordType overrideSourceForLibrarySymbols(@NotNull PsiElement context, @NotNull JSRecordType resultType) {
        if (context == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(39);
        }
        if (resultType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(40);
        }
        Set<VirtualFile> libraries = TypeScriptLibraryProvider.getAllLibraries(context.getProject());
        boolean hasSourceFromLibrary = false;
        block0: for (JSRecordType.TypeMember member : resultType.getTypeMembers()) {
            List sourceElements = member.getMemberSource().getAllSourceElements();
            for (PsiElement element : sourceElements) {
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
                if (virtualFile == null || !libraries.contains(virtualFile)) continue;
                hasSourceFromLibrary = true;
                continue block0;
            }
        }
        if (!hasSourceFromLibrary) {
            JSRecordType jSRecordType = resultType;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(41);
            }
            return jSRecordType;
        }
        JSTypeSource resultTypeSource = resultType.getSource();
        JSType candidate = JSTypeBaseImpl.replaceSourceRecursive((JSType)resultType, (Function<? super JSTypeBaseImpl, ? extends JSType>)((Function)el -> {
            if (!(el instanceof JSNamedType) && !(el instanceof JSGenericTypeImpl)) {
                return el;
            }
            if (el.getSource() == resultTypeSource) {
                return el;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)el.getSource().getSourceElement());
            if (virtualFile != null && libraries.contains(virtualFile)) {
                return el.withNewSource(resultTypeSource);
            }
            return el;
        }));
        JSRecordType jSRecordType = candidate instanceof JSRecordType ? (JSRecordType)candidate : resultType;
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(42);
        }
        return jSRecordType;
    }

    @NotNull
    public static JSRecordType buildResolvedType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(43);
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(elements, type);
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(44);
        }
        return jSRecordType;
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveElementsByType(@Nullable JSType type) {
        PsiElement originSourceElement;
        if (type == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(45);
            }
            return list2;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        if (sourceElement == null) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(46);
            }
            return list3;
        }
        if (type instanceof JSFunctionTypeImpl && sourceElement instanceof JSFunction) {
            List list4 = ContainerUtil.createMaybeSingletonList((Object)sourceElement);
            if (list4 == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(47);
            }
            return list4;
        }
        if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSFunctionTypeImpl && (originSourceElement = ((JSGenericTypeImpl)type).getType().getSource().getSourceElement()) instanceof JSFunction) {
            List list5 = ContainerUtil.createMaybeSingletonList((Object)originSourceElement);
            if (list5 == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(48);
            }
            return list5;
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, sourceElement);
        if (collection == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(49);
        }
        return collection;
    }

    private static void addTypeMembersFromClass(@NotNull JSType type, boolean isStatic, @NotNull List<JSRecordType.TypeMember> members, @NotNull PsiElement resolvedElement, @NotNull Set<PsiElement> visited) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(50);
        }
        if (members == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(51);
        }
        if (resolvedElement == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(52);
        }
        if (visited == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(53);
        }
        if (!visited.add(resolvedElement)) {
            return;
        }
        if (resolvedElement instanceof TypeScriptEnumField) {
            resolvedElement = ((TypeScriptEnumField)resolvedElement).getOwner();
        }
        if (resolvedElement instanceof JSClass) {
            boolean bl;
            if (type instanceof JSArrayType && !((JSArrayType)type).isPrimitive()) {
                type = ((JSArrayType)type).asGenericType();
            }
            JSRecordType classType = null;
            boolean bl2 = false;
            if (type instanceof JSTypeWithOuterGenerics) {
                type = ((JSTypeWithOuterGenerics)type).getType();
                bl = true;
            }
            if (type instanceof JSGenericTypeImpl) {
                classType = JSTypeCastUtil.buildWithAppliedGenericArguments((JSClass)resolvedElement, (JSGenericTypeImpl)type, bl);
            } else if (resolvedElement instanceof TypeScriptTypeAlias) {
                JSType declaration = ((TypeScriptTypeAlias)resolvedElement).getParsedTypeDeclaration();
                if (declaration instanceof JSRecordType) {
                    classType = (JSRecordType)declaration;
                } else if (declaration instanceof JSFunctionTypeImpl) {
                    classType = declaration.asRecordType();
                } else if (declaration != null) {
                    classType = TypeScriptTypeParser.buildResolvedType(TypeScriptTypeParser.resolveElementsByType(declaration), declaration, visited);
                }
            } else {
                classType = TypeScriptTypeParser.buildTypeFromClass((JSClass)resolvedElement, isStatic);
            }
            if (classType != null) {
                members.addAll(classType.getTypeMembers());
            }
        } else if (resolvedElement instanceof TypeScriptModule && isStatic) {
            JSRecordType moduleType = TypeScriptTypeParser.buildTypeForModule((TypeScriptModule)resolvedElement);
            if (moduleType != null) {
                members.addAll(moduleType.getTypeMembers());
            }
        } else if (resolvedElement instanceof JSFunction) {
            if (resolvedElement instanceof TypeScriptFunction) {
                for (JSFunctionItem jSFunctionItem : TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)resolvedElement)) {
                    members.add((JSRecordType.TypeMember)TypeScriptTypeParser.createCallSignatureForFunction(jSFunctionItem));
                }
            }
            members.add((JSRecordType.TypeMember)TypeScriptTypeParser.createCallSignatureForFunction((JSFunctionItem)((JSFunction)resolvedElement)));
        }
    }

    @NotNull
    private static JSRecordTypeImpl.CallSignatureImpl createCallSignatureForFunction(@NotNull JSFunctionItem resolvedElement) {
        if (resolvedElement == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(54);
        }
        JSRecordTypeImpl.CallSignatureImpl callSignatureImpl = new JSRecordTypeImpl.CallSignatureImpl(false, new JSFunctionTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)resolvedElement, true), TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics(resolvedElement.getParameterVariables(), null), resolvedElement.getReturnType()));
        if (callSignatureImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(55);
        }
        return callSignatureImpl;
    }

    @Nullable
    public static JSRecordType buildTypeForModule(@NotNull TypeScriptModule element) {
        if (element == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(56);
        }
        if (!element.isInstantiated()) {
            return null;
        }
        JSSourceElement[] elements = JSResolveUtil.getSourceElements((PsiElement)element);
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> typeMembers = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>();
        for (JSSourceElement sourceElement : elements) {
            if (!(sourceElement instanceof JSVarStatement) && (!(sourceElement instanceof JSElementBase) || ((JSElementBase)sourceElement).getAccessType() != JSAttributeList.AccessType.PUBLIC)) continue;
            if (sourceElement instanceof JSVarStatement) {
                for (JSVariable variable : ((JSVarStatement)sourceElement).getStubSafeVariables()) {
                    String name;
                    if (variable.getAccessType() != JSAttributeList.AccessType.PUBLIC || (name = variable.getName()) == null) continue;
                    typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(name, variable.getJSType(), false, false, (PsiElement)variable));
                }
                continue;
            }
            if (sourceElement instanceof JSFunction) {
                JSFunction function = (JSFunction)sourceElement;
                String name = function.getName();
                if (name == null) continue;
                typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(name, (JSType)TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function), false, false, (PsiElement)function));
                continue;
            }
            if (!(sourceElement instanceof JSClass)) continue;
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)sourceElement, true);
            String name = sourceElement.getName();
            if (name == null) continue;
            JSType type = JSNamedTypeFactory.createType(name, source, JSContext.STATIC);
            typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, false, (PsiElement)sourceElement));
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)element, true);
        return new JSRecordTypeImpl(source, typeMembers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMembers";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 35: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromTypeScript";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeForFunctionItem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionTypeImpl";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromClass";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorReturnType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "sortElements";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideSourceForLibrarySymbols";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "buildResolvedType";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsByType";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallSignatureForFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromTypeScript";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 55: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeForFunctionItem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionType";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addObjectTypeProperties";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterAndFillTypeMembers";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromClass";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorReturnType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMixinInstanceType";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "buildResolvedType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sortElements";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "overrideSourceForLibrarySymbols";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addTypeMembersFromClass";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createCallSignatureForFunction";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeForModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class TypeParameterGenericId
    implements JSTypeSubstitutor.JSTypeGenericId {
        @NotNull
        private final PsiElement myOwner;
        @NotNull
        private final String myName;
        @Nullable
        private final String myOwnerQName;

        public TypeParameterGenericId(@NotNull TypeScriptGenericOrMappedTypeParameter parameter, @Nullable String name) {
            if (parameter == null) {
                TypeParameterGenericId.$$$reportNull$$$0(0);
            }
            this.myName = StringUtil.notNullize((String)name);
            TypeScriptGenericOrMappedTypeParameter originalCandidate = (TypeScriptGenericOrMappedTypeParameter)CompletionUtilCoreImpl.getOriginalElement((PsiElement)parameter);
            TypeScriptGenericOrMappedTypeParameter original = originalCandidate == null ? parameter : originalCandidate;
            JSElement owner = original.getOwner();
            this.myOwner = owner == null ? original : owner;
            this.myOwnerQName = this.myOwner instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)this.myOwner).getQualifiedName() : null;
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                TypeParameterGenericId.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object candidate) {
            if (!(candidate instanceof TypeParameterGenericId)) {
                return false;
            }
            TypeParameterGenericId obj = (TypeParameterGenericId)candidate;
            if (!this.getName().equals(obj.getName())) {
                return false;
            }
            if (this.myOwner.equals(((TypeParameterGenericId)candidate).myOwner)) {
                return true;
            }
            return this.myOwnerQName != null && Objects.equals(this.myOwnerQName, ((TypeParameterGenericId)candidate).myOwnerQName);
        }

        public String toString() {
            PsiElement owner = this.myOwner;
            String name = owner instanceof PsiNamedElement ? ((PsiNamedElement)owner).getName() : owner.getClass().getSimpleName();
            return name + "@<" + this.getName() + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$TypeParameterGenericId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$TypeParameterGenericId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

