/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSTypePredicateImpl;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptAsExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParenthesesUtils {
    private static final int PARENTHESIZED_PRECEDENCE = 0;
    public static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    public static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int EXPONENTIATION_PRECEDENCE = 5;
    public static final int MULTIPLICATIVE_PRECEDENCE = 6;
    private static final int ADDITIVE_PRECEDENCE = 7;
    public static final int SHIFT_PRECEDENCE = 8;
    private static final int RELATIONAL_PRECEDENCE = 9;
    private static final int EQUALITY_PRECEDENCE = 10;
    private static final int BINARY_AND_PRECEDENCE = 11;
    private static final int BINARY_XOR_PRECEDENCE = 12;
    private static final int BINARY_OR_PRECEDENCE = 13;
    public static final int AND_PRECEDENCE = 14;
    public static final int OR_PRECEDENCE = 15;
    public static final int CONDITIONAL_PRECEDENCE = 16;
    private static final int ASSIGNMENT_PRECEDENCE = 17;
    private static final int NUM_PRECEDENCES = 18;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(18);

    private JSParenthesesUtils() {
    }

    public static int getPrecedence(JSExpression exp) {
        if (exp instanceof JSThisExpression || exp instanceof JSLiteralExpression || exp instanceof JSObjectLiteralExpression || exp instanceof JSArrayLiteralExpression || exp instanceof JSIndexedPropertyAccessExpression) {
            return 0;
        }
        if (exp instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)exp).getQualifier() != null ? 1 : 0;
        }
        if (exp instanceof JSCallExpression || exp instanceof ES6TaggedTemplateExpression) {
            return 1;
        }
        if (exp instanceof JSPrefixExpression || exp instanceof JSYieldExpression) {
            return 3;
        }
        if (exp instanceof JSPostfixExpression) {
            return 2;
        }
        if (exp instanceof TypeScriptCastExpression) {
            return exp instanceof TypeScriptAsExpression ? 9 : 4;
        }
        if (exp instanceof JSAssignmentExpression) {
            return 17;
        }
        if (exp instanceof JSBinaryExpression) {
            return JSParenthesesUtils.precedenceForBinaryOperator(((JSBinaryExpression)exp).getOperationSign());
        }
        if (exp instanceof JSConditionalExpression) {
            return 16;
        }
        if (exp instanceof JSParenthesizedExpression) {
            return 0;
        }
        return -1;
    }

    private static int precedenceForBinaryOperator(IElementType sign) {
        if (s_binaryOperatorPrecedence.containsKey(sign)) {
            return s_binaryOperatorPrecedence.get(sign);
        }
        return 17;
    }

    @Nullable
    public static JSExpression stripParentheses(@Nullable JSExpression exp) {
        return JSUtils.unparenthesize(exp);
    }

    public static String removeParentheses(@Nullable JSExpression expression) {
        if (expression instanceof JSCallExpression) {
            return JSParenthesesUtils.removeParensFromFunctionCallExpression((JSCallExpression)expression);
        }
        if (expression instanceof ES6TaggedTemplateExpression) {
            return JSParenthesesUtils.removeParensFromTaggedTemplateExpression((ES6TaggedTemplateExpression)expression);
        }
        if (expression instanceof JSReferenceExpression) {
            return JSParenthesesUtils.removeParensFromReferenceExpression((JSReferenceExpression)expression);
        }
        if (expression instanceof JSAssignmentExpression) {
            return JSParenthesesUtils.removeParensFromBinaryExpression((JSBinaryExpression)((JSAssignmentExpression)expression));
        }
        if (expression instanceof JSArrayLiteralExpression) {
            return JSParenthesesUtils.removeParensFromArrayLiteralExpression((JSArrayLiteralExpression)expression);
        }
        if (expression instanceof JSPrefixExpression) {
            return JSParenthesesUtils.removeParensFromPrefixExpression((JSPrefixExpression)expression);
        }
        if (expression instanceof JSPostfixExpression) {
            return JSParenthesesUtils.removeParensFromPostfixExpression((JSPostfixExpression)expression);
        }
        if (expression instanceof JSBinaryExpression) {
            return JSParenthesesUtils.removeParensFromBinaryExpression((JSBinaryExpression)expression);
        }
        if (expression instanceof JSConditionalExpression) {
            return JSParenthesesUtils.removeParensFromConditionalExpression((JSConditionalExpression)expression);
        }
        if (expression instanceof JSParenthesizedExpression) {
            JSExpression innerExpression = ((JSParenthesizedExpression)expression).getInnerExpression();
            if (innerExpression instanceof JSCallExpression) {
                return innerExpression.getText();
            }
            return JSParenthesesUtils.removeParensFromParenthesizedExpression((JSParenthesizedExpression)expression);
        }
        return expression == null ? "" : expression.getText();
    }

    private static String removeParensFromReferenceExpression(@NotNull JSReferenceExpression expression) {
        JSExpression qualifier;
        if (expression == null) {
            JSParenthesesUtils.$$$reportNull$$$0(0);
        }
        if ((qualifier = expression.getQualifier()) != null) {
            return JSParenthesesUtils.removeParentheses(qualifier) + '.' + expression.getReferenceName();
        }
        return expression.getText();
    }

    private static String removeParensFromParenthesizedExpression(@NotNull JSParenthesizedExpression parenthesizedExp) {
        if (parenthesizedExp == null) {
            JSParenthesesUtils.$$$reportNull$$$0(1);
        }
        if (!JSParenthesesUtils.canRemoveParentheses(parenthesizedExp)) {
            return parenthesizedExp.getText();
        }
        JSExpression body = JSParenthesesUtils.stripParentheses(parenthesizedExp.getInnerExpression());
        if (body != null) {
            return JSParenthesesUtils.removeParentheses(body);
        }
        return parenthesizedExp.getText();
    }

    private static String removeParensFromConditionalExpression(@NotNull JSConditionalExpression conditionalExp) {
        if (conditionalExp == null) {
            JSParenthesesUtils.$$$reportNull$$$0(2);
        }
        JSExpression condition = conditionalExp.getCondition();
        JSExpression thenBranch = conditionalExp.getThen();
        JSExpression elseBranch = conditionalExp.getElse();
        return JSParenthesesUtils.removeParentheses(condition) + " ? " + JSParenthesesUtils.removeParentheses(thenBranch) + " : " + JSParenthesesUtils.removeParentheses(elseBranch);
    }

    private static String removeParensFromBinaryExpression(@NotNull JSBinaryExpression binaryExp) {
        ASTNode sign;
        if (binaryExp == null) {
            JSParenthesesUtils.$$$reportNull$$$0(3);
        }
        if ((sign = binaryExp.getOperationNode()) == null) {
            return binaryExp.getText();
        }
        JSExpression lhs = binaryExp.getLOperand();
        JSExpression rhs = binaryExp.getROperand();
        return JSParenthesesUtils.removeParentheses(lhs) + ' ' + sign.getText() + ' ' + JSParenthesesUtils.removeParentheses(rhs);
    }

    private static String removeParensFromPostfixExpression(@NotNull JSPostfixExpression postfixExp) {
        ASTNode sign;
        if (postfixExp == null) {
            JSParenthesesUtils.$$$reportNull$$$0(4);
        }
        if ((sign = postfixExp.getOperationNode()) == null) {
            return postfixExp.getText();
        }
        JSExpression body = postfixExp.getExpression();
        return JSParenthesesUtils.removeParentheses(body) + sign.getText();
    }

    private static String removeParensFromPrefixExpression(@NotNull JSPrefixExpression prefixExp) {
        ASTNode signNode;
        if (prefixExp == null) {
            JSParenthesesUtils.$$$reportNull$$$0(5);
        }
        if ((signNode = prefixExp.getOperationNode()) == null) {
            return prefixExp.getText();
        }
        JSExpression body = prefixExp.getExpression();
        IElementType sign = signNode.getElementType();
        String bodyText = JSParenthesesUtils.removeParentheses(body);
        String signText = signNode.getText();
        if (sign == JSTokenTypes.TYPEOF_KEYWORD || sign == JSTokenTypes.DELETE_KEYWORD || sign == JSTokenTypes.AWAIT_KEYWORD) {
            signText = signText + " ";
        }
        return signText + bodyText;
    }

    private static String removeParensFromArrayLiteralExpression(@NotNull JSArrayLiteralExpression init) {
        if (init == null) {
            JSParenthesesUtils.$$$reportNull$$$0(6);
        }
        JSExpression[] contents = init.getExpressions();
        String text = init.getText();
        int textLength = text.length();
        StringBuilder out = new StringBuilder(textLength);
        out.append('[');
        JSParenthesesUtils.removeParenthesesFromCommaSeparatedExpressions(contents, out);
        return out.append(']').toString();
    }

    private static void removeParenthesesFromCommaSeparatedExpressions(@NotNull JSExpression[] contents, StringBuilder out) {
        if (contents == null) {
            JSParenthesesUtils.$$$reportNull$$$0(7);
        }
        for (int index = 0; index < contents.length; ++index) {
            JSExpression arg = contents[index];
            if (index != 0) {
                out.append(',');
            }
            out.append(JSParenthesesUtils.removeParentheses(arg));
        }
    }

    private static String removeParensFromFunctionCallExpression(@NotNull JSCallExpression functionCall) {
        if (functionCall == null) {
            JSParenthesesUtils.$$$reportNull$$$0(8);
        }
        JSExpression target = functionCall.getMethodExpression();
        JSExpression[] args = functionCall.getArguments();
        StringBuilder out = new StringBuilder(functionCall.getTextLength());
        String strippedTarget = JSParenthesesUtils.removeParentheses(target);
        if (functionCall instanceof JSNewExpression) {
            out.append("new ");
        }
        out.append(strippedTarget);
        out.append('(');
        JSParenthesesUtils.removeParenthesesFromCommaSeparatedExpressions(args, out);
        out.append(')');
        return out.toString();
    }

    private static String removeParensFromTaggedTemplateExpression(@NotNull ES6TaggedTemplateExpression expression) {
        JSStringTemplateExpression templateExpression;
        if (expression == null) {
            JSParenthesesUtils.$$$reportNull$$$0(9);
        }
        JSExpression target = expression.getTag();
        StringBuilder out = new StringBuilder(expression.getTextLength());
        if (target != null) {
            out.append(JSParenthesesUtils.removeParentheses(target));
        }
        if ((templateExpression = expression.getTemplateExpression()) != null) {
            out.append(templateExpression.getText());
        }
        return out.toString();
    }

    public static String getParenthesized(@NotNull JSExpression expression, int precedence) {
        if (expression == null) {
            JSParenthesesUtils.$$$reportNull$$$0(10);
        }
        return JSParenthesesUtils.getPrecedence(expression) > precedence ? '(' + expression.getText() + ')' : expression.getText();
    }

    public static boolean canRemoveParentheses(@NotNull JSParenthesizedExpression expression) {
        int childPrecedence;
        PsiElement expressionParent;
        if (expression == null) {
            JSParenthesesUtils.$$$reportNull$$$0(11);
        }
        if (!((expressionParent = expression.getParent()) instanceof JSElement) || expressionParent instanceof FlowJSTypePredicateImpl) {
            return false;
        }
        JSElement parent = (JSElement)expressionParent;
        JSExpression body = expression.getInnerExpression();
        if (body == null) {
            return false;
        }
        if (!(parent instanceof JSExpression)) {
            JSDefinitionExpression definitionExpression;
            JSAssignmentExpression assignmentExpression;
            if (body instanceof JSCallExpression && ((JSCallExpression)body).getMethodExpression() instanceof JSFunctionExpression) {
                return false;
            }
            JSAssignmentExpression jSAssignmentExpression = assignmentExpression = body instanceof JSAssignmentExpression ? (JSAssignmentExpression)body : null;
            return assignmentExpression == null || (definitionExpression = assignmentExpression.getDefinitionExpression()) == null || PsiTreeUtil.getChildOfType((PsiElement)definitionExpression, JSObjectLiteralExpression.class) == null;
        }
        if (body instanceof JSParenthesizedExpression) {
            return true;
        }
        if (parent instanceof JSFunctionExpression) {
            return !JSPsiImplUtils.parensAroundArrowFunctionBodyRequired(body);
        }
        int parentPrecedence = JSParenthesesUtils.getPrecedence((JSExpression)parent);
        if (parentPrecedence > (childPrecedence = JSParenthesesUtils.getPrecedence(body))) {
            return !(body instanceof JSFunctionExpression);
        }
        if (parentPrecedence == childPrecedence && parent instanceof JSBinaryExpression && body instanceof JSBinaryExpression) {
            IElementType parentOperator = ((JSBinaryExpression)parent).getOperationSign();
            IElementType childOperator = ((JSBinaryExpression)body).getOperationSign();
            JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
            JSExpression lhs = binaryExpression.getLOperand();
            return lhs != null && lhs.equals(expression) && Objects.equals(parentOperator, childOperator);
        }
        return false;
    }

    public static boolean needsParenthesis(@NotNull JSExpression oldExpr, @NotNull JSExpression newExpr) {
        int parentPrecedence;
        if (oldExpr == null) {
            JSParenthesesUtils.$$$reportNull$$$0(12);
        }
        if (newExpr == null) {
            JSParenthesesUtils.$$$reportNull$$$0(13);
        }
        int precedence = JSParenthesesUtils.getPrecedence(newExpr);
        PsiElement parent = oldExpr.getParent();
        if (!(parent instanceof JSExpression) || parent instanceof JSFunctionExpression) {
            return false;
        }
        if (parent instanceof JSParenthesizedExpression) {
            return false;
        }
        if (newExpr instanceof JSFunctionExpression && (parent instanceof JSCallExpression || parent instanceof JSReferenceExpression)) {
            return true;
        }
        if (parent instanceof JSDefinitionExpression) {
            parent = parent.getParent();
        }
        if (precedence > (parentPrecedence = JSParenthesesUtils.getPrecedence((JSExpression)parent))) {
            return true;
        }
        if (precedence == parentPrecedence && parent instanceof JSBinaryExpression) {
            IElementType operationSign = ((JSBinaryExpression)parent).getOperationSign();
            if (oldExpr != ((JSBinaryExpression)parent).getROperand()) {
                return false;
            }
            if (!JSTokenTypes.ASSOC_OPERATIONS.contains(operationSign)) {
                return true;
            }
            return ((JSBinaryExpression)newExpr).getOperationSign() != operationSign;
        }
        return false;
    }

    static {
        s_binaryOperatorPrecedence.put(JSTokenTypes.PLUS, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MINUS, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MULT, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.DIV, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.PERC, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MULTMULT, 5);
        s_binaryOperatorPrecedence.put(JSTokenTypes.ANDAND, 14);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OROR, 15);
        s_binaryOperatorPrecedence.put(JSTokenTypes.QUEST_QUEST, 15);
        s_binaryOperatorPrecedence.put(JSTokenTypes.AND, 11);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OR, 13);
        s_binaryOperatorPrecedence.put(JSTokenTypes.XOR, 12);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LTLT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGTGT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GT, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GE, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LT, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LE, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQ, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQEQ, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NE, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NEQEQ, 10);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesizedExp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpr";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSParenthesesUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromParenthesizedExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromConditionalExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromBinaryExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPostfixExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPrefixExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromArrayLiteralExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParenthesesFromCommaSeparatedExpressions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromFunctionCallExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromTaggedTemplateExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getParenthesized";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "canRemoveParentheses";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "needsParenthesis";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

