/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.introduceVariable.ES6IntroduceSpreadVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSCustomIntroduceVariableHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ES6IntroduceVariableFromDestructuringHandler
implements JSCustomIntroduceVariableHandler {
    private static final Function<JSVarStatement, Integer> OFFSET_GETTER = e -> Objects.requireNonNull(e.getDeclarations()[0].getInitializer()).getTextOffset();
    private static final String DEFAULT_VAR_NAME = "item";

    @Override
    public boolean isAvailableOnEditorAndFile(@NotNull Editor editor, @NotNull PsiFile file2) {
        int end;
        SelectionModel selectionModel;
        if (editor == null) {
            ES6IntroduceVariableFromDestructuringHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ES6IntroduceVariableFromDestructuringHandler.$$$reportNull$$$0(1);
        }
        if (!(selectionModel = editor.getSelectionModel()).hasSelection()) {
            return false;
        }
        int start = selectionModel.getSelectionStart();
        return (ES6IntroduceVariableFromDestructuringHandler.isAvailableFor(JSDestructuringArray.class, file2, start, end = selectionModel.getSelectionEnd()) || ES6IntroduceVariableFromDestructuringHandler.isAvailableFor(JSDestructuringObject.class, file2, start, end)) && ES6IntroduceSpreadVariableHandler.getScope(file2.findElementAt(start)) != null;
    }

    private static <T extends JSDestructuringContainer> boolean isAvailableFor(Class<T> clazz, PsiFile file2, int start, int end) {
        PsiElement parent;
        JSDestructuringContainer array = (JSDestructuringContainer)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(start), clazz, (boolean)true, (Class[])new Class[]{JSSourceElement.class});
        PsiElement psiElement = parent = array == null ? null : array.getParent();
        if (!(parent instanceof JSDestructuringElement)) {
            return false;
        }
        JSElement owner = ES6IntroduceVariableFromDestructuringHandler.getOwner(parent);
        return owner != null && new TextRange(start, end).contains(array.getTextRange());
    }

    private static JSElement getOwner(PsiElement parent) {
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSCatchBlock.class, JSDestructuringParameter.class, JSVarStatement.class});
    }

    @Override
    public void invoke(@NotNull Editor editor, @NotNull PsiFile file2) {
        SelectionModel selectionModel;
        if (editor == null) {
            ES6IntroduceVariableFromDestructuringHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ES6IntroduceVariableFromDestructuringHandler.$$$reportNull$$$0(3);
        }
        if (!(selectionModel = editor.getSelectionModel()).hasSelection()) {
            return;
        }
        int start = selectionModel.getSelectionStart();
        Ref statementRef = Ref.create();
        ES6IntroduceSpreadVariableHandler.runWriteCommand(() -> statementRef.set((Object)ES6IntroduceVariableFromDestructuringHandler.invokeFor(JSDestructuringArray.class, file2, start)));
        if (ES6IntroduceSpreadVariableHandler.rename(file2, statementRef, editor, OFFSET_GETTER)) {
            return;
        }
        ES6IntroduceSpreadVariableHandler.runWriteCommand(() -> statementRef.set((Object)ES6IntroduceVariableFromDestructuringHandler.invokeFor(JSDestructuringObject.class, file2, start)));
        ES6IntroduceSpreadVariableHandler.rename(file2, statementRef, editor, OFFSET_GETTER);
    }

    private static JSVarStatement invokeFor(Class<? extends PsiElement> clazz, PsiFile file2, int start) {
        JSDestructuringContainer element = (JSDestructuringContainer)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(start), JSDestructuringContainer.class, (boolean)true, (Class[])new Class[]{JSSourceElement.class});
        if (element == null || !clazz.isInstance(element)) {
            return null;
        }
        String variableName = JSNameSuggestionsUtil.ensureUniqueVariableName(ES6IntroduceVariableFromDestructuringHandler.createVarName((PsiElement)element), (PsiElement)element, ContainerUtil.emptyList(), false);
        PsiElement scope = ES6IntroduceSpreadVariableHandler.getScope((PsiElement)element);
        if (scope == null) {
            return null;
        }
        JSElement owner = ES6IntroduceVariableFromDestructuringHandler.getOwner((PsiElement)element);
        if (owner == null || !PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)owner, (boolean)false)) {
            return null;
        }
        String keyword = owner instanceof JSVarStatement ? Objects.requireNonNull(((JSVarStatement)owner).getVarKeyword()).getText() : "let";
        JSVarStatement newStatement = JSPsiElementFactory.createJSStatement(keyword + " " + element.getText() + " = " + variableName + JSCodeStyleSettings.getSemicolon((PsiElement)owner), (PsiElement)owner, JSVarStatement.class);
        ES6IntroduceVariableFromDestructuringHandler.replaceElement((PsiElement)element, variableName, owner);
        Pair<JSVarStatement, PsiElement> statementAndItemToReformat = ES6IntroduceVariableFromDestructuringHandler.addStatement(owner, newStatement);
        SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)statementAndItemToReformat.first));
        FormatFixer.create((PsiElement)statementAndItemToReformat.second, FormatFixer.Mode.Reformat).fixFormat();
        return (JSVarStatement)pointer.getElement();
    }

    @NotNull
    public static Pair<JSVarStatement, PsiElement> addStatement(JSElement owner, JSVarStatement newStatement) {
        Pair<JSVarStatement, PsiElement> statementAndItemToReformat;
        PsiElement parent;
        PsiElement psiElement = parent = owner instanceof JSVarStatement ? owner.getParent() : null;
        if (parent instanceof JSForInStatement) {
            statementAndItemToReformat = ES6IntroduceVariableFromDestructuringHandler.createAndAddStatement(newStatement, parent, ((JSForInStatement)parent).getBody());
        } else if (owner instanceof JSCatchBlock) {
            statementAndItemToReformat = ES6IntroduceVariableFromDestructuringHandler.createAndAddStatement(newStatement, (PsiElement)owner, ((JSCatchBlock)owner).getStatement());
        } else if (owner instanceof JSDestructuringParameter || owner instanceof JSParameterList) {
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)owner, JSFunction.class);
            assert (function != null);
            JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function);
            if (expression == null) {
                statementAndItemToReformat = ES6IntroduceVariableFromDestructuringHandler.createAndAddStatement(newStatement, (PsiElement)function, (JSStatement)function.getBlock());
            } else {
                JSBlockStatement blockStatement = JSPsiElementFactory.createJSStatement("{ return " + expression.getText() + JSCodeStyleSettings.getSemicolon((PsiElement)expression) + "}", parent, JSBlockStatement.class);
                JSElement newElement = JSChangeUtil.replaceElement((JSElement)expression, (JSElement)blockStatement);
                statementAndItemToReformat = ES6IntroduceVariableFromDestructuringHandler.createAndAddStatement(newStatement, (PsiElement)function, (JSStatement)newElement);
            }
        } else {
            assert (owner instanceof JSVarStatement);
            JSVarStatement varStatement = (JSVarStatement)((JSVarStatement)owner).addStatementAfter((JSStatement)newStatement);
            statementAndItemToReformat = Pair.create((Object)varStatement, (Object)varStatement);
        }
        Pair<JSVarStatement, PsiElement> pair = statementAndItemToReformat;
        if (pair == null) {
            ES6IntroduceVariableFromDestructuringHandler.$$$reportNull$$$0(4);
        }
        return pair;
    }

    public static void replaceElement(PsiElement element, String variableName, JSElement owner) {
        JSExpression initializer;
        element = element.getParent();
        String initializerText = "";
        if (element instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)element).getInitializer()) != null) {
            initializerText = " = " + initializer.getText();
        }
        if (owner instanceof JSVarStatement) {
            JSVarStatement tempStatement = JSPsiElementFactory.createJSStatement("var " + variableName + initializerText + ";", (PsiElement)owner, JSVarStatement.class);
            element.replace((PsiElement)tempStatement.getVariables()[0]);
        } else if (owner instanceof JSDestructuringParameter || owner instanceof JSCatchBlock) {
            JSFunction function = JSPsiElementFactory.createJSSourceElement("function f({" + variableName + initializerText + "}) {}", (PsiElement)owner, JSFunction.class);
            element.replace((PsiElement)function.getParameterVariables()[0]);
        }
    }

    private static Pair<JSVarStatement, PsiElement> createAndAddStatement(JSVarStatement newStatement, PsiElement parent, JSStatement body) {
        if (!(body instanceof JSBlockStatement)) {
            JSBlockStatement blockStatement = JSPsiElementFactory.createJSStatement("{" + (body == null ? "" : body.getText()) + "}", parent, JSBlockStatement.class);
            body = body == null ? (JSStatement)parent.addAfter((PsiElement)blockStatement, null) : body.replace((JSStatement)blockStatement);
        }
        return Pair.create((Object)((JSVarStatement)body.addAfter((PsiElement)newStatement, Objects.requireNonNull(body.getNode().findChildByType(JSTokenTypes.LBRACE)).getPsi())), (Object)body);
    }

    private static String createVarName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSDestructuringElement)) {
            return DEFAULT_VAR_NAME;
        }
        PsiElement parentParent = parent.getParent();
        if (parentParent instanceof JSDestructuringProperty) {
            return ((JSDestructuringProperty)parentParent).getName();
        }
        if (parentParent instanceof JSDestructuringArray) {
            JSInitializerOwner[] elements = ((JSDestructuringArray)parentParent).getElements();
            for (int i = 0; i < elements.length; ++i) {
                JSInitializerOwner item = elements[i];
                if (item != parent) continue;
                return JSNameSuggestionsUtil.generateOrdinal(i);
            }
        }
        return "foo";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceVariable/ES6IntroduceVariableFromDestructuringHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/ES6IntroduceVariableFromDestructuringHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnEditorAndFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

