/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSStatementSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            JSStatementSurrounder.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            JSStatementSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            JSStatementSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            JSStatementSurrounder.$$$reportNull$$$0(3);
        }
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement(elements[0]);
        ASTNode node = JSChangeUtil.createStatementFromText(project, this.getStatementTemplate(project, elements[0]), languageDialect);
        if (elements.length == 1 && elements[0] instanceof JSExpression && this.willWrapExpression()) {
            elements[0] = elements[0].getParent();
        }
        PsiElement container = elements[0].getParent();
        container.getNode().addChild(node, elements[0].getNode());
        ASTNode insertBeforeNode = this.getInsertBeforeNode(node);
        for (PsiElement element : elements) {
            ASTNode childNode = element.getNode();
            ASTNode childNodeCopy = childNode.copyElement();
            container.getNode().removeChild(childNode);
            insertBeforeNode.getTreeParent().addChild(childNodeCopy, insertBeforeNode);
        }
        node = this.cleanup(node);
        CodeStyleManager csManager = CodeStyleManager.getInstance((Project)project);
        csManager.reformat(node.getPsi());
        csManager.reformatNewlyAddedElement(node.getTreeParent(), node);
        return this.getSurroundSelectionRange(node);
    }

    protected boolean willWrapExpression() {
        return false;
    }

    protected ASTNode cleanup(ASTNode node) {
        return node;
    }

    @NonNls
    protected abstract String getStatementTemplate(Project var1, PsiElement var2);

    protected abstract ASTNode getInsertBeforeNode(ASTNode var1);

    protected abstract TextRange getSurroundSelectionRange(ASTNode var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/surroundWith/JSStatementSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

