/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bugs;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.ConstantUtils;
import org.jetbrains.annotations.NotNull;

public class DivideByZeroJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("divide.by.zero.display.name", new Object[0]);
        if (string == null) {
            DivideByZeroJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            DivideByZeroJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("division.by.zero.error.string", new Object[0]);
        if (string == null) {
            DivideByZeroJSInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DivisionByZeroVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/bugs/DivideByZeroJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DivisionByZeroVisitor
    extends BaseInspectionVisitor {
        private DivisionByZeroVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                DivisionByZeroVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationSign();
            if (!JSTokenTypes.DIV.equals(tokenType) && !JSTokenTypes.PERC.equals(tokenType)) {
                return;
            }
            if (!ConstantUtils.isZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        public void visitJSAssignmentExpression(JSAssignmentExpression expression) {
            super.visitJSAssignmentExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationSign();
            if (!JSTokenTypes.DIVEQ.equals(tokenType) && !JSTokenTypes.PERCEQ.equals(tokenType)) {
                return;
            }
            if (!ConstantUtils.isZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bugs/DivideByZeroJSInspection$DivisionByZeroVisitor", "visitJSBinaryExpression"));
        }
    }
}

