/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryContinueJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final UnnecessaryContinueFix fix = new UnnecessaryContinueFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("unnecessary.continue.statement.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryContinueJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            UnnecessaryContinueJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("unnecessary.continue.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/UnnecessaryContinueJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSContinueStatement(@NotNull JSContinueStatement statement) {
            JSStatement continuedStatement;
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((continuedStatement = statement.getStatementToContinue()) == null) {
                return;
            }
            if (continuedStatement instanceof JSLabeledStatement) {
                continuedStatement = ((JSLabeledStatement)continuedStatement).getStatement();
            }
            if (!(continuedStatement instanceof JSLoopStatement)) {
                return;
            }
            JSLoopStatement loopParent = (JSLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, JSLoopStatement.class);
            if (loopParent != continuedStatement) {
                return;
            }
            JSStatement body = ((JSLoopStatement)continuedStatement).getBody();
            if (body == null) {
                return;
            }
            if (body instanceof JSBlockStatement) {
                if (ControlFlowUtils.blockCompletesWithStatement((JSBlockStatement)body, (JSStatement)statement)) {
                    this.registerStatementError((JSSourceElement)statement, new Object[0]);
                }
            } else if (ControlFlowUtils.statementCompletesWithStatement(body, (JSStatement)statement)) {
                this.registerStatementError((JSSourceElement)statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/UnnecessaryContinueJSInspection$Visitor", "visitJSContinueStatement"));
        }
    }

    private static class UnnecessaryContinueFix
    extends InspectionJSFix {
        private UnnecessaryContinueFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("remove.unnecessary.continue.fix", new Object[0]);
            if (string == null) {
                UnnecessaryContinueFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement continueKeywordElement = descriptor2.getPsiElement();
            PsiElement continueStatement = continueKeywordElement.getParent();
            assert (continueStatement != null);
            UnnecessaryContinueFix.deleteElement(continueStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryContinueJSInspection$UnnecessaryContinueFix", "getFamilyName"));
        }
    }
}

