/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.credentialStore.Credentials;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshPasswordProvider;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ssh.interaction.RemoteProcessUserInfo;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.CommandLineUtil;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.remotesdk.transport.JschExecProcess;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.remotesdk.ui.CredentialsEditorProvider;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JTextField;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkUtil {
    private static final Logger LOG = Logger.getInstance(RemoteSdkUtil.class);
    @NonNls
    private static final String JETBRAINS_REMOTE_RUN = "JETBRAINS_REMOTE_RUN";
    public static final long TEST_CONNECTION_POLL_TIMEOUT = 100L;
    private static final int MAX_CREATE_DIR_ATTEMPTS = 5;
    public static final long TEST_CONNECTION_TIMEOUT = 10L;
    public static final String DEFAULT_PYCHARM_HELPERS_PATH_ON_DOCKER = "/opt/.pycharm_helpers";
    public static final ImmutableSet<CredentialsType> BUILTIN_CREDENTIALS_TYPE = ImmutableSet.of((Object)CredentialsType.SSH_HOST, (Object)CredentialsType.VAGRANT, (Object)CredentialsType.WEB_DEPLOYMENT);

    private RemoteSdkUtil() {
    }

    public static void copyData(@NotNull RemoteCredentials from, @NotNull RemoteCredentialsVerifiableHolder to) {
        if (from == null) {
            RemoteSdkUtil.$$$reportNull$$$0(0);
        }
        if (to == null) {
            RemoteSdkUtil.$$$reportNull$$$0(1);
        }
        to.setHost(from.getHost());
        to.setLiteralPort(from.getLiteralPort());
        to.setAuthType(from.getAuthType());
        to.setPrivateKeyFile(from.getPrivateKeyFile());
    }

    public static void createFromRemoteCredentials(@NotNull WebServerConfig server, @NotNull RemoteCredentials data) {
        if (server == null) {
            RemoteSdkUtil.$$$reportNull$$$0(2);
        }
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(3);
        }
        FileTransferConfig config = server.getFileTransferConfig();
        config.setAccessType(AccessType.SFTP);
        config.setHost(data.getHost());
        config.setLiteralPort(data.getLiteralPort());
        config.setAnonymous(false);
        config.setAuthType(data.getAuthType());
        config.setPrivateKeyFile(data.getPrivateKeyFile());
        WebDeploymentCredentialHelper.saveCredentials((WebServerConfig)server, (String)data.getUserName(), (String)RemoteSdkUtil.getDataPassword(data), (boolean)RemoteSdkUtil.isMemoryOnly(data));
    }

    @Nullable
    private static String getDataPassword(@NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(4);
        }
        switch (data.getAuthType()) {
            case PASSWORD: {
                return data.getPassword();
            }
            case KEY_PAIR: {
                return data.getPassphrase();
            }
        }
        return null;
    }

    private static boolean isMemoryOnly(@NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(5);
        }
        switch (data.getAuthType()) {
            case PASSWORD: {
                return !data.isStorePassword();
            }
            case KEY_PAIR: {
                return !data.isStorePassphrase();
            }
        }
        return true;
    }

    public static void initRemoteSdkData(@NotNull RemoteSdkCredentials data, @NotNull Deployable deployable) {
        String passwordOrPassphrase;
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(6);
        }
        if (deployable == null) {
            RemoteSdkUtil.$$$reportNull$$$0(7);
        }
        data.setHost(deployable.getHost());
        data.setLiteralPort(deployable.getLiteralPort());
        Credentials credentials = deployable.getCredentials();
        data.setUserName(credentials == null ? null : credentials.getUserName());
        String string = passwordOrPassphrase = credentials == null ? null : credentials.getPasswordAsString();
        if (deployable.getAuthType() == AuthType.KEY_PAIR) {
            data.setPassphrase(passwordOrPassphrase);
        } else if (deployable.getAuthType() == AuthType.PASSWORD) {
            data.setPassword(passwordOrPassphrase);
        }
        data.setPrivateKeyFile(deployable.getPrivateKeyFile());
        data.setAuthType(deployable.getAuthType());
    }

    @NotNull
    public static List<WebServerConfig> getSftpServerList() {
        List<WebServerConfig> list = RemoteSdkUtil.getSftpServerList(null);
        if (list == null) {
            RemoteSdkUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public static List<WebServerConfig> getSftpServerList(@Nullable Project project) {
        List config = GroupedServersConfigManager.getInstance((Project)project).getFlattenedServers();
        Predicate filter = input -> input.getFileTransferConfig().getAccessType() == AccessType.SFTP;
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter((Iterable)config, (Predicate)filter));
        if (arrayList == null) {
            RemoteSdkUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean testConnectionAndCreateHelpersPath(@Nullable Project project, @NotNull RemoteSdkCredentials data, String title) throws RemoteCancelledException, FileSystemException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(10);
        }
        return RemoteSdkUtil.testConnectionAndCreateHelpersPath(project, data, title, null);
    }

    public static boolean testConnection(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(11);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            return RemoteSdkUtil.testConnectionFromEDT(project, data);
        }
        return RemoteSdkUtil.testConnectionFromNonEDT(project, data);
    }

    private static boolean testConnectionFromEDT(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(12);
        }
        try {
            return RemoteSdkUtil.doTestConnection(project, data, 10L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private static boolean testConnectionFromNonEDT(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(13);
        }
        Future result = ApplicationManager.getApplication().executeOnPooledThread(() -> RemoteSdkUtil.doTestConnection(project, data, 10L, TimeUnit.SECONDS));
        try {
            return (Boolean)result.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.warn((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean doTestConnection(@Nullable Project project, @NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(14);
        }
        if (timeUnit == null) {
            RemoteSdkUtil.$$$reportNull$$$0(15);
        }
        try {
            void timeUnit2;
            return RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project).connect(timeout, (TimeUnit)timeUnit2).isConnected();
        }
        catch (SshTransportException sshTransportException) {
            return false;
        }
    }

    public static boolean testConnectionAndCreateHelpersPath(final @Nullable Project project, final @NotNull RemoteSdkCredentials data, String title, final @Nullable RemoteSdkUpdatedCallback updatedCallback) throws FileSystemException, RemoteCancelledException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(16);
        }
        final Ref error = new Ref();
        final Ref result = new Ref();
        result.set((Object)false);
        Task.Modal task = new Task.Modal(project, title, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                Semaphore done = new Semaphore();
                done.down();
                EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        pi.setText("Connecting to " + data.getHost() + "...");
                        RemoteSdkUtil.checkInterpreterAndCreateHelpersDir(project, data, (Ref<? super Exception>)error, (Ref<? super Boolean>)result, updatedCallback);
                    }
                    finally {
                        done.up();
                    }
                });
                try {
                    while (!done.waitFor(100L)) {
                        pi.checkCanceled();
                    }
                }
                finally {
                    ((ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                }
            }

            public void onCancel() {
                error.set((Object)new RemoteCancelledException("Connection was canceled."));
            }

            public void onThrowable(@NotNull Throwable err) {
                Exception ex;
                if (err == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((ex = (Exception)ObjectUtils.tryCast((Object)err, Exception.class)) == null) {
                    ex = new Exception(err);
                }
                error.set((Object)ex);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pi";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "err";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)task));
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!error.isNull()) {
            Exception exception = (Exception)error.get();
            if (exception instanceof RemoteCancelledException) {
                throw (RemoteCancelledException)exception;
            }
            if (exception instanceof FileSystemException) {
                throw (FileSystemException)exception;
            }
            throw new FileSystemException("Exception:", (Throwable)exception);
        }
        return (Boolean)result.get();
    }

    public static boolean checkInterpreterAndCreateHelpersDir(@Nullable Project project, @NotNull RemoteSdkCredentials sdkCredentials, @NotNull Ref<? super Exception> error, @NotNull Ref<? super Boolean> result, @Nullable RemoteSdkUpdatedCallback updateCallback) {
        if (sdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(17);
        }
        if (error == null) {
            RemoteSdkUtil.$$$reportNull$$$0(18);
        }
        if (result == null) {
            RemoteSdkUtil.$$$reportNull$$$0(19);
        }
        try {
            SftpChannel channel = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)sdkCredentials, (Project)project).withConnectionTimeout(0L).openSftpChannel(60);
            return RemoteSdkUtil.checkInterpreterAndCreateHelpersDir(sdkCredentials, error, result, updateCallback, channel);
        }
        catch (Exception e) {
            error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
            return false;
        }
    }

    @Deprecated
    public static boolean checkInterpreterAndCreateHelpersDir(@NotNull RemoteSdkCredentials sdkCredentials, @NotNull Ref<? super Exception> error, @NotNull Ref<? super Boolean> result, @Nullable RemoteSdkUpdatedCallback updateCallback, SshRemoteSession session) {
        if (sdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(20);
        }
        if (error == null) {
            RemoteSdkUtil.$$$reportNull$$$0(21);
        }
        if (result == null) {
            RemoteSdkUtil.$$$reportNull$$$0(22);
        }
        try {
            SftpChannel sftp = session.sftp();
            return RemoteSdkUtil.checkInterpreterAndCreateHelpersDir(sdkCredentials, error, result, updateCallback, sftp);
        }
        catch (Exception e) {
            error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkInterpreterAndCreateHelpersDir(@NotNull RemoteSdkCredentials sdkCredentials, @NotNull Ref<? super Exception> error, @NotNull Ref<? super Boolean> result, @Nullable RemoteSdkUpdatedCallback updateCallback, @NotNull SftpChannel sftpChannel) throws SshTransportException {
        if (sdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(23);
        }
        if (error == null) {
            RemoteSdkUtil.$$$reportNull$$$0(24);
        }
        if (result == null) {
            RemoteSdkUtil.$$$reportNull$$$0(25);
        }
        if (sftpChannel == null) {
            RemoteSdkUtil.$$$reportNull$$$0(26);
        }
        try {
            String interpreterPath = sdkCredentials.getInterpreterPath();
            String pathForHelpers = sdkCredentials.getHelpersPath();
            if (updateCallback != null) {
                RemoteFileObject fileObject = sftpChannel.file(interpreterPath);
                if (!fileObject.exists() || fileObject.isDir()) {
                    error.set((Object)new CustomFileSystemException("Interpreter '" + interpreterPath + "' doesn't exist on remote server"));
                    boolean bl = false;
                    return bl;
                }
                if (!StringUtil.isEmpty((String)pathForHelpers)) {
                    fileObject = sftpChannel.file(pathForHelpers);
                    if (!fileObject.exists() || !fileObject.isDir()) {
                        error.set((Object)new CustomFileSystemException("Directory '" + pathForHelpers + "' doesn't exist on remote server"));
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    String path = new RemoteFile(sftpChannel.getHome(), sdkCredentials.getDefaultHelpersName()).getPath();
                    sdkCredentials.setHelpersPath(path);
                    int i = 0;
                    while (true) {
                        ProgressManager.checkCanceled();
                        fileObject = sftpChannel.file(path);
                        if (fileObject.exists() && fileObject.isDir()) break;
                        try {
                            fileObject.mkdir();
                            sdkCredentials.setHelpersPath(path);
                        }
                        catch (Exception e) {
                            path = sdkCredentials.getHelpersPath() + "_" + ++i;
                            if (i <= 5) continue;
                            throw e;
                        }
                        break;
                    }
                    updateCallback.updated(sdkCredentials);
                }
            }
            result.set((Object)true);
            boolean bl = true;
            return bl;
        }
        finally {
            sftpChannel.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureCanWriteFile(@NotNull ConnectionOwner connectionOwner, @NotNull RemoteSdkCredentials data, @NotNull String path) {
        boolean bl;
        if (connectionOwner == null) {
            RemoteSdkUtil.$$$reportNull$$$0(27);
        }
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(28);
        }
        if (path == null) {
            RemoteSdkUtil.$$$reportNull$$$0(29);
        }
        RemoteProcessUserInfo userInfo = new RemoteProcessUserInfo(connectionOwner, (RemoteCredentials)data, null);
        SftpChannel sftp = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data).withSshPasswordProvider((SshPasswordProvider)userInfo).withConnectionTimeout(60L).openSftpChannel(60);
        try {
            RemoteFileObject fileObject = sftp.file(path);
            bl = (fileObject.getPermissions() & 0x80) != 0 && fileObject.getUId() != 0;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    sftp.disconnect();
                    throw throwable;
                }
                catch (Exception e2) {
                    return true;
                }
            }
            sftp.disconnect();
            return bl2;
        }
        sftp.disconnect();
        return bl;
    }

    @Deprecated
    @NotNull
    public static JschProcess createRemoteProcess(@NotNull SshRemoteSession runProcessSession, @NotNull GeneralCommandLine commandLine, boolean allocatePty, boolean askForSudo, boolean changeDir) throws RemoteSdkException {
        JschExecProcess jschExecProcess;
        if (runProcessSession == null) {
            RemoteSdkUtil.$$$reportNull$$$0(30);
        }
        if (commandLine == null) {
            RemoteSdkUtil.$$$reportNull$$$0(31);
        }
        try {
            commandLine.getEnvironment().put(JETBRAINS_REMOTE_RUN, "1");
            String command = commandLine.getCommandLineString();
            if (!RemoteFile.isWindowsPath((String)commandLine.getExePath())) {
                command = CommandLineUtil.addEnvCommand((GeneralCommandLine)commandLine, (String)command);
                if (askForSudo) {
                    command = "sudo -S -p '' " + command;
                }
            }
            if (changeDir && commandLine.getWorkDirectory() != null) {
                String workingDir = commandLine.getWorkDirectory().getPath();
                workingDir = RemoteFile.detectSystemByPath((String)commandLine.getExePath()).createRemoteFile(workingDir).getPath();
                command = "cd " + workingDir + "; " + command;
            }
            JschExecProcess process2 = runProcessSession.exec(command, 60, allocatePty);
            if (askForSudo) {
                RemoteCredentialsUtil.sendRootPasswordToProcessStdin((SshProcess)process2);
            }
            jschExecProcess = process2;
        }
        catch (Exception e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        if (jschExecProcess == null) {
            RemoteSdkUtil.$$$reportNull$$$0(32);
        }
        return jschExecProcess;
    }

    @Deprecated
    public static SshRemoteSession createRemoteSession(@Nullable Project project, @NotNull RemoteCredentials data) throws RemoteSdkException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(33);
        }
        return new SshRemoteSession(ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages((Project)project), data, null);
    }

    public static CredentialsDeployable createDeployable(RemoteCredentials data) {
        CredentialsDeployable config = new CredentialsDeployable(data);
        config.setName("Remote host");
        return config;
    }

    public static boolean testConnection(@NotNull Component component, RemoteSdkCredentials data, boolean reportOnSuccess) {
        String error;
        if (component == null) {
            RemoteSdkUtil.$$$reportNull$$$0(34);
        }
        CredentialsDeployable config = RemoteSdkUtil.createDeployable((RemoteCredentials)data);
        String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getAccessType().getTitle()});
        String validationInfo = config.validateFastInternal();
        if (validationInfo != null) {
            error = validationInfo;
        } else {
            try {
                error = RemoteSdkUtil.testConnectionAndCreateHelpersPath(null, data, title) ? null : "Connection failed";
            }
            catch (FileSystemException e) {
                error = StringUtil.capitalize((String)PublishUtils.getMessage((Throwable)e, (boolean)false));
            }
            catch (RemoteCancelledException e) {
                error = "Connection was cancelled";
            }
        }
        if (error == null) {
            if (reportOnSuccess) {
                Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title);
            }
            return true;
        }
        Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), error}), (String)title);
        return false;
    }

    public static boolean testConnection(@NotNull Component component, RemoteCredentials data, boolean reportOnSuccess) {
        if (component == null) {
            RemoteSdkUtil.$$$reportNull$$$0(35);
        }
        CredentialsDeployable config = RemoteSdkUtil.createDeployable(data);
        String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getAccessType().getTitle()});
        String validationInfo = config.validateFastInternal();
        Object error = validationInfo != null ? validationInfo : (RemoteSdkUtil.testConnection(null, data) ? null : "Connection failed");
        if (error == null) {
            if (reportOnSuccess) {
                UIUtil.invokeLaterIfNeeded(() -> Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title));
            }
            return true;
        }
        UIUtil.invokeLaterIfNeeded(() -> RemoteSdkUtil.lambda$testConnection$4(component, data, (String)error, title));
        return false;
    }

    public static ServerBrowserDialog showBrowseRemoteDialog(@NotNull String title, @NotNull JTextField field, boolean foldersOnly, @NotNull Deployable deployable) {
        if (title == null) {
            RemoteSdkUtil.$$$reportNull$$$0(36);
        }
        if (field == null) {
            RemoteSdkUtil.$$$reportNull$$$0(37);
        }
        if (deployable == null) {
            RemoteSdkUtil.$$$reportNull$$$0(38);
        }
        WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(field.getText());
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)field));
        ServerBrowserDialog d = project != null ? new ServerBrowserDialog(project, deployable, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath) : new ServerBrowserDialog((Component)field, deployable, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath);
        d.show();
        return d;
    }

    @NotNull
    public static RemoteTransfer.HelpersTransferConfig newHelpersTransferConfigFromRemoteCredentials(final @NotNull RemoteSdkCredentials myRemoteSdkCredentials) {
        if (myRemoteSdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(39);
        }
        RemoteTransfer.HelpersTransferConfig helpersTransferConfig = new RemoteTransfer.HelpersTransferConfig(){

            @Override
            @NotNull
            public String getHelpersPath() {
                String string = myRemoteSdkCredentials.getHelpersPath();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public final void createFileTransferConfig(@NotNull CredentialsDeployable deployable) {
                if (deployable == null) {
                    2.$$$reportNull$$$0(1);
                }
                deployable.resetCredentials(myRemoteSdkCredentials);
            }

            @Override
            public boolean isHelpersVersionChecked() {
                return myRemoteSdkCredentials.isHelpersVersionChecked();
            }

            @Override
            public void setHelpersVersionChecked(boolean checked) {
                myRemoteSdkCredentials.setHelpersVersionChecked(checked);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deployable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHelpersPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createFileTransferConfig";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (helpersTransferConfig == null) {
            RemoteSdkUtil.$$$reportNull$$$0(40);
        }
        return helpersTransferConfig;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NonNls GeneralCommandLine command) throws RemoteSdkException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(41);
        }
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        RemoteSdkSessionUtil.checkConnectionInBackground(connectionBuilder);
        SshExecProcess process2 = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)command).withChangeDir(false).withAllocatePty(false).start();
        CapturingSshProcessHandler processHandler = new CapturingSshProcessHandler((SshProcess)process2, null, command.getCommandLineString());
        ProcessOutput processOutput = processHandler.runProcess();
        if (processOutput == null) {
            RemoteSdkUtil.$$$reportNull$$$0(42);
        }
        return processOutput;
    }

    @Nullable
    public static String chooseRemoteFile(@NotNull Project project, @NotNull RemoteCredentials credentials, boolean foldersOnly) {
        WebServerConfig.RemotePath path;
        if (project == null) {
            RemoteSdkUtil.$$$reportNull$$$0(43);
        }
        if (credentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(44);
        }
        CredentialsDeployable deployable = RemoteSdkUtil.createDeployable(credentials);
        ServerBrowserDialog d = new ServerBrowserDialog(project, (Deployable)deployable, "Choose Remote Path", foldersOnly, FileTransferConfig.Origin.Default, null);
        d.show();
        if (d.isOK() && (path = d.getPath()) != null) {
            return path.path;
        }
        return null;
    }

    public static boolean isInvalidLinuxEnvName(@Nullable String string) {
        return StringUtil.isEmptyOrSpaces((String)string) || string.contains("=");
    }

    public static void remoteIncorrectVariables(Map<String, String> envs) {
        envs.entrySet().removeIf(e -> RemoteSdkUtil.isInvalidLinuxEnvName((String)e.getKey()));
    }

    public static void showCannotLoadCredentialsErrorDialog(@Nullable Project project, @NotNull String interpreterId, @NotNull CredentialsType connectionType) {
        if (interpreterId == null) {
            RemoteSdkUtil.$$$reportNull$$$0(45);
        }
        if (connectionType == null) {
            RemoteSdkUtil.$$$reportNull$$$0(46);
        }
        String message = connectionType instanceof CredentialsTypeEx ? RemoteSdkUtil.getCannotLoadCredentialsTypeMessage(connectionType) : RemoteSdkUtil.getCannotLoadCredentialsTypeMessage(interpreterId);
        UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project, (String)message, (String)"Failed Loading Interpreter"));
    }

    @NotNull
    public static String getCannotLoadCredentialsTypeMessage(@NotNull CredentialsType type) {
        if (type == null) {
            RemoteSdkUtil.$$$reportNull$$$0(47);
        }
        String string = RemoteSdkUtil.getCannotLoadCredentialsTypeMessage(type.getName());
        if (string == null) {
            RemoteSdkUtil.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    private static String getCannotLoadCredentialsTypeMessage(@NotNull String interpreterId) {
        if (interpreterId == null) {
            RemoteSdkUtil.$$$reportNull$$$0(49);
        }
        String string = "Cannot load " + interpreterId + " interpreter. Please make sure corresponding plugin is enabled.";
        if (string == null) {
            RemoteSdkUtil.$$$reportNull$$$0(50);
        }
        return string;
    }

    public static boolean isCredentialsTypeSupportedForLanguage(@NotNull CredentialsType credentialsType, @NotNull Class<?> languageContributionMarkerClass) {
        if (credentialsType == null) {
            RemoteSdkUtil.$$$reportNull$$$0(51);
        }
        if (languageContributionMarkerClass == null) {
            RemoteSdkUtil.$$$reportNull$$$0(52);
        }
        if (BUILTIN_CREDENTIALS_TYPE.contains((Object)credentialsType)) {
            return true;
        }
        for (CredentialsTypeEx typeEx : CredentialsManager.getInstance().getExTypes()) {
            List<CredentialsLanguageContribution> contributions;
            CredentialsEditorProvider editorProvider;
            if (!credentialsType.equals(typeEx) || (editorProvider = (CredentialsEditorProvider)ObjectUtils.tryCast((Object)typeEx, CredentialsEditorProvider.class)) == null || (contributions = RemoteSdkUtil.getContributions(languageContributionMarkerClass)).isEmpty()) continue;
            for (CredentialsLanguageContribution contribution : contributions) {
                if (contribution.getType() != typeEx || !editorProvider.isAvailable(contribution)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static <T> List<CredentialsLanguageContribution> getContributions(@NotNull Class<T> languageContributionMarkerInterface) {
        if (languageContributionMarkerInterface == null) {
            RemoteSdkUtil.$$$reportNull$$$0(53);
        }
        List list = ContainerUtil.filter((Object[])CredentialsLanguageContribution.EP_NAME.getExtensions(), (Condition)FilteringIterator.instanceOf(languageContributionMarkerInterface));
        if (list == null) {
            RemoteSdkUtil.$$$reportNull$$$0(54);
        }
        return list;
    }

    private static /* synthetic */ void lambda$testConnection$4(Component component, RemoteCredentials data, String error, String title) {
        Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), error}), (String)title);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 32: 
            case 40: 
            case 42: 
            case 48: 
            case 50: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 32: 
            case 40: 
            case 42: 
            case 48: 
            case 50: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 28: 
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 8: 
            case 9: 
            case 32: 
            case 40: 
            case 42: 
            case 48: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCredentials";
                break;
            }
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sftpChannel";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProcessSession";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myRemoteSdkCredentials";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionType";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsType";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageContributionMarkerClass";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageContributionMarkerInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSftpServerList";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteProcess";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "newHelpersTransferConfigFromRemoteCredentials";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 48: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCannotLoadCredentialsTypeMessage";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getContributions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFromRemoteCredentials";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDataPassword";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMemoryOnly";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initRemoteSdkData";
                break;
            }
            case 8: 
            case 9: 
            case 32: 
            case 40: 
            case 42: 
            case 48: 
            case 50: 
            case 54: {
                break;
            }
            case 10: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "testConnectionAndCreateHelpersPath";
                break;
            }
            case 11: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "testConnection";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "testConnectionFromEDT";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "testConnectionFromNonEDT";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doTestConnection";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkInterpreterAndCreateHelpersDir";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanWriteFile";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteProcess";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteSession";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "showBrowseRemoteDialog";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "newHelpersTransferConfigFromRemoteCredentials";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "chooseRemoteFile";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "showCannotLoadCredentialsErrorDialog";
                break;
            }
            case 47: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getCannotLoadCredentialsTypeMessage";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isCredentialsTypeSupportedForLanguage";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getContributions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 32: 
            case 40: 
            case 42: 
            case 48: 
            case 50: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RemoteSdkUpdatedCallback {
        public void updated(RemoteSdkCredentials var1);
    }
}

