/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.RunConfigurationConverter;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.jetbrains.debugger.wip.JSRemoteDebugConfiguration;
import com.jetbrains.debugger.wip.JSRemoteDebugConfigurationTypeKt;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfigurationType;", "Lcom/intellij/execution/configurations/ConfigurationTypeBase;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/execution/RunConfigurationConverter;", "()V", "convertRunConfigurationOnDemand", "", "element", "Lorg/jdom/Element;", "getHelpTopic", "", "getTag", "intellij.javascript.chrome.connector"})
public final class JSRemoteDebugConfigurationType
extends ConfigurationTypeBase
implements DumbAware,
RunConfigurationConverter {
    @NotNull
    public String getTag() {
        return "jsRemote";
    }

    public boolean convertRunConfigurationOnDemand(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!JSRemoteDebugConfigurationTypeKt.access$isNodeJsRemoteDebugConfiguration(element)) {
            return false;
        }
        element.setAttribute("type", "ChromiumRemoteDebugType");
        element.setAttribute("factoryName", "Chromium Remote");
        element.setAttribute("isV8Legacy", "true");
        ListIterator iterator = element.getChildren().listIterator();
        while (iterator.hasNext()) {
            Attribute it;
            Attribute attribute;
            boolean bl;
            boolean bl2;
            Element next;
            Element element2 = next = (Element)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"next");
            if (!Intrinsics.areEqual((Object)element2.getName(), (Object)"node-js-remote-debug")) continue;
            if (next.getAttribute("host") != null) {
                bl2 = false;
                bl = false;
                it = attribute;
                boolean bl3 = false;
                element.setAttribute("host", it.getValue());
            }
            if (next.getAttribute("debug-port") != null) {
                bl2 = false;
                bl = false;
                it = attribute;
                boolean bl4 = false;
                element.setAttribute("port", it.getValue());
            }
            iterator.remove();
        }
        return true;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.dialogs.rundebug.ChromiumRemoteDebugType";
    }

    public JSRemoteDebugConfigurationType() {
        super("ChromiumRemoteDebugType", "Attach to Node.js/Chrome", null, NotNullLazyValue.createValue((NotNullFactory)1.INSTANCE));
        this.addFactory(new ConfigurationFactory((ConfigurationType)this){

            @NotNull
            public RunConfigurationSingletonPolicy getSingletonPolicy() {
                return RunConfigurationSingletonPolicy.SINGLE_INSTANCE_ONLY;
            }

            @NotNull
            public String getId() {
                return "Chromium Remote";
            }

            @NotNull
            public JSRemoteDebugConfiguration createTemplateConfiguration(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                return new JSRemoteDebugConfiguration(project, this, this.getConfigurationTypeDescription());
            }
        });
    }
}

