/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.python.profiler.CallCountColumn;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.FunctionTableColumn;
import com.jetbrains.python.profiler.NavigateToSourceAction;
import com.jetbrains.python.profiler.OwnTimeColumn;
import com.jetbrains.python.profiler.ProfilerViewKt;
import com.jetbrains.python.profiler.TimeColumn;
import com.jetbrains.python.profiler.callgraph.CallGraphView;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/profiler/ExecStatsView;", "Lcom/intellij/ui/table/TableView;", "Lcom/jetbrains/python/profiler/FunctionStat;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "profileStats", "Lcom/intellij/openapi/util/UserDataHolder;", "functionStats", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/UserDataHolder;Ljava/util/List;)V", "callGraphView", "Lcom/jetbrains/python/profiler/callgraph/CallGraphView;", "getCallGraphView", "()Lcom/jetbrains/python/profiler/callgraph/CallGraphView;", "setCallGraphView", "(Lcom/jetbrains/python/profiler/callgraph/CallGraphView;)V", "getFunctionStats", "()Ljava/util/List;", "getProfileStats", "()Lcom/intellij/openapi/util/UserDataHolder;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getData", "", "dataId", "", "intellij.python.profiler"})
public final class ExecStatsView
extends TableView<FunctionStat>
implements DataProvider {
    @Nullable
    private CallGraphView callGraphView;
    @NotNull
    private final Project project;
    @NotNull
    private final UserDataHolder profileStats;
    @NotNull
    private final List<FunctionStat> functionStats;

    @Nullable
    public final CallGraphView getCallGraphView() {
        return this.callGraphView;
    }

    public final void setCallGraphView(@Nullable CallGraphView callGraphView) {
        this.callGraphView = callGraphView;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        if (ProfilerViewKt.getCALL_GRAPH_VIEW().is(dataId)) {
            return this.callGraphView;
        }
        if (ProfilerViewKt.getFUNCTION_STAT().is(dataId)) {
            return this.getSelectedObject();
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            FunctionStat functionStat = (FunctionStat)this.getSelectedObject();
            if (functionStat == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)functionStat, (String)"selectedObject ?: return null");
            FunctionStat selectedObject = functionStat;
            return ProfilerViewKt.findNavigatables(this.project, selectedObject, this.profileStats);
        }
        return null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final UserDataHolder getProfileStats() {
        return this.profileStats;
    }

    @NotNull
    public final List<FunctionStat> getFunctionStats() {
        return this.functionStats;
    }

    public ExecStatsView(@NotNull Project project, @NotNull UserDataHolder profileStats, @NotNull List<? extends FunctionStat> functionStats) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)profileStats, (String)"profileStats");
        Intrinsics.checkParameterIsNotNull(functionStats, (String)"functionStats");
        super(new ListTableModel(new ColumnInfo[]{new FunctionTableColumn(), new CallCountColumn(), new TimeColumn(), new OwnTimeColumn()}, functionStats, 3, SortOrder.DESCENDING));
        this.project = project;
        this.profileStats = profileStats;
        this.functionStats = functionStats;
        new TableSpeedSearch((JTable)((Object)this), (Convertor)1.INSTANCE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (e.getClickCount() == 2) {
                    NavigateToSourceAction a = new NavigateToSourceAction();
                    AnActionEvent anActionEvent = AnActionEvent.createFromInputEvent((InputEvent)e, (String)"", (Presentation)new Presentation(), (DataContext)new DataContext(this){
                        final /* synthetic */ 2 this$0;

                        @Nullable
                        public final Object getData(@NotNull String key) {
                            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                            return this.this$0.this.getData(key);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    Intrinsics.checkExpressionValueIsNotNull((Object)anActionEvent, (String)"AnActionEvent.createFrom\u2026getData(key)\n          })");
                    AnActionEvent event2 = anActionEvent;
                    a.update(event2);
                    Presentation presentation = event2.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"event.presentation");
                    if (presentation.isEnabled()) {
                        a.actionPerformed(event2);
                    }
                }
            }
        });
    }
}

