/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.profiler.CallTreeNode;
import com.jetbrains.python.profiler.CallTreeView;
import com.jetbrains.python.profiler.ExecStatsView;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.ProfileStats;
import com.jetbrains.python.profiler.ProfilerView;
import com.jetbrains.python.profiler.ProfilerViewForm;
import com.jetbrains.python.profiler.callgraph.CallGraphView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/profiler/ProfilerView;", "Lcom/jetbrains/python/profiler/ProfilerViewForm;", "Lcom/intellij/openapi/Disposable;", "()V", "dispose", "", "init", "project", "Lcom/intellij/openapi/project/Project;", "profileStats", "Lcom/jetbrains/python/profiler/ProfileStats;", "installPopups", "component", "Ljavax/swing/JComponent;", "intellij.python.profiler"})
public final class ProfilerView
extends ProfilerViewForm
implements Disposable {
    public final void init(@NotNull Project project, @NotNull ProfileStats profileStats) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)profileStats, (String)"profileStats");
        if (profileStats.isEmpty()) {
            this.myTabbedPane.removeAll();
            this.mainPanel.removeAll();
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)new JLabel("Profile doesn't contain samples. Please profile for a longer period of time or use a tracing profiler, for example CProfile."), "North");
            GridConstraints c = new GridConstraints();
            this.mainPanel.add((Component)p, c);
        } else {
            List<FunctionStat> functionStats = profileStats.getFunctionStats();
            if (functionStats != null) {
                ExecStatsView execStatsView = new ExecStatsView(project, profileStats, functionStats);
                JPanel jPanel = this.execStatsPanel;
                if (jPanel == null) {
                    Intrinsics.throwNpe();
                }
                jPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)execStatsView))), "Center");
                AsyncProcessIcon asyncProcessIcon = new AsyncProcessIcon("Creating call graph...");
                JPanel jPanel2 = this.callGraphPanel;
                if (jPanel2 == null) {
                    Intrinsics.throwNpe();
                }
                jPanel2.add((Component)asyncProcessIcon, "Center");
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, project, profileStats, functionStats, execStatsView){
                    final /* synthetic */ ProfilerView this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ProfileStats $profileStats;
                    final /* synthetic */ List $functionStats;
                    final /* synthetic */ ExecStatsView $execStatsView;

                    /*
                     * WARNING - void declaration
                     */
                    public final void run() {
                        void callGraph2;
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = new CallGraphView(this.$project, this.$profileStats, this.$functionStats, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ init.1 this$0;

                            public final void invoke() {
                                JBTabbedPane jBTabbedPane = this.this$0.this$0.myTabbedPane;
                                Intrinsics.checkExpressionValueIsNotNull((Object)jBTabbedPane, (String)"this@ProfilerView.myTabbedPane");
                                jBTabbedPane.setSelectedIndex(1);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                        Disposer.register((Disposable)this.this$0, (Disposable)((Disposable)((CallGraphView)callGraph2.element).getBuilder()));
                        this.$execStatsView.setCallGraphView((CallGraphView)callGraph2.element);
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, (Ref.ObjectRef)callGraph2){
                            final /* synthetic */ init.1 this$0;
                            final /* synthetic */ Ref.ObjectRef $callGraph;

                            public final void run() {
                                this.this$0.this$0.callGraphPanel.removeAll();
                                JPanel jPanel = this.this$0.this$0.callGraphPanel;
                                if (jPanel == null) {
                                    Intrinsics.throwNpe();
                                }
                                jPanel.add((Component)((CallGraphView)this.$callGraph.element), "Center");
                            }
                            {
                                this.this$0 = var1_1;
                                this.$callGraph = objectRef;
                            }
                        });
                    }
                    {
                        this.this$0 = profilerView;
                        this.$project = project;
                        this.$profileStats = profileStats;
                        this.$functionStats = list;
                        this.$execStatsView = execStatsView;
                    }
                });
                this.installPopups((JComponent)((Object)execStatsView));
            } else {
                this.myTabbedPane.removeTabAt(0);
                this.myTabbedPane.removeTabAt(0);
            }
            CallTreeNode callTree = profileStats.getCallTree();
            if (callTree != null) {
                CallTreeView callTreeView = new CallTreeView(project, callTree, profileStats);
                this.installPopups(callTreeView);
                JPanel jPanel = this.callTreePanel;
                if (jPanel == null) {
                    Intrinsics.throwNpe();
                }
                jPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)callTreeView), "Center");
            } else {
                this.myTabbedPane.removeTabAt(2);
            }
        }
    }

    private final void installPopups(JComponent component) {
        PopupHandler.installPopupHandler((JComponent)component, (String)"PyProfiler.Popup.Actions", (String)"PyProfiler.ExecutionStats");
    }

    public void dispose() {
    }
}

