/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import com.jetbrains.plugins.webDeployment.config.ServerDeployableWithTempCredentials;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.remote.PyRemoteInterpreterManagerImpl;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.remote.sdk.add.RemoteSdkCreationUtilKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FileSystemException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a4\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001\u001a@\u0010\u000b\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001aP\u0010\u0014\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0013\u001a\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0016H\u0000\u001a\u0018\u0010!\u001a\u00020\"2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010#\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"NOT_EMPTY_URL", "", "createAndInitRemoteSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;", "existingSdks", "", "suggestedName", "createSdkFromExistingServerConfiguration", "module", "Lcom/intellij/openapi/module/Module;", "existingWebServerConfig", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "", "interpreterPath", "runAsRootViaSudo", "", "createSdkFromNewServerConfiguration", "storeCredentials", "Lcom/intellij/credentialStore/Credentials;", "isStoreCredentialsMemoryOnly", "newWebServerConfig", "createSftpWebServerConfig", "remoteCredentials", "Lcom/jetbrains/plugins/webDeployment/config/RemoteCredentialsVerifiableHolder;", "isProjectLevel", "getRemoteCredentialsWithAuth", "Lcom/intellij/remote/RemoteCredentials;", "webServerConfig", "authCredentials", "initializeHelpersPath", "", "setWebDeploymentCredentials", "intellij.python.remoteInterpreter"})
public final class RemoteSdkCreationUtilKt {
    private static final String NOT_EMPTY_URL = "http:///";

    @NotNull
    public static final Sdk createAndInitRemoteSdk(@Nullable Project project, @NotNull PyRemoteSdkAdditionalData data, @NotNull Collection<? extends Sdk> existingSdks, @Nullable String suggestedName) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (pythonRemoteInterpreterManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.remote.PyRemoteInterpreterManagerImpl");
        }
        PyRemoteInterpreterManagerImpl remoteSdkFactory = (PyRemoteInterpreterManagerImpl)pythonRemoteInterpreterManager;
        Sdk remoteSdk = remoteSdkFactory.createRemoteSdk(project, data, suggestedName, existingSdks);
        remoteSdkFactory.initSdk(remoteSdk, project, null);
        Sdk sdk = remoteSdk;
        Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"remoteSdk");
        return sdk;
    }

    public static /* synthetic */ Sdk createAndInitRemoteSdk$default(Project project, PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData, Collection collection, String string, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return RemoteSdkCreationUtilKt.createAndInitRemoteSdk(project, pyRemoteSdkAdditionalData, collection, string);
    }

    @NotNull
    public static final Sdk createSdkFromExistingServerConfiguration(@Nullable Project project, @Nullable Module module, @NotNull WebServerConfig existingWebServerConfig, @NotNull List<? extends Sdk> existingSdks, @NotNull String interpreterPath, boolean runAsRootViaSudo) {
        Intrinsics.checkParameterIsNotNull((Object)existingWebServerConfig, (String)"existingWebServerConfig");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)interpreterPath, (String)"interpreterPath");
        PyRemoteSdkAdditionalData data = new PyRemoteSdkAdditionalData(interpreterPath, runAsRootViaSudo);
        RemoteSdkCreationUtilKt.setWebDeploymentCredentials(data, existingWebServerConfig, WebDeploymentCredentialHelper.getRemoteCredentials((WebServerConfig)existingWebServerConfig));
        RemoteSdkCreationUtilKt.initializeHelpersPath(project, data);
        Sdk sdk = RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(project, data, existingSdks, null, 8, null);
        if (existingWebServerConfig.isProjectLevel()) {
            PySdkExtKt.associateWithModule((Sdk)sdk, (Module)module, null);
        }
        return sdk;
    }

    @NotNull
    public static final Sdk createSdkFromNewServerConfiguration(@Nullable Project project, @Nullable Module module, @NotNull Credentials storeCredentials, boolean isStoreCredentialsMemoryOnly, @NotNull WebServerConfig newWebServerConfig, @NotNull List<? extends Sdk> existingSdks, @NotNull String interpreterPath, boolean runAsRootViaSudo) {
        Intrinsics.checkParameterIsNotNull((Object)storeCredentials, (String)"storeCredentials");
        Intrinsics.checkParameterIsNotNull((Object)newWebServerConfig, (String)"newWebServerConfig");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)interpreterPath, (String)"interpreterPath");
        PyRemoteSdkAdditionalData data = new PyRemoteSdkAdditionalData(interpreterPath, runAsRootViaSudo);
        RemoteSdkCreationUtilKt.setWebDeploymentCredentials(data, newWebServerConfig, RemoteSdkCreationUtilKt.getRemoteCredentialsWithAuth(newWebServerConfig, storeCredentials));
        GroupedServersConfigManager.getInstance((Project)project).addServer(newWebServerConfig);
        Deployable settingsDeployable = Deployable.create((WebServerConfig)newWebServerConfig);
        settingsDeployable.setCredentials(storeCredentials, isStoreCredentialsMemoryOnly, true, false);
        RemoteSdkCreationUtilKt.initializeHelpersPath(project, data);
        Sdk sdk = RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(project, data, existingSdks, null, 8, null);
        if (newWebServerConfig.isProjectLevel()) {
            PySdkExtKt.associateWithModule((Sdk)sdk, (Module)module, null);
        }
        return sdk;
    }

    private static final void setWebDeploymentCredentials(PyRemoteSdkAdditionalData data, WebServerConfig webServerConfig, RemoteCredentials remoteCredentials) {
        String string = webServerConfig.getId();
        if (string == null) {
            throw (Throwable)new IllegalStateException();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"webServerConfig.id ?: th\u2026w IllegalStateException()");
        String webServerConfigId = string;
        WebDeploymentCredentialsHolder webDeploymentCredentialsHolder = new WebDeploymentCredentialsHolder(webServerConfigId, webServerConfig.getName(), remoteCredentials);
        CredentialsType credentialsType = CredentialsType.WEB_DEPLOYMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)credentialsType, (String)"CredentialsType.WEB_DEPLOYMENT");
        data.setCredentials(credentialsType.getCredentialsKey(), (Object)webDeploymentCredentialsHolder);
    }

    public static final void initializeHelpersPath(@Nullable Project project, @NotNull PyRemoteSdkAdditionalData data) throws FileSystemException, RemoteCancelledException {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        PyRemoteSdkCredentials remoteSdkCredentials = data.getRemoteSdkCredentials(project, true);
        RemoteSdkUtil.RemoteSdkUpdatedCallback callback2 = initializeHelpersPath.callback.1.INSTANCE;
        RemoteSdkUtil.testConnectionAndCreateHelpersPath((Project)project, (RemoteSdkCredentials)((RemoteSdkCredentials)remoteSdkCredentials), (String)"Creating Helpers Directory", (RemoteSdkUtil.RemoteSdkUpdatedCallback)callback2);
        PyRemoteSdkCredentials pyRemoteSdkCredentials = remoteSdkCredentials;
        Intrinsics.checkExpressionValueIsNotNull((Object)pyRemoteSdkCredentials, (String)"remoteSdkCredentials");
        data.setHelpersPath(pyRemoteSdkCredentials.getHelpersPath());
    }

    @NotNull
    public static final WebServerConfig createSftpWebServerConfig(@NotNull RemoteCredentialsVerifiableHolder remoteCredentials, boolean isProjectLevel) {
        Intrinsics.checkParameterIsNotNull((Object)remoteCredentials, (String)"remoteCredentials");
        WebServerConfig webServerConfig = new WebServerConfig(WebServerConfig.getNextId());
        webServerConfig.setIsProjectLevel(isProjectLevel);
        RemoteCredentialsVerifiableHolder remoteCredentialsVerifiableHolder = remoteCredentials;
        boolean bl = false;
        boolean bl2 = false;
        RemoteCredentialsVerifiableHolder it = remoteCredentialsVerifiableHolder;
        boolean bl3 = false;
        webServerConfig.setName(it.getUserName() + '@' + it.getHost() + ':' + it.getPort());
        webServerConfig.setUrl(NOT_EMPTY_URL);
        FileTransferConfig fileTransferConfig = new FileTransferConfig(remoteCredentials);
        fileTransferConfig.setAccessType(AccessType.SFTP);
        fileTransferConfig.setAuthType(remoteCredentials.getAuthType());
        webServerConfig.setFileTransferConfig(fileTransferConfig);
        return webServerConfig;
    }

    public static /* synthetic */ WebServerConfig createSftpWebServerConfig$default(RemoteCredentialsVerifiableHolder remoteCredentialsVerifiableHolder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return RemoteSdkCreationUtilKt.createSftpWebServerConfig(remoteCredentialsVerifiableHolder, bl);
    }

    @NotNull
    public static final RemoteCredentials getRemoteCredentialsWithAuth(@NotNull WebServerConfig webServerConfig, @NotNull Credentials authCredentials) {
        Intrinsics.checkParameterIsNotNull((Object)webServerConfig, (String)"webServerConfig");
        Intrinsics.checkParameterIsNotNull((Object)authCredentials, (String)"authCredentials");
        ServerDeployableWithTempCredentials settingsDeployable = new ServerDeployableWithTempCredentials(webServerConfig);
        settingsDeployable.setCredentials(authCredentials, true, false, false);
        RemoteCredentialsHolder credentialsHolder = new RemoteCredentialsHolder();
        settingsDeployable.copyToCredentials((MutableRemoteCredentials)credentialsHolder);
        return (RemoteCredentials)credentialsHolder;
    }
}

