/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffViewer
extends TwosideTextDiffViewer {
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private final List<SimpleDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleDiffChange> myInvalidDiffChanges;
    private boolean myIsContentsEqual;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final ModifierProvider myModifierProvider;
    @NotNull
    protected final TwosideTextDiffProvider myTextDiffProvider;

    public SimpleDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            SimpleDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request);
        this.myDiffChanges = new ArrayList<SimpleDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleDiffChange>();
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.mySyncScrollable = new MySyncScrollable();
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.getProject(), this.getEditors(), (Disposable)this);
        this.myModifierProvider = new ModifierProvider();
        this.myTextDiffProvider = DiffUtil.createTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, (Disposable)this);
        for (Side side : Side.values()) {
            DiffUtil.installLineConvertor(this.getEditor(side), this.getContent(side), this.myFoldingModel, side.getIndex());
        }
        DiffUtil.registerAction((AnAction)new ReplaceSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction((AnAction)new AppendSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction((AnAction)new ReplaceSelectedChangesAction(Side.RIGHT, true), this.myPanel);
        DiffUtil.registerAction((AnAction)new AppendSelectedChangesAction(Side.RIGHT, true), this.myPanel);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter());
        this.myModifierProvider.init();
    }

    @Override
    protected void onDispose() {
        this.destroyChangedBlocks();
        this.myFoldingModel.destroy();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new TwosideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new TwosideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new ReplaceSelectedChangesAction(Side.LEFT, false));
        group.add((AnAction)new AppendSelectedChangesAction(Side.LEFT, false));
        group.add((AnAction)new ReplaceSelectedChangesAction(Side.RIGHT, false));
        group.add((AnAction)new AppendSelectedChangesAction(Side.RIGHT, false));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            SimpleDiffViewer.$$$reportNull$$$0(5);
        }
        return settings;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        boolean isContentsEqual;
        List<LineFragment> lineFragments;
        block10: {
            if (indicator == null) {
                SimpleDiffViewer.$$$reportNull$$$0(6);
            }
            indicator.checkCanceled();
            Document document1 = this.getContent1().getDocument();
            Document document2 = this.getContent2().getDocument();
            CharSequence[] texts = (CharSequence[])ReadAction.compute(() -> new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()});
            lineFragments = this.myTextDiffProvider.compare(texts[0], texts[1], indicator);
            boolean bl = isContentsEqual = (lineFragments == null || lineFragments.isEmpty()) && StringUtil.equals((CharSequence)texts[0], (CharSequence)texts[1]);
            if (lineFragments != null) break block10;
            Runnable runnable3 = this.apply(this.createCompareData(null, isContentsEqual));
            if (runnable3 == null) {
                SimpleDiffViewer.$$$reportNull$$$0(7);
            }
            return runnable3;
        }
        try {
            List changes = ContainerUtil.map(lineFragments, fragment -> new SimpleDiffChange(this, (LineFragment)fragment));
            runnable2 = this.apply(this.createCompareData(changes, isContentsEqual));
        }
        catch (DiffTooBigException e) {
            Runnable runnable4 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable4 == null) {
                SimpleDiffViewer.$$$reportNull$$$0(9);
            }
            return runnable4;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable5 = this.applyNotification(DiffNotifications.createError());
            if (runnable5 == null) {
                SimpleDiffViewer.$$$reportNull$$$0(10);
            }
            return runnable5;
        }
        if (runnable2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(8);
        }
        return runnable2;
    }

    @NotNull
    protected CompareData createCompareData(@Nullable List<SimpleDiffChange> changes, boolean isContentsEqual) {
        List nonSkipped = changes != null ? ContainerUtil.filter(changes, it -> !it.isSkipped()) : null;
        FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(nonSkipped, this.getFoldingModelSettings());
        CompareData compareData = new CompareData(changes, isContentsEqual, foldingState);
        if (compareData == null) {
            SimpleDiffViewer.$$$reportNull$$$0(11);
        }
        return compareData;
    }

    @NotNull
    protected Runnable apply(@NotNull CompareData data) {
        if (data == null) {
            SimpleDiffViewer.$$$reportNull$$$0(12);
        }
        Runnable runnable2 = () -> {
            List<SimpleDiffChange> changes;
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            this.myIsContentsEqual = data.isContentsEqual();
            if (data.isContentsEqual()) {
                boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(this.getContents());
                boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(this.getContents());
                this.myPanel.addNotification(DiffNotifications.createEqualContents(equalCharsets, equalSeparators));
            }
            if ((changes = data.getChanges()) != null) {
                for (int i = 0; i < changes.size(); ++i) {
                    SimpleDiffChange change = changes.get(i);
                    LineFragment previousChangeFragment = i != 0 ? changes.get(i - 1).getFragment() : null;
                    change.installHighlighter(previousChangeFragment);
                }
                this.myDiffChanges.addAll(changes);
            }
            this.myFoldingModel.install(data.getFoldingState(), (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDivider();
            this.myStatusPanel.update();
        };
        if (runnable2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(13);
        }
        return runnable2;
    }

    @NotNull
    protected Runnable applyNotification(@Nullable JComponent notification) {
        Runnable runnable2 = () -> {
            this.clearDiffPresentation();
            this.myFoldingModel.destroy();
            if (notification != null) {
                this.myPanel.addNotification(notification);
            }
        };
        if (runnable2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(14);
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.destroyChangedBlocks();
    }

    private void destroyChangedBlocks() {
        this.myIsContentsEqual = false;
        for (SimpleDiffChange change : this.myDiffChanges) {
            change.destroyHighlighter();
        }
        this.myDiffChanges.clear();
        for (SimpleDiffChange change : this.myInvalidDiffChanges) {
            change.destroyHighlighter();
        }
        this.myInvalidDiffChanges.clear();
        this.myContentPanel.repaintDivider();
        this.myStatusPanel.update();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            SimpleDiffViewer.$$$reportNull$$$0(15);
        }
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        List documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        Side side = Side.fromValue((List)documents, (Object)e.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        ArrayList<SimpleDiffChange> invalid = new ArrayList<SimpleDiffChange>();
        for (SimpleDiffChange change : this.myDiffChanges) {
            if (!change.processChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
        }
    }

    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        SimpleDiffChange targetChange;
        if (scrollToPolicy == null) {
            SimpleDiffViewer.$$$reportNull$$$0(16);
        }
        if ((targetChange = scrollToPolicy.select(this.getNonSkippedDiffChanges())) == null) {
            targetChange = scrollToPolicy.select(this.myDiffChanges);
        }
        if (targetChange == null) {
            return false;
        }
        this.doScrollToChange(targetChange, false);
        return true;
    }

    private void doScrollToChange(@NotNull SimpleDiffChange change, boolean animated) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(17);
        }
        int line1 = change.getStartLine(Side.LEFT);
        int line2 = change.getStartLine(Side.RIGHT);
        int endLine1 = change.getEndLine(Side.LEFT);
        int endLine2 = change.getEndLine(Side.RIGHT);
        DiffUtil.moveCaret(this.getEditor1(), line1);
        DiffUtil.moveCaret(this.getEditor2(), line2);
        this.getSyncScrollSupport().makeVisible(this.getCurrentSide(), line1, endLine1, line2, endLine2, animated);
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        ChangedLinesIterator changedLinesIterator;
        int line2;
        if (context == null) {
            SimpleDiffViewer.$$$reportNull$$$0(18);
        }
        if ((line2 = context.contextMatchCheck((Iterator)(changedLinesIterator = new ChangedLinesIterator()))) == -1) {
            AllLinesIterator allLinesIterator = new AllLinesIterator(this.getEditor(Side.RIGHT).getDocument());
            line2 = context.contextMatchCheck((Iterator)allLinesIterator);
        }
        if (line2 == -1) {
            return false;
        }
        this.scrollToLine(Side.RIGHT, line2);
        return true;
    }

    @NotNull
    protected List<SimpleDiffChange> getDiffChanges() {
        List<SimpleDiffChange> list2 = this.myDiffChanges;
        if (list2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    private List<SimpleDiffChange> getNonSkippedDiffChanges() {
        List list2 = ContainerUtil.filter(this.myDiffChanges, it -> !it.isSkipped());
        if (list2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable() {
        SyncScrollSupport.SyncScrollable syncScrollable = this.mySyncScrollable;
        if (syncScrollable == null) {
            SimpleDiffViewer.$$$reportNull$$$0(21);
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected StatusPanel getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            SimpleDiffViewer.$$$reportNull$$$0(22);
        }
        return statusPanel;
    }

    @NotNull
    public ModifierProvider getModifierProvider() {
        ModifierProvider modifierProvider = this.myModifierProvider;
        if (modifierProvider == null) {
            SimpleDiffViewer.$$$reportNull$$$0(23);
        }
        return modifierProvider;
    }

    @Override
    @NotNull
    public SyncScrollSupport.TwosideSyncScrollSupport getSyncScrollSupport() {
        SyncScrollSupport.TwosideSyncScrollSupport twosideSyncScrollSupport = super.getSyncScrollSupport();
        if (twosideSyncScrollSupport == null) {
            SimpleDiffViewer.$$$reportNull$$$0(24);
        }
        return twosideSyncScrollSupport;
    }

    protected boolean isEditable(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(25);
        }
        return DiffUtil.isEditable(this.getEditor(side));
    }

    boolean isDiffForLocalChanges() {
        boolean isLastWithLocal = (Boolean)DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL.get((UserDataHolder)this.myContext, (Object)false);
        return isLastWithLocal && !this.isEditable(Side.LEFT) && this.isEditable(Side.RIGHT);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleDiffViewer.$$$reportNull$$$0(26);
        }
        if (request == null) {
            SimpleDiffViewer.$$$reportNull$$$0(27);
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    protected boolean isSomeChangeSelected(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(28);
        }
        if (this.myDiffChanges.isEmpty()) {
            return false;
        }
        EditorEx editor = this.getEditor(side);
        return DiffUtil.isSomeRangeSelected(editor, (Condition<? super BitSet>)((Condition)lines -> ContainerUtil.exists(this.myDiffChanges, change -> SimpleDiffViewer.isChangeSelected(change, lines, side))));
    }

    @NotNull
    protected List<SimpleDiffChange> getSelectedChanges(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(29);
        }
        EditorEx editor = this.getEditor(side);
        BitSet lines = DiffUtil.getSelectedLines(editor);
        List list2 = ContainerUtil.filter(this.myDiffChanges, change -> SimpleDiffViewer.isChangeSelected(change, lines, side));
        if (list2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(30);
        }
        return list2;
    }

    private static boolean isChangeSelected(SimpleDiffChange change, @NotNull BitSet lines, @NotNull Side side) {
        if (lines == null) {
            SimpleDiffViewer.$$$reportNull$$$0(31);
        }
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(32);
        }
        int line1 = change.getStartLine(side);
        int line2 = change.getEndLine(side);
        return DiffUtil.isSelectedByLine(lines, line1, line2);
    }

    @Nullable
    protected SimpleDiffChange getSelectedChange(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(33);
        }
        int caretLine = this.getEditor((Side)side).getCaretModel().getLogicalPosition().line;
        for (SimpleDiffChange change : this.myDiffChanges) {
            int line2;
            int line1 = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(caretLine, line1, line2 = change.getEndLine(side))) continue;
            return change;
        }
        return null;
    }

    public void replaceChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(34);
        }
        if (sourceSide == null) {
            SimpleDiffViewer.$$$reportNull$$$0(35);
        }
        if (!change.isValid()) {
            return;
        }
        Side outputSide = sourceSide.other();
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getStartLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        change.destroyHighlighter();
        this.myDiffChanges.remove(change);
    }

    public void appendChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(36);
        }
        if (sourceSide == null) {
            SimpleDiffViewer.$$$reportNull$$$0(37);
        }
        if (!change.isValid()) {
            return;
        }
        if (change.getStartLine(sourceSide) == change.getEndLine(sourceSide)) {
            return;
        }
        Side outputSide = sourceSide.other();
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getEndLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        change.destroyHighlighter();
        this.myDiffChanges.remove(change);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        SimpleDiffChange change;
        if (dataId == null) {
            SimpleDiffViewer.$$$reportNull$$$0(38);
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getSelectedChange(this.getCurrentSide())) != null) {
            return new LineRange(change.getStartLine(this.getCurrentSide()), change.getEndLine(this.getCurrentSide()));
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollToPolicy";
                break;
            }
            case 17: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompareData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "applyNotification";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffChanges";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonSkippedDiffChanges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollable";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierProvider";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollSupport";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToChange";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isSomeChangeSelected";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChanges";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isChangeSelected";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChange";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyInitialScrollHelper
    extends TwosideTextDiffViewer.MyInitialScrollPositionHelper {
        private MyInitialScrollHelper() {
            super(SimpleDiffViewer.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return SimpleDiffViewer.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToContext(this.myNavigationContext);
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable;

        MyFoldingModel(@Nullable Project project, @NotNull List<? extends EditorEx> editors, @NotNull Disposable disposable) {
            if (editors == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            super(project, editors.toArray(new EditorEx[0]), disposable);
            this.myPaintable = new FoldingModelSupport.MyPaintable(this, 0, 1);
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<SimpleDiffChange> changes, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                MyFoldingModel.$$$reportNull$$$0(3);
            }
            if (divider == null) {
                MyFoldingModel.$$$reportNull$$$0(4);
            }
            this.myPaintable.paintOnDivider(gg, divider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gg";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createState";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintOnDivider";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ModifierProvider
    extends KeyboardModifierListener {
        public void init() {
            this.init(SimpleDiffViewer.this.myPanel, (Disposable)SimpleDiffViewer.this);
        }

        @Override
        public void onModifiersChanged() {
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                change.updateGutterActions(false);
            }
        }
    }

    private static class CompareData {
        @Nullable
        private final List<SimpleDiffChange> myChanges;
        private final boolean myIsContentsEqual;
        @Nullable
        private final FoldingModelSupport.Data myFoldingState;

        private CompareData(@Nullable List<SimpleDiffChange> changes, boolean isContentsEqual, @Nullable FoldingModelSupport.Data state) {
            this.myChanges = changes;
            this.myIsContentsEqual = isContentsEqual;
            this.myFoldingState = state;
        }

        @Nullable
        public List<SimpleDiffChange> getChanges() {
            return this.myChanges;
        }

        public boolean isContentsEqual() {
            return this.myIsContentsEqual;
        }

        @Nullable
        public FoldingModelSupport.Data getFoldingState() {
            return this.myFoldingState;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (SimpleDiffViewer.this.myTextDiffProvider.isHighlightingDisabled()) {
                return DiffBundle.message((String)"diff.highlighting.disabled.text", (Object[])new Object[0]);
            }
            int excludedChanges = ContainerUtil.count((Iterable)SimpleDiffViewer.this.myDiffChanges, it -> it.isExcluded()) + ContainerUtil.count((Iterable)SimpleDiffViewer.this.myInvalidDiffChanges, it -> it.isExcluded());
            int changesCount = SimpleDiffViewer.this.myDiffChanges.size() + SimpleDiffViewer.this.myInvalidDiffChanges.size();
            if (changesCount == 0 && !SimpleDiffViewer.this.myIsContentsEqual) {
                return DiffBundle.message((String)"diff.all.differences.ignored.text", (Object[])new Object[0]);
            }
            String message = DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{changesCount - excludedChanges});
            if (excludedChanges > 0) {
                message = message + " " + DiffBundle.message((String)"diff.inactive.count.differences.status.text", (Object[])new Object[]{excludedChanges});
            }
            return message;
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private MyDividerPainter() {
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                MyDividerPainter.$$$reportNull$$$0(0);
            }
            if (divider == null) {
                MyDividerPainter.$$$reportNull$$$0(1);
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, SimpleDiffViewer.this.getEditor1().getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor(SimpleDiffViewer.this.getEditor1()));
            gg.fill(gg.getClipBounds());
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), SimpleDiffViewer.this.getEditor1(), SimpleDiffViewer.this.getEditor2(), this);
            SimpleDiffViewer.this.myFoldingModel.paintOnDivider(gg, divider);
            gg.dispose();
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                MyDividerPainter.$$$reportNull$$$0(2);
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.myDiffChanges) {
                if (handler2.processExcludable(diffChange.getStartLine(Side.LEFT), diffChange.getEndLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT), diffChange.getEndLine(Side.RIGHT), SimpleDiffViewer.this.getEditor1(), diffChange.getDiffType(), diffChange.isExcluded())) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        private MySyncScrollable() {
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return SimpleDiffViewer.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        @NotNull
        public Range getRange(@NotNull Side baseSide, int line2) {
            if (baseSide == null) {
                MySyncScrollable.$$$reportNull$$$0(0);
            }
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                Range range2 = MySyncScrollable.idRange(line2);
                if (range2 == null) {
                    MySyncScrollable.$$$reportNull$$$0(1);
                }
                return range2;
            }
            Range range3 = super.getRange(baseSide, line2);
            if (range3 == null) {
                MySyncScrollable.$$$reportNull$$$0(2);
            }
            return range3;
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                MySyncScrollable.$$$reportNull$$$0(3);
            }
            if (!helper.process(0, 0)) {
                return;
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.myDiffChanges) {
                if (!helper.process(diffChange.getStartLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT))) {
                    return;
                }
                if (helper.process(diffChange.getEndLine(Side.LEFT), diffChange.getEndLine(Side.RIGHT))) continue;
                return;
            }
            helper.process(DiffUtil.getLineCount(SimpleDiffViewer.this.getEditor1().getDocument()), DiffUtil.getLineCount(SimpleDiffViewer.this.getEditor2().getDocument()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseSide";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRange";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processHelper";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        private int myIndex = 0;

        private ChangedLinesIterator() {
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < SimpleDiffViewer.this.myDiffChanges.size();
        }

        @Override
        public void loadNextBlock() {
            SimpleDiffChange change = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(this.myIndex);
            ++this.myIndex;
            int line1 = change.getStartLine(Side.RIGHT);
            int line2 = change.getEndLine(Side.RIGHT);
            DocumentEx document = SimpleDiffViewer.this.getEditor(Side.RIGHT).getDocument();
            for (int i = line1; i < line2; ++i) {
                int offset1 = document.getLineStartOffset(i);
                int offset2 = document.getLineEndOffset(i);
                CharSequence text2 = document.getImmutableCharSequence().subSequence(offset1, offset2);
                this.addLine(i, text2);
            }
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction() {
            super(SimpleDiffViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            SimpleDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        AppendSelectedChangesAction(Side focusedSide, boolean shortcut) {
            if (focusedSide == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")).getShortcutSet());
        }

        @Override
        @NotNull
        protected String getText(@NotNull Side side) {
            if (side == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(1);
            }
            String string = this.isBothEditable() ? (String)this.myModifiedSide.select((Object)"Append to the Left", (Object)"Append to the Right") : "Append";
            if (string == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(3);
            }
            return DiffUtil.getArrowDownIcon(this.myModifiedSide.other());
        }

        @Override
        protected void apply(@NotNull List<SimpleDiffChange> changes) {
            if (changes == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(4);
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.appendChange(change, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        ReplaceSelectedChangesAction(Side focusedSide, boolean shortcut) {
            if (focusedSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
        }

        @Override
        @NotNull
        protected String getText(@NotNull Side side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(1);
            }
            if (this.myModifiedSide == Side.RIGHT && SimpleDiffViewer.this.isDiffForLocalChanges()) {
                if ("Revert" == null) {
                    ReplaceSelectedChangesAction.$$$reportNull$$$0(2);
                }
                return "Revert";
            }
            if ("Accept" == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(3);
            }
            return "Accept";
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(4);
            }
            return DiffUtil.getArrowIcon(this.myModifiedSide.other());
        }

        @Override
        protected void apply(@NotNull List<SimpleDiffChange> changes) {
            if (changes == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(5);
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.replaceChange(change, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends SelectedChangesActionBase {
        @NotNull
        protected final Side myModifiedSide;

        ApplySelectedChangesActionBase(Side modifiedSide, boolean shortcut) {
            if (modifiedSide == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            super(shortcut);
            this.myModifiedSide = modifiedSide;
        }

        @Override
        protected boolean isVisible(@NotNull Side side) {
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            if (!SimpleDiffViewer.this.isEditable(this.myModifiedSide)) {
                return false;
            }
            return !this.isBothEditable() || side == this.myModifiedSide.other();
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(3);
            }
            if (changes == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(4);
            }
            if (!SimpleDiffViewer.this.isEditable(this.myModifiedSide)) {
                return;
            }
            String title = e.getPresentation().getText() + " selected changes";
            DiffUtil.executeWriteCommand(SimpleDiffViewer.this.getEditor(this.myModifiedSide).getDocument(), e.getProject(), title, () -> this.apply(changes));
        }

        protected boolean isBothEditable() {
            return SimpleDiffViewer.this.isEditable(Side.LEFT) && SimpleDiffViewer.this.isEditable(Side.RIGHT);
        }

        protected abstract void apply(@NotNull List<SimpleDiffChange> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedSide";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doPerform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected abstract class SelectedChangesActionBase
    extends DumbAwareAction {
        private final boolean myShortcut;

        public SelectedChangesActionBase(boolean shortcut) {
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleDiffViewer.this.getEditors(), (Object)editor);
            if (side == null || !this.isVisible(side)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setText(this.getText(side));
            e.getPresentation().setIcon(this.getIcon(side));
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(SimpleDiffViewer.this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleDiffViewer.this.getEditors(), (Object)editor);
            if (side == null) {
                return;
            }
            List<SimpleDiffChange> selectedChanges = SimpleDiffViewer.this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, side, ContainerUtil.reverse(selectedChanges));
        }

        protected abstract boolean isVisible(@NotNull Side var1);

        @NotNull
        protected abstract String getText(@NotNull Side var1);

        @Nullable
        protected abstract Icon getIcon(@NotNull Side var1);

        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull Side var2, @NotNull List<SimpleDiffChange> var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$SelectedChangesActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        MyReadOnlyLockAction() {
            super(SimpleDiffViewer.this.getContext(), SimpleDiffViewer.this.getEditableEditors());
        }

        @Override
        protected void doApply(boolean readOnly) {
            super.doApply(readOnly);
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                change.updateGutterActions(true);
            }
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<SimpleDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<SimpleDiffChange> getChanges() {
            List list2 = SimpleDiffViewer.this.getNonSkippedDiffChanges();
            if (list2 == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = SimpleDiffViewer.this.getCurrentEditor();
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull SimpleDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return change.getStartLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected int getEndLine(@NotNull SimpleDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return change.getEndLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected void scrollToChange(@NotNull SimpleDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(4);
            }
            SimpleDiffViewer.this.doScrollToChange(change, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "scrollToChange";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

