/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.DetailsPagePluginComponent;
import com.intellij.ide.plugins.newui.InstallPluginInfo;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyPluginModel
extends InstalledPluginsTableModel
implements PluginManagerMain.PluginEnabler {
    private final List<CellPluginComponent> myListComponents = new ArrayList<CellPluginComponent>();
    private final Map<IdeaPluginDescriptor, List<CellPluginComponent>> myListMap = new HashMap<IdeaPluginDescriptor, List<CellPluginComponent>>();
    private final Map<IdeaPluginDescriptor, List<CellPluginComponent>> myGridMap = new HashMap<IdeaPluginDescriptor, List<CellPluginComponent>>();
    private final List<PluginsGroup> myEnabledGroups = new ArrayList<PluginsGroup>();
    private PluginsGroupComponent myDownloadedPanel;
    private PluginsGroup myDownloaded;
    private PluginsGroup myInstalling;
    private PluginsGroup myUpdates;
    private Configurable.TopComponentController myTopController;
    private List<String> myVendorsSorted;
    private static final Set<IdeaPluginDescriptor> myInstallingPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Set<IdeaPluginDescriptor> myInstallingWithUpdatesPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Map<IdeaPluginDescriptor, InstallPluginInfo> myInstallingInfos = new HashMap<IdeaPluginDescriptor, InstallPluginInfo>();
    public boolean needRestart;
    public boolean createShutdownCallback = true;
    public DetailsPagePluginComponent detailPanel;
    private final List<PluginDetailsPageComponent> myDetailPanels = new ArrayList<PluginDetailsPageComponent>();
    private StatusBarEx myStatusBar;
    private PluginUpdatesService myPluginUpdatesService;
    private Runnable myInvalidFixCallback;

    protected MyPluginModel() {
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        this.myStatusBar = MyPluginModel.getStatusBar(window);
        if (this.myStatusBar == null && window != null) {
            this.myStatusBar = MyPluginModel.getStatusBar(window.getOwner());
        }
    }

    @Nullable
    private static StatusBarEx getStatusBar(@Nullable Window frame) {
        if (frame instanceof IdeFrame && !(frame instanceof WelcomeFrame)) {
            return (StatusBarEx)((IdeFrame)frame).getStatusBar();
        }
        return null;
    }

    public void addComponent(@NotNull CellPluginComponent component) {
        if (component == null) {
            MyPluginModel.$$$reportNull$$$0(0);
        }
        if (!component.isMarketplace()) {
            if (myInstallingPlugins.contains(component.myPlugin)) {
                return;
            }
            this.myListComponents.add(component);
            List components = this.myListMap.computeIfAbsent(component.myPlugin, __ -> new ArrayList());
            components.add(component);
        } else {
            List components = this.myGridMap.computeIfAbsent(component.myPlugin, __ -> new ArrayList());
            components.add(component);
        }
    }

    public void removeComponent(@NotNull CellPluginComponent component) {
        if (component == null) {
            MyPluginModel.$$$reportNull$$$0(1);
        }
        if (!component.isMarketplace()) {
            this.myListComponents.remove(component);
            List<CellPluginComponent> components = this.myListMap.get(component.myPlugin);
            if (components != null) {
                components.remove(component);
                if (components.isEmpty()) {
                    this.myListMap.remove(component.myPlugin);
                }
            }
        } else {
            List<CellPluginComponent> components = this.myGridMap.get(component.myPlugin);
            if (components != null) {
                components.remove(component);
                if (components.isEmpty()) {
                    this.myGridMap.remove(component.myPlugin);
                }
            }
        }
    }

    public void setTopController(@NotNull Configurable.TopComponentController topController) {
        if (topController == null) {
            MyPluginModel.$$$reportNull$$$0(2);
        }
        this.myTopController = topController;
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.fromBackground(this);
        }
        if (!myInstallingInfos.isEmpty()) {
            this.myTopController.showProgress(true);
        }
    }

    public void setPluginUpdatesService(@NotNull PluginUpdatesService service) {
        if (service == null) {
            MyPluginModel.$$$reportNull$$$0(3);
        }
        this.myPluginUpdatesService = service;
    }

    @Nullable
    public PluginsGroup getDownloadedGroup() {
        return this.myDownloaded;
    }

    @NotNull
    public static Set<IdeaPluginDescriptor> getInstallingPlugins() {
        Set<IdeaPluginDescriptor> set = myInstallingPlugins;
        if (set == null) {
            MyPluginModel.$$$reportNull$$$0(4);
        }
        return set;
    }

    static boolean isInstallingOrUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(5);
        }
        return myInstallingWithUpdatesPlugins.contains(descriptor2);
    }

    void installOrUpdatePlugin(@NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptor updateDescriptor) {
        PluginNode pluginNode;
        IdeaPluginDescriptor actionDescriptor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(6);
        }
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(Collections.singletonList(descriptor2))) {
            return;
        }
        IdeaPluginDescriptor ideaPluginDescriptor = actionDescriptor = updateDescriptor == null ? descriptor2 : updateDescriptor;
        if (actionDescriptor instanceof PluginNode) {
            pluginNode = (PluginNode)actionDescriptor;
        } else {
            pluginNode = new PluginNode(actionDescriptor.getPluginId(), actionDescriptor.getName(), "-1");
            pluginNode.setDepends(Arrays.asList(actionDescriptor.getDependentPluginIds()), actionDescriptor.getOptionalDependentPluginIds());
            pluginNode.setRepositoryName("__unknown_repository__");
        }
        ArrayList pluginsToInstall = ContainerUtil.newArrayList((Object[])new PluginNode[]{pluginNode});
        PluginManagerMain.suggestToEnableInstalledDependantPlugins(this, pluginsToInstall);
        MyPluginModel.installPlugin(pluginsToInstall, this.getAllRepoPlugins(), this, this.prepareToInstall(descriptor2, updateDescriptor));
    }

    private static void installPlugin(@NotNull List<PluginNode> pluginsToInstall, @NotNull List<? extends IdeaPluginDescriptor> allPlugins, @NotNull PluginManagerMain.PluginEnabler pluginEnabler, @NotNull InstallPluginInfo info) {
        if (pluginsToInstall == null) {
            MyPluginModel.$$$reportNull$$$0(7);
        }
        if (allPlugins == null) {
            MyPluginModel.$$$reportNull$$$0(8);
        }
        if (pluginEnabler == null) {
            MyPluginModel.$$$reportNull$$$0(9);
        }
        if (info == null) {
            MyPluginModel.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean cancel = false;
            boolean error = false;
            try {
                error = !PluginInstaller.prepareToInstall(pluginsToInstall, allPlugins, pluginEnabler, info.indicator);
            }
            catch (ProcessCanceledException e) {
                cancel = true;
            }
            catch (Throwable e) {
                PluginManagerMain.LOG.error(e);
                error = true;
            }
            boolean success = !error;
            boolean _cancel = cancel;
            ApplicationManager.getApplication().invokeLater(() -> info.finish(success, _cancel), ModalityState.any());
        });
    }

    public void toBackground() {
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.toBackground(this.myStatusBar);
        }
    }

    @NotNull
    private InstallPluginInfo prepareToInstall(@NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptor updateDescriptor) {
        List<CellPluginComponent> listComponents;
        List<CellPluginComponent> gridComponents;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(11);
        }
        boolean install = updateDescriptor == null;
        InstallPluginInfo info = new InstallPluginInfo(descriptor2, updateDescriptor, this, install);
        myInstallingInfos.put(descriptor2, info);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(true);
        }
        myInstallingWithUpdatesPlugins.add(descriptor2);
        if (install) {
            myInstallingPlugins.add(descriptor2);
        }
        if (install && this.myInstalling != null) {
            if (this.myInstalling.ui == null) {
                this.myInstalling.descriptors.add(descriptor2);
                this.myDownloadedPanel.addGroup(this.myInstalling, 0);
            } else {
                this.myDownloadedPanel.addToGroup(this.myInstalling, descriptor2);
            }
            this.myInstalling.titleWithCount();
            this.myDownloadedPanel.doLayout();
        }
        if ((gridComponents = this.myGridMap.get(descriptor2)) != null) {
            for (CellPluginComponent gridComponent : gridComponents) {
                gridComponent.showProgress();
            }
        }
        if ((listComponents = this.myListMap.get(descriptor2)) != null) {
            for (CellPluginComponent listComponent : listComponents) {
                listComponent.showProgress();
            }
        }
        if (this.detailPanel != null && this.detailPanel.myPlugin == descriptor2) {
            this.detailPanel.showProgress();
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.myPlugin != descriptor2) continue;
            panel2.showProgress();
        }
        InstallPluginInfo installPluginInfo = info;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(12);
        }
        return installPluginInfo;
    }

    void finishInstall(@NotNull IdeaPluginDescriptor descriptor2, boolean success, boolean showErrors) {
        List<CellPluginComponent> listComponents;
        List<CellPluginComponent> gridComponents;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(13);
        }
        InstallPluginInfo info = MyPluginModel.finishInstall(descriptor2);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(false);
        }
        if ((gridComponents = this.myGridMap.get(descriptor2)) != null) {
            for (CellPluginComponent cellPluginComponent : gridComponents) {
                cellPluginComponent.hideProgress(success);
            }
        }
        if ((listComponents = this.myListMap.get(descriptor2)) != null) {
            for (CellPluginComponent listComponent : listComponents) {
                listComponent.hideProgress(success);
            }
        }
        if (this.detailPanel != null && this.detailPanel.myPlugin == descriptor2) {
            this.detailPanel.hideProgress(success);
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.myPlugin != descriptor2) continue;
            panel2.hideProgress(success);
        }
        if (info.install) {
            if (this.myInstalling != null && this.myInstalling.ui != null) {
                this.clearInstallingProgress(descriptor2);
                if (myInstallingPlugins.isEmpty()) {
                    this.myDownloadedPanel.removeGroup(this.myInstalling);
                } else {
                    this.myDownloadedPanel.removeFromGroup(this.myInstalling, descriptor2);
                    this.myInstalling.titleWithCount();
                }
                this.myDownloadedPanel.doLayout();
            }
            if (success) {
                this.appendOrUpdateDescriptor(descriptor2);
                this.appendDependsAfterInstall();
            }
        } else if (success) {
            CellPluginComponent cellPluginComponent;
            if (this.myDownloaded != null && this.myDownloaded.ui != null && (cellPluginComponent = this.myDownloaded.ui.findComponent(descriptor2)) != null) {
                cellPluginComponent.enableRestart();
            }
            if (this.myUpdates != null) {
                this.myUpdates.titleWithCount();
            }
            this.myPluginUpdatesService.finishUpdate(info.updateDescriptor);
        }
        info.indicator.cancel();
        if (success) {
            this.needRestart = true;
        }
        if (!success && showErrors) {
            Messages.showErrorDialog((String)("Plugin " + descriptor2.getName() + " download or installing failed"), (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
        }
    }

    private void clearInstallingProgress(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(14);
        }
        if (myInstallingPlugins.isEmpty()) {
            for (CellPluginComponent listComponent : this.myInstalling.ui.plugins) {
                listComponent.clearProgress();
            }
        } else {
            for (CellPluginComponent listComponent : this.myInstalling.ui.plugins) {
                if (listComponent.myPlugin != descriptor2) continue;
                listComponent.clearProgress();
                return;
            }
        }
    }

    @NotNull
    static InstallPluginInfo finishInstall(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(15);
        }
        InstallPluginInfo info = myInstallingInfos.remove(descriptor2);
        myInstallingWithUpdatesPlugins.remove(descriptor2);
        if (info.install) {
            myInstallingPlugins.remove(descriptor2);
        }
        InstallPluginInfo installPluginInfo = info;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(16);
        }
        return installPluginInfo;
    }

    static void addProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            MyPluginModel.$$$reportNull$$$0(18);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2).indicator.addStateDelegate(indicator);
    }

    static void removeProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(19);
        }
        if (indicator == null) {
            MyPluginModel.$$$reportNull$$$0(20);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2).indicator.removeStateDelegate(indicator);
    }

    public void addEnabledGroup(@NotNull PluginsGroup group) {
        if (group == null) {
            MyPluginModel.$$$reportNull$$$0(21);
        }
        this.myEnabledGroups.add(group);
    }

    public void setDownloadedGroup(@NotNull PluginsGroupComponent panel2, @NotNull PluginsGroup downloaded, @NotNull PluginsGroup installing) {
        if (panel2 == null) {
            MyPluginModel.$$$reportNull$$$0(22);
        }
        if (downloaded == null) {
            MyPluginModel.$$$reportNull$$$0(23);
        }
        if (installing == null) {
            MyPluginModel.$$$reportNull$$$0(24);
        }
        this.myDownloadedPanel = panel2;
        this.myDownloaded = downloaded;
        this.myInstalling = installing;
    }

    public void setUpdateGroup(@NotNull PluginsGroup group) {
        if (group == null) {
            MyPluginModel.$$$reportNull$$$0(25);
        }
        this.myUpdates = group;
    }

    private void appendDependsAfterInstall() {
        if (this.myDownloaded == null || this.myDownloaded.ui == null) {
            return;
        }
        block0: for (IdeaPluginDescriptor descriptor2 : InstalledPluginsState.getInstance().getInstalledPlugins()) {
            if (this.myDownloaded.ui.findComponent(descriptor2) != null) continue;
            this.appendOrUpdateDescriptor(descriptor2);
            String id = descriptor2.getPluginId().getIdString();
            for (Map.Entry<IdeaPluginDescriptor, List<CellPluginComponent>> entry : this.myGridMap.entrySet()) {
                if (!id.equals(entry.getKey().getPluginId().getIdString())) continue;
                for (CellPluginComponent component : entry.getValue()) {
                    component.hideProgress(true);
                }
                continue block0;
            }
        }
    }

    public void addDetailPanel(@NotNull PluginDetailsPageComponent detailPanel) {
        if (detailPanel == null) {
            MyPluginModel.$$$reportNull$$$0(26);
        }
        this.myDetailPanels.add(detailPanel);
    }

    @Override
    public void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(27);
        }
        super.appendOrUpdateDescriptor(descriptor2);
        this.needRestart = true;
        if (this.myDownloaded == null) {
            return;
        }
        this.myVendorsSorted = null;
        if (this.myDownloaded.ui == null) {
            this.myDownloaded.descriptors.add(descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myDownloadedPanel.addGroup(this.myDownloaded, this.myInstalling == null || this.myInstalling.ui == null ? 0 : 1);
            this.myDownloadedPanel.setSelection(this.myDownloaded.ui.plugins.get(0));
            this.myDownloadedPanel.doLayout();
            this.addEnabledGroup(this.myDownloaded);
        } else {
            CellPluginComponent component = this.myDownloaded.ui.findComponent(descriptor2);
            if (component != null) {
                this.myDownloadedPanel.setSelection(component);
                component.enableRestart();
                return;
            }
            this.myDownloadedPanel.addToGroup(this.myDownloaded, descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myDownloadedPanel.setSelection(this.myDownloaded.ui.plugins.get(this.myDownloaded.descriptors.indexOf(descriptor2)));
            this.myDownloadedPanel.doLayout();
        }
    }

    @NotNull
    public List<String> getVendors() {
        if (ContainerUtil.isEmpty(this.myVendorsSorted)) {
            assert (this.myDownloadedPanel != null);
            List descriptors = this.myDownloadedPanel.getGroups().stream().flatMap(group -> group.plugins.stream()).map(plugin -> plugin.myPlugin).collect(Collectors.toList());
            this.myVendorsSorted = MyPluginModel.getVendors(descriptors);
        }
        List<String> list2 = this.myVendorsSorted;
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @NotNull
    public static List<String> getVendors(@NotNull List<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            MyPluginModel.$$$reportNull$$$0(29);
        }
        HashMap<String, Integer> vendors = new HashMap<String, Integer>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            String vendor = StringUtil.trim((String)ideaPluginDescriptor.getVendor());
            if (StringUtil.isEmptyOrSpaces((String)vendor)) continue;
            Integer count = (Integer)vendors.get(vendor);
            if (count == null) {
                vendors.put(vendor, 1);
                continue;
            }
            vendors.put(vendor, count + 1);
        }
        vendors.put("JetBrains", Integer.MAX_VALUE);
        List list2 = ContainerUtil.sorted(vendors.keySet(), (v1, v2) -> {
            int result2 = (Integer)vendors.get(v2) - (Integer)vendors.get(v1);
            return result2 == 0 ? v2.compareToIgnoreCase((String)v1) : result2;
        });
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(30);
        }
        return list2;
    }

    public static boolean isVendor(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Set<String> vendors) {
        String vendor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(31);
        }
        if (vendors == null) {
            MyPluginModel.$$$reportNull$$$0(32);
        }
        if (StringUtil.isEmpty((String)(vendor = StringUtil.trim((String)descriptor2.getVendor())))) {
            return false;
        }
        for (String vendorToFind : vendors) {
            if (!vendor.equalsIgnoreCase(vendorToFind) && !StringUtil.containsIgnoreCase((String)vendor, (String)vendorToFind)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(@NotNull IdeaPluginDescriptor plugin) {
        Boolean enabled;
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(33);
        }
        return (enabled = this.getEnabledMap().get(plugin.getPluginId())) == null || enabled != false;
    }

    @NotNull
    String getEnabledTitle(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(34);
        }
        String string = this.isEnabled(plugin) ? "Disable" : "Enable";
        if (string == null) {
            MyPluginModel.$$$reportNull$$$0(35);
        }
        return string;
    }

    void changeEnableDisable(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(36);
        }
        this.enableRows(new IdeaPluginDescriptor[]{plugin}, !this.isEnabled(plugin));
        this.updateAfterEnableDisable();
    }

    public void changeEnableDisable(@NotNull IdeaPluginDescriptor[] plugins2, boolean state) {
        if (plugins2 == null) {
            MyPluginModel.$$$reportNull$$$0(37);
        }
        this.enableRows(plugins2, state);
        this.updateAfterEnableDisable();
    }

    @Override
    public void enablePlugins(Set<? extends IdeaPluginDescriptor> disabled) {
        this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), true);
    }

    @Override
    public void disablePlugins(Set<? extends IdeaPluginDescriptor> disabled) {
        this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), false);
    }

    void enableRequiredPlugins(@NotNull IdeaPluginDescriptor descriptor2) {
        Set<PluginId> requiredPluginIds;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(38);
        }
        if (ContainerUtil.isEmpty(requiredPluginIds = this.getRequiredPlugins(descriptor2.getPluginId()))) {
            return;
        }
        List<IdeaPluginDescriptor> allPlugins = this.getAllPlugins();
        HashSet<IdeaPluginDescriptor> requiredPlugins = new HashSet<IdeaPluginDescriptor>();
        for (PluginId pluginId : requiredPluginIds) {
            IdeaPluginDescriptor result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> pluginId.equals(d.getPluginId()));
            if (result2 == null && PluginManagerCore.isModuleDependency(pluginId) && (result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> {
                if (d instanceof IdeaPluginDescriptorImpl) {
                    return ((IdeaPluginDescriptorImpl)d).getModules().contains(pluginId.getIdString());
                }
                return false;
            })) != null) {
                this.getEnabledMap().put(pluginId, Boolean.TRUE);
            }
            if (result2 == null) continue;
            requiredPlugins.add(result2);
        }
        if (!requiredPlugins.isEmpty()) {
            this.enablePlugins(requiredPlugins);
            if (this.myInvalidFixCallback != null) {
                ApplicationManager.getApplication().invokeLater(this.myInvalidFixCallback, ModalityState.any());
            }
        }
    }

    public void setInvalidFixCallback(@Nullable Runnable invalidFixCallback) {
        this.myInvalidFixCallback = invalidFixCallback;
    }

    private void updateAfterEnableDisable() {
        for (CellPluginComponent component : this.myListComponents) {
            component.updateEnabledState();
        }
        for (PluginDetailsPageComponent detailPanel : this.myDetailPanels) {
            detailPanel.updateEnabledState();
        }
        for (PluginsGroup group : this.myEnabledGroups) {
            group.titleWithEnabled(this);
        }
    }

    static boolean showUninstallDialog(@NotNull List<? extends CellPluginComponent> selection) {
        int size;
        if (selection == null) {
            MyPluginModel.$$$reportNull$$$0(39);
        }
        return MyPluginModel.showUninstallDialog((size = selection.size()) == 1 ? selection.get((int)0).myPlugin.getName() : null, size);
    }

    static boolean showUninstallDialog(@Nullable String singleName, int count) {
        String message = singleName == null ? IdeBundle.message((String)"prompt.uninstall.several.plugins", (Object[])new Object[]{count}) : IdeBundle.message((String)"prompt.uninstall.plugin", (Object[])new Object[]{singleName});
        return Messages.showYesNoDialog((String)message, (String)IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    void doUninstall(@NotNull Component uiParent, @NotNull IdeaPluginDescriptor descriptor2, @Nullable Runnable update2) {
        List<CellPluginComponent> listComponents;
        String title;
        String message;
        if (uiParent == null) {
            MyPluginModel.$$$reportNull$$$0(40);
        }
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(41);
        }
        if (!this.dependent((IdeaPluginDescriptorImpl)descriptor2).isEmpty() && Messages.showYesNoDialog((Component)uiParent, (String)(message = IdeBundle.message((String)"several.plugins.depend.on.0.continue.to.remove", (Object[])new Object[]{descriptor2.getName()})), (String)(title = IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        try {
            ((IdeaPluginDescriptorImpl)descriptor2).setDeleted(true);
            PluginInstaller.prepareToUninstall(descriptor2.getPluginId());
            this.needRestart |= descriptor2.isEnabled();
        }
        catch (IOException e) {
            PluginManagerMain.LOG.error((Throwable)e);
        }
        if (update2 != null) {
            update2.run();
        }
        if ((listComponents = this.myListMap.get(descriptor2)) != null) {
            for (CellPluginComponent listComponent : listComponents) {
                listComponent.updateAfterUninstall();
            }
        }
        for (CellPluginComponent component : this.myListComponents) {
            component.updateErrors();
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.myPlugin != descriptor2) continue;
            panel2.enableRestart();
        }
    }

    @Nullable
    public static IdeaPluginDescriptor findPlugin(@NotNull PluginId id) {
        IdeaPluginDescriptor plugin;
        if (id == null) {
            MyPluginModel.$$$reportNull$$$0(42);
        }
        if ((plugin = PluginManager.getPlugin(id)) == null && PluginManagerCore.isModuleDependency(id)) {
            for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                if (!(descriptor2 instanceof IdeaPluginDescriptorImpl) || !((IdeaPluginDescriptorImpl)descriptor2).getModules().contains(id.getIdString())) continue;
                return descriptor2;
            }
        }
        return plugin;
    }

    @Override
    public boolean hasProblematicDependencies(PluginId pluginId) {
        Set<PluginId> ids = this.getDependentToRequiredListMap().get(pluginId);
        if (ContainerUtil.isEmpty(ids)) {
            return false;
        }
        for (PluginId id : ids) {
            IdeaPluginDescriptor plugin = MyPluginModel.findPlugin(id);
            if (plugin == null || this.isEnabled(plugin)) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(43);
        }
        return PluginManagerCore.isIncompatible(plugin) || this.hasProblematicDependencies(plugin.getPluginId());
    }

    @NotNull
    public String getErrorMessage(@NotNull PluginDescriptor pluginDescriptor, @NotNull Ref<? super String> enableAction) {
        String message;
        Set<PluginId> requiredPlugins;
        if (pluginDescriptor == null) {
            MyPluginModel.$$$reportNull$$$0(44);
        }
        if (enableAction == null) {
            MyPluginModel.$$$reportNull$$$0(45);
        }
        if (ContainerUtil.isEmpty(requiredPlugins = this.getRequiredPlugins(pluginDescriptor.getPluginId()))) {
            message = "Incompatible with the current " + ApplicationNamesInfo.getInstance().getFullProductName() + " version.";
        } else if (requiredPlugins.contains(PluginId.getId((String)"com.intellij.modules.ultimate"))) {
            message = "The plugin requires IntelliJ IDEA Ultimate.";
        } else {
            String deps = StringUtil.join(requiredPlugins, id -> {
                IdeaPluginDescriptor plugin = MyPluginModel.findPlugin(id);
                return StringUtil.wrapWithDoubleQuote((String)(plugin != null ? plugin.getName() : id.getIdString()));
            }, (String)", ");
            int size = requiredPlugins.size();
            message = IdeBundle.message((String)"new.plugin.manager.incompatible.deps.tooltip", (Object[])new Object[]{size, deps});
            enableAction.set((Object)IdeBundle.message((String)"new.plugin.manager.incompatible.deps.action", (Object[])new Object[]{size}));
        }
        String string = message;
        if (string == null) {
            MyPluginModel.$$$reportNull$$$0(46);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 16: 
            case 28: 
            case 30: 
            case 35: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 16: 
            case 28: 
            case 30: 
            case 35: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topController";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: 
            case 12: 
            case 16: 
            case 28: 
            case 30: 
            case 35: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 27: 
            case 31: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPlugins";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloaded";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installing";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailPanel";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendors";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiParent";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallingPlugins";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareToInstall";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "finishInstall";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendors";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledTitle";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTopController";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPluginUpdatesService";
                break;
            }
            case 4: 
            case 12: 
            case 16: 
            case 28: 
            case 30: 
            case 35: 
            case 46: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInstallingOrUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installOrUpdatePlugin";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "installPlugin";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "finishInstall";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clearInstallingProgress";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addProgress";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeProgress";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addEnabledGroup";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setDownloadedGroup";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setUpdateGroup";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addDetailPanel";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendOrUpdateDescriptor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVendors";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isVendor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledTitle";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "changeEnableDisable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "enableRequiredPlugins";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showUninstallDialog";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "doUninstall";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasErrors";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 16: 
            case 28: 
            case 30: 
            case 35: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

