/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class DarculaButtonUI
extends BasicButtonUI {
    private final Rectangle viewRect = new Rectangle();
    private final Rectangle textRect = new Rectangle();
    private final Rectangle iconRect = new Rectangle();
    protected static JBValue HELP_BUTTON_DIAMETER = new JBValue.Float(22.0f);
    protected static JBValue MINIMUM_BUTTON_WIDTH = new JBValue.Float(72.0f);
    protected static JBValue HORIZONTAL_PADDING = new JBValue.Float(14.0f);

    public static ComponentUI createUI(JComponent c2) {
        return new DarculaButtonUI();
    }

    public static boolean isSquare(Component c2) {
        return c2 instanceof AbstractButton && "square".equals(((AbstractButton)c2).getClientProperty("JButton.buttonType"));
    }

    public static boolean isDefaultButton(JComponent c2) {
        return c2 instanceof JButton && ((JButton)c2).isDefaultButton();
    }

    public static boolean isSmallComboButton(Component c2) {
        ComboBoxAction a = DarculaButtonUI.getComboAction(c2);
        return a != null && a.isSmallVariant();
    }

    public static ComboBoxAction getComboAction(Component c2) {
        return c2 instanceof AbstractButton ? (ComboBoxAction)((JComponent)c2).getClientProperty("styleCombo") : null;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setIconTextGap(this.textIconGap());
        b.setMargin((Insets)JBUI.emptyInsets());
    }

    protected int textIconGap() {
        return JBUIScale.scale((int)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean paintDecorations(Graphics2D g, JComponent c2) {
        Rectangle r = new Rectangle(c2.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
        if (UIUtil.isHelpButton((Component)c2)) {
            g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getButtonColorEnd()));
            int diam = HELP_BUTTON_DIAMETER.get();
            int x = r.x + (r.width - diam) / 2;
            int y = r.x + (r.height - diam) / 2;
            g.fill(new Ellipse2D.Float(x, y, diam, diam));
            AllIcons.Actions.Help.paintIcon(c2, g, x + JBUIScale.scale((int)3), y + JBUIScale.scale((int)3));
            return false;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            float bw;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float arc = DarculaUIUtil.BUTTON_ARC.getFloat();
            float f = bw = DarculaButtonUI.isSmallComboButton(c2) ? 0.0f : DarculaUIUtil.BW.getFloat();
            if (!c2.hasFocus() && !DarculaButtonUI.isSmallComboButton(c2) && c2.isEnabled() && UIManager.getBoolean("Button.paintShadow")) {
                JBColor shadowColor = JBColor.namedColor((String)"Button.shadowColor", (Color)JBColor.namedColor((String)"Button.darcula.shadowColor", (Color)new JBColor(new Color(-1499027917, true), new Color(909522560, true))));
                int shadowWidth = JBUIScale.scale((int)JBUI.getInt((String)"Button.shadowWidth", (int)2));
                g2.setColor((Color)(DarculaButtonUI.isDefaultButton(c2) ? JBColor.namedColor((String)"Button.default.shadowColor", (Color)shadowColor) : shadowColor));
                g2.fill(new RoundRectangle2D.Float(bw, bw + (float)shadowWidth, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
            }
            if (c2.isEnabled()) {
                g2.setPaint(this.getBackground(c2, r));
                g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
            }
        }
        finally {
            g2.dispose();
        }
        return true;
    }

    private Paint getBackground(JComponent c2, Rectangle r) {
        Color backgroundColor = (Color)c2.getClientProperty("JButton.backgroundColor");
        return backgroundColor != null ? backgroundColor : (DarculaButtonUI.isSmallComboButton(c2) ? JBColor.namedColor((String)"ComboBoxButton.background", (Color)JBColor.namedColor((String)"Button.darcula.smallComboButtonBackground", (Color)UIUtil.getPanelBackground())) : (DarculaButtonUI.isDefaultButton(c2) ? UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getDefaultButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getDefaultButtonColorEnd()) : UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getButtonColorEnd())));
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        if (this.paintDecorations((Graphics2D)g, c2)) {
            this.paintContents(g, (AbstractButton)c2);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c2, Rectangle textRect, String text2) {
        int mnemonicIndex;
        if (UIUtil.isHelpButton((Component)c2)) {
            return;
        }
        AbstractButton button2 = (AbstractButton)c2;
        ButtonModel model2 = button2.getModel();
        g.setColor(this.getButtonTextColor(button2));
        FontMetrics metrics = UIUtilities.getFontMetrics((JComponent)c2, (Graphics)g);
        int n = mnemonicIndex = DarculaLaf.isAltPressed() ? button2.getDisplayedMnemonicIndex() : -1;
        if (model2.isEnabled()) {
            UIUtilities.drawStringUnderlineCharAt((JComponent)c2, (Graphics)g, (String)text2, (int)mnemonicIndex, (int)(textRect.x + this.getTextShiftOffset()), (int)(textRect.y + metrics.getAscent() + this.getTextShiftOffset()));
        } else {
            this.paintDisabledText(g, text2, c2, textRect, metrics);
        }
    }

    protected Color getButtonTextColor(AbstractButton button2) {
        Color textColor = (Color)button2.getClientProperty("JButton.textColor");
        return textColor != null ? textColor : DarculaUIUtil.getButtonTextColor(button2);
    }

    public static Color getDisabledTextColor() {
        return UIManager.getColor("Button.disabledText");
    }

    protected void paintDisabledText(Graphics g, String text2, JComponent c2, Rectangle textRect, FontMetrics metrics) {
        g.setColor(UIManager.getColor("Button.disabledText"));
        UIUtilities.drawStringUnderlineCharAt((JComponent)c2, (Graphics)g, (String)text2, (int)-1, (int)(textRect.x + this.getTextShiftOffset()), (int)(textRect.y + metrics.getAscent() + this.getTextShiftOffset()));
    }

    protected void paintContents(Graphics g, AbstractButton b) {
        if (b instanceof JBOptionButton) {
            return;
        }
        FontMetrics fm = UIUtilities.getFontMetrics((JComponent)b, (Graphics)g);
        boolean isDotButton = DarculaButtonUI.isSquare(b) && b.getIcon() == AllIcons.General.Ellipsis;
        String text2 = isDotButton ? "..." : b.getText();
        Icon icon = isDotButton ? null : b.getIcon();
        text2 = this.layout(b, text2, icon, fm, b.getWidth(), b.getHeight());
        if (DarculaButtonUI.isSquare(b)) {
            if (b.getIcon() == AllIcons.General.Ellipsis) {
                UISettings.setupAntialiasing((Graphics)g);
                this.paintText(g, b, this.textRect, text2);
            } else if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
        } else {
            if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
            if (text2 != null && !text2.isEmpty()) {
                View v = (View)b.getClientProperty("html");
                if (v != null) {
                    v.paint(g, this.textRect);
                } else {
                    UISettings.setupAntialiasing((Graphics)g);
                    this.paintText(g, b, this.textRect, text2);
                }
            }
        }
    }

    protected Dimension getDarculaButtonSize(JComponent c2, Dimension prefSize) {
        Insets i = c2.getInsets();
        prefSize = (Dimension)ObjectUtils.notNull((Object)prefSize, (Object)JBUI.emptySize());
        if (UIUtil.isHelpButton((Component)c2) || DarculaButtonUI.isSquare(c2)) {
            int helpDiam = HELP_BUTTON_DIAMETER.get();
            return new Dimension(Math.max(prefSize.width, helpDiam + i.left + i.right), Math.max(prefSize.height, helpDiam + i.top + i.bottom));
        }
        int width = DarculaButtonUI.getComboAction(c2) != null ? prefSize.width : Math.max(HORIZONTAL_PADDING.get() * 2 + prefSize.width, MINIMUM_BUTTON_WIDTH.get() + i.left + i.right);
        int height = Math.max(prefSize.height, this.getMinimumHeight() + i.top + i.bottom);
        return new Dimension(width, height);
    }

    protected int getMinimumHeight() {
        return DarculaUIUtil.MINIMUM_HEIGHT.get();
    }

    @Override
    public final Dimension getPreferredSize(JComponent c2) {
        AbstractButton b = (AbstractButton)c2;
        int textIconGap = StringUtil.isEmpty((String)b.getText()) || b.getIcon() == null ? 0 : b.getIconTextGap();
        Dimension size = BasicGraphicsUtils.getPreferredButtonSize(b, textIconGap);
        return this.getDarculaButtonSize(c2, size);
    }

    @Override
    public void update(Graphics g, JComponent c2) {
        this.setupDefaultButton(c2, g);
        super.update(g, c2);
    }

    protected void setupDefaultButton(JComponent button2, Graphics g) {
        Font f = button2.getFont();
        if (!SystemInfo.isMac && f instanceof FontUIResource && DarculaButtonUI.isDefaultButton(button2)) {
            g.setFont(f.deriveFont(1));
        }
    }

    protected Color getButtonColorStart() {
        return JBColor.namedColor((String)"Button.startBackground", (Color)JBColor.namedColor((String)"Button.darcula.startColor", (int)0x555A5C));
    }

    protected Color getButtonColorEnd() {
        return JBColor.namedColor((String)"Button.endBackground", (Color)JBColor.namedColor((String)"Button.darcula.endColor", (int)4277832));
    }

    protected Color getDefaultButtonColorStart() {
        return JBColor.namedColor((String)"Button.default.startBackground", (Color)JBColor.namedColor((String)"Button.darcula.defaultStartColor", (int)3690347));
    }

    protected Color getDefaultButtonColorEnd() {
        return JBColor.namedColor((String)"Button.default.endBackground", (Color)JBColor.namedColor((String)"Button.darcula.defaultEndColor", (int)2306371));
    }

    protected String layout(AbstractButton b, String text2, Icon icon, FontMetrics fm, int width, int height) {
        this.textRect.setBounds(0, 0, 0, 0);
        this.iconRect.setBounds(0, 0, 0, 0);
        this.viewRect.setBounds(0, 0, width, height);
        this.modifyViewRect(b, this.viewRect);
        return SwingUtilities.layoutCompoundLabel(b, fm, text2, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, StringUtil.isEmpty((String)text2) || icon == null ? 0 : b.getIconTextGap());
    }

    protected void modifyViewRect(AbstractButton b, Rectangle rect) {
        JBInsets.removeFrom((Rectangle)rect, (Insets)b.getInsets());
        JBInsets.removeFrom((Rectangle)rect, (Insets)b.getMargin());
    }
}

