/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowWhitelistEP;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowCollector {
    public static final Map<String, PluginInfo> ourToolwindowWhitelist = new HashMap<String, PluginInfo>();

    public static ToolWindowCollector getInstance() {
        return (ToolWindowCollector)ServiceManager.getService(ToolWindowCollector.class);
    }

    public ToolWindowCollector() {
        for (ToolWindowWhitelistEP extension : (ToolWindowWhitelistEP[])ToolWindowWhitelistEP.EP_NAME.getExtensions()) {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfoById(extension.getPluginId());
            if (!info.isDevelopedByJetBrains()) continue;
            ourToolwindowWhitelist.put(extension.id, info);
        }
    }

    public void recordActivation(String toolWindowId) {
        this.record(toolWindowId, ToolWindowActivationSource.ACTIVATION);
    }

    public void recordClick(String toolWindowId) {
        this.record(toolWindowId, ToolWindowActivationSource.CLICK);
    }

    private void record(@Nullable String toolWindowId, @NotNull ToolWindowActivationSource source) {
        if (source == null) {
            ToolWindowCollector.$$$reportNull$$$0(0);
        }
        if (StringUtil.isNotEmpty((String)toolWindowId)) {
            FeatureUsageData data = new FeatureUsageData().addOS();
            if (source != ToolWindowActivationSource.ACTIVATION) {
                data.addData("source", StringUtil.toLowerCase((String)source.name()));
            }
            FUCounterUsageLogger.getInstance().logEvent("toolwindow", toolWindowId, data);
        }
    }

    @NotNull
    private static PluginInfo getPluginInfo(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(1);
        }
        if (ourToolwindowWhitelist.containsKey(toolWindowId)) {
            PluginInfo pluginInfo = ourToolwindowWhitelist.get(toolWindowId);
            if (pluginInfo == null) {
                ToolWindowCollector.$$$reportNull$$$0(2);
            }
            return pluginInfo;
        }
        PluginInfo info = ToolWindowCollector.getPluginInfo(toolWindowId, (ToolWindowEP[])ToolWindowEP.EP_NAME.getExtensions());
        if (info == null) {
            info = ToolWindowCollector.getPluginInfo(toolWindowId, (ToolWindowEP[])LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        if (info == null) {
            info = ToolWindowCollector.getPluginInfo(toolWindowId, (ToolWindowEP[])FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        PluginInfo pluginInfo = info != null ? info : PluginInfoDetectorKt.getUnknownPlugin();
        if (pluginInfo == null) {
            ToolWindowCollector.$$$reportNull$$$0(3);
        }
        return pluginInfo;
    }

    @Nullable
    public static PluginInfo getPluginInfo(@NotNull String toolWindowId, @NotNull ToolWindowEP[] toolWindows) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(4);
        }
        if (toolWindows == null) {
            ToolWindowCollector.$$$reportNull$$$0(5);
        }
        for (ToolWindowEP ep : toolWindows) {
            if (!StringUtil.equals((CharSequence)toolWindowId, (CharSequence)ep.id)) continue;
            return PluginInfoDetectorKt.getPluginInfoById(ep.getPluginId());
        }
        return null;
    }

    static {
        ourToolwindowWhitelist.put(ToolWindowId.COMMANDER, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.MESSAGES_WINDOW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.PROJECT_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.STRUCTURE_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.FAVORITES_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.ANT_BUILD, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DEBUG, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.RUN, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.BUILD, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.FIND, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.CVS, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.HIERARCHY, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.INSPECTION, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.TODO_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DEPENDENCIES, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.VCS, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.MODULES_DEPENDENCIES, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DUPLICATES, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.EXTRACT_METHOD, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DOCUMENTATION, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.TASKS, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DATABASE_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.PREVIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.RUN_DASHBOARD, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.SERVICES, PluginInfoDetectorKt.getPlatformPlugin());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPluginInfo";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ToolWindowUtilValidator
    extends CustomWhiteListRule {
        @Override
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "toolwindow".equals(ruleId);
        }

        @Override
        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(1);
            }
            if ("unknown".equals(data)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    ToolWindowUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            PluginInfo info = ToolWindowCollector.getPluginInfo(data);
            if (StringUtil.equals((CharSequence)data, (CharSequence)context.eventId)) {
                context.setPluginInfo(info);
            }
            ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum ToolWindowActivationSource {
        ACTIVATION,
        CLICK;

    }
}

