/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseCredentials {
    private static final String DB_SSH_PWD = "db:ssh:pwd@";
    private static final String DB_SSH_PHR = "db:ssh:phr@";
    private static final DatabaseCredentials ourInstance = new DatabaseCredentials(DbCredentialManager.Global.INSTANCE);
    private static final DatabaseCredentials ourStrictInstance = new DatabaseCredentials(DbCredentialManager.GlobalStrict.INSTANCE);
    private final DbCredentialManager myCredentialManager;
    private static final Object ourEDTLock = new Object();

    private DatabaseCredentials(DbCredentialManager manager) {
        this.myCredentialManager = manager;
    }

    public static DatabaseCredentials getInstance() {
        return ourInstance;
    }

    public static DatabaseCredentials newUIInstance() {
        return new DatabaseCredentials(new DbCredentialManager.Local());
    }

    @NotNull
    public DatabaseCredentials strict() {
        DatabaseCredentials databaseCredentials = this.myCredentialManager instanceof DbCredentialManager.Local ? this : ourStrictInstance;
        if (databaseCredentials == null) {
            DatabaseCredentials.$$$reportNull$$$0(0);
        }
        return databaseCredentials;
    }

    @Nullable
    private static LocalDataSource getLocalDataSource(@Nullable DasDataSource info) {
        if (!(info instanceof LocalDataSource)) {
            return null;
        }
        if (!DbImplUtil.isAuthRequired((LocalDataSource)info)) {
            return null;
        }
        return (LocalDataSource)info;
    }

    @Nullable
    public Credentials getCredentials(@NotNull DasDataSource info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(1);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return null;
        }
        return new Credentials(dataSource.getUsername(), this.getPassword(info));
    }

    @Nullable
    public OneTimeString getPassword(@NotNull DasDataSource info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(2);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return null;
        }
        return dataSource.getPasswordStorage().isOneTime() ? null : this.myCredentialManager.getPassword(dataSource, null);
    }

    @NotNull
    public CompletionStage<Credentials> getCredentialsAsync(@NotNull DasDataSource info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(3);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DatabaseCredentials.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        CompletionStage<Credentials> completionStage = AsyncUtil.supplyAsync(() -> CompletableFuture.completedFuture(this.getCredentials(info)), AsyncUtil.POOL_EXECUTOR);
        if (completionStage == null) {
            DatabaseCredentials.$$$reportNull$$$0(5);
        }
        return completionStage;
    }

    public void setPassword(@NotNull DasDataSource info, @Nullable OneTimeString password) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(6);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return;
        }
        LocalDataSource.Storage storage = dataSource.getPasswordStorage();
        this.myCredentialManager.setPassword(dataSource, storage.isOneTime() ? null : password, storage.isPersisted());
    }

    public void copyAllCredentials(@NotNull DasDataSource from, @NotNull DasDataSource to, @NotNull DatabaseCredentials toStorage) {
        if (from == null) {
            DatabaseCredentials.$$$reportNull$$$0(7);
        }
        if (to == null) {
            DatabaseCredentials.$$$reportNull$$$0(8);
        }
        if (toStorage == null) {
            DatabaseCredentials.$$$reportNull$$$0(9);
        }
        toStorage.setPassword(to, this.getPassword(from));
        toStorage.setSshPassword(to, this.getSshPassword(from));
        toStorage.setSshPassphrase(to, this.getSshPassphrase(from));
    }

    public void setSshPassword(@NotNull DasDataSource dataSource, @Nullable OneTimeString pwd) {
        if (dataSource == null) {
            DatabaseCredentials.$$$reportNull$$$0(10);
        }
        this.setSshImpl(dataSource, pwd, DB_SSH_PWD);
    }

    public void setSshPassphrase(@NotNull DasDataSource dataSource, @Nullable OneTimeString phr) {
        if (dataSource == null) {
            DatabaseCredentials.$$$reportNull$$$0(11);
        }
        this.setSshImpl(dataSource, phr, DB_SSH_PHR);
    }

    public void handleSessionFinished(@NotNull DasDataSource info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(12);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return;
        }
        LocalDataSource.Storage storage = dataSource.getPasswordStorage();
        if (storage == LocalDataSource.Storage.SESSION) {
            this.setPassword(info, null);
        }
    }

    private void setSshImpl(@NotNull DasDataSource info, @Nullable OneTimeString secret, String prefix) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(13);
        }
        if ((dataSource = (LocalDataSource)ObjectUtils.tryCast((Object)info, LocalDataSource.class)) == null) {
            return;
        }
        DataSourceSshTunnelConfiguration ssh = dataSource.getSshConfiguration();
        LocalDataSource.Storage storage = LocalDataSource.Storage.orMem(ssh == null ? null : ssh.getPasswordStorage());
        this.myCredentialManager.setPassword(dataSource, storage.isOneTime() ? null : secret, storage.isPersisted(), prefix);
    }

    @Nullable
    public OneTimeString getSshPassword(@NotNull DasDataSource info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(14);
        }
        return (dataSource = (LocalDataSource)ObjectUtils.tryCast((Object)info, LocalDataSource.class)) != null ? this.myCredentialManager.getPassword(dataSource, DB_SSH_PWD) : null;
    }

    @Nullable
    public OneTimeString getSshPassphrase(@NotNull DasDataSource info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(15);
        }
        return (dataSource = (LocalDataSource)ObjectUtils.tryCast((Object)info, LocalDataSource.class)) != null ? this.myCredentialManager.getPassword(dataSource, DB_SSH_PHR) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeLater(@NotNull Runnable r) {
        Application app;
        if (r == null) {
            DatabaseCredentials.$$$reportNull$$$0(16);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            r.run();
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        Object object = ourEDTLock;
        synchronized (object) {
            ModalityState modalityState = ModalityState.defaultModalityState();
            if (indicator != null && indicator.isModal()) {
                GuiUtils.invokeLaterIfNeeded((Runnable)r, (ModalityState)modalityState);
            } else {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(r, modalityState);
            }
        }
    }

    public static <T> CompletableFuture<T> showCredentialsDialog(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, AsyncUtil.asyncFriendlyExecutor(r -> DatabaseCredentials.invokeLater(r)));
    }

    @NotNull
    public static DialogBuilder prepareDialog(@NotNull Project project, @Nullable Icon icon, @NotNull JComponent component, @NotNull String title, @NotNull String message2) {
        if (project == null) {
            DatabaseCredentials.$$$reportNull$$$0(17);
        }
        if (component == null) {
            DatabaseCredentials.$$$reportNull$$$0(18);
        }
        if (title == null) {
            DatabaseCredentials.$$$reportNull$$$0(19);
        }
        if (message2 == null) {
            DatabaseCredentials.$$$reportNull$$$0(20);
        }
        JPanel panel = new JPanel(new BorderLayout());
        JTextPane messageField = Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)message2, (UIUtil.FontSize)UIUtil.FontSize.SMALL);
        JComponent msgPanel = Messages.wrapToScrollPaneIfNeeded((JComponent)messageField, (int)40, (int)4);
        if (icon != null) {
            msgPanel = JBUI.Panels.simplePanel().addToLeft((Component)((BorderLayoutPanel)JBUI.Panels.simplePanel().withBorder((Border)JBUI.Borders.emptyRight((int)10))).addToTop((Component)new JBLabel(icon))).addToCenter((Component)msgPanel);
        }
        panel.add((Component)msgPanel, "Center");
        panel.add((Component)component, "South");
        DialogBuilder builder = new DialogBuilder(project);
        builder.setTitle(title);
        builder.setCenterPanel((JComponent)panel);
        builder.addOkAction();
        builder.addCancelAction();
        builder.resizable(false);
        DialogBuilder dialogBuilder = builder;
        if (dialogBuilder == null) {
            DatabaseCredentials.$$$reportNull$$$0(21);
        }
        return dialogBuilder;
    }

    public static <T> CompletionStage<T> getInitialCredentialsImpl(@NotNull LocalDataSource.Storage storage, boolean canAskPassword, Supplier<? extends CompletionStage<T>> get2, Function<Throwable, ? extends CompletionStage<T>> ask, Condition<? super T> isEmpty) {
        if (storage == null) {
            DatabaseCredentials.$$$reportNull$$$0(22);
        }
        if (storage.isOneTime() && canAskPassword) {
            return ask.apply(null);
        }
        if (!canAskPassword) {
            return get2.get();
        }
        return get2.get().handle(Pair::create).thenCompose(p2 -> {
            if (p2.second != null) {
                if (AsyncUtil.isCancellation((Throwable)p2.second)) {
                    return AsyncUtil.cancelled();
                }
                return (CompletionStage)ask.apply((Throwable)p2.second);
            }
            if (storage.isMemory() && isEmpty.value(p2.first)) {
                return (CompletionStage)ask.apply(null);
            }
            return CompletableFuture.completedFuture(p2.first);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/access/DatabaseCredentials";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toStorage";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "strict";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/access/DatabaseCredentials";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsAsync";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPassword";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCredentialsAsync";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPassword";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyAllCredentials";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSshPassword";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSshPassphrase";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleSessionFinished";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSshImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSshPassword";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSshPassphrase";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepareDialog";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCredentialsImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

