/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.actions.DatabaseObjectRefactoring;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.DbSrcMigration;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.CommentQueryGenerator;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DropQueryGenerator;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.KeyModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.DbBatchIndicesDialog;
import com.intellij.database.view.ui.DbObjectDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.FieldPanel;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.DatabaseIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlActions {
    private static void deleteDataSources(@NotNull Project project, final @NotNull Set<DbDataSource> dataSources2) {
        String message2;
        if (project == null) {
            DdlActions.$$$reportNull$$$0(0);
        }
        if (dataSources2 == null) {
            DdlActions.$$$reportNull$$$0(1);
        }
        if (dataSources2.size() == 1) {
            DbDataSource element2 = dataSources2.iterator().next();
            message2 = DatabaseMessages.message((String)"confirmation.text.remove.data.source", (Object[])new Object[]{element2.getName()});
        } else {
            StringBuilder sb = new StringBuilder("The following data sources will be removed:\n");
            int i2 = 0;
            for (DbDataSource o : dataSources2) {
                if (i2++ > 0) {
                    sb.append(",").append(i2 % 3 == 1 ? "\n" : " ");
                }
                sb.append(o.getName());
            }
            message2 = sb.toString();
        }
        int ret = Messages.showOkCancelDialog((Project)project, (String)message2, (String)"Confirmation", (Icon)Messages.getWarningIcon());
        if (ret != 0) {
            return;
        }
        DdlActions.closeAllFilesBeforeDataSourceRemoval(project, dataSources2);
        final DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        GlobalUndoableAction action2 = new GlobalUndoableAction(){

            public void undo() {
                for (DbDataSource dataSource : dataSources2) {
                    facade.getDataSourceManager(dataSource).addDataSource((DasDataSource)dataSource.getDelegate());
                }
            }

            public void redo() {
                for (DbDataSource dataSource : dataSources2) {
                    facade.getDataSourceManager(dataSource).removeDataSource((DasDataSource)dataSource.getDelegate());
                }
            }
        };
        try {
            WriteCommandAction.writeCommandAction((Project)project).withName(DatabaseMessages.message((String)"command.name.remove.data.source", (Object[])new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> DdlActions.lambda$deleteDataSources$0((UndoableAction)action2, project));
        }
        catch (UnexpectedUndoException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeAllFilesBeforeDataSourceRemoval(@NotNull Project project, @NotNull Set<DbDataSource> elements) {
        if (project == null) {
            DdlActions.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            DdlActions.$$$reportNull$$$0(3);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            DbDataSource dataSource = DbImplUtil.findDataSource(project, virtualFile);
            if (!elements.contains(dataSource)) continue;
            fileEditorManager.closeFile(virtualFile);
        }
    }

    @NotNull
    static Pair<DbTable, Set<DbColumn>> getTableAndColumns(AnActionEvent e) {
        DbTable tableElement;
        Set<Object> columns = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class);
        Set tables = ContainerUtil.map2Set(columns, (Function)((NullableFunction)element2 -> element2.getParent()));
        DbTable dbTable = tableElement = tables.size() == 1 ? (DbTable)tables.iterator().next() : null;
        if (tableElement == null) {
            JBIterable<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), true);
            DbElement element3 = (DbElement)selection.single();
            tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element3, DbTable.class, (boolean)false);
            columns = Collections.emptySet();
        }
        Pair pair = Pair.create((Object)tableElement, columns);
        if (pair == null) {
            DdlActions.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static /* synthetic */ void lambda$deleteDataSources$0(UndoableAction action2, Project project) throws UnexpectedUndoException {
        action2.redo();
        UndoManager.getInstance((Project)project).undoableActionPerformed(action2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DdlActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DdlActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableAndColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteDataSources";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "closeAllFilesBeforeDataSourceRemoval";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommentOnObjectAction
    extends DumbAwareAction {
        public CommentOnObjectAction() {
            super("Modify Comment...", "Modify comment for selected column", null);
        }

        public void update(@NotNull AnActionEvent e) {
            Set<DbElement> selection;
            if (e == null) {
                CommentOnObjectAction.$$$reportNull$$$0(0);
            }
            DbElement single = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            BasicNamedElement element2 = single == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel model = element2 == null ? null : element2.getModel();
            boolean visible = model != null && CommentQueryGenerator.canComment(model, element2) && DbImplUtil.canConnectTo(single);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify(single));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BasicModel model;
            Set<DbElement> selection;
            if (e == null) {
                CommentOnObjectAction.$$$reportNull$$$0(1);
            }
            DbElement single = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            final BasicNamedElement element2 = single == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel basicModel = model = element2 == null ? null : element2.getModel();
            if (model == null) {
                return;
            }
            BasicNamespace current = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObjectForSwitch(single.getDataSource(), element2), BasicNamespace.class);
            final CommentQueryGenerator generator = new CommentQueryGenerator(single.getProject(), model, element2);
            generator.setCurrentNamespace(current);
            new DatabaseScriptDialog(single.getProject(), single.getDataSource(), ObjectPaths.searchPathOf(current), "Modify Comment"){
                private FieldPanel myComment;

                @Override
                protected ScriptingTask getTask() {
                    return generator.createTask(null);
                }

                @Override
                protected void settingsChanged(ScriptingOptions options) {
                    generator.setOptions(options);
                    this.regenerate();
                }

                @Override
                protected JComponent createCenterPanel() {
                    this.myComment = new FieldPanel("Comment:", null, null, () -> this.regenerate());
                    this.myComment.setText(element2.getComment());
                    return new BorderLayoutPanel().addToTop((Component)this.myComment).addToCenter((Component)Objects.requireNonNull(super.createCenterPanel()));
                }

                private void regenerate() {
                    this.generateText(this.myComment.getText());
                }

                @Nullable
                public JComponent getPreferredFocusedComponent() {
                    return this.myComment.getTextField();
                }

                private void generateText(String comment) {
                    this.updateText(generator.generate(comment));
                }

                @Override
                protected void fillContext(DatabaseRefactoringHandler handler) {
                    handler.getContext().include(element2);
                }
            }.initAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$CommentOnObjectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DropForeignKeyAction
    extends DumbAwareAction {
        public DropForeignKeyAction() {
            super("Drop Foreign Key", "Drop foreign key from selected column", DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            Set<DbColumn> selection;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(0);
            }
            DbColumn column2 = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class)).size() == 1 ? (DbColumn)ContainerUtil.getFirstItem(selection) : null;
            boolean visible = column2 != null && SchemaEditor.forDbms(DbImplUtil.getDbms((DbElement)column2)).getDbEditorCaps().getTableEditorCaps(true).getForeignKeys().canRemove() && DbImplUtil.canConnectTo((DbElement)column2) && DasUtil.isForeign((DasColumn)column2);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)column2));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbColumn column2;
            DbTable table;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(1);
            }
            DbTable dbTable = table = (column2 = (DbColumn)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class))) == null ? null : column2.getTable();
            if (table == null) {
                return;
            }
            DbDataSource dataSource = column2.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)DbImplUtil.getSearchPathObjectForSwitch((DbElement)column2)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(dataSource.getProject(), model);
            JBIterable selection = JBIterable.from((Iterable)DasUtil.getForeignKeys((DasTable)table)).filter(key2 -> DasUtil.containsName((String)column2.getName(), (MultiRef)key2.getColumnsRef())).filter(DbElement.class);
            generator.setItems((Iterable<BasicElement>)DeleteProvider2.getElements((JBIterable<DbElement>)selection));
            generator.setCurrentNamespace(namespace);
            DeleteProvider2.showDialogAndRun(dataSource.getProject(), dataSource, ObjectPaths.searchPathOf(namespace), (JBIterable<DbElement>)selection, generator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DropForeignKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DropPrimaryKeyAction
    extends DumbAwareAction {
        public DropPrimaryKeyAction() {
            super("Drop Primary Key", "Drop primary key from selected table", DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            Set<DbElement> selection;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            DbElement element2 = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbTable tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element2, DbTable.class, (boolean)false);
            boolean visible = tableElement != null && SchemaEditor.forDbms(DbImplUtil.getDbms((DbElement)tableElement)).getDbEditorCaps().getTableEditorCaps(true).getPrimaryKey().canRemove() && DbImplUtil.canConnectTo((DbElement)tableElement) && DasUtil.getPrimaryKey((DasTable)tableElement) != null;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)tableElement));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            DbTable table;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class))), DbTable.class, (boolean)false)) == null) {
                return;
            }
            DbTableKey pk = (DbTableKey)DasUtil.getPrimaryKey((DasTable)table);
            if (pk == null) {
                return;
            }
            DbDataSource dataSource = pk.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)DbImplUtil.getSearchPathObjectForSwitch((DbElement)pk)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(dataSource.getProject(), model);
            JBIterable selection = JBIterable.of((Object)pk);
            generator.setItems((Iterable<BasicElement>)DeleteProvider2.getElements((JBIterable<DbElement>)selection));
            generator.setCurrentNamespace(namespace);
            DeleteProvider2.showDialogAndRun(dataSource.getProject(), dataSource, ObjectPaths.searchPathOf(namespace), (JBIterable<DbElement>)selection, generator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddForeignKeyAction
    extends DumbAwareAction {
        public AddForeignKeyAction() {
            super("_Foreign Key", "Add new foreign key to selected table", DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddForeignKeyAction.$$$reportNull$$$0(0);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtil.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddForeignKey(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddForeignKeyAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newFk = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withForeignKey(""))).addRefRefs((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog2, columns))).addAndGet((Ref<DeForeignKey>)newFk)).leave()).commit();
                return (DeObject)newFk.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddForeignKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddPrimaryKeyAction
    extends DumbAwareAction {
        public AddPrimaryKeyAction() {
            super("_Primary Key", "Add new primary key to selected table", DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtil.canConnectTo((DbElement)pair.first) && DasUtil.getPrimaryKey((DasTable)((DasTable)pair.first)) == null && DbRefactoringDialogHelper.canAddPrimaryKey(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first) && ((DbTable)pair.first).getKind() == ObjectKind.TABLE && !((Set)pair.second).isEmpty();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newKey = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((KeyModelBuilder)((Object)((TableModelBuilder.TableKeyModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withKey("")).setPrimary(true, false))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog2, columns), DasIndex.Sorting.NONE)).addAndGet((Ref<DeTableKey>)newKey)).leave()).commit();
                return (DeObject)newKey.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddPrimaryKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BatchAddIndicesAction
    extends DumbAwareAction {
        public BatchAddIndicesAction() {
            super("Indice_s Per Column", "Add separate indices for selected columns", DatabaseIcons.Index);
        }

        @NotNull
        private static List<DbColumn> getColumns(@NotNull AnActionEvent e) {
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(0);
            }
            Set<DbColumn> columns = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class);
            DbDataSource dataSource = null;
            for (DbColumn column2 : columns) {
                if (dataSource == null) {
                    dataSource = column2.getDataSource();
                }
                if (dataSource == column2.getDataSource()) continue;
                List<DbColumn> list = Collections.emptyList();
                if (list == null) {
                    BatchAddIndicesAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            ArrayList<DbColumn> arrayList = new ArrayList<DbColumn>(columns);
            if (arrayList == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        public void update(@NotNull AnActionEvent e) {
            List<DbColumn> columns;
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(3);
            }
            boolean visible = (columns = BatchAddIndicesAction.getColumns(e)).size() > 1 && DbImplUtil.canConnectTo((DbElement)columns.get(0)) && DbBatchIndicesDialog.canAddAnything(new DatabaseEditorContext((DbElement)columns.get(0), null), columns);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)columns.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DbColumn> columns;
            List basicColumns;
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(4);
            }
            if ((basicColumns = JBIterable.from(columns = BatchAddIndicesAction.getColumns(e)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toList()).size() < 2) {
                return;
            }
            DbBatchIndicesDialog.newBatchAddIndicesDialog(new DatabaseEditorContext((DbElement)columns.get(0), null), basicColumns).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumns";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AddIndexAction
    extends DumbAwareAction {
        public AddIndexAction() {
            super("_Index", "Add new index for selected columns", DatabaseIcons.Index);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddIndexAction.$$$reportNull$$$0(0);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtil.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddIndex(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddIndexAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newIndex = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog2, columns), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)newIndex)).leave()).commit();
                return (DeObject)newIndex.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddIndexAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddColumnAction
    extends DumbAwareAction {
        public AddColumnAction() {
            super("_Column", "Add new column to selected table", DatabaseIcons.Col);
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbElement> selection;
            DbElement element2;
            DbTable table;
            if (e == null) {
                AddColumnAction.$$$reportNull$$$0(0);
            }
            boolean visible = (table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)(selection = DatabaseView.getSelectedElements(e.getDataContext(), true)).single()), DbTable.class, (boolean)false)) != null && SchemaEditor.forDbms(DbImplUtil.getDbms((DbElement)table)).getDbEditorCaps().getTableEditorCaps(true).getColumns().canAdd() && DbImplUtil.canConnectTo((DbElement)table) && DbRefactoringDialogHelper.canAddColumn(new DatabaseEditorContext((DbElement)table, null), (DasTable)table) && table.getKind() == ObjectKind.TABLE;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)table));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            DbTable table;
            if (e == null) {
                AddColumnAction.$$$reportNull$$$0(1);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)DatabaseView.getSelectedElements(e.getDataContext(), true).single()), DbTable.class, (boolean)false)) == null) {
                return;
            }
            AddColumnAction.perform(table, (DbColumn)PsiTreeUtil.getParentOfType((PsiElement)element2, DbColumn.class, (boolean)false), "new_column");
        }

        public static void perform(@NotNull DbTable table, @Nullable DbColumn anchor, @NotNull String colName) {
            BasicTable basicTable;
            if (table == null) {
                AddColumnAction.$$$reportNull$$$0(2);
            }
            if (colName == null) {
                AddColumnAction.$$$reportNull$$$0(3);
            }
            if ((basicTable = (BasicTable)ObjectUtils.tryCast((Object)table.getDelegate(), BasicTable.class)) == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                List<DeColumn> columns = ((DatabaseTableEditor)dialog2.getEditor()).getTable().columns;
                int idx = columns.size();
                if (anchor != null && ((DatabaseTableEditor)dialog2.getEditor()).getCaps().getColumns().canReorder()) {
                    String name2 = anchor.getName();
                    idx = 0;
                    for (DeColumn column2 : columns) {
                        ++idx;
                        if (!column2.name.equals(name2)) continue;
                        break;
                    }
                }
                Ref newCol = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableColumnModelBuilder)((TableModelBuilder.TableColumnModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withColumn(colName)).addAndGet((Ref<DeColumn>)newCol, idx)).leave()).commit();
                return (DeObject)newCol.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddColumnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddSchemaAction
    extends DumbAwareAction {
        private static final String DEFAULT_TEXT = "_Schema";

        public AddSchemaAction() {
            super(DEFAULT_TEXT, "Add new schema to selected database", DatabaseIcons.Schema);
        }

        public void update(@NotNull AnActionEvent e) {
            DbElement parent2;
            if (e == null) {
                AddSchemaAction.$$$reportNull$$$0(0);
            }
            DbDataSource dataSource = (parent2 = AddSchemaAction.getSchemaParent(e)) == null ? null : parent2.getDataSource();
            DatabaseDialectEx dialect = dataSource == null ? null : DbImplUtil.getDatabaseDialect((DbElement)dataSource);
            boolean visible = dialect != null && SchemaEditor.forDbms(dataSource.getDbms()).getDbEditorCaps().getSchemaEditorCaps(false).canDoAnything() && DbImplUtil.canConnectTo((DbElement)dataSource);
            Presentation presentation = e.getPresentation();
            presentation.setVisible(visible);
            presentation.setEnabled(visible && DbImplUtil.canModify((DbElement)dataSource) && AddSchemaAction.canDoAnything(parent2));
            if (dialect != null) {
                String schemaName = dialect.getNameForKind(ObjectKind.SCHEMA);
                String formattedName = StringUtil.capitalize((String)StringUtil.toLowerCase((String)schemaName));
                presentation.setText("_" + formattedName);
            } else {
                presentation.setText(DEFAULT_TEXT);
            }
        }

        private static boolean canDoAnything(DbElement element2) {
            return SchemaEditor.forDbms(DbImplUtil.getDbms(element2)).getDbEditorCaps().getSchemaEditorCaps(false).canDoAnything();
        }

        @Nullable
        private static DbElement getSchemaParent(@NotNull AnActionEvent e) {
            DbDataSource dataSource;
            Set selection;
            if (e == null) {
                AddSchemaAction.$$$reportNull$$$0(1);
            }
            DbElement element2 = (selection = DatabaseView.getSelectedElements(e.getDataContext(), true).toSet()).size() == 1 ? (DbElement)ContainerUtil.getFirstItem((Collection)selection) : null;
            DbElement parent2 = (DbElement)DbImplUtil.getTopSingleNamespace((DasObject)element2);
            parent2 = (DbElement)DasUtil.dasParents((DasObject)parent2).filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).filter(DbElement.class).first();
            DbDataSource dbDataSource = dataSource = element2 == null ? null : element2.getDataSource();
            if (parent2 == null) {
                parent2 = dataSource;
            }
            return parent2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement parent2;
            if (e == null) {
                AddSchemaAction.$$$reportNull$$$0(2);
            }
            if ((parent2 = AddSchemaAction.getSchemaParent(e)) == null) {
                return;
            }
            AddSchemaAction.perform(parent2, "new_schema");
        }

        public static void perform(@NotNull DbElement parent2, @NotNull String schemaName) {
            Pair<BasicElement, DatabaseEditorContext> info;
            if (parent2 == null) {
                AddSchemaAction.$$$reportNull$$$0(3);
            }
            if (schemaName == null) {
                AddSchemaAction.$$$reportNull$$$0(4);
            }
            if ((info = DatabaseObjectRefactoring.prepareForEditing((PsiElement)parent2, (DasObject)parent2)) == null) {
                return;
            }
            DbObjectDialog dialog2 = DbRefactoringDialogHelper.newAddObjectDialog((DatabaseEditorContext)info.second, (BasicElement)info.first, schemaName, ObjectKind.SCHEMA);
            dialog2.finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemaName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddSchemaAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSchemaParent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddDatabaseAction
    extends DumbAwareAction {
        public AddDatabaseAction() {
            super("_Database", "Add new database to selected data source", DatabaseIcons.Database);
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbElement> selection;
            DbElement element2;
            if (e == null) {
                AddDatabaseAction.$$$reportNull$$$0(0);
            }
            DbDataSource dataSource = (element2 = (DbElement)(selection = DatabaseView.getSelectedElements(e.getDataContext(), true)).single()) == null ? null : element2.getDataSource();
            boolean visible = dataSource != null && SchemaEditor.forDbms(dataSource.getDbms()).getDbEditorCaps().getDatabaseEditorCaps(false).canDoAnything() && DbImplUtil.canConnectTo((DbElement)dataSource);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)dataSource));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            DbDataSource dataSource;
            if (e == null) {
                AddDatabaseAction.$$$reportNull$$$0(1);
            }
            DbDataSource dbDataSource = dataSource = (element2 = (DbElement)DatabaseView.getSelectedElements(e.getDataContext(), true).single()) == null ? null : element2.getDataSource();
            if (dataSource == null) {
                return;
            }
            AddDatabaseAction.perform(dataSource, "new_database");
        }

        public static void perform(@NotNull DbDataSource dataSource, @NotNull String databaseName) {
            if (dataSource == null) {
                AddDatabaseAction.$$$reportNull$$$0(2);
            }
            if (databaseName == null) {
                AddDatabaseAction.$$$reportNull$$$0(3);
            }
            DbObjectDialog dialog2 = DbRefactoringDialogHelper.newAddObjectDialog(new DatabaseEditorContext((DbElement)dataSource, null), null, databaseName, ObjectKind.DATABASE);
            dialog2.finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "databaseName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddDatabaseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BatchModifyIndicesAction
    extends DumbAwareAction {
        public BatchModifyIndicesAction() {
            super("Modify Indices", "Batch Modify Indices", null);
        }

        @NotNull
        private static List<DbIndex> getIndicesToModify(@NotNull AnActionEvent e) {
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(0);
            }
            JBIterable elements = DatabaseView.getSelectedElementsFlat(e.getDataContext()).filter(DbIndex.class);
            DbDataSource dataSource = null;
            for (DbIndex element2 : elements) {
                DbDataSource currentSource = element2.getDataSource();
                if (dataSource == null) {
                    dataSource = currentSource;
                }
                if (dataSource == currentSource) continue;
                List<DbIndex> list = Collections.emptyList();
                if (list == null) {
                    BatchModifyIndicesAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = elements.toList();
            if (list == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(2);
            }
            return list;
        }

        public void update(@NotNull AnActionEvent e) {
            List<DbIndex> indices;
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(3);
            }
            boolean visible = (indices = BatchModifyIndicesAction.getIndicesToModify(e)).size() > 1 && DbImplUtil.canConnectTo((DbElement)indices.get(0)) && DbBatchIndicesDialog.canModifyAnything(new DatabaseEditorContext((DbElement)indices.get(0), null), indices);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)indices.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DbIndex> indices;
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(4);
            }
            if ((indices = BatchModifyIndicesAction.getIndicesToModify(e)).size() < 2) {
                return;
            }
            BatchModifyIndicesAction.showModifyIndicesDialogAndRun(indices);
        }

        public static void showModifyIndicesDialogAndRun(@NotNull List<DbIndex> indices) {
            if (indices == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(5);
            }
            List basicIndices = JBIterable.from(indices).transform(DbElement::getDelegate).filter(BasicIndex.class).toList();
            DbBatchIndicesDialog.newBatchModifyIndicesDialog(new DatabaseEditorContext((DbElement)indices.get(0), null), basicIndices).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndicesToModify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndicesToModify";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showModifyIndicesDialogAndRun";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AddTableAction
    extends DumbAwareAction {
        public AddTableAction() {
            super("_Table", "Add new table to selected schema", DatabaseIcons.Table);
        }

        public void update(@NotNull AnActionEvent e) {
            DbElement element2;
            DbElement parent2;
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(0);
            }
            boolean visible = (parent2 = (DbElement)DbImplUtil.getTopSingleNamespace((DasObject)(element2 = AddTableAction.getElement(e)))) != null && parent2.getKind() == ObjectKind.SCHEMA && DbImplUtil.canConnectTo(parent2);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify(parent2) && AddTableAction.canDoAnything(element2));
        }

        private static boolean canDoAnything(DbElement element2) {
            return SchemaEditor.forDbms(DbImplUtil.getDbms(element2)).getDbEditorCaps().getTableEditorCaps(false).canDoAnything();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(1);
            }
            if ((element2 = AddTableAction.getElement(e)) == null) {
                return;
            }
            DbDataSource dataSource = element2.getDataSource();
            DasNamespace namespace = DbImplUtil.getTopSingleNamespace((DasObject)element2);
            Pair<BasicElement, DatabaseEditorContext> info = DatabaseObjectRefactoring.prepareForEditing((PsiElement)((DbNamespaceImpl)namespace), (DasObject)namespace);
            if (info == null || !(info.first instanceof BasicSchema)) {
                return;
            }
            AddTableAction.showAddTableDialogAndRun(dataSource, (BasicSchema)info.first, (DatabaseEditorContext)info.second, "table_name", ContainerUtil.emptyList());
        }

        @Nullable
        private static DbElement getElement(@NotNull AnActionEvent e) {
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(2);
            }
            return (DbElement)DatabaseView.getSelectedElements(e.getDataContext(), true).first();
        }

        public static void showAddTableDialogAndRun(@NotNull DbDataSource dataSource, @Nullable BasicSchema schema, @Nullable DatabaseEditorContext context, @NotNull String defaultName, @NotNull Collection<String> columnNames) {
            if (dataSource == null) {
                AddTableAction.$$$reportNull$$$0(3);
            }
            if (defaultName == null) {
                AddTableAction.$$$reportNull$$$0(4);
            }
            if (columnNames == null) {
                AddTableAction.$$$reportNull$$$0(5);
            }
            DbRefactoringDialogHelper.newAddTableDialog(context, schema, defaultName, columnNames).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddTableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showAddTableDialogAndRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DeleteProvider2
    implements DeleteProvider,
    TitledHandler {
        public String getActionTitle() {
            return "Drop";
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            BasicModel model;
            Project project;
            if (dataContext == null) {
                DeleteProvider2.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable<DbElement> selection = DatabaseView.getSelectedElementsFlat(dataContext);
            if (selection.isEmpty() || !selection.filter(DbDataSource.class).isEmpty()) {
                return false;
            }
            DbElement any = (DbElement)selection.iterator().next();
            DbDataSource dataSource = any == null ? null : any.getDataSource();
            BasicModel basicModel = model = dataSource == null ? null : (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (model == null || !DbImplUtil.canConnectToAndModify((DbElement)dataSource)) {
                return false;
            }
            for (DbElement e : selection) {
                if (!e.isWritable()) {
                    return false;
                }
                if (dataSource.equals(e.getDataSource())) continue;
                return false;
            }
            return DropQueryGenerator.canDeleteAnything(model, DeleteProvider2.getElements(selection));
        }

        @NotNull
        public static JBIterable<BasicElement> getElements(JBIterable<DbElement> selection) {
            JBIterable jBIterable = selection.filter(e -> !DataImporter.isBusy(e)).transform(DbElement::getDelegate).filter(BasicElement.class);
            if (jBIterable == null) {
                DeleteProvider2.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DeleteProvider2.$$$reportNull$$$0(2);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable<DbElement> selection = DatabaseView.getSelectedElementsFlat(dataContext);
            DbElement first2 = (DbElement)selection.first();
            if (first2 == null) {
                return;
            }
            DbDataSource dataSource = first2.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)DbImplUtil.getSearchPathObjectForSwitch(first2)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(project, model);
            generator.setItems((Iterable<BasicElement>)DeleteProvider2.getElements(selection));
            while (namespace != null && generator.getItems().contains(namespace)) {
                namespace = (BasicNamespace)ObjectUtils.tryCast((Object)namespace.getParent(), BasicNamespace.class);
            }
            generator.setCurrentNamespace(namespace);
            DeleteProvider2.showDialogAndRun(project, dataSource, ObjectPaths.searchPathOf(namespace), selection, generator);
        }

        public static void showDialogAndRun(final @NotNull Project project, final @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, final @NotNull JBIterable<DbElement> selection, final @NotNull DropQueryGenerator generator) {
            if (project == null) {
                DeleteProvider2.$$$reportNull$$$0(3);
            }
            if (dataSource == null) {
                DeleteProvider2.$$$reportNull$$$0(4);
            }
            if (selection == null) {
                DeleteProvider2.$$$reportNull$$$0(5);
            }
            if (generator == null) {
                DeleteProvider2.$$$reportNull$$$0(6);
            }
            DatabaseScriptDialog dialog2 = new DatabaseScriptDialog(project, dataSource, searchPath, "Confirm Drop"){

                protected void init() {
                    super.init();
                    this.generate();
                }

                @Override
                protected ScriptingTask getTask() {
                    return generator.createTask(null);
                }

                @Override
                protected void settingsChanged(ScriptingOptions options) {
                    generator.setOptions(options);
                    this.generate();
                }

                private void generate() {
                    CompositeText text2 = generator.generate().getScript();
                    try {
                        ObjectPath first2 = ObjectPaths.of((DasObject)ContainerUtil.getFirstItem(generator.getItems()));
                        String comment = first2.getDisplayName() + (generator.getItems().size() > 1 ? " +" + (generator.getItems().size() - 1) : "");
                        text2 = DbSrcMigration.formatCompositeText(project, DbSqlUtil.getSqlDialect((DbElement)dataSource), comment, text2);
                    }
                    catch (Error | RuntimeException e) {
                        Logger.getInstance(DdlActions.class).warn(e);
                    }
                    String query = text2.getText().toString();
                    this.updateText(query);
                }

                @Override
                protected void fillContext(DatabaseRefactoringHandler handler) {
                    LoaderContext context = handler.getContext();
                    for (DbElement element2 : selection) {
                        if (element2 instanceof DbTableChild) {
                            DbTable table = ((DbTableChild)element2).getTable();
                            context.include((DbElement)table);
                            for (DasForeignKey fk : DasUtil.getForeignKeys((DasTable)table)) {
                                context.include((DasObject)fk.getRefTable());
                            }
                        }
                        context.include(element2);
                    }
                    if (DatabaseSettings.getSettings().trackNamespaces) {
                        ArrayList<ObjectPath> toRemove = new ArrayList<ObjectPath>();
                        generator.fillNamespacesToRemove(toRemove);
                        for (ObjectPath pair : toRemove) {
                            context.getScopeUpdater().toRemove(pair);
                        }
                    }
                }
            };
            dialog2.initAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$DeleteProvider2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$DeleteProvider2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "showDialogAndRun";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DeleteProvider1
    implements DeleteProvider,
    TitledHandler {
        public String getActionTitle() {
            return "Remove";
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DeleteProvider1.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbElement.class));
            if (selection.filter(DbDataSource.class).size() != selection.size()) {
                return false;
            }
            return !selection.isEmpty();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DeleteProvider1.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbDataSource.class));
            DdlActions.deleteDataSources(project, selection.toSet());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DeleteProvider1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

