/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseLogView;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanView;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DatabaseClientLogView
extends DatabaseLogView<DatabaseSessionClientWithFile> {
    private static final Key<PlanView> PLAN_VIEW_KEY = Key.create((String)"PlanView");
    private final List<ConsoleGridDataHookUp> myHookUps;
    private Content myPlanContent;

    public DatabaseClientLogView(@NotNull LanguageConsoleView languageConsole, @NotNull DatabaseSessionClientWithFile owner) {
        if (languageConsole == null) {
            DatabaseClientLogView.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DatabaseClientLogView.$$$reportNull$$$0(1);
        }
        super(languageConsole, owner, new ClientLogViewController(owner), DatabaseClientLogView.getPlaceholder(owner));
        this.myHookUps = new ArrayList<ConsoleGridDataHookUp>();
    }

    public boolean isEmpty() {
        return this.myHookUps.isEmpty() && this.myPlanContent == null && this.getConsoleView().getHistoryViewer().getDocument().getTextLength() == 0;
    }

    @Override
    @NotNull
    protected LocalDataSource getDataSource() {
        LocalDataSource localDataSource = (LocalDataSource)((DatabaseSession)((DatabaseSessionClientWithFile)this.getTarget()).getSession()).getTarget();
        if (localDataSource == null) {
            DatabaseClientLogView.$$$reportNull$$$0(2);
        }
        return localDataSource;
    }

    public void registerHookUp(@NotNull Disposable disposable, @NotNull ConsoleGridDataHookUp hookUp) {
        if (disposable == null) {
            DatabaseClientLogView.$$$reportNull$$$0(3);
        }
        if (hookUp == null) {
            DatabaseClientLogView.$$$reportNull$$$0(4);
        }
        this.myHookUps.add(hookUp);
        Disposer.register((Disposable)disposable, () -> this.myHookUps.remove(hookUp));
    }

    public void showPlan(@Nullable PlanModel plan) {
        if (plan != null) {
            this.ensureContentInitialized();
            if (this.myPlanContent == null) {
                this.myPlanContent = this.createPlanContent();
                this.getUi().addContent(this.myPlanContent, -1, PlaceInGrid.bottom, false);
                this.getUi().setBouncing(this.myPlanContent, true);
            }
            ((PlanView)PLAN_VIEW_KEY.get((UserDataHolder)this.myPlanContent)).setModel(plan);
            this.getUi().selectAndFocus(this.myPlanContent, true, false);
        } else if (this.myPlanContent != null) {
            this.getUi().removeContent(this.myPlanContent, true);
            this.myPlanContent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTarget(@NotNull DatabaseSessionClientWithFile target2, @NotNull DataBus.Consuming bus) {
        if (target2 == null) {
            DatabaseClientLogView.$$$reportNull$$$0(5);
        }
        if (bus == null) {
            DatabaseClientLogView.$$$reportNull$$$0(6);
        }
        try {
            if (this.myHookUps != null) {
                for (ConsoleGridDataHookUp hookUp : this.myHookUps) {
                    hookUp.setParent(target2);
                    hookUp.setSession((DatabaseSession)target2.getSession());
                }
            }
        }
        finally {
            super.setTarget(target2, bus);
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && ((DatabaseSessionClientWithFile)this.getTarget()).getVirtualFile().isValid();
    }

    @NotNull
    private Content createPlanContent() {
        PlanView view2 = PlanView.createView(this.getProject());
        Content content = this.getUi().createContent("Input", view2.getComponent(), "Plan", DatabaseIcons.Table, view2.getPreferredFocusedComponent());
        content.setCloseable(true);
        PLAN_VIEW_KEY.set((UserDataHolder)content, (Object)view2);
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                DatabaseClientLogView.this.myPlanContent = null;
            }
        });
        Content content2 = content;
        if (content2 == null) {
            DatabaseClientLogView.$$$reportNull$$$0(7);
        }
        return content2;
    }

    @NotNull
    private static String getPlaceholder(@NotNull DatabaseSessionClientWithFile owner) {
        if (owner == null) {
            DatabaseClientLogView.$$$reportNull$$$0(8);
        }
        String string = String.format("%s output", StringUtil.capitalize((String)owner.getDepartment().getCommonName()));
        if (string == null) {
            DatabaseClientLogView.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlanContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerHookUp";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClientLogViewController
    extends DatabaseLogView.DatabaseServiceViewController<DatabaseSessionClientWithFile> {
        ClientLogViewController(@NotNull DatabaseSessionClientWithFile owner) {
            if (owner == null) {
                ClientLogViewController.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        @NotNull
        protected Promise<Void> selectNode(@NotNull Project project, @NotNull DatabaseSessionClientWithFile owner, boolean activate, boolean requestFocus) {
            if (project == null) {
                ClientLogViewController.$$$reportNull$$$0(1);
            }
            if (owner == null) {
                ClientLogViewController.$$$reportNull$$$0(2);
            }
            Promise<Void> promise = DatabaseServiceViewContributor.selectNode(project, owner, activate, requestFocus);
            if (promise == null) {
                ClientLogViewController.$$$reportNull$$$0(3);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView$ClientLogViewController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView$ClientLogViewController";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "selectNode";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

