/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceScopeEditorTree;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSourceScopeEditor {
    private static final Key<DataSourceScopeEditor> EDITOR_KEY = Key.create((String)"DataSourceScopeEditor");
    private final Project myProject;
    private final MyTree myTree;
    protected BasicModel myModel;
    protected TreePattern mySelectedScope;
    protected TreePattern myPermStructure;
    protected Couple<String> myFakeCurrentSchema;
    protected final DataSourceSchemaMapping mySchemaMapping;
    private boolean mySchemaRoot;
    private boolean mySkipSpecForRoot;
    private boolean myFakeCurrentSchemaEnabled;
    private final JComponent myPanel;

    public DataSourceScopeEditor(@NotNull Project project) {
        if (project == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(0);
        }
        this.myModel = null;
        this.mySelectedScope = TreePattern.EMPTY;
        this.myPermStructure = TreePattern.EMPTY;
        this.myFakeCurrentSchema = null;
        this.mySchemaMapping = new DataSourceSchemaMapping();
        this.mySchemaRoot = false;
        this.mySkipSpecForRoot = true;
        this.myFakeCurrentSchemaEnabled = false;
        this.myTree = new MyTree(this, project, new DataSourceScopeEditorTree.MyNode(null, ObjectKind.NONE, null){

            @Override
            public ObjectKind getAllKind() {
                return DataSourceScopeEditor.this.mySchemaRoot ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
            }
        }, (Getter<Couple<String>>)((Getter)() -> this.myFakeCurrentSchema), this.mySchemaMapping);
        this.myProject = project;
        UIUtil.putClientProperty((JComponent)this.getTree(), EDITOR_KEY, (Object)this);
        this.myTree.getSearchModel().addNodeListener(new FilteringTree.SearchTreeModel.Listener<DataSourceScopeEditorTree.MyNode>(){

            @Override
            public void beforeNodeChanged(DataSourceScopeEditorTree.MyNode x) {
                DataSourceScopeEditor.this.beforeStateChanged();
            }

            @Override
            public void nodeChanged(DataSourceScopeEditorTree.MyNode x) {
                DataSourceScopeEditor.this.onStateChanged();
            }
        });
        this.myTree.getSearchModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesInserted(TreeModelEvent e) {
                if (DataSourceScopeEditor.this.mySkipSpecForRoot) {
                    for (Object o : e.getChildren()) {
                        CheckedTreeNode node = (CheckedTreeNode)ObjectUtils.tryCast((Object)o, CheckedTreeNode.class);
                        DataSourceScopeEditorTree.MyNode userNode = (DataSourceScopeEditorTree.MyNode)DataSourceScopeEditor.this.myTree.getSearchModel().getUserObject(node);
                        if (userNode == null || userNode.getKind() != ObjectKind.DATABASE) continue;
                        DbUIUtil.invokeLater(() -> DataSourceScopeEditor.this.myTree.getTree().expandPath(new TreePath(node.getPath())));
                    }
                }
            }
        });
        JComponent northPanel = this.createNorthPanel();
        northPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)northPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree.getComponent(), (boolean)true);
        this.myPanel.add((Component)scrollPane, "Center");
    }

    public boolean isSchemaRoot() {
        return this.mySchemaRoot;
    }

    @NotNull
    protected JComponent createNorthPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        ActionToolbar actionsToolbar = ActionManager.getInstance().createActionToolbar("DbSourceScopeEditor", (ActionGroup)this.createTreeActions(), true);
        actionsToolbar.setTargetComponent((JComponent)this.getTree());
        northPanel.add((Component)actionsToolbar.getComponent(), "East");
        this.myTree.installSimple();
        JPanel jPanel = northPanel;
        if (jPanel == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Nullable
    public Couple<String> getFakeCurrentSchema() {
        return this.myFakeCurrentSchema;
    }

    public void setFakeCurrentSchema(@Nullable Couple<String> fakeSchema) {
        this.myFakeCurrentSchema = fakeSchema;
        TreeUtil.invalidateCacheAndRepaint((TreeUI)this.getTree().getUI());
    }

    public boolean isSubstituted(@NotNull BasicNamespace e) {
        if (e == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(2);
        }
        return DataSourceSnapshotManager.INSTANCE.map(e, this.mySchemaMapping) != null;
    }

    public void setSubstituted(@NotNull BasicNamespace e, boolean substituted) {
        if (e == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(3);
        }
        ObjectPath path = BasicPaths.of(e);
        TreePattern pattern = DataSourceSchemaMapping.asPattern(path);
        if (substituted) {
            ObjectPath tgt = DataSourceSnapshotManager.INSTANCE.getBasePath(e);
            if (tgt != null) {
                this.mySchemaMapping.put(pattern, "minicat", tgt);
            }
        } else {
            this.mySchemaMapping.prune(pattern);
        }
        this.myTree.getTree().getSearchModel().updateStructure();
    }

    public void setSchemaMapping(@NotNull DataSourceSchemaMapping mapping) {
        if (mapping == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(4);
        }
        this.mySchemaMapping.assign(mapping);
    }

    @NotNull
    public abstract DataSourceSchemaMapping getSchemaMapping();

    protected void beforeStateChanged() {
    }

    protected void onStateChanged() {
    }

    protected FilteringTree<CheckedTreeNode, DataSourceScopeEditorTree.MyNode> getFilteringTree() {
        return this.myTree;
    }

    public void setScopes(@Nullable TreePattern selection, @Nullable TreePattern structure) {
        boolean structChanged;
        boolean permStructChanged;
        if (selection == null && structure == null) {
            return;
        }
        boolean selChanged = selection != null && !selection.equals(this.mySelectedScope);
        if (selChanged) {
            this.mySelectedScope = selection;
        }
        if (permStructChanged = structure != null && !structure.equals(this.myPermStructure)) {
            this.myPermStructure = structure;
        }
        boolean bl = structChanged = permStructChanged || selChanged;
        if (selChanged) {
            this.myTree.recheck(this.mySelectedScope);
        }
        DbUIUtil.invokeLater(() -> {
            if (structChanged) {
                TreePattern tempStructure = TreePatternUtils.union(this.myPermStructure, this.mySelectedScope);
                if (permStructChanged || tempStructure != this.myPermStructure) {
                    this.myTree.createShadowStructure((DataSourceScopeEditorTree.MyNode)this.myTree.getSearchModel().getRootObject(), tempStructure);
                    this.myTree.getSearchModel().updateStructure();
                }
            }
            this.myTree.recheck(this.mySelectedScope);
            this.onSetScopeReady();
        });
    }

    protected void onSetScopeReady() {
    }

    @NotNull
    protected TreePattern getEditorState() {
        LocalDataSource ds;
        DataSourceScopeEditorTree.MyNode root2 = (DataSourceScopeEditorTree.MyNode)this.myTree.getSearchModel().getRootObject();
        BasicMetaModel meta = this.myModel != null ? this.myModel.getMetaModel() : (BasicMetaModel)DbImplUtil.getMetaModel((ds = this.getDataSource(false)) == null ? Dbms.UNKNOWN : ds.getDbms());
        TreePatternNode<?> rootNode = DataSourceScopeEditor.build(root2, meta.root);
        TreePattern treePattern = new TreePattern(rootNode.groups);
        if (treePattern == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(5);
        }
        return treePattern;
    }

    @NotNull
    private static TreePatternNode<?> build(DataSourceScopeEditorTree.MyNode node, BasicMetaObject<?> meta) {
        TreePatternUtils.GroupBuilder g;
        LinkedHashMap gg = new LinkedHashMap();
        for (DataSourceScopeEditorTree.MyNode child : node.getChildNodes()) {
            if (!child.isChecked()) continue;
            TreePatternUtils.GroupBuilder g2 = (TreePatternUtils.GroupBuilder)ContainerUtil.getOrCreate(gg, (Object)child.getKind(), TreePatternUtils.GroupBuilder::new);
            TreePatternNode<?> childNode = DataSourceScopeEditor.build(child, BasicMetaUtils.findChild(meta, child.getKind()));
            g2.add(childNode);
        }
        if (node instanceof DataSourceScopeEditorTree.CurNode && node.getKind() == ObjectKind.DATABASE) {
            g = (TreePatternUtils.GroupBuilder)ContainerUtil.getOrCreate(gg, (Object)ObjectKind.SCHEMA, TreePatternUtils.GroupBuilder::new);
            g.positives.add(new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(DataSourceSchemaMapping.CURRENT_NAMESPACE_NAME), TreePatternNode.NO_GROUPS));
        } else if (node.getObject() == "*" && node.getKind() == ObjectKind.DATABASE) {
            g = (TreePatternUtils.GroupBuilder)ContainerUtil.getOrCreate(gg, (Object)ObjectKind.SCHEMA, TreePatternUtils.GroupBuilder::new);
            g.negative = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, TreePatternNode.NO_GROUPS);
        }
        TreePatternUtils.NodeBuilder builder = new TreePatternUtils.NodeBuilder();
        for (Map.Entry entry : gg.entrySet()) {
            TreePatternUtils.GroupBuilder b2 = (TreePatternUtils.GroupBuilder)entry.getValue();
            if (b2.negative != null) {
                b2.positives.clear();
            } else {
                b2.deduplicate();
            }
            builder.groups.add(b2.build((ObjectKind)entry.getKey()));
        }
        TreePatternNode<TreePatternNode.NegativeNaming> treePatternNode = builder.build(node.getObject() == "*" || node.getName() == null ? TreePatternNode.NegativeNaming.WILDCARD : new TreePatternNode.PositiveNaming(ObjectName.quoted((String)DataSourceScopeEditor.getNodeName(node))));
        if (treePatternNode == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(6);
        }
        return treePatternNode;
    }

    public boolean hasSpeedSearchActive() {
        return SpeedSearchSupply.getSupply((JComponent)this.getTree()) != null;
    }

    public void select(@Nullable BasicElement selection) {
        if (selection == null) {
            return;
        }
        TreePath path = new TreePath(ArrayUtil.reverseArray((Object[])JBIterable.generate((Object)selection, o -> o.getParent()).toList().toArray()));
        TreeUtil.visit((JTree)((Object)this.myTree.getTree()), (TreeVisitor)new TreeVisitor.ByTreePath(path, o -> {
            Object userObject = TreeUtil.getUserObject((Object)o);
            Object result2 = userObject instanceof DataSourceScopeEditorTree.MyNode ? ((DataSourceScopeEditorTree.MyNode)userObject).getObject() : userObject;
            return result2 == null ? this.myModel.getRoot() : result2;
        }), o -> {
            this.myTree.getTree().expandPath((TreePath)o);
            TreeUtil.selectPath((JTree)((Object)this.myTree.getTree()), (TreePath)o);
        });
    }

    @NotNull
    private static JBIterable<String> getNodeNames(Iterable<DataSourceScopeEditorTree.MyNode> nodes2) {
        JBIterable jBIterable = JBIterable.from(nodes2).filter(DbCheckBoxTree.MyNode::isChecked).transform(n -> DataSourceScopeEditor.getNodeName(n)).filter(Conditions.notNull());
        if (jBIterable == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Nullable
    protected static String getNodeName(DataSourceScopeEditorTree.MyNode n) {
        if (n instanceof DataSourceScopeEditorTree.CurNode) {
            return "@";
        }
        if (n.getObject() == "*") {
            return "*";
        }
        return n.getName();
    }

    public void setInitialModel(@Nullable LocalDataSource dataSource, @Nullable BasicModel tempModel) {
        this.myModel = tempModel;
        this.mySchemaRoot = dataSource != null && this.isSchemaRoot(dataSource, this.myModel);
        this.mySkipSpecForRoot = dataSource != null && DataSourceScopeEditor.isSingleRoot(dataSource);
        this.myFakeCurrentSchema = dataSource == null ? null : dataSource.getFakeCurrentSchema();
        this.myFakeCurrentSchemaEnabled = this.isFakeCurrentSchemaEnabled(tempModel, this.myFakeCurrentSchema);
        this.myTree.update();
    }

    public boolean isFakeCurrentSchemaEnabled(@Nullable BasicModel tempModel, Couple<String> fakeCurrentSchema) {
        if (fakeCurrentSchema != null) {
            return true;
        }
        if (tempModel == null) {
            return false;
        }
        if (tempModel.getMetaModel().dbms != Dbms.UNKNOWN) {
            return false;
        }
        NamingFamily namespaces = tempModel.getRoot().getNamespaces();
        if (namespaces.isEmpty()) {
            return false;
        }
        BasicDatabase curDb = tempModel.getRoot().getCurrentDatabase();
        if (curDb == null) {
            return true;
        }
        namespaces = curDb.getNamespaces();
        if (namespaces.isEmpty()) {
            return false;
        }
        BasicMateNamespace curSc = (BasicMateNamespace)namespaces.jbi().filter(BasicMateNamespace.class).filter(BasicMateNamespace::isCurrent).first();
        return curSc == null;
    }

    protected DataSourceScopeEditorTree.MyNode getRoot() {
        return (DataSourceScopeEditorTree.MyNode)this.myTree.getSearchModel().getRootObject();
    }

    @Nullable
    protected LocalDataSource getDataSource(boolean withCredentials) {
        return null;
    }

    public void introspectIfEmpty() {
        LocalDataSource dataSource = this.getDataSource(false);
        if (dataSource == null || !DbImplUtil.canConnectTo(dataSource) || this.myModel != null && !DataSourceScopeEditor.getNamespaces(this.myModel.getRoot()).isEmpty()) {
            return;
        }
        this.reintrospect(null);
    }

    private static JBIterable<BasicNamespace> getNamespaces(@NotNull BasicElement el) {
        if (el == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(8);
        }
        return el.getChildren().filter(BasicNamespace.class);
    }

    private boolean canReintrospect() {
        LocalDataSource dataSource = this.getDataSource(false);
        return dataSource != null && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource);
    }

    public void reintrospect(@Nullable List<BasicNamespace> objects2) {
        CompletionStage<DataSourceSyncManager.SyncResult> promise;
        LocalDataSource dataSource = this.getDataSource(true);
        if (dataSource == null) {
            return;
        }
        LoaderContext context = new LoaderContext(this.myProject, dataSource).setNamespacesOnly(true);
        if (objects2 != null) {
            objects2.forEach(context::include);
        }
        if ((promise = DataSourceSyncManager.getInstance().tryPerform(context, true, true)) == null) {
            return;
        }
        promise.whenCompleteAsync((res2, e) -> {
            BasicModel model;
            AsyncUtil.addUnhandledError(context.getErrorHandler(), e, context.getDataSource().getName(), context.getDataSource().getDbms());
            if (res2 != null && (model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class)) != null && !DataSourceScopeEditor.getNamespaces(model.getRoot()).isEmpty()) {
                this.myModel = model;
                this.mySchemaRoot = this.isSchemaRoot(dataSource, model);
                this.mySkipSpecForRoot = DataSourceScopeEditor.isSingleRoot(dataSource);
                this.myFakeCurrentSchemaEnabled = this.isFakeCurrentSchemaEnabled(model, dataSource.getFakeCurrentSchema());
                this.myTree.update();
                this.onStateChanged();
            }
            this.handleIntrospectionError(StringUtil.nullize((String)context.getErrorHandler().getSummary()));
        }, AsyncUtil.EDT_EXECUTOR);
    }

    protected void handleIntrospectionError(@Nullable String msg) {
    }

    private static boolean isSingleRoot(@NotNull LocalDataSource dataSource) {
        Dbms dbms;
        if (dataSource == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(9);
        }
        return (dbms = dataSource.getDbms()).isH2() || dbms.isHsqldb();
    }

    protected boolean isSchemaRoot(@NotNull LocalDataSource dataSource, @Nullable BasicModel tempModel) {
        BasicNamespace rootNamespace;
        if (dataSource == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(10);
        }
        BasicNamespace basicNamespace = rootNamespace = tempModel == null ? null : (BasicNamespace)DataSourceScopeEditor.getNamespaces(tempModel.getRoot()).first();
        return rootNamespace == null ? DbImplUtil.getMetaModel(dataSource).getRootNamespaceKinds().contains((Object)ObjectKind.SCHEMA) : rootNamespace.getKind() == ObjectKind.SCHEMA;
    }

    @NotNull
    public Tree getTree() {
        DataSourceScopeEditorTree dataSourceScopeEditorTree = this.myTree.getTree();
        if (dataSourceScopeEditorTree == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(11);
        }
        return dataSourceScopeEditorTree;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(12);
        }
        return jComponent;
    }

    @NotNull
    protected DefaultActionGroup createTreeActions() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{new RefreshAction(), this.createExpandActon(), this.createCollapseAction(), new MarkAsCurrentAction(), new SubstituteAction()});
        if (defaultActionGroup == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(13);
        }
        return defaultActionGroup;
    }

    @NotNull
    private AnAction createCollapseAction() {
        CollapseAllAction action2 = new CollapseAllAction((JTree)this.getTree());
        action2.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CollapseAll"), (JComponent)this.getTree());
        CollapseAllAction collapseAllAction = action2;
        if (collapseAllAction == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(14);
        }
        return collapseAllAction;
    }

    @NotNull
    private AnAction createExpandActon() {
        ExpandAllAction action2 = new ExpandAllAction((JTree)this.getTree());
        action2.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ExpandAll"), (JComponent)this.getTree());
        ExpandAllAction expandAllAction = action2;
        if (expandAllAction == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(15);
        }
        return expandAllAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNorthPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapseAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandActon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSubstituted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSchemaMapping";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaces";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSingleRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTree
    extends FilteringTree<CheckedTreeNode, DataSourceScopeEditorTree.MyNode> {
        final /* synthetic */ DataSourceScopeEditor this$0;

        MyTree(@NotNull DataSourceScopeEditor dataSourceScopeEditor, Project project, DataSourceScopeEditorTree.MyNode root2, Getter<Couple<String>> fakeCurrent, DataSourceSchemaMapping mapping) {
            if (project == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            this(dataSourceScopeEditor, project, DataSourceScopeEditorTree.createNode(root2), fakeCurrent, mapping);
        }

        private MyTree(@NotNull DataSourceScopeEditor dataSourceScopeEditor, Project project, CheckedTreeNode root2, Getter<Couple<String>> fakeCurrent, DataSourceSchemaMapping mapping) {
            if (project == null) {
                MyTree.$$$reportNull$$$0(1);
            }
            this.this$0 = dataSourceScopeEditor;
            super(project, (Tree)new DataSourceScopeEditorTree(root2, fakeCurrent, mapping), root2);
        }

        @Override
        protected Class<? extends CheckedTreeNode> getNodeClass() {
            return CheckedTreeNode.class;
        }

        @Override
        @NotNull
        protected CheckedTreeNode createNode(@Nullable DataSourceScopeEditorTree.MyNode obj2) {
            CheckedTreeNode checkedTreeNode = DataSourceScopeEditorTree.createNode(obj2);
            if (checkedTreeNode == null) {
                MyTree.$$$reportNull$$$0(2);
            }
            return checkedTreeNode;
        }

        @Override
        @NotNull
        protected Iterable<DataSourceScopeEditorTree.MyNode> getChildren(@NotNull DataSourceScopeEditorTree.MyNode obj2) {
            if (obj2 == null) {
                MyTree.$$$reportNull$$$0(3);
            }
            JBIterable jBIterable = obj2.getChildNodes();
            if (jBIterable == null) {
                MyTree.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        protected String getText(@Nullable DataSourceScopeEditorTree.MyNode object) {
            return object == null || object.getObject() == "*" ? null : object.getName();
        }

        @NotNull
        public DataSourceScopeEditorTree getTree() {
            DataSourceScopeEditorTree dataSourceScopeEditorTree = (DataSourceScopeEditorTree)super.getTree();
            if (dataSourceScopeEditorTree == null) {
                MyTree.$$$reportNull$$$0(5);
            }
            return dataSourceScopeEditorTree;
        }

        @Override
        protected void rebuildTree() {
            DataSourceScopeEditorTree.MyNode root2 = (DataSourceScopeEditorTree.MyNode)this.getSearchModel().getRootObject();
            if (this.this$0.myModel == null) {
                root2.setHasAllAndCur(!this.this$0.mySkipSpecForRoot);
                DataSourceScopeEditorTree.CurNode current = root2.getCurNode();
                if (current != null) {
                    current.setCurObject(null);
                }
                root2.setChildren(null);
                root2.setShadowChildren(null);
                return;
            }
            this.addNodes(root2, this.sorted((Iterable<? extends BasicNamespace>)DataSourceScopeEditor.getNamespaces(this.this$0.myModel.getRoot())));
            this.createShadowStructure(root2, TreePatternUtils.union(this.this$0.myPermStructure, this.this$0.mySelectedScope));
            this.getSearchModel().updateStructure();
        }

        private void addNodes(@NotNull DataSourceScopeEditorTree.MyNode p2, @NotNull Iterable<BasicNamespace> objects2) {
            if (p2 == null) {
                MyTree.$$$reportNull$$$0(6);
            }
            if (objects2 == null) {
                MyTree.$$$reportNull$$$0(7);
            }
            Map<String, DataSourceScopeEditorTree.MyNode> oldCache = this.mapByName((Iterable<DataSourceScopeEditorTree.MyNode>)p2.getChildNodes());
            ArrayList<DataSourceScopeEditorTree.MyNode> children2 = new ArrayList<DataSourceScopeEditorTree.MyNode>();
            BasicNamespace cur = null;
            for (BasicNamespace object : objects2) {
                DataSourceScopeEditorTree.MyNode node = oldCache.remove(object.getName());
                if (node != null) {
                    node.setObject(object);
                } else {
                    node = new DataSourceScopeEditorTree.MyNode(object.getName(), object.getKind(), object);
                }
                children2.add(node);
                if (object.isCurrent()) {
                    cur = object;
                }
                if (DbImplUtil.isSchema(object)) continue;
                this.addNodes(node, this.sorted((Iterable<? extends BasicNamespace>)DataSourceScopeEditor.getNamespaces(object)));
            }
            oldCache.values().forEach(o -> o.setObject(o.getName()));
            p2.setHasAllAndCur(p2.getKind() != ObjectKind.NONE || !this.this$0.mySkipSpecForRoot || p2.getAllNode() != null);
            DataSourceScopeEditorTree.CurNode current = p2.getCurNode();
            if (current != null) {
                current.setCurObject(cur);
            }
            p2.setChildren(children2);
            p2.setShadowChildren(oldCache.values());
        }

        private Iterable<BasicNamespace> sorted(Iterable<? extends BasicNamespace> children2) {
            ArrayList namespaces = ContainerUtil.newArrayList(children2);
            Collections.sort(namespaces, (n1, n2) -> StringUtil.naturalCompare((String)n1.getName(), (String)n2.getName()));
            return namespaces;
        }

        private void createShadowStructure(@NotNull DataSourceScopeEditorTree.MyNode root2, @NotNull TreePattern scope) {
            if (root2 == null) {
                MyTree.$$$reportNull$$$0(8);
            }
            if (scope == null) {
                MyTree.$$$reportNull$$$0(9);
            }
            if (!this.this$0.mySchemaRoot) {
                TreePatternNode.Group dbG = scope.root.getGroup(ObjectKind.DATABASE);
                this.fillShadowDatabases(dbG, root2);
            } else {
                TreePatternNode.Group scG = scope.root.getGroup(ObjectKind.SCHEMA);
                this.fillShadowSchemas(scG, root2);
            }
        }

        private void fillShadowDatabases(TreePatternNode.Group dbG, @NotNull @NotNull @NotNull DataSourceScopeEditorTree.MyNode root2) {
            if (root2 == null) {
                MyTree.$$$reportNull$$$0(10);
            }
            HashSet<DataSourceScopeEditorTree.MyNode> processedDb = new HashSet<DataSourceScopeEditorTree.MyNode>();
            ArrayList<DataSourceScopeEditorTree.MyNode> rootShadow = new ArrayList<DataSourceScopeEditorTree.MyNode>();
            Map<String, DataSourceScopeEditorTree.MyNode> oldRootCache = this.mapByName(root2.getShadowChildren());
            Map<String, DataSourceScopeEditorTree.MyNode> objects2 = this.mapByName(root2.getChildren());
            if (dbG != null) {
                if (dbG.matchedChildren(DataSourceSchemaMapping.CURRENT_NAMESPACE_NAME, null, null) || dbG.negativeChild != null) {
                    root2.setHasAllAndCur(true);
                }
                if (dbG.positiveChildren != null) {
                    for (TreePatternNode<TreePatternNode.PositiveNaming> child : dbG.positiveChildren) {
                        TreePatternNode.Group scG = child.getGroup(ObjectKind.SCHEMA);
                        for (ObjectName dbName : ((TreePatternNode.BaseNaming)child.naming).names) {
                            String db = dbName.name;
                            if (db.equals("@")) continue;
                            DataSourceScopeEditorTree.MyNode object = objects2.get(db);
                            if (object != null) {
                                processedDb.add(object);
                            } else {
                                object = oldRootCache.get(db);
                                if (object == null) {
                                    object = new DataSourceScopeEditorTree.MyNode(db, ObjectKind.DATABASE, db);
                                }
                                rootShadow.add(object);
                            }
                            this.fillShadowSchemas(scG, object);
                        }
                    }
                }
            }
            root2.setShadowChildren(rootShadow);
            for (DataSourceScopeEditorTree.MyNode node : root2.getChildren()) {
                if (processedDb.contains(node)) continue;
                node.purgeShadow();
            }
        }

        private void fillShadowSchemas(@Nullable TreePatternNode.Group scG, DataSourceScopeEditorTree.MyNode p2) {
            ArrayList<DataSourceScopeEditorTree.MyNode> dbShadow = new ArrayList<DataSourceScopeEditorTree.MyNode>();
            Map<String, DataSourceScopeEditorTree.MyNode> schemaObjects = this.mapByName(p2.getChildren());
            Map<String, DataSourceScopeEditorTree.MyNode> oldSchemasCache = this.mapByName(p2.getShadowChildren());
            if (scG != null) {
                if (scG.matchedChildren(DataSourceSchemaMapping.CURRENT_NAMESPACE_NAME, null, null) || scG.negativeChild != null) {
                    p2.setHasAllAndCur(true);
                }
                if (scG.positiveChildren != null) {
                    for (TreePatternNode<TreePatternNode.PositiveNaming> child : scG.positiveChildren) {
                        for (ObjectName scName : ((TreePatternNode.BaseNaming)child.naming).names) {
                            String sc = scName.name;
                            if (sc.equals("*") || sc.equals("@") || schemaObjects.containsKey(sc)) continue;
                            DataSourceScopeEditorTree.MyNode schema = oldSchemasCache.get(sc);
                            if (schema == null) {
                                schema = new DataSourceScopeEditorTree.MyNode(sc, ObjectKind.SCHEMA, sc);
                            }
                            dbShadow.add(schema);
                        }
                    }
                }
            }
            p2.setShadowChildren(dbShadow);
            for (DataSourceScopeEditorTree.MyNode node : p2.getChildNodes()) {
                node.purgeShadow();
            }
        }

        private Map<String, DataSourceScopeEditorTree.MyNode> mapByName(Iterable<DataSourceScopeEditorTree.MyNode> children2) {
            HashMap<String, DataSourceScopeEditorTree.MyNode> oldCache = new HashMap<String, DataSourceScopeEditorTree.MyNode>();
            for (DataSourceScopeEditorTree.MyNode node : children2) {
                if (node instanceof DataSourceScopeEditorTree.CurNode || node.getObject() == "*") continue;
                oldCache.put(node.getName(), node);
            }
            return oldCache;
        }

        private void recheck(@NotNull TreePattern scope) {
            if (scope == null) {
                MyTree.$$$reportNull$$$0(11);
            }
            FilteringTree.SearchTreeModel model = this.this$0.myTree.getSearchModel();
            DataSourceScopeEditorTree.MyNode root2 = (DataSourceScopeEditorTree.MyNode)model.getRootObject();
            root2.setChecked(true);
            this.recheck(root2, Collections.singleton(scope.root));
            this.getTree().updateFromNodes();
        }

        private void recheck(DataSourceScopeEditorTree.MyNode n, Iterable<TreePatternNode<?>> pns) {
            for (DataSourceScopeEditorTree.MyNode c2 : n.getChildNodes()) {
                HashSet childPatterns = new HashSet();
                String name2 = DataSourceScopeEditor.getNodeName(c2);
                for (TreePatternNode<?> pn : pns) {
                    TreePatternNode.Group cg = pn.getGroup(c2.getKind());
                    if (cg == null) continue;
                    if ("*".equals(name2)) {
                        ContainerUtil.addIfNotNull(childPatterns, cg.negativeChild);
                        continue;
                    }
                    cg.matchedChildren(ObjectName.quoted((String)name2), null, childPatterns);
                }
                if (!"*".equals(name2)) {
                    childPatterns.removeIf(p2 -> p2.naming instanceof TreePatternNode.NegativeNaming);
                }
                c2.setChecked(!childPatterns.isEmpty());
                this.recheck(c2, childPatterns);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addNodes";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createShadowStructure";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "fillShadowDatabases";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "recheck";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SubstituteAction
    extends DumbAwareAction {
        public SubstituteAction() {
            super(null, null, AllIcons.Actions.Lightning);
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor;
            if (e == null) {
                SubstituteAction.$$$reportNull$$$0(0);
            }
            LocalDataSource dataSource = (editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY)) == null ? null : editor.getDataSource(false);
            boolean visible = editor != null && (DataSourceSnapshotManager.IGNORE_AUTO_MINI_CAT || dataSource != null && !dataSource.getSchemaMapping().isUseMiniCat());
            JBIterable<DataSourceScopeEditorTree.MyNode> nodes2 = visible ? SubstituteAction.getNamespaceNodes(editor) : JBIterable.empty();
            boolean enabled = visible && nodes2.map(n -> n.getObject()).filter(BasicNamespace.class).filter(o -> DataSourceSnapshotManager.INSTANCE.canSubstitute((BasicNamespace)o, false)).isNotEmpty();
            DataSourceScopeEditorTree.MyNode first2 = (DataSourceScopeEditorTree.MyNode)nodes2.first();
            BasicNamespace namespace = first2 == null ? null : (BasicNamespace)first2.getObject();
            boolean state2 = editor != null && (first2 == null || editor.isSubstituted(namespace) && !first2.isChecked());
            String ac = state2 ? "Disable" : "Enable";
            e.getPresentation().setText(ac + " Pre-Introspected Objects");
            e.getPresentation().setDescription(ac + " pre-introspected objects for code assistance");
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        @NotNull
        private static JBIterable<DataSourceScopeEditorTree.MyNode> getNamespaceNodes(DataSourceScopeEditor editor) {
            JBIterable jBIterable = JBIterable.of((Object[])editor.getTree().getSelectedNodes(CheckedTreeNode.class, null)).filterMap(n -> (DataSourceScopeEditorTree.MyNode)editor.myTree.getUserObject((TreeNode)n)).filter(n -> n.getObject() instanceof BasicNamespace);
            if (jBIterable == null) {
                SubstituteAction.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor;
            JBIterable<DataSourceScopeEditorTree.MyNode> namespaces;
            DataSourceScopeEditorTree.MyNode first2;
            if (e == null) {
                SubstituteAction.$$$reportNull$$$0(2);
            }
            BasicNamespace namespace = (first2 = (DataSourceScopeEditorTree.MyNode)(namespaces = SubstituteAction.getNamespaceNodes(editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY))).first()) == null ? null : (BasicNamespace)first2.getObject();
            boolean state2 = first2 == null || editor.isSubstituted(namespace) && !first2.isChecked();
            namespaces.forEach(n -> {
                if (!state2 && n.isChecked()) {
                    n.setChecked(false);
                }
                editor.setSubstituted((BasicNamespace)n.getObject(), !state2);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor$SubstituteAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$SubstituteAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaceNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MarkAsCurrentAction
    extends DumbAwareAction {
        public MarkAsCurrentAction() {
            super("Mark as Current", "Mark schema/database as current", AllIcons.Actions.Checked_selected);
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor;
            if (e == null) {
                MarkAsCurrentAction.$$$reportNull$$$0(0);
            }
            boolean visible = (editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY)) != null && editor.myFakeCurrentSchemaEnabled;
            boolean enabled = visible && !this.getNodes(editor).isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        @NotNull
        public JBIterable<DataSourceScopeEditorTree.MyNode> getNodes(DataSourceScopeEditor editor) {
            JBIterable jBIterable = JBIterable.of((Object[])editor.getTree().getSelectedNodes(CheckedTreeNode.class, null)).filterMap(n -> (DataSourceScopeEditorTree.MyNode)editor.myTree.getUserObject((TreeNode)n)).filter(n -> !(n instanceof DataSourceScopeEditorTree.CurNode) && n.getObject() != "*");
            if (jBIterable == null) {
                MarkAsCurrentAction.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor;
            DataSourceScopeEditorTree.MyNode node;
            if (e == null) {
                MarkAsCurrentAction.$$$reportNull$$$0(2);
            }
            if ((node = (DataSourceScopeEditorTree.MyNode)this.getNodes(editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY)).first()) == null) {
                return;
            }
            String name2 = DataSourceScopeEditor.getNodeName(node);
            if (node.getKind() == ObjectKind.DATABASE) {
                this.mark(editor, name2, null);
            } else {
                this.mark(editor, DataSourceScopeEditorTree.getParentName(node), name2);
            }
        }

        public void mark(DataSourceScopeEditor editor, String pName, String name2) {
            Couple<String> fsc = editor.myFakeCurrentSchema;
            boolean isSet = DataSourceScopeEditorTree.matches(fsc, pName, name2);
            editor.setFakeCurrentSchema(isSet ? null : Couple.of((Object)pName, (Object)name2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor$MarkAsCurrentAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$MarkAsCurrentAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RefreshAction
    extends DumbAwareAction {
        RefreshAction() {
            super("Refresh", "Refresh schemas list", AllIcons.Actions.Refresh);
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor;
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            boolean enabled = (editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY)) != null && editor.canReintrospect();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription("Refresh schemas list" + (enabled ? "" : " (already running)"));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor;
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            if ((editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY)) != null) {
                List objects2 = JBIterable.of((Object[])editor.getTree().getSelectedNodes(CheckedTreeNode.class, null)).transform(n -> {
                    DataSourceScopeEditorTree.MyNode node = (DataSourceScopeEditorTree.MyNode)editor.myTree.getUserObject((TreeNode)n);
                    return node == null ? null : node.getObject();
                }).filter(BasicNamespace.class).toList();
                editor.reintrospect(objects2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$RefreshAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

