/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabasePasswordField;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.ui.PasswordStorageComponent;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.AuthType;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshPanel {
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final DatabaseCredentials myCredentials;
    private final SingleAlarm myUpdateAlarm;
    private JPanel myPanel;
    private JBTextField myProxyHostField;
    private JBTextField myProxyPortField;
    private JBTextField myUserField;
    private JBPasswordField myPasswordField;
    private JCheckBox myUseSshCheckBox;
    private JPanel mySettingContainerPanel;
    private ComboBox<AuthType> myAuthTypeCombo;
    private JBPasswordField myPassphraseField;
    private TextFieldWithBrowseButton myPrivateKeyFileField;
    private LinkLabel<?> mySshCopyFrom;
    private JPanel myPasswordPanel;
    private JPanel myCertificatePanel;
    private PasswordStorageComponent myPasswordStorage;
    private JComponent myStorageOption;
    private JBTextField myLocalPortField;
    private JPanel myStoragePanel;
    private DatabasePasswordField myPasswordLazyField;
    private DatabasePasswordField myPassphraseLazyField;

    public DataSourceSshPanel(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseCredentials credentials, @NotNull Disposable parent2) {
        if (project == null) {
            DataSourceSshPanel.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DataSourceSshPanel.$$$reportNull$$$0(1);
        }
        if (credentials == null) {
            DataSourceSshPanel.$$$reportNull$$$0(2);
        }
        if (parent2 == null) {
            DataSourceSshPanel.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myCredentials = credentials;
        this.myUpdateAlarm = new SingleAlarm(this::updateAlarmCallback, 100, ModalityState.any(), parent2);
        this.$$$setupUI$$$();
        DataSourceSshTunnelConfiguration ssh = this.myDataSource.getSshConfiguration();
        this.reset(this.myDataSource, false);
        this.myUseSshCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceSshPanel.this.updateSshPanel();
            }
        });
        this.myAuthTypeCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(AuthType.values()), (Object)(ssh == null ? AuthType.PASSWORD : ssh.getAuthType())));
        this.myAuthTypeCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", AuthType::getDisplayName));
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceSshPanel.this.updateSshPanel();
            }
        });
        this.myProxyHostField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DataSourceSshPanel.this.myUpdateAlarm.cancelAndRequest();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSshPanel$3", "textChanged"));
            }
        });
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                DataSourceSshPanel.this.updateNeedsPassphrase();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSshPanel$4", "textChanged"));
            }
        });
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return true;
            }
        };
        this.myPrivateKeyFileField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Choose Private Key File", "", (ComponentWithBrowseButton)this.myPrivateKeyFileField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.updateSshPanel();
    }

    private void updateAlarmCallback() {
        this.updateOpenSSHPortUser();
    }

    public void hidePasswords() {
        this.myPasswordLazyField.moveToStorage();
        this.myPassphraseLazyField.moveToStorage();
    }

    public void passwordsChangedInStorage() {
        this.myPasswordLazyField.changedInStorage();
        this.myPassphraseLazyField.changedInStorage();
    }

    private void updateNeedsPassphrase() {
        if (!this.myPrivateKeyFileField.isValid()) {
            return;
        }
        if (StringUtil.isNotEmpty((String)this.myPrivateKeyFileField.getText())) {
            boolean needsPassphrase = SshConnectionUtil.isPassphraseMayBeRequired((String)this.myPrivateKeyFileField.getText());
            if (needsPassphrase) {
                if (!this.myPassphraseField.isEnabled()) {
                    this.myPassphraseField.setEnabled(true);
                }
            } else {
                this.myPassphraseField.setEnabled(false);
            }
        } else {
            this.myPasswordField.setEnabled(true);
        }
    }

    private void updateSshPanel() {
        AuthType authType = (AuthType)this.myAuthTypeCombo.getSelectedItem();
        boolean useSsh = this.myUseSshCheckBox.isSelected();
        if (authType == AuthType.PASSWORD) {
            this.myPasswordPanel.add((Component)this.myStoragePanel, UrlPropertiesPanel.createSimpleConstraints(0, 3, 1));
        } else if (authType == AuthType.KEY_PAIR) {
            this.myCertificatePanel.add((Component)this.myStoragePanel, UrlPropertiesPanel.createSimpleConstraints(1, 3, 1));
        }
        this.myUpdateAlarm.cancelAndRequest();
        UIUtil.setEnabled((Component)this.myPasswordPanel, (useSsh && authType == AuthType.PASSWORD ? 1 : 0) != 0, (boolean)true);
        this.myPasswordPanel.setVisible(authType == AuthType.PASSWORD);
        UIUtil.setEnabled((Component)this.myCertificatePanel, (authType == AuthType.KEY_PAIR ? 1 : 0) != 0, (boolean)true);
        this.myCertificatePanel.setVisible(authType == AuthType.KEY_PAIR);
        this.updateNeedsPassphrase();
        UIUtil.setEnabled((Component)this.mySettingContainerPanel, (boolean)this.myUseSshCheckBox.isSelected(), (boolean)true);
        this.mySshCopyFrom.setVisible(this.myUseSshCheckBox.isSelected());
    }

    private void updateOpenSSHPortUser() {
        AuthType authType = this.getAuthType();
        switch (authType) {
            case PASSWORD: {
                this.myProxyPortField.getEmptyText().setText(String.valueOf(22));
                this.myLocalPortField.getEmptyText().setText("<Dynamic>");
                this.myUserField.getEmptyText().clear();
                break;
            }
            case KEY_PAIR: {
                this.myProxyPortField.getEmptyText().setText(String.valueOf(22));
                this.myLocalPortField.getEmptyText().setText("<Dynamic>");
                this.myUserField.getEmptyText().clear();
                ((JBTextField)this.myPrivateKeyFileField.getTextField()).getEmptyText().setText("~/.ssh/id_rsa");
                break;
            }
            case OPEN_SSH: {
                OpenSSHClientConfig openSSHConfig = OpenSSHConfigService.getInstance().getConfig();
                if (openSSHConfig == null) {
                    return;
                }
                OpenSSHClientConfig.HostConfig hostConfig = openSSHConfig.getConfig(this.myProxyHostField.getText().trim());
                int port = hostConfig.getPort();
                this.myProxyPortField.getEmptyText().setText(port == -1 ? "" : String.valueOf(port));
                String user = hostConfig.getUser();
                this.myUserField.getEmptyText().setText(user == null ? "" : user);
                String localPort = this.getLocalPort((ConfigRepository.Config)hostConfig);
                this.myLocalPortField.getEmptyText().setText(StringUtil.notNullize((String)localPort, (String)"<Dynamic>"));
            }
        }
    }

    @Nullable
    private String getLocalPort(ConfigRepository.Config hostConfig) {
        Pair<String, String> hostPort = this.getActualHostPort();
        String term = hostPort == null ? null : " " + (String)hostPort.first + ":" + (String)hostPort.second;
        Object[] forwards = term == null ? null : hostConfig.getValues("LocalForward");
        String fwd = forwards == null ? null : (String)ContainerUtil.find((Object[])forwards, f -> f.endsWith(term));
        int colon = fwd == null ? -1 : fwd.indexOf(32);
        return colon == -1 ? null : fwd.substring(0, colon);
    }

    @Nullable
    protected Pair<String, String> getActualHostPort() {
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        String url = this.myDataSource.getUrl();
        return driver == null || url == null ? null : JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), url, null);
    }

    public void updateInfoLabel() {
        Pair<String, String> hostPort = this.getActualHostPort();
        if (hostPort == null) {
            this.myUseSshCheckBox.setToolTipText("Unable to find remote host/port in URL");
        } else {
            this.myUseSshCheckBox.setToolTipText("Remote host is " + (String)hostPort.first + " : " + (String)hostPort.second);
        }
        this.updateOpenSSHPortUser();
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DataSourceSshPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Nullable
    public DataSourceSshTunnelConfiguration createSshConfig() {
        DataSourceSshTunnelConfiguration result2 = new DataSourceSshTunnelConfiguration(this.myProxyHostField.getText().trim(), this.myProxyPortField.getText().trim(), this.myLocalPortField.getText().trim(), this.myPasswordStorage.getStorage(), this.myUserField.getText().trim(), this.getAuthType(), this.myPrivateKeyFileField.getText().trim(), this.myUseSshCheckBox.isSelected());
        return result2.isEmpty() ? null : result2;
    }

    @NotNull
    public AuthType getAuthType() {
        AuthType authType = (AuthType)ObjectUtils.notNull((Object)this.myAuthTypeCombo.getSelectedItem());
        if (authType == null) {
            DataSourceSshPanel.$$$reportNull$$$0(5);
        }
        return authType;
    }

    private void setupFromSshCfg(@Nullable DataSourceSshTunnelConfiguration c2) {
        this.myPasswordStorage.setPasswordStorage(LocalDataSource.Storage.orMem(c2 == null ? null : c2.getPasswordStorage()));
        this.myProxyHostField.setText(c2 == null ? "" : c2.getProxyHost());
        this.myProxyPortField.setText(c2 == null ? "" : c2.getProxyPort());
        this.myLocalPortField.setText(c2 == null ? "" : c2.getLocalPort());
        this.myUserField.setText(c2 == null ? "" : c2.getUser());
        this.myUseSshCheckBox.setSelected(c2 != null && c2.isEnabled());
        this.myAuthTypeCombo.setSelectedItem((Object)(c2 == null ? AuthType.PASSWORD : c2.getAuthType()));
        this.myPrivateKeyFileField.setText(c2 == null ? "" : c2.getPrivateKeyPath());
    }

    private void createUIComponents() {
        this.myPasswordStorage = new PasswordStorageComponent();
        this.myStorageOption = this.myPasswordStorage.getComponent();
        this.mySshCopyFrom = DataSourceSshPanel.createLabel(this.myProject, (Condition<LocalDataSource>)((Condition)ds -> ds != this.myDataSource && ds.getSshConfiguration() != null), (Consumer<? super LocalDataSource>)((Consumer)dataSource -> this.copyFrom(this.getActualDataSource((LocalDataSource)dataSource))), "No data sources with SSH");
        this.myPasswordLazyField = new DatabasePasswordField(this.myCredentials, this.myDataSource){

            @Override
            @Nullable
            protected OneTimeString extractPassword(@NotNull DatabaseCredentials credentials, @NotNull DasDataSource dataSource) {
                if (credentials == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (dataSource == null) {
                    6.$$$reportNull$$$0(1);
                }
                return credentials.getSshPassword(dataSource);
            }

            @Override
            protected void setPassword(@NotNull DatabaseCredentials credentials, @NotNull DasDataSource dataSource, @Nullable OneTimeString password) {
                if (credentials == null) {
                    6.$$$reportNull$$$0(2);
                }
                if (dataSource == null) {
                    6.$$$reportNull$$$0(3);
                }
                credentials.setSshPassword(dataSource, password);
            }

            @Override
            protected LocalDataSource getActualTarget() {
                return DataSourceSshPanel.this.withUpToDateStorage();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "credentials";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshPanel$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extractPassword";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setPassword";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myPasswordField = this.myPasswordLazyField.getComponent();
        this.myPassphraseLazyField = new DatabasePasswordField(this.myCredentials, this.myDataSource){

            @Override
            @Nullable
            protected OneTimeString extractPassword(@NotNull DatabaseCredentials credentials, @NotNull DasDataSource dataSource) {
                if (credentials == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (dataSource == null) {
                    7.$$$reportNull$$$0(1);
                }
                return credentials.getSshPassphrase(dataSource);
            }

            @Override
            protected void setPassword(@NotNull DatabaseCredentials credentials, @NotNull DasDataSource dataSource, @Nullable OneTimeString password) {
                if (credentials == null) {
                    7.$$$reportNull$$$0(2);
                }
                if (dataSource == null) {
                    7.$$$reportNull$$$0(3);
                }
                credentials.setSshPassphrase(dataSource, password);
            }

            @Override
            protected LocalDataSource getActualTarget() {
                return DataSourceSshPanel.this.withUpToDateStorage();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "credentials";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshPanel$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extractPassword";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setPassword";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myPassphraseField = this.myPassphraseLazyField.getComponent();
    }

    @NotNull
    private LocalDataSource withUpToDateStorage() {
        LocalDataSource copy = this.myDataSource.copy(true);
        copy.setSshConfiguration(this.createSshConfig());
        LocalDataSource localDataSource = copy;
        if (localDataSource == null) {
            DataSourceSshPanel.$$$reportNull$$$0(6);
        }
        return localDataSource;
    }

    public void copyFrom(LocalDataSource actualDataSource) {
        this.myUseSshCheckBox.setSelected(true);
        this.setupFromSshCfg(actualDataSource.getSshConfiguration());
        this.myPasswordLazyField.copy(actualDataSource);
        this.myPassphraseLazyField.copy(actualDataSource);
        this.updateSshPanel();
    }

    protected LocalDataSource getActualDataSource(LocalDataSource dataSource) {
        return dataSource;
    }

    @NotNull
    static LinkLabel<?> createLabel(final @NotNull Project project, final @NotNull Condition<LocalDataSource> condition, final @NotNull Consumer<? super LocalDataSource> processor, final @NotNull String emptyText) {
        if (project == null) {
            DataSourceSshPanel.$$$reportNull$$$0(7);
        }
        if (condition == null) {
            DataSourceSshPanel.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            DataSourceSshPanel.$$$reportNull$$$0(9);
        }
        if (emptyText == null) {
            DataSourceSshPanel.$$$reportNull$$$0(10);
        }
        LinkLabel linkLabel = new LinkLabel("Copy from ...", null, (LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel src, Void data) {
                List sources = DataSourceSshPanel.findAvailableDataSources(project, (Condition<LocalDataSource>)condition);
                if (sources.isEmpty()) {
                    JBPopupFactory.getInstance().createPopupChooserBuilder(Collections.singletonList(emptyText)).setRenderer((ListCellRenderer)new SelectionAwareListCellRenderer(dom -> {
                        JBLabel label = new JBLabel(dom, null, 2);
                        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
                        return label;
                    })).setRequestFocus(true).createPopup().showUnderneathOf((Component)src);
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(sources).setRenderer((ListCellRenderer)new SelectionAwareListCellRenderer(o -> {
                    JBLabel label = new JBLabel(o.getName(), o.getBaseIcon(), 2);
                    label.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
                    return label;
                })).setRequestFocus(true).setItemChosenCallback(source -> {
                    if (source == null) {
                        return;
                    }
                    processor.consume(source);
                }).createPopup().showUnderneathOf((Component)src);
            }
        });
        if (linkLabel == null) {
            DataSourceSshPanel.$$$reportNull$$$0(11);
        }
        return linkLabel;
    }

    @NotNull
    private static List<LocalDataSource> findAvailableDataSources(Project project, Condition<LocalDataSource> condition) {
        List dataSources2 = DbPsiFacade.getInstance((Project)project).getDataSources();
        List list = JBIterable.from((Iterable)dataSources2).map(DbElement::getDelegate).filter(LocalDataSource.class).filter(condition).sort(Comparator.comparing(AbstractDataSource::getName)).toList();
        if (list == null) {
            DataSourceSshPanel.$$$reportNull$$$0(12);
        }
        return list;
    }

    public void reset(@NotNull LocalDataSource ds, boolean resetCredentials) {
        if (ds == null) {
            DataSourceSshPanel.$$$reportNull$$$0(13);
        }
        if (resetCredentials) {
            this.myPasswordLazyField.setPassword(null);
            this.myPassphraseLazyField.setPassword(null);
        }
        this.setupFromSshCfg(ds.getSshConfiguration());
    }

    public void saveData(@NotNull LocalDataSource ds, boolean copyCredentials) {
        if (ds == null) {
            DataSourceSshPanel.$$$reportNull$$$0(14);
        }
        DataSourceSshTunnelConfiguration newSsh = this.createSshConfig();
        ds.setSshConfiguration(newSsh);
        if (copyCredentials) {
            this.myPasswordLazyField.save(ds);
            this.myPassphraseLazyField.save(ds);
        }
    }

    @Nullable
    public OneTimeString getPassword() {
        char[] pass = this.myAuthTypeCombo.getSelectedItem() == AuthType.PASSWORD ? this.myPasswordLazyField.getPassword() : null;
        return pass != null ? new OneTimeString(pass) : null;
    }

    @Nullable
    public OneTimeString getPassphrase() {
        char[] pass = this.myAuthTypeCombo.getSelectedItem() != AuthType.PASSWORD ? this.myPassphraseLazyField.getPassword() : null;
        return pass != null ? new OneTimeString(pass) : null;
    }

    public boolean isPasswordChanged() {
        return this.myPasswordLazyField.isModified();
    }

    public boolean isPassphraseChanged() {
        return this.myPassphraseLazyField.isModified();
    }

    public void onApply() {
        this.myPasswordLazyField.setPassword(null);
        this.myPassphraseLazyField.setPassword(null);
    }

    @Nullable
    public String getVisiblePassword() {
        char[] pass = this.myPasswordLazyField.getPasswordOpt();
        return pass == null ? null : new String(pass);
    }

    @Nullable
    public String getVisiblePassphrase() {
        char[] pass = this.myPassphraseLazyField.getPasswordOpt();
        return pass == null ? null : new String(pass);
    }

    public void setPassword(@Nullable String pass) {
        this.myPasswordLazyField.setPassword(pass);
    }

    public void setPassphrase(@Nullable String pass) {
        this.myPassphraseLazyField.setPassword(pass);
    }

    public void setPasswordStorage(@NotNull LocalDataSource.Storage storage) {
        if (storage == null) {
            DataSourceSshPanel.$$$reportNull$$$0(15);
        }
        this.myPasswordStorage.setPasswordStorage(storage);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshPanel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withUpToDateStorage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findAvailableDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setPasswordStorage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel3;
        ComboBox comboBox;
        JBTextField jBTextField;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        JBTextField jBTextField4;
        JPanel jPanel4;
        JCheckBox jCheckBox;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseSshCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        jCheckBox.setText("Use SSH tunnel");
        jCheckBox.setMnemonic('H');
        jCheckBox.setDisplayedMnemonicIndex(6);
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, true));
        this.mySettingContainerPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Proxy host:");
        jBLabel.setDisplayedMnemonic('O');
        jBLabel.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Proxy user:");
        jBLabel2.setDisplayedMnemonic('U');
        jBLabel2.setDisplayedMnemonicIndex(6);
        jPanel4.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myProxyHostField = jBTextField4 = new JBTextField();
        jPanel4.add((Component)jBTextField4, new GridConstraints(0, 1, 1, 2, 8, 1, 7, 0, null, null, null, 0, true));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 3, 2, 1, 0, 3, 0, 0, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Proxy port:");
        jBLabel3.setDisplayedMnemonic('P');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, true));
        this.myProxyPortField = jBTextField3 = new JBTextField();
        jBTextField3.setColumns(5);
        jBTextField3.setText("22");
        jPanel6.add((Component)jBTextField3, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Local port:");
        jBLabel4.setDisplayedMnemonic('L');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, true));
        this.myLocalPortField = jBTextField2 = new JBTextField();
        jBTextField2.setColumns(5);
        jBTextField2.setText("");
        jPanel6.add((Component)jBTextField2, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null, 0, true));
        this.myUserField = jBTextField = new JBTextField();
        jPanel4.add((Component)jBTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, null, null, 0, true));
        this.myAuthTypeCombo = comboBox = new ComboBox();
        jPanel4.add((Component)comboBox, new GridConstraints(2, 1, 1, 3, 8, 0, 0, 0, null, null, null, 0, true));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Auth type:");
        jBLabel5.setDisplayedMnemonic('T');
        jBLabel5.setDisplayedMnemonicIndex(5);
        jPanel4.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myCertificatePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, true));
        this.myPrivateKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 3, 0, 1, 6, 0, null, null, null, 0, true));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Private key file:");
        jBLabel6.setDisplayedMnemonic('R');
        jBLabel6.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        JBPasswordField jBPasswordField = this.myPassphraseField;
        jBPasswordField.setColumns(10);
        jPanel3.add((Component)jBPasswordField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, null, null, 0, true));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Passphrase:");
        jBLabel7.setDisplayedMnemonic('S');
        jBLabel7.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jBLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myStoragePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        JComponent jComponent = this.myStorageOption;
        jPanel2.add((Component)jComponent, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("Remember:");
        jPanel2.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, true));
        this.myPasswordPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("Proxy password:");
        jBLabel9.setDisplayedMnemonic('W');
        jBLabel9.setDisplayedMnemonicIndex(10);
        jPanel.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        JBPasswordField jBPasswordField2 = this.myPasswordField;
        jBPasswordField2.setColumns(10);
        jPanel.add((Component)jBPasswordField2, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, null, null, 0, true));
        LinkLabel<?> linkLabel = this.mySshCopyFrom;
        linkLabel.setText("Copy from...");
        linkLabel.setVerticalAlignment(1);
        jPanel5.add((Component)linkLabel, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null, 0, true));
        jBLabel.setLabelFor((Component)jBTextField4);
        jBLabel2.setLabelFor((Component)jBTextField);
        jBLabel3.setLabelFor((Component)jBTextField3);
        jBLabel4.setLabelFor((Component)jBTextField3);
        jBLabel5.setLabelFor((Component)comboBox);
        jBLabel6.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel7.setLabelFor((Component)jBPasswordField);
        jBLabel8.setLabelFor((Component)jBPasswordField);
        jBLabel9.setLabelFor((Component)jBPasswordField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

