/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.SqlValuesExtractor;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.CharOut;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PreparedStatementContext
implements DataRequest.StatementContext {
    private final RowQueryData myRowQueryData;
    private final Dbms myDbms;
    private String mySql;

    public PreparedStatementContext(@NotNull RowQueryData rowQueryData, @NotNull Dbms dbms) {
        if (rowQueryData == null) {
            PreparedStatementContext.$$$reportNull$$$0(0);
        }
        if (dbms == null) {
            PreparedStatementContext.$$$reportNull$$$0(1);
        }
        this.myRowQueryData = rowQueryData;
        this.myDbms = dbms;
    }

    @Override
    @NotNull
    public String getSql() {
        if (this.mySql != null) {
            String string = this.mySql;
            if (string == null) {
                PreparedStatementContext.$$$reportNull$$$0(2);
            }
            return string;
        }
        ObjectFormatter converter = new ObjectFormatter();
        PlaceholdersExtractor extractor = new PlaceholdersExtractor(converter, this.myRowQueryData);
        StringBuilder sb = new StringBuilder();
        CharOut out = CharOut.Util.newSink(sb);
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>();
        List<ColumnQueryData> data = this.myRowQueryData.getColumnsData();
        ArrayList<Object> objects2 = new ArrayList<Object>();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            ColumnQueryData cqd = data.get(i2);
            DataConsumer.Column column2 = cqd.getColumn();
            columns.add(new DataConsumer.Column(i2, column2.name, column2.type, column2.typeName, column2.clazz, column2.precision, column2.scale, column2.catalog, column2.schema, column2.table));
            objects2.add(cqd.getObject());
        }
        DataConsumer.Row row = DataConsumer.Row.create(0, objects2.toArray());
        ExtractorsUtil.extract(out, this.myDbms, true, columns, extractor, Collections.singletonList(row), ArrayUtilRt.EMPTY_INT_ARRAY);
        this.mySql = sb.toString();
        if (this.mySql == null) {
            PreparedStatementContext.$$$reportNull$$$0(3);
        }
        return this.mySql;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowQueryData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/PreparedStatementContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/PreparedStatementContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSql";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PlaceholdersExtractor
    extends SqlValuesExtractor {
        private final RowQueryData myRowQueryData;

        PlaceholdersExtractor(@NotNull ObjectFormatter converter, @NotNull RowQueryData data) {
            if (converter == null) {
                PlaceholdersExtractor.$$$reportNull$$$0(0);
            }
            if (data == null) {
                PlaceholdersExtractor.$$$reportNull$$$0(1);
            }
            super(converter, (DasTable)null);
            this.myRowQueryData = data;
        }

        @Override
        public DataExtractor.Extraction startExtraction(CharOut out, Dbms dbms, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
            return new MyExtraction(out, dbms, allColumns);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "converter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "data";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/PreparedStatementContext$PlaceholdersExtractor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyExtraction
        extends SqlValuesExtractor.SqlExtractionBase {
            MyExtraction(@NotNull CharOut output, @NotNull Dbms dbms, List<DataConsumer.Column> allColumns) {
                if (output == null) {
                    MyExtraction.$$$reportNull$$$0(0);
                }
                if (dbms == null) {
                    MyExtraction.$$$reportNull$$$0(1);
                }
                if (allColumns == null) {
                    MyExtraction.$$$reportNull$$$0(2);
                }
                super(PlaceholdersExtractor.this, output, dbms, true, allColumns, ArrayUtilRt.EMPTY_INT_ARRAY);
            }

            @Override
            protected void appendData(List<DataConsumer.Row> rows) {
                int lastIndex = 0;
                String sql = PlaceholdersExtractor.this.myRowQueryData.getSql();
                DataConsumer.Row row = (DataConsumer.Row)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(rows));
                int[] offsets = PlaceholdersExtractor.this.myRowQueryData.getOffsets();
                for (int i2 = 0; i2 < offsets.length; ++i2) {
                    int offset = offsets[i2];
                    DataConsumer.Column cqd = (DataConsumer.Column)this.myAllColumns.get(i2);
                    String value = PlaceholdersExtractor.this.getValueLiteral(row, cqd, this.myDbms);
                    this.myDdlBuilder.plain(sql.substring(lastIndex, offset)).plain(value);
                    lastIndex = offset + 1;
                }
                this.myDdlBuilder.plain(sql.substring(lastIndex));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "output";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dbms";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "allColumns";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/datagrid/PreparedStatementContext$PlaceholdersExtractor$MyExtraction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

