/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dialects.base.introspector.AuditFacade;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.impl.RemoteConnectionImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.project.Project;
import java.rmi.RemoteException;
import java.sql.Connection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u0012H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/base/introspector/DBFacadeProvider;", "", "()V", "createFacadeWithSingleLeasedConnection", "Lorg/jetbrains/dekaf/core/DBFacade;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "getRemoteIntermediateFacade", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateFacade;", "withFacade", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "operation", "Lkotlin/Function1;", "ProjectDBFacade", "intellij.database.dialects.base"})
public final class DBFacadeProvider {
    public static final DBFacadeProvider INSTANCE;

    @JvmStatic
    public static final void withFacade(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseDepartment department, @NotNull Function1<? super DBFacade, Unit> operation2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)department, (String)"department");
        Intrinsics.checkParameterIsNotNull(operation2, (String)"operation");
        DatabaseSessionManager.facade$default(project, dataSource, null, null, null, department, 24, null).runSync((Function1)new Function1<InterruptibleDatabaseConnection, Unit>(operation2){
            final /* synthetic */ Function1 $operation;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull InterruptibleDatabaseConnection c2) {
                Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c");
                DBFacade facade = DBFacadeProvider.createFacadeWithSingleLeasedConnection(c2);
                try {
                    this.$operation.invoke((Object)facade);
                }
                finally {
                    facade.disconnect();
                }
            }
            {
                this.$operation = function1;
                super(1);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final DBFacade createFacadeWithSingleLeasedConnection(@NotNull DatabaseConnection connection2) {
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        PrimeIntermediateFacade primeIntermediateFacade = INSTANCE.getRemoteIntermediateFacade(connection2);
        AdaptIntermediateFacade integralIntermediateFacade = new AdaptIntermediateFacade((PrimeIntermediateFacade)new AuditFacade(primeIntermediateFacade, connection2));
        ProjectDBFacade facade = new ProjectDBFacade(connection2.getAuditService().getProject(), (IntegralIntermediateFacade)integralIntermediateFacade);
        facade.connect();
        return (DBFacade)facade;
    }

    private final PrimeIntermediateFacade getRemoteIntermediateFacade(DatabaseConnection connection2) {
        RemoteConnection remoteConnection = (RemoteConnection)RemoteUtil.castToRemote((Object)connection2.getJdbcConnection(), RemoteConnection.class);
        if (remoteConnection == null) {
            JdbcIntermediateFacade jdbcIntermediateFacade = RemoteConnectionImpl.createFacade((JdbcHelper)DbImplUtil.getJdbcHelper(connection2.getDbms()), (Connection)connection2.getJdbcConnection());
            Intrinsics.checkExpressionValueIsNotNull((Object)jdbcIntermediateFacade, (String)"RemoteConnectionImpl.cre\u2026onnection.jdbcConnection)");
            return (PrimeIntermediateFacade)jdbcIntermediateFacade;
        }
        PrimeIntermediateFacade remoteFacade = null;
        try {
            RemoteFacade jpdaFacade = remoteConnection.jpdaFacade();
            Object object = RemoteUtil.castToLocal((Object)jpdaFacade, PrimeIntermediateFacade.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RemoteUtil.castToLocal(j\u2026ediateFacade::class.java)");
            remoteFacade = (PrimeIntermediateFacade)object;
        }
        catch (RemoteException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return remoteFacade;
    }

    private DBFacadeProvider() {
    }

    static {
        DBFacadeProvider dBFacadeProvider;
        INSTANCE = dBFacadeProvider = new DBFacadeProvider();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/base/introspector/DBFacadeProvider$ProjectDBFacade;", "Lorg/jetbrains/dekaf/core/BaseFacade;", "project", "Lcom/intellij/openapi/project/Project;", "facade", "Lorg/jetbrains/dekaf/intermediate/IntegralIntermediateFacade;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/dekaf/intermediate/IntegralIntermediateFacade;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.database.dialects.base"})
    public static final class ProjectDBFacade
    extends BaseFacade {
        @Nullable
        private final Project project;

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        public ProjectDBFacade(@Nullable Project project, @NotNull IntegralIntermediateFacade facade) {
            Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
            super(facade);
            this.project = project;
        }
    }
}

