/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.dialects.cassandra.Cass21Domains;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.Nullable;

public class Cass22Domains
extends Cass21Domains {
    public Cass22Domains() {
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
    }

    @Override
    public boolean isSuitable(@Nullable Version productVersion) {
        return productVersion == null || productVersion.isOrGreater(new int[]{2, 2}) && productVersion.less(new int[]{3, 10});
    }
}

