/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.model;

import com.intellij.database.dialects.db2.model.Db2Check;
import com.intellij.database.dialects.db2.model.Db2ForeignKey;
import com.intellij.database.dialects.db2.model.Db2Index;
import com.intellij.database.dialects.db2.model.Db2Key;
import com.intellij.database.dialects.db2.model.Db2Schema;
import com.intellij.database.dialects.db2.model.Db2TableColumn;
import com.intellij.database.dialects.db2.model.Db2Trigger;
import com.intellij.database.dialects.db2.model.Db2TriggerTarget;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.Db2PartitionMode;
import com.intellij.database.model.properties.Db2TableClustering;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Db2Table
extends BasicModTable,
Db2TriggerTarget {
    @Override
    @Nullable
    default public Db2Schema getSchema() {
        return this.getParent();
    }

    @Override
    @Nullable
    public Db2Schema getParent();

    default public @Nullable NamingFamily<@NotNull ? extends Db2Table> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2Trigger> getTriggers();

    @Override
    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends Db2TableColumn> getColumns();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2Index> getIndices();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2Key> getKeys();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2ForeignKey> getForeignKeys();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2Check> getChecks();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK);
        if (list == null) {
            Db2Table.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getTriggers(), this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks());
        if (list == null) {
            Db2Table.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public Db2PartitionMode getPartitionMode();

    public boolean isColumnOrganized();

    @Nullable
    public Db2TableClustering getClustering();

    @NotNull
    public List<String> getClusteringIndexNames();

    public int getPageFreePercentage();

    @Nullable
    public String getRCTCheckName();

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        String rCTCheckName;
        int pageFreePercentage;
        List<String> clusteringIndexNames;
        Db2TableClustering clustering;
        boolean columnOrganized;
        Db2PartitionMode partitionMode;
        boolean temporary;
        boolean system;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        if (consumer2 == null) {
            Db2Table.$$$reportNull$$$0(2);
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if (outdated = this.isOutdated()) {
            consumer2.accept("Outdated", PropertyConverter.export(outdated));
        }
        if (system = this.isSystem()) {
            consumer2.accept("System", PropertyConverter.export(system));
        }
        if (temporary = this.isTemporary()) {
            consumer2.accept("Temporary", PropertyConverter.export(temporary));
        }
        if ((partitionMode = this.getPartitionMode()) != null) {
            consumer2.accept("PartitionMode", PropertyConverter.export(partitionMode));
        }
        if (columnOrganized = this.isColumnOrganized()) {
            consumer2.accept("ColumnOrganized", PropertyConverter.export(columnOrganized));
        }
        if ((clustering = this.getClustering()) != null) {
            consumer2.accept("Clustering", PropertyConverter.export(clustering));
        }
        if (!(clusteringIndexNames = this.getClusteringIndexNames()).isEmpty()) {
            consumer2.accept("ClusteringIndexNames", PropertyConverter.exportListOfString(clusteringIndexNames));
        }
        if ((pageFreePercentage = this.getPageFreePercentage()) != 0) {
            consumer2.accept("PageFreePercentage", PropertyConverter.export(pageFreePercentage));
        }
        if ((rCTCheckName = this.getRCTCheckName()) != null) {
            consumer2.accept("RCTCheckName", PropertyConverter.export(rCTCheckName));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Outdated", "System", "Temporary", "PartitionMode", "ColumnOrganized", "Clustering", "ClusteringIndexNames", "PageFreePercentage", "RCTCheckName");
        if (list == null) {
            Db2Table.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setTemporary(boolean var1);

    public void setPartitionMode(@Nullable Db2PartitionMode var1);

    public void setColumnOrganized(boolean var1);

    public void setClustering(@Nullable Db2TableClustering var1);

    public void setClusteringIndexNames(@NotNull List<String> var1);

    default public void setClusteringIndexNames(String ... clusteringIndexNames) {
        this.setClusteringIndexNames(Arrays.asList(clusteringIndexNames));
    }

    public void setPageFreePercentage(int var1);

    public void setRCTCheckName(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            Db2Table.$$$reportNull$$$0(4);
        }
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String system = _properties.get("System");
        String temporary = _properties.get("Temporary");
        String partitionMode = _properties.get("PartitionMode");
        String columnOrganized = _properties.get("ColumnOrganized");
        String clustering = _properties.get("Clustering");
        String clusteringIndexNames = _properties.get("ClusteringIndexNames");
        String pageFreePercentage = _properties.get("PageFreePercentage");
        String rCTCheckName = _properties.get("RCTCheckName");
        this.setName(name2 != null ? PropertyConverter.importString(name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean(outdated) : false);
        this.setSystem(system != null ? PropertyConverter.importBoolean(system) : false);
        this.setTemporary(temporary != null ? PropertyConverter.importBoolean(temporary) : false);
        this.setPartitionMode(partitionMode != null ? PropertyConverter.importDb2PartitionMode(partitionMode) : null);
        this.setColumnOrganized(columnOrganized != null ? PropertyConverter.importBoolean(columnOrganized) : false);
        this.setClustering(clustering != null ? PropertyConverter.importDb2TableClustering(clustering) : null);
        this.setClusteringIndexNames(clusteringIndexNames != null ? PropertyConverter.importListOfString(clusteringIndexNames) : Collections.emptyList());
        this.setPageFreePercentage(pageFreePercentage != null ? PropertyConverter.importInt(pageFreePercentage) : 0);
        this.setRCTCheckName(rCTCheckName != null ? PropertyConverter.importString(rCTCheckName) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/model/Db2Table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/model/Db2Table";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

