/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsTableOrView;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J.\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J&\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J>\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/mssql/MsPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "formatTypes", "", "Lcom/intellij/database/data/types/LogicalType;", "getFormatTypes", "()Ljava/util/Set;", "canCastToText", "", "typeName", "", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/model/DasColumn;", "value", "", "type", "Lcom/intellij/database/data/types/OperandType;", "version", "Lcom/intellij/database/util/Version;", "ftsPredicate", "likePredicate", "likeType", "Lcom/intellij/database/data/types/domain/LikeOpType;", "matchCase", "intellij.database.dialects.mssql"})
public final class MsPredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final Set<LogicalType> formatTypes;

    @Override
    @NotNull
    protected Set<LogicalType> getFormatTypes() {
        return this.formatTypes;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull OperandType type, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        if (Intrinsics.areEqual((Object)column2.getDataType().typeName, (Object)"image")) {
            return null;
        }
        return PredicatesUtilKt.defaultEqualsPredicate(column2, value, type, this.getDbms(), version);
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull DasColumn column2, @Nullable Object value, @Nullable Version version) {
        boolean hasFulltextIndex;
        block7: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
            if (!(value instanceof String)) {
                return null;
            }
            DasTable dasTable = column2.getTable();
            if (!(dasTable instanceof MsTableOrView)) {
                dasTable = null;
            }
            MsTableOrView msTableOrView = (MsTableOrView)dasTable;
            if (msTableOrView == null) {
                return null;
            }
            MsTableOrView table = msTableOrView;
            Family family = table.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"table.indices");
            Iterable $this$any$iv = family;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List indexCols;
                    MsIndex index2 = (MsIndex)element$iv;
                    boolean bl2 = false;
                    MsIndex msIndex = index2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)msIndex, (String)"index");
                    Intrinsics.checkExpressionValueIsNotNull((Object)msIndex.getCols(), (String)"index.cols");
                    boolean bl3 = indexCols.size() == 1 && Intrinsics.areEqual((Object)((BasicLikeColumn)indexCols.get(0)), (Object)column2) && index2 instanceof MsIndex && index2.isFulltext();
                    if (!bl3) continue;
                    bl = true;
                    break block7;
                }
                bl = hasFulltextIndex = false;
            }
        }
        if (!hasFulltextIndex) {
            return null;
        }
        String string = DbImplUtil.StringLiteralDecorator.MATCHES.decorate((String)value, this.getDbms());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DbImplUtil.StringLiteral\u2026HES.decorate(value, dbms)");
        String literal = string;
        return new PredicatesHelper.PredicateProducer(column2, literal){
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $literal;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                builder.keyword("CONTAINS").symbol("(").identifier((DasObject)this.$column).symbol(",").space().plain(this.$literal).symbol(")");
            }
            {
                this.$column = dasColumn;
                this.$literal = string;
            }
        };
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull LikeOpType likeType, boolean matchCase, boolean canCastToText, @Nullable Version version) {
        boolean canCast;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)likeType), (String)"likeType");
        if (!(value instanceof String)) {
            return null;
        }
        boolean typeSupportsOperation = PredicatesUtilKt.supportsOperation(OperationKt.LIKE_OPERATION, column2, this.getDbms(), version);
        boolean bl = canCast = canCastToText && this.canCastToText(column2.getDataType().typeName) && !PredicatesUtilKt.supportsOperation(OperationKt.EQUALS_TO_NUMBER_OPERATION, column2, this.getDbms(), version);
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        String likeWord = matchCase || !DbImplUtil.getJdbcHelper(this.getDbms()).supportsIlike() ? "LIKE" : "ILIKE";
        String string = likeType.getDecorator().decorate(StringUtil.notNullize((String)((String)value)), this.getDbms());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"likeType.decorator.decor\u2026.notNullize(value), dbms)");
        String literal = string;
        return new PredicatesHelper.PredicateProducer(typeSupportsOperation, column2, likeWord, literal){
            final /* synthetic */ boolean $typeSupportsOperation;
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $likeWord;
            final /* synthetic */ String $literal;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                if (!this.$typeSupportsOperation) {
                    builder.keyword("CAST").symbol("(").identifier((DasObject)this.$column).space().keyword("AS").space().type("VARCHAR").symbol(")");
                } else {
                    builder.identifier((DasObject)this.$column);
                }
                builder.space().keyword(this.$likeWord).space().literal(this.$literal);
            }
            {
                this.$typeSupportsOperation = bl;
                this.$column = dasColumn;
                this.$likeWord = string;
                this.$literal = string2;
            }
        };
    }

    private final boolean canCastToText(String typeName) {
        String string;
        String string2 = typeName;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return Intrinsics.areEqual(string, (Object)"image") ^ true;
    }

    public MsPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
        this.formatTypes = SetsKt.setOf((Object[])new LogicalType[]{LogicalType.TIME_WITH_TIMEZONE, LogicalType.TIMESTAMP_WITH_TIMEZONE, LogicalType.TIMESTAMP, LogicalType.TIME, LogicalType.DATE});
    }
}

