/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.util.ThreeState;
import java.sql.ResultSet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/mysqlbase/MysqlBaseExecutionEnvironmentHelper;", "Lcom/intellij/database/dialects/base/BaseExecutionEnvironmentHelper;", "()V", "getSslState", "Lcom/intellij/util/ThreeState;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "getTimeZoneManager", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "MysqlBaseTimeZoneManager", "intellij.database.dialects.mysqlbase"})
public final class MysqlBaseExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @NotNull
    public ThreeState getSslState(@NotNull DatabaseConnection connection2) {
        ThreeState threeState;
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        ExecutionMode executionMode = StandardExecutionMode.QUERY;
        String string = "show status like 'ssl_version'";
        SimpleSmartStatement simpleSmartStatement = SmartStatements.Companion.poweredBy(connection2).simple();
        boolean $i$f$first = false;
        ResultsProducer.VoidReadyProcessor voidReadyProcessor = new ResultsProducer.VoidReadyProcessor<String>(){

            public String empty() {
                ResultSet rs = null;
                boolean bl = false;
                return null;
            }

            public String results(@NotNull ResultSet resultSet, int index2) {
                Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
                ResultSet rs = resultSet.next() ? resultSet : null;
                boolean bl = false;
                ResultSet resultSet2 = rs;
                return resultSet2 != null ? resultSet2.getString(2) : null;
            }

            public String updateCount(int count2, int index2) {
                ResultSet rs = null;
                boolean bl = false;
                return null;
            }
        };
        String sslVer = simpleSmartStatement.execute(string, executionMode, voidReadyProcessor).rightOr(null);
        if (sslVer == null) {
            threeState = ThreeState.UNSURE;
        } else {
            CharSequence charSequence = sslVer;
            boolean bl = false;
            threeState = charSequence.length() > 0 ? ThreeState.YES : ThreeState.NO;
        }
        return threeState;
    }

    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        return MysqlBaseTimeZoneManager.INSTANCE;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/mysqlbase/MysqlBaseExecutionEnvironmentHelper$MysqlBaseTimeZoneManager;", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "()V", "canChange", "", "changeTimeZone", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "timeZone", "", "intellij.database.dialects.mysqlbase"})
    public static final class MysqlBaseTimeZoneManager
    implements ExecutionEnvironmentHelper.TimeZoneManager {
        public static final MysqlBaseTimeZoneManager INSTANCE;

        @Override
        public boolean canChange() {
            return true;
        }

        @Override
        public void changeTimeZone(@NotNull DatabaseConnection connection2, @NotNull String timeZone) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            Intrinsics.checkParameterIsNotNull((Object)timeZone, (String)"timeZone");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "set session time_zone = '%s'";
            Object[] objectArray = new Object[]{timeZone};
            BarrenStatement.QuietBarrenStatement<String> quietBarrenStatement = SmartStatements.Companion.poweredBy(connection2).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).barren().quiet();
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            quietBarrenStatement.execute(string3);
        }

        private MysqlBaseTimeZoneManager() {
        }

        static {
            MysqlBaseTimeZoneManager mysqlBaseTimeZoneManager;
            INSTANCE = mysqlBaseTimeZoneManager = new MysqlBaseTimeZoneManager();
        }
    }
}

