/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected OraDialect() {
        super(new TypeHelper.OraTypeHelper(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.ORACLE;
        if (dbms == null) {
            OraDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        if ("Oracle" == null) {
            OraDialect.$$$reportNull$$$0(1);
        }
        return "Oracle";
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            OraDialect.$$$reportNull$$$0(2);
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nvarchar2")) {
            return -9;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nchar")) {
            return -15;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nclob")) {
            return 2011;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).startsWith("timestamp")) {
            return 93;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    @Override
    public boolean supportsSynonymDefinition() {
        return true;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            OraDialect.$$$reportNull$$$0(3);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 1, true);
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsAlterAutoIncrement() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(4);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SYNONYM', '" + element2.getName() + "', '" + DasUtil.getSchema((DasObject)element2) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable table, DatabaseConnection connection2) throws Exception {
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlSynonymDefinition((DasObject)table);
        Dbms dbms = connection2.getDbms();
        String string = DbImplUtil.concatStringResults(connection2, dbms, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            OraDialect.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(7);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('TABLE', '" + element2.getName() + "', '" + DasUtil.getSchema((DasObject)element2) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        if (table == null) {
            OraDialect.$$$reportNull$$$0(9);
        }
        if (connection2 == null) {
            OraDialect.$$$reportNull$$$0(10);
        }
        Dbms dbms = connection2.getDbms();
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection2, dbms, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            OraDialect.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnection connection2) throws Exception {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(12);
        }
        if (connection2 == null) {
            OraDialect.$$$reportNull$$$0(13);
        }
        Dbms dbms = connection2.getDbms();
        Map<String, Object> map2 = DbImplUtil.resultRowAsMap(connection2, String.format("SELECT NUM_ROWS as \"rows\",  TABLESPACE_NAME as \"tablespace\",  LAST_ANALYZED as \"analyzed on\" FROM SYS.all_tables WHERE owner LIKE '%s' ESCAPE '#' AND table_name LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element2), true, dbms), DbImplUtil.escapeSql(element2.getName(), true, dbms)), new String[0]);
        if (map2 == null) {
            OraDialect.$$$reportNull$$$0(14);
        }
        return map2;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            OraDialect.$$$reportNull$$$0(15);
        }
        if (connection2 == null) {
            OraDialect.$$$reportNull$$$0(16);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection2, dbms = connection2.getDbms(), "select sys_context('userenv', 'current_schema') x from dual", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            OraDialect.$$$reportNull$$$0(17);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("alter session set current_schema = %s", this.quoteIdentifier(current.getName(), false, false));
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            OraDialect.$$$reportNull$$$0(18);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                OraDialect.$$$reportNull$$$0(19);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("NUMBER".equals(typeName)) {
            String string = "number" + (precision == 0 && scale == -127 ? "" : "(" + precision + (scale == 0 ? "" : ", " + scale) + ")");
            if (string == null) {
                OraDialect.$$$reportNull$$$0(20);
            }
            return string;
        }
        if ("LONG".equals(typeName) && jdbcType == -1 && precision == 0 && scale == 0) {
            if ("long" == null) {
                OraDialect.$$$reportNull$$$0(21);
            }
            return "long";
        }
        if ("DATE".equals(typeName) && jdbcType == 93 && precision == 7 && scale == 0) {
            if ("date" == null) {
                OraDialect.$$$reportNull$$$0(22);
            }
            return "date";
        }
        if ("ROWID".equals(typeName) && jdbcType == 1111 && precision == 10 && scale == 0) {
            if ("rowid" == null) {
                OraDialect.$$$reportNull$$$0(23);
            }
            return "rowid";
        }
        if ("UROWID".equals(typeName) && jdbcType == 1111 && precision == 4000 && scale == 0) {
            if ("urowid" == null) {
                OraDialect.$$$reportNull$$$0(24);
            }
            return "urowid";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            OraDialect.$$$reportNull$$$0(25);
        }
        return string;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> getSupportedFkUpdate() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class);
        if (valuesCapability == null) {
            OraDialect.$$$reportNull$$$0(26);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> getSupportedFkDelete() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.RuleAction.NO_ACTION, DasForeignKey.RuleAction.SET_NULL, DasForeignKey.RuleAction.CASCADE, DasForeignKey.RuleAction.RESTRICT);
        if (valuesCapability == null) {
            OraDialect.$$$reportNull$$$0(27);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> getSupportedFkDeferrable() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.Deferrability.values());
        if (valuesCapability == null) {
            OraDialect.$$$reportNull$$$0(28);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            OraDialect.$$$reportNull$$$0(29);
        }
        if (sequence == null) {
            OraDialect.$$$reportNull$$$0(30);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, null);
        if (ddlBuilder == null) {
            OraDialect.$$$reportNull$$$0(31);
        }
        return ddlBuilder;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(32);
        }
        Pair pair = Pair.create((Object)OraDialect.getPackageDefinitionQuery(element2, "PACKAGE BODY"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(33);
        }
        return pair;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    private static String getPackageDefinitionQuery(DasObject element2, String type) {
        return "select TEXT FROM SYS.ALL_SOURCE WHERE OWNER = '" + DasUtil.getSchema((DasObject)element2) + "' AND NAME = '" + element2.getName() + "' AND TYPE = '" + type + "' ORDER BY LINE";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(34);
        }
        Pair pair = Pair.create((Object)OraDialect.getPackageDefinitionQuery(element2, "PACKAGE"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(35);
        }
        return pair;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(36);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SEQUENCE', '" + element2.getName() + "', '" + DasUtil.getSchema((DasObject)element2) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(37);
        }
        return pair;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(38);
        }
        return Pair.create((Object)("select TEXT FROM SYS.ALL_VIEWS WHERE OWNER = '" + DasUtil.getSchema((DasObject)element2) + "' AND VIEW_NAME = '" + element2.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(39);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("select TEXT ");
        result2.append("FROM SYS.ALL_SOURCE ");
        result2.append("WHERE OWNER = ");
        result2.append("'");
        result2.append(DasUtil.getSchema((DasObject)element2));
        result2.append("'");
        result2.append(" AND NAME = ");
        result2.append("'");
        result2.append(element2.getName());
        result2.append("'");
        String type = StringUtil.toUpperCase((String)element2.getRoutineKind().name());
        result2.append(" AND TYPE = ");
        result2.append("'");
        result2.append(StringUtil.toUpperCase((String)type));
        result2.append("'");
        result2.append(" ORDER BY LINE");
        Pair pair = Pair.create((Object)result2.toString(), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(40);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            OraDialect.$$$reportNull$$$0(41);
        }
        if (qualifier == null) {
            OraDialect.$$$reportNull$$$0(42);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, pkg, pkgName);
        if (ddlBuilder == null) {
            OraDialect.$$$reportNull$$$0(43);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraDialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 3: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSynonymDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadSynonymDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkUpdate";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDelete";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDeferrable";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageBodyDefinition";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageDefinition";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceDefinition";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlSynonymDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

