/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.oracle.introspector.OraIntroQueries;
import com.intellij.database.dialects.oracle.introspector.OraTypeAndName;
import com.intellij.database.dialects.oracle.introspector.PortionType;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraCatalogObject;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraConstraint;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.dialects.oracle.model.OraViewTrigger;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import gnu.trove.TLongHashSet;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u00d2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u001a\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002\u001a\u0018\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002\u001a\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u0004H\u0002\u001a \u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,2\u0006\u0010$\u001a\u00020%2\u0006\u0010.\u001a\u00020\u0004H\u0002\u001aN\u0010/\u001a\u00020\u00182\u0006\u0010$\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u00106\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u00010\u00042\b\u00108\u001a\u0004\u0018\u00010\u00042\u0006\u00109\u001a\u00020\u0004H\u0002\u001aL\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u0002002\b\u0010=\u001a\u0004\u0018\u00010\u00042\b\u0010>\u001a\u0004\u0018\u00010\u00042\b\u0010?\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010@\u001a\u00020\u00052\b\b\u0002\u0010A\u001a\u00020\u00052\b\b\u0002\u0010B\u001a\u00020\u0007H\u0002\u001a\u001e\u0010C\u001a\u00020\u00182\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010G\u001a\u00020HH\u0002\u001a\u0010\u0010I\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u0004H\u0003\u001a\u0016\u0010K\u001a\u0004\u0018\u00010L*\u00020M2\u0006\u0010J\u001a\u00020\u0004H\u0002\u001a\u0016\u0010N\u001a\u0004\u0018\u00010O*\u00020%2\u0006\u0010J\u001a\u00020\u0004H\u0002\u001a\u0016\u0010P\u001a\u0004\u0018\u00010\"*\u0002002\u0006\u0010Q\u001a\u00020RH\u0002\u001a\u0016\u0010S\u001a\u0004\u0018\u00010T*\u00020%2\u0006\u0010J\u001a\u00020\u0004H\u0002\u001a\u0016\u0010U\u001a\u0004\u0018\u00010V*\u00020%2\u0006\u0010W\u001a\u00020\u0004H\u0002\u001a \u0010X\u001a\u00020\u0018*\u00020-2\b\u0010Y\u001a\u0004\u0018\u00010Z2\b\u0010[\u001a\u0004\u0018\u00010ZH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"AUTO_NOT_NULL_CHECK_PATTERN", "Lkotlin/text/Regex;", "DATA_TYPE_STAR_SIZE", "", "", "", "DELIMITER", "", "EXPLICIT_UNIT_DATA_TYPES", "", "INDEX_EXPRESSION_STUB_PATTERN", "NATIVE_TRIGGER_DEFINITION_PATTERN", "SEQUENCE_SURROGATE_NAME_PATTERN", "SIMPLE_DATA_TYPES", "SIMPLE_QUOTED_NAME_PATTERN", "SRC_NAMES_PORTION_SIZE", "SURROGATE_NAME_PATTERN", "SYSTEM_SCHEMAS", "Ljava/util/TreeSet;", "obfuscationTextPattern", "applicablePortionTypeFor", "Lcom/intellij/database/dialects/oracle/introspector/PortionType;", "n", "applyStoredProgramSources", "", "obj", "Lcom/intellij/database/dialects/oracle/model/OraSourceAware;", "text", "applyViewSources", "view", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "canCheckOutdated", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "dropUnexistentObjectsInSchema", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "identifiers", "Lgnu/trove/TLongHashSet;", "getObjectKindByOracleTypeName", "Lcom/intellij/database/model/ObjectKind;", "oracleTypeName", "majorFamilyOf", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "Lcom/intellij/database/dialects/oracle/model/OraSchemaObject;", "code", "makeArgument", "Lcom/intellij/database/model/basic/BasicSchema;", "routine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "position", "", "argName", "argDirection", "dataTypeSchemaName", "dataTypePackageName", "dataTypeSpec", "makeDataType", "Lcom/intellij/database/model/DataType;", "thisSchema", "typeSchemaName", "typePackageName", "typeSpec", "precision", "scale", "unitsCode", "processSynonyms", "ss", "", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneSynonym;", "root", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "unquoteNameIfPossible", "name", "findModConstraint", "Lcom/intellij/database/dialects/oracle/model/OraConstraint;", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "findModuleByName", "Lcom/intellij/database/dialects/oracle/model/OraModule;", "findOracleObjectByStringTypeAndName", "oracleTypeAndName", "Lcom/intellij/database/dialects/oracle/introspector/OraTypeAndName;", "findTableOrViewByName", "Lcom/intellij/database/dialects/oracle/model/OraLikeTable;", "findTrigger", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "triggerName", "setCreatedAndModifiedTimestamps", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "intellij.database.dialects.oracle"})
@JvmName(name="OraIntrospectorFunctions")
public final class OraIntrospectorFunctions {
    private static final TreeSet<String> SYSTEM_SCHEMAS = SetsKt.sortedSetOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Object[])new String[]{"SYS", "SYSTEM", "CTXSYS"});
    private static final int SRC_NAMES_PORTION_SIZE = 100;
    private static final Set<String> SIMPLE_DATA_TYPES = SetsKt.setOf((Object[])new String[]{"INTEGER", "BINARY_INTEGER", "BINARY_FLOAT", "BINARY_DOUBLE", "DATE", "TIME", "ROWID", "UROWID", "CLOB", "BLOB", "LONG", "LONG RAW", "BFILE"});
    private static final Set<String> EXPLICIT_UNIT_DATA_TYPES = SetsKt.setOf((Object[])new String[]{"CHAR", "VARCHAR", "VARCHAR2"});
    private static final Map<String, Integer> DATA_TYPE_STAR_SIZE = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"NUMBER", (Object)38), TuplesKt.to((Object)"FLOAT", (Object)126)});
    private static final Regex NATIVE_TRIGGER_DEFINITION_PATTERN;
    private static final Regex SIMPLE_QUOTED_NAME_PATTERN;
    private static final Regex AUTO_NOT_NULL_CHECK_PATTERN;
    private static final Regex SURROGATE_NAME_PATTERN;
    private static final Regex INDEX_EXPRESSION_STUB_PATTERN;
    private static final Regex SEQUENCE_SURROGATE_NAME_PATTERN;
    public static final char DELIMITER = '\uffff';
    private static final Regex obfuscationTextPattern;

    private static final PortionType applicablePortionTypeFor(int n) {
        return n <= 1 ? PortionType.ONE : (n <= PortionType.SMALL.getSize() ? PortionType.SMALL : (n <= PortionType.NORMAL.getSize() ? PortionType.NORMAL : PortionType.ALL));
    }

    private static final ModNamingIdentifyingFamily<? extends OraSchemaObject> majorFamilyOf(OraSchema schema, String code) {
        switch (code) {
            case "TA": {
                ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily = schema.getTables();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.tables");
                return modNamingIdentifyingFamily;
            }
            case "CL": {
                ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily = schema.getClusters();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.clusters");
                return modNamingIdentifyingFamily;
            }
            case "VI": {
                ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily = schema.getViews();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.views");
                return modNamingIdentifyingFamily;
            }
            case "SY": {
                ModNamingIdentifyingFamily<? extends OraSynonym> modNamingIdentifyingFamily = schema.getSynonyms();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.synonyms");
                return modNamingIdentifyingFamily;
            }
            case "SE": {
                ModNamingIdentifyingFamily<? extends OraSequence> modNamingIdentifyingFamily = schema.getSequences();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.sequences");
                return modNamingIdentifyingFamily;
            }
            case "PR": {
                ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.routines");
                return modNamingIdentifyingFamily;
            }
            case "FU": {
                ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.routines");
                return modNamingIdentifyingFamily;
            }
            case "PA": {
                ModNamingIdentifyingFamily<? extends OraPackage> modNamingIdentifyingFamily = schema.getPackages();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.packages");
                return modNamingIdentifyingFamily;
            }
            case "MA": {
                ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily = schema.getMatViews();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.matViews");
                return modNamingIdentifyingFamily;
            }
            case "YB": {
                ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily = schema.getObjectTypes();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.objectTypes");
                return modNamingIdentifyingFamily;
            }
            case "YC": {
                ModNamingIdentifyingFamily<? extends OraCollectionType> modNamingIdentifyingFamily = schema.getCollectionTypes();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.collectionTypes");
                return modNamingIdentifyingFamily;
            }
        }
        throw (Throwable)new IllegalArgumentException("Unknown object code: " + code);
    }

    private static final void processSynonyms(List<OraIntroQueries.OneSynonym> ss, OraRoot root2) {
        Set affectedSchemas = new HashSet();
        for (OraIntroQueries.OneSynonym s : ss) {
            OraSchema schema;
            OraSynonym synonym2;
            if ((OraSchema)root2.getSchemas().get(s.synonym_schema_name) == null) {
                continue;
            }
            OraSynonym oraSynonym = synonym2 = schema.getSynonyms().renew(s.synonym_id, s.synonym_name);
            Intrinsics.checkExpressionValueIsNotNull((Object)oraSynonym, (String)"synonym");
            oraSynonym.setCreatedTimestamp(s.created_timestamp);
            synonym2.setModifiedTimestamp(s.modified_timestamp);
            synonym2.setTargetSchemaName(s.origin_schema_name);
            synonym2.setTargetObjectName(s.origin_object_name);
            affectedSchemas.add(schema);
        }
        for (OraSchema schema : affectedSchemas) {
            schema.getSynonyms().sort();
        }
    }

    private static final void dropUnexistentObjectsInSchema(OraSchema schema, TLongHashSet identifiers) {
        ModNamingIdentifyingFamily<? extends OraSequence> modNamingIdentifyingFamily = schema.getSequences();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.sequences");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily, identifiers);
        ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily2 = schema.getClusters();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.clusters");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily2, identifiers);
        ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily3 = schema.getTables();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily3, (String)"schema.tables");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily3, identifiers);
        ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily4 = schema.getMatViews();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily4, (String)"schema.matViews");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily4, identifiers);
        ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily5 = schema.getViews();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily5, (String)"schema.views");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily5, identifiers);
        ModNamingIdentifyingFamily<? extends OraPackage> modNamingIdentifyingFamily6 = schema.getPackages();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily6, (String)"schema.packages");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily6, identifiers);
        ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily7 = schema.getObjectTypes();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily7, (String)"schema.objectTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily7, identifiers);
        ModNamingIdentifyingFamily<? extends OraCollectionType> modNamingIdentifyingFamily8 = schema.getCollectionTypes();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily8, (String)"schema.collectionTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily8, identifiers);
        ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily9 = schema.getRoutines();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily9, (String)"schema.routines");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily9, identifiers);
        ModNamingIdentifyingFamily<? extends OraSynonym> modNamingIdentifyingFamily10 = schema.getSynonyms();
        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily10, (String)"schema.synonyms");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily10, identifiers);
        Iterator iterator = schema.getClusters().iterator();
        while (iterator.hasNext()) {
            OraCluster oraCluster;
            OraCluster oraCluster2 = oraCluster = (OraCluster)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraCluster2, (String)"cluster");
            ModSingletonFamily<? extends OraClusterIndex> modSingletonFamily = oraCluster2.getIndices();
            Intrinsics.checkExpressionValueIsNotNull(modSingletonFamily, (String)"cluster.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, identifiers);
        }
        iterator = schema.getTables().iterator();
        while (iterator.hasNext()) {
            OraTable oraTable;
            OraTable oraTable2 = oraTable = (OraTable)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraTable2, (String)"table");
            Family family = oraTable2.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"table.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)family), identifiers);
            ModNamingIdentifyingFamily<? extends OraTableTrigger> modNamingIdentifyingFamily11 = oraTable.getTriggers();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily11, (String)"table.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily11, identifiers);
        }
        for (OraMatView oraMatView : schema.getMatViews()) {
        }
        iterator = schema.getViews().iterator();
        while (iterator.hasNext()) {
            OraView oraView;
            OraView oraView2 = oraView = (OraView)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraView2, (String)"view");
            ModNamingIdentifyingFamily<? extends OraViewTrigger> modNamingIdentifyingFamily12 = oraView2.getTriggers();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily12, (String)"view.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily12, identifiers);
        }
        iterator = schema.getPackages().iterator();
        while (iterator.hasNext()) {
            OraPackage oraPackage;
            OraPackage oraPackage2 = oraPackage = (OraPackage)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraPackage2, (String)"pack");
            ModSingletonFamily<? extends OraPackageBody> modSingletonFamily = oraPackage2.getBodies();
            Intrinsics.checkExpressionValueIsNotNull(modSingletonFamily, (String)"pack.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, identifiers);
        }
        iterator = schema.getObjectTypes().iterator();
        while (iterator.hasNext()) {
            OraObjectType oraObjectType;
            OraObjectType oraObjectType2 = oraObjectType = (OraObjectType)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraObjectType2, (String)"ot");
            ModSingletonFamily<? extends OraObjectTypeBody> modSingletonFamily = oraObjectType2.getBodies();
            Intrinsics.checkExpressionValueIsNotNull(modSingletonFamily, (String)"ot.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, identifiers);
        }
    }

    private static final void setCreatedAndModifiedTimestamps(@NotNull OraSchemaObject $this$setCreatedAndModifiedTimestamps, Date createdTimestamp, Date modifiedTimestamp) {
        $this$setCreatedAndModifiedTimestamps.setCreatedTimestamp(createdTimestamp);
        $this$setCreatedAndModifiedTimestamps.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final OraLikeTable findTableOrViewByName(@NotNull OraSchema $this$findTableOrViewByName, String name2) {
        OraLikeTable oraLikeTable;
        OraLikeTable oraLikeTable2 = (OraLikeTable)$this$findTableOrViewByName.getTables().get(name2);
        if (oraLikeTable2 == null) {
            oraLikeTable2 = oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getMatViews().get(name2);
        }
        if (oraLikeTable2 == null) {
            oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getViews().get(name2);
        }
        return oraLikeTable;
    }

    private static final OraModule findModuleByName(@NotNull OraSchema $this$findModuleByName, String name2) {
        OraModule oraModule = (OraModule)$this$findModuleByName.getObjectTypes().get(name2);
        if (oraModule == null) {
            oraModule = (OraModule)$this$findModuleByName.getPackages().get(name2);
        }
        return oraModule;
    }

    private static final OraConstraint findModConstraint(@NotNull OraTable $this$findModConstraint, String name2) {
        OraConstraint oraConstraint;
        OraConstraint oraConstraint2 = (OraConstraint)$this$findModConstraint.getKeys().get(name2);
        if (oraConstraint2 == null) {
            oraConstraint2 = oraConstraint = (OraConstraint)$this$findModConstraint.getForeignKeys().get(name2);
        }
        if (oraConstraint2 == null) {
            oraConstraint = (OraConstraint)$this$findModConstraint.getChecks().get(name2);
        }
        return oraConstraint;
    }

    private static final OraTrigger findTrigger(@NotNull OraSchema $this$findTrigger, String triggerName) {
        OraTrigger trigger = null;
        Iterator iterator = $this$findTrigger.getTables().iterator();
        while (iterator.hasNext()) {
            OraTable oraTable;
            OraTable oraTable2 = oraTable = (OraTable)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraTable2, (String)"table");
            trigger = (OraTrigger)oraTable2.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        iterator = $this$findTrigger.getViews().iterator();
        while (iterator.hasNext()) {
            OraView oraView;
            OraView oraView2 = oraView = (OraView)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraView2, (String)"view");
            trigger = (OraTrigger)oraView2.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        iterator = $this$findTrigger.getMatViews().iterator();
        while (iterator.hasNext()) {
            OraMatView oraMatView;
            OraMatView oraMatView2 = oraMatView = (OraMatView)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraMatView2, (String)"view");
            trigger = (OraTrigger)oraMatView2.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        return null;
    }

    @Contract(pure=true)
    private static final String unquoteNameIfPossible(String name2) {
        Object object = SIMPLE_QUOTED_NAME_PATTERN.matchEntire((CharSequence)name2);
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            object = name2;
        }
        return object;
    }

    private static final void makeArgument(BasicSchema schema, OraRoutine routine, short position, String argName, char argDirection, String dataTypeSchemaName, String dataTypePackageName, String dataTypeSpec) {
        ArgumentDirection dir = ArgumentDirection.of((char)argDirection);
        if (dir == null && argName != null) {
            dir = ArgumentDirection.IN;
        }
        if (dir == null) {
            dir = ArgumentDirection.IN;
        }
        OraArgument argument = null;
        if (dir == ArgumentDirection.RETURN) {
            BasicModArgument basicModArgument = routine.createOrGetReturnArgument();
            if (basicModArgument == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraArgument");
            }
            argument = (OraArgument)basicModArgument;
            argument.setRealName(argName);
        } else if (argName != null) {
            Object e = routine.getArguments().createOrGet(argName);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"routine.arguments.createOrGet(argName)");
            argument = (OraArgument)e;
            argument.setPosition(position);
            argument.setArgumentDirection(dir);
        } else {
            return;
        }
        DataType dataType = OraIntrospectorFunctions.makeDataType$default(schema, dataTypeSchemaName, dataTypePackageName, dataTypeSpec, 0, 0, '\u0000', 112, null);
        argument.setDataType(dataType);
    }

    private static final DataType makeDataType(BasicSchema thisSchema, String typeSchemaName, String typePackageName, String typeSpec, int precision, int scale, char unitsCode) {
        String spec = typeSpec;
        if (spec != null && spec.length() > 7 && StringsKt.startsWith$default((String)spec, (String)"PL/SQL ", (boolean)false, (int)2, null)) {
            String string = spec;
            int n = 7;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            spec = string2;
        }
        DataType type = null;
        if (spec == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            type = dataType;
        } else if (StringsKt.contains$default((CharSequence)spec, (CharSequence)"(", (boolean)false, (int)2, null)) {
            DataType dataType = DataTypeFactory.of(spec);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(spec)");
            type = dataType;
        } else {
            DataType dataType;
            int p2;
            LengthUnit units;
            boolean customType = typeSchemaName != null;
            boolean simple = SIMPLE_DATA_TYPES.contains(spec) && !customType;
            boolean explicitUnits = EXPLICIT_UNIT_DATA_TYPES.contains(spec) && unitsCode == 'C' && !customType;
            switch (unitsCode) {
                case 'B': {
                    LengthUnit lengthUnit = LengthUnit.BYTE;
                    break;
                }
                case 'C': {
                    LengthUnit lengthUnit = LengthUnit.CHAR;
                    break;
                }
                case 'D': {
                    LengthUnit lengthUnit = LengthUnit.DIGIT;
                    break;
                }
                default: {
                    LengthUnit lengthUnit = units = null;
                }
            }
            String explicitSchemaName = customType ? (Intrinsics.areEqual((Object)thisSchema.getRealName(), (Object)typeSchemaName) || Intrinsics.areEqual((Object)typeSchemaName, (Object)"PUBLIC") ? null : typeSchemaName) : null;
            Integer starSize = DATA_TYPE_STAR_SIZE.get(spec);
            int n = p2 = starSize != null && precision == starSize ? 0x7FFFFFFE : precision;
            if (customType) {
                DataType dataType2 = DataTypeFactory.of(explicitSchemaName, typePackageName, spec, -1, 0, null, null, false, true);
                dataType = dataType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"DataTypeFactory.of(expli\u2026 null, null, false, true)");
            } else {
                DataType dataType3 = simple ? DataTypeFactory.of(null, typePackageName, spec, -1, -1, units, null, false, false) : DataTypeFactory.of(null, typePackageName, spec, p2, scale, units, null, explicitUnits, false);
                dataType = dataType3;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"if (simple)\n          Da\u2026ll, explicitUnits, false)");
            }
            type = dataType;
        }
        return type;
    }

    static /* synthetic */ DataType makeDataType$default(BasicSchema basicSchema, String string, String string2, String string3, int n, int n2, char c2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n = -1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            c2 = '\u0000';
        }
        return OraIntrospectorFunctions.makeDataType(basicSchema, string, string2, string3, n, n2, c2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void applyStoredProgramSources(OraSourceAware obj2, String text2) {
        if (text2 != null) {
            CharSequence charSequence = text2;
            boolean bl = false;
            if (charSequence.length() > 0) {
                obj2.setSourceText(new SimpleCompositeText("CREATE ", CompositeText.Kind.PLAIN_TEXT, text2, CompositeText.Kind.ORIGINAL_TEXT));
                return;
            }
        }
        obj2.setSourceText(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void applyViewSources(BasicModSourceAware view2, String text2) {
        if (text2 != null) {
            CharSequence charSequence = text2;
            boolean bl = false;
            if (charSequence.length() > 0) {
                view2.setSourceText(new SimpleCompositeText(text2, CompositeText.Kind.ORIGINAL_TEXT));
                return;
            }
        }
        view2.setSourceText(null);
    }

    private static final boolean canCheckOutdated(BasicElement e) {
        return e == null || e instanceof OraCatalogObject && !(e instanceof OraSchema) && ((OraCatalogObject)e).getObjectId() != Long.MIN_VALUE && ((OraCatalogObject)e).getModifiedTimestamp() != null;
    }

    private static final BasicElement findOracleObjectByStringTypeAndName(@NotNull BasicSchema $this$findOracleObjectByStringTypeAndName, OraTypeAndName oracleTypeAndName) {
        String string = oracleTypeAndName.getType();
        if (string == null) {
            return null;
        }
        String objectTypeName = string;
        ObjectKind objectKind = OraIntrospectorFunctions.getObjectKindByOracleTypeName(objectTypeName);
        if (objectKind == null) {
            return null;
        }
        ObjectKind objectKind2 = objectKind;
        String string2 = oracleTypeAndName.getName();
        if (string2 == null) {
            return null;
        }
        String objectName = string2;
        ObjectKind objectKind3 = objectKind2;
        if (Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.OBJECT_TYPE)) {
            BasicElement o;
            Family<? extends BasicElement> family1 = $this$findOracleObjectByStringTypeAndName.familyOf(ObjectKind.OBJECT_TYPE);
            Family<? extends BasicElement> family = family1;
            if (!(family instanceof NamingFamily)) {
                family = null;
            }
            NamingFamily namingFamily = (NamingFamily)family;
            BasicElement basicElement = o = namingFamily != null ? (BasicElement)namingFamily.get(objectName) : null;
            if (o == null) {
                Family<? extends BasicElement> family2 = $this$findOracleObjectByStringTypeAndName.familyOf(ObjectKind.COLLECTION_TYPE);
                Family<? extends BasicElement> family3 = family2;
                if (!(family3 instanceof NamingFamily)) {
                    family3 = null;
                }
                NamingFamily namingFamily2 = (NamingFamily)family3;
                o = namingFamily2 != null ? (BasicElement)namingFamily2.get(objectName) : null;
            }
            return o;
        }
        if (Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.BODY)) {
            BasicNode basicNode;
            ObjectKind objectKind4;
            switch (objectTypeName.charAt(0)) {
                case 'P': {
                    objectKind4 = ObjectKind.PACKAGE;
                    break;
                }
                case 'T': {
                    objectKind4 = ObjectKind.OBJECT_TYPE;
                    break;
                }
                default: {
                    return null;
                }
            }
            ObjectKind parentKind = objectKind4;
            Family<? extends BasicElement> family = $this$findOracleObjectByStringTypeAndName.familyOf(parentKind);
            if (family == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull(family, (String)"this.familyOf(parentKind) ?: return null");
            Family<? extends BasicElement> parentFamily = family;
            Family<? extends BasicElement> family4 = parentFamily;
            if (!(family4 instanceof NamingFamily)) {
                family4 = null;
            }
            if ((basicNode = (NamingFamily)family4) == null || (basicNode = (BasicElement)basicNode.get(objectName)) == null) {
                return null;
            }
            BasicNode parent2 = basicNode;
            Family<? extends BasicElement> family5 = parent2.familyOf(ObjectKind.BODY);
            return family5 != null ? (BasicElement)CollectionsKt.firstOrNull((Iterable)family5) : null;
        }
        Family<? extends BasicElement> family = $this$findOracleObjectByStringTypeAndName.familyOf(objectKind2);
        if (family == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(family, (String)"this.familyOf(objectKind) ?: return null");
        Family<? extends BasicElement> family6 = family;
        return family6 instanceof NamingFamily ? (BasicElement)((NamingFamily)family6).get(objectName) : null;
    }

    private static final ObjectKind getObjectKindByOracleTypeName(String oracleTypeName) {
        ObjectKind objectKind;
        switch (oracleTypeName) {
            case "INDEX": {
                objectKind = ObjectKind.INDEX;
                break;
            }
            case "TABLE": {
                objectKind = ObjectKind.TABLE;
                break;
            }
            case "CLUSTER": {
                objectKind = ObjectKind.CLUSTER;
                break;
            }
            case "VIEW": {
                objectKind = ObjectKind.VIEW;
                break;
            }
            case "SYNONYM": {
                objectKind = ObjectKind.SYNONYM;
                break;
            }
            case "SEQUENCE": {
                objectKind = ObjectKind.SEQUENCE;
                break;
            }
            case "PROCEDURE": {
                objectKind = ObjectKind.ROUTINE;
                break;
            }
            case "FUNCTION": {
                objectKind = ObjectKind.ROUTINE;
                break;
            }
            case "PACKAGE": {
                objectKind = ObjectKind.PACKAGE;
                break;
            }
            case "PACKAGE BODY": {
                objectKind = ObjectKind.BODY;
                break;
            }
            case "TRIGGER": {
                objectKind = ObjectKind.TRIGGER;
                break;
            }
            case "TYPE": {
                objectKind = ObjectKind.OBJECT_TYPE;
                break;
            }
            case "TYPE BODY": {
                objectKind = ObjectKind.BODY;
                break;
            }
            case "MATERIALIZED VIEW": {
                objectKind = ObjectKind.MAT_VIEW;
                break;
            }
            default: {
                objectKind = null;
            }
        }
        return objectKind;
    }

    static {
        String string = "(?s)^CREATE(\\s*OR\\s*REPLACE)?(\\s*[EN][A-Z]+)?\\s+TRIGGER.+$";
        boolean bl = false;
        NATIVE_TRIGGER_DEFINITION_PATTERN = new Regex(string);
        string = "^\\s*\"([^\"]*)\"\\s*$";
        bl = false;
        SIMPLE_QUOTED_NAME_PATTERN = new Regex(string);
        string = "\".+\" IS NOT NULL";
        bl = false;
        AUTO_NOT_NULL_CHECK_PATTERN = new Regex(string);
        string = "^SYS_\\w*\\d+\\$*$";
        bl = false;
        SURROGATE_NAME_PATTERN = new Regex(string);
        string = "^SYS_NC\\d+.$";
        bl = false;
        INDEX_EXPRESSION_STUB_PATTERN = new Regex(string);
        string = "^ISEQ\\$+_\\d+$";
        bl = false;
        SEQUENCE_SURROGATE_NAME_PATTERN = new Regex(string);
        obfuscationTextPattern = new Regex("^[^\\n]*wrapped\\s*\\n", RegexOption.DOT_MATCHES_ALL);
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(BasicElement e) {
        return OraIntrospectorFunctions.canCheckOutdated(e);
    }

    public static final /* synthetic */ PortionType access$applicablePortionTypeFor(int n) {
        return OraIntrospectorFunctions.applicablePortionTypeFor(n);
    }

    public static final /* synthetic */ Regex access$getNATIVE_TRIGGER_DEFINITION_PATTERN$p() {
        return NATIVE_TRIGGER_DEFINITION_PATTERN;
    }

    public static final /* synthetic */ void access$processSynonyms(List ss, OraRoot root2) {
        OraIntrospectorFunctions.processSynonyms(ss, root2);
    }

    public static final /* synthetic */ void access$dropUnexistentObjectsInSchema(OraSchema schema, TLongHashSet identifiers) {
        OraIntrospectorFunctions.dropUnexistentObjectsInSchema(schema, identifiers);
    }

    public static final /* synthetic */ TreeSet access$getSYSTEM_SCHEMAS$p() {
        return SYSTEM_SCHEMAS;
    }

    public static final /* synthetic */ Regex access$getSEQUENCE_SURROGATE_NAME_PATTERN$p() {
        return SEQUENCE_SURROGATE_NAME_PATTERN;
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(OraSchemaObject $this$access_u24setCreatedAndModifiedTimestamps, Date createdTimestamp, Date modifiedTimestamp) {
        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps($this$access_u24setCreatedAndModifiedTimestamps, createdTimestamp, modifiedTimestamp);
    }

    public static final /* synthetic */ DataType access$makeDataType(BasicSchema thisSchema, String typeSchemaName, String typePackageName, String typeSpec, int precision, int scale, char unitsCode) {
        return OraIntrospectorFunctions.makeDataType(thisSchema, typeSchemaName, typePackageName, typeSpec, precision, scale, unitsCode);
    }

    public static final /* synthetic */ Regex access$getSURROGATE_NAME_PATTERN$p() {
        return SURROGATE_NAME_PATTERN;
    }

    public static final /* synthetic */ Regex access$getINDEX_EXPRESSION_STUB_PATTERN$p() {
        return INDEX_EXPRESSION_STUB_PATTERN;
    }

    public static final /* synthetic */ String access$unquoteNameIfPossible(String name2) {
        return OraIntrospectorFunctions.unquoteNameIfPossible(name2);
    }

    public static final /* synthetic */ Regex access$getAUTO_NOT_NULL_CHECK_PATTERN$p() {
        return AUTO_NOT_NULL_CHECK_PATTERN;
    }

    public static final /* synthetic */ OraConstraint access$findModConstraint(OraTable $this$access_u24findModConstraint, String name2) {
        return OraIntrospectorFunctions.findModConstraint($this$access_u24findModConstraint, name2);
    }

    public static final /* synthetic */ OraLikeTable access$findTableOrViewByName(OraSchema $this$access_u24findTableOrViewByName, String name2) {
        return OraIntrospectorFunctions.findTableOrViewByName($this$access_u24findTableOrViewByName, name2);
    }

    public static final /* synthetic */ OraModule access$findModuleByName(OraSchema $this$access_u24findModuleByName, String name2) {
        return OraIntrospectorFunctions.findModuleByName($this$access_u24findModuleByName, name2);
    }

    public static final /* synthetic */ void access$makeArgument(BasicSchema schema, OraRoutine routine, short position, String argName, char argDirection, String dataTypeSchemaName, String dataTypePackageName, String dataTypeSpec) {
        OraIntrospectorFunctions.makeArgument(schema, routine, position, argName, argDirection, dataTypeSchemaName, dataTypePackageName, dataTypeSpec);
    }

    public static final /* synthetic */ BasicElement access$findOracleObjectByStringTypeAndName(BasicSchema $this$access_u24findOracleObjectByStringTypeAndName, OraTypeAndName oracleTypeAndName) {
        return OraIntrospectorFunctions.findOracleObjectByStringTypeAndName($this$access_u24findOracleObjectByStringTypeAndName, oracleTypeAndName);
    }

    public static final /* synthetic */ void access$applyViewSources(BasicModSourceAware view2, String text2) {
        OraIntrospectorFunctions.applyViewSources(view2, text2);
    }

    public static final /* synthetic */ void access$applyStoredProgramSources(OraSourceAware obj2, String text2) {
        OraIntrospectorFunctions.applyStoredProgramSources(obj2, text2);
    }

    public static final /* synthetic */ Regex access$getObfuscationTextPattern$p() {
        return obfuscationTextPattern;
    }

    public static final /* synthetic */ OraTrigger access$findTrigger(OraSchema $this$access_u24findTrigger, String triggerName) {
        return OraIntrospectorFunctions.findTrigger($this$access_u24findTrigger, triggerName);
    }

    public static final /* synthetic */ ModNamingIdentifyingFamily access$majorFamilyOf(OraSchema schema, String code) {
        return OraIntrospectorFunctions.majorFamilyOf(schema, code);
    }
}

