/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgAccessMethod;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgCollation;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgForeignDataWrapper;
import com.intellij.database.dialects.postgres.model.PgForeignServer;
import com.intellij.database.dialects.postgres.model.PgModelFun;
import com.intellij.database.dialects.postgres.model.PgModelHelper;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.PgUserMapping;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseAggregate;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumDescriptionService;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.PgAccessMethodType;
import com.intellij.database.model.properties.PgDataTypeSubCategory;
import com.intellij.database.model.properties.PgRoutineConcurrencyKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001B\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0014J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u0005H\u0014J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0003H\u0014R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"Lcom/intellij/database/dialects/postgres/model/PgDescriptionService;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumDescriptionService;", "Lcom/intellij/database/dialects/postgres/model/PgRoutine;", "Lcom/intellij/database/dialects/postgres/model/PgDefType;", "Lcom/intellij/database/dialects/postgres/model/PgTrigger;", "Lcom/intellij/database/dialects/postgres/model/PgRole;", "Lcom/intellij/database/dialects/postgres/model/PgAggregate;", "()V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "PgOptions", "", "", "options", "collectAggregateAttributes", "aggregate", "collectRoleAttributes", "role", "collectRoutineAttributes", "routine", "content", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describePgAccessMethod", "method", "Lcom/intellij/database/dialects/postgres/model/PgAccessMethod;", "describePgCollation", "collation", "Lcom/intellij/database/dialects/postgres/model/PgCollation;", "describePgForeignDataWrapper", "wrapper", "Lcom/intellij/database/dialects/postgres/model/PgForeignDataWrapper;", "describePgForeignServer", "server", "Lcom/intellij/database/dialects/postgres/model/PgForeignServer;", "describePgUserMapping", "mapping", "Lcom/intellij/database/dialects/postgres/model/PgUserMapping;", "getTypeCategory", "dt", "intellij.database.dialects.postgres"})
public final class PgDescriptionService
extends PgGPlumDescriptionService<PgRoutine, PgDefType, PgTrigger, PgRole, PgAggregate> {
    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        PgModelHelper pgModelHelper = PgModelHelper.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)pgModelHelper, (String)"PgModelHelper.INSTANCE");
        return pgModelHelper;
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof PgCollation ? this.describePgCollation((PgCollation)e) : (basicElement instanceof PgForeignDataWrapper ? this.describePgForeignDataWrapper((PgForeignDataWrapper)e) : (basicElement instanceof PgForeignServer ? this.describePgForeignServer((PgForeignServer)e) : (basicElement instanceof PgUserMapping ? this.describePgUserMapping((PgUserMapping)e) : (basicElement instanceof PgAccessMethod ? this.describePgAccessMethod((PgAccessMethod)e) : super.content(e, context)))));
    }

    @Override
    @NotNull
    protected List<String> collectRoutineAttributes(@NotNull PgRoutine routine) {
        Intrinsics.checkParameterIsNotNull((Object)routine, (String)"routine");
        ArrayList<String> attributes2 = new ArrayList<String>();
        PgRoutineConcurrencyKind pgRoutineConcurrencyKind = routine.getConcurrencyKind();
        boolean bl = false;
        boolean bl2 = false;
        PgRoutineConcurrencyKind it2 = pgRoutineConcurrencyKind;
        boolean bl3 = false;
        if (it2 != PgRoutineConcurrencyKind.UNSAFE) {
            StringBuilder stringBuilder = new StringBuilder().append("parallel ");
            PgRoutineConcurrencyKind pgRoutineConcurrencyKind2 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pgRoutineConcurrencyKind2), (String)"it");
            attributes2.add(stringBuilder.append(pgRoutineConcurrencyKind2.getModifier()).toString());
        }
        if (routine.isWindow()) {
            attributes2.add("window");
        }
        if (PgModelFun.isRowsDefined(routine)) {
            attributes2.add("rows " + PgModelFun.rowsAsString(routine));
        }
        return CollectionsKt.plus((Collection)super.collectRoutineAttributes((PgGPlumBaseRoutine)routine), (Iterable)attributes2);
    }

    @Override
    @NotNull
    protected String getTypeCategory(@NotNull PgDefType dt) {
        Intrinsics.checkParameterIsNotNull((Object)dt, (String)"dt");
        String category = super.getTypeCategory((PgGPlumBaseDefType)dt);
        PgDataTypeSubCategory pgDataTypeSubCategory = dt.getSubCategory();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pgDataTypeSubCategory), (String)"dt.subCategory");
        PgDataTypeSubCategory sc = pgDataTypeSubCategory;
        if (sc != PgDataTypeSubCategory.NONE && Intrinsics.areEqual((Object)sc.human_readable_name(), (Object)category) ^ true) {
            return category + " (" + sc.human_readable_name() + ')';
        }
        return category;
    }

    private final String describePgCollation(PgCollation collation) {
        return "lc_collate: " + collation.getCollate() + ", lc_ctype: " + collation.getCType();
    }

    @Override
    @NotNull
    protected List<String> collectRoleAttributes(@NotNull PgRole role) {
        boolean bl;
        String string;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        ArrayList attributes2 = new ArrayList();
        if (role.isReplication()) {
            collection = attributes2;
            string = " replication";
            bl = false;
            collection.add(string);
        }
        if (role.isBypassRls()) {
            collection = attributes2;
            string = " bypassrls";
            bl = false;
            collection.add(string);
        }
        return CollectionsKt.plus((Collection)super.collectRoleAttributes((PgGPlumBaseRole)role), (Iterable)attributes2);
    }

    private final String describePgForeignDataWrapper(PgForeignDataWrapper wrapper) {
        List attributes2 = new ArrayList();
        if (wrapper.getValidator() != null) {
            attributes2.add("validator: " + wrapper.getValidator());
        }
        if (wrapper.getHandler() != null) {
            attributes2.add("handler: " + wrapper.getHandler());
        }
        List<String> list = wrapper.getOptions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"wrapper.options");
        attributes2.addAll((Collection)this.PgOptions(list));
        String string = "foreign data wrapper " + CollectionsKt.joinToString$default((Iterable)attributes2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String describePgForeignServer(PgForeignServer server) {
        List attributes2 = new ArrayList();
        if (server.getType() != null) {
            attributes2.add("type: " + server.getType());
        }
        if (server.getVersion() != null) {
            attributes2.add("version: " + server.getVersion());
        }
        List<String> list = server.getOptions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"server.options");
        attributes2.addAll((Collection)this.PgOptions(list));
        String string = "foreign server " + CollectionsKt.joinToString$default((Iterable)attributes2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String describePgAccessMethod(PgAccessMethod method) {
        List attributes2 = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder().append("type: ");
        PgAccessMethodType pgAccessMethodType = method.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pgAccessMethodType), (String)"method.type");
        attributes2.add(stringBuilder.append(pgAccessMethodType.getModifier()).toString());
        if (method.getHandler() != null) {
            attributes2.add("handler: " + method.getHandler());
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String describePgUserMapping(PgUserMapping mapping) {
        List attributes2 = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder().append("user: ");
        String string = mapping.getUser();
        if (string == null) {
            string = "public";
        }
        attributes2.add(stringBuilder.append(string).toString());
        List<String> list = mapping.getOptions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"mapping.options");
        attributes2.addAll((Collection)this.PgOptions(list));
        String string2 = "user mapping " + CollectionsKt.joinToString$default((Iterable)attributes2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @Override
    @NotNull
    protected List<String> collectAggregateAttributes(@NotNull PgAggregate aggregate) {
        boolean bl;
        String string;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)aggregate, (String)"aggregate");
        ArrayList attributes2 = new ArrayList();
        if (aggregate.isFinalExtra()) {
            collection = attributes2;
            string = "final extra arguments";
            bl = false;
            collection.add(string);
        }
        if (aggregate.getCombine() != null) {
            collection = attributes2;
            string = "combine function: " + aggregate.getCombine();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getSerialization() != null) {
            collection = attributes2;
            string = "serialization function: " + aggregate.getSerialization();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getDeserialization() != null) {
            collection = attributes2;
            string = "deserialization function: " + aggregate.getDeserialization();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getStateSize() != 0L) {
            collection = attributes2;
            string = "state size: " + aggregate.getStateSize();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getInverseTransition() != null) {
            collection = attributes2;
            string = "inverse transition: " + aggregate.getInverseTransition();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getMovingTransition() != null) {
            collection = attributes2;
            string = "moving transition: " + aggregate.getMovingTransition();
            bl = false;
            collection.add(string);
        }
        if (Intrinsics.areEqual((Object)aggregate.getMovingStateType(), (Object)DataType.UNKNOWN) ^ true) {
            collection = attributes2;
            string = "moving state type: " + aggregate.getMovingStateType();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getMovingStateSize() != 0L) {
            collection = attributes2;
            string = "moving state size: " + aggregate.getMovingStateSize();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getMovingFinal() != null) {
            collection = attributes2;
            string = "moving final function: " + aggregate.getMovingFinal();
            bl = false;
            collection.add(string);
        }
        if (aggregate.isMovingFinalExtra()) {
            collection = attributes2;
            string = "moving final extra arguments";
            bl = false;
            collection.add(string);
        }
        if (aggregate.getMovingInitialValue() != null) {
            collection = attributes2;
            string = "moving initial value: " + aggregate.getMovingInitialValue();
            bl = false;
            collection.add(string);
        }
        if (aggregate.getConcurrencyKind() != PgRoutineConcurrencyKind.UNSAFE) {
            collection = attributes2;
            StringBuilder stringBuilder = new StringBuilder().append("concurrency kind: ");
            PgRoutineConcurrencyKind pgRoutineConcurrencyKind = aggregate.getConcurrencyKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pgRoutineConcurrencyKind), (String)"aggregate.concurrencyKind");
            string = stringBuilder.append(pgRoutineConcurrencyKind.getModifier()).toString();
            bl = false;
            collection.add(string);
        }
        return CollectionsKt.plus((Collection)super.collectAggregateAttributes((PgGPlumBaseAggregate)aggregate), (Iterable)attributes2);
    }

    private final List<String> PgOptions(List<String> options) {
        Object object;
        List it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = options;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = StringsKt.split$default((CharSequence)((CharSequence)((Object)it2)), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = (String)CollectionsKt.first((List)it2) + " '" + (String)CollectionsKt.last((List)it2) + '\'';
            collection.add(object);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }
}

