/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.postgresbase.PgBaseObjectBuilder;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseObjectBuilder;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseAggregate;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseExtension;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLocalTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRule;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTrigger;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.PgAggregateKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.psi.PgCreateAggregateStatementImpl;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateSequenceStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateUserStatementImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0004J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0004J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\f\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\f\u001a\u00020\u001cH\u0004J\u0019\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\f\u001a\u0004\u0018\u00010\u001cH\u0004\u00a2\u0006\u0002\u0010&J\u001a\u0010'\u001a\u0004\u0018\u00010#2\u0006\u0010\f\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u0004\u0018\u00010#*\u0004\u0018\u00010+H\u0004R*\u0010\u0003\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseObjectBuilder;", "Lcom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder;", "()V", "triggerRoutines", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;", "kotlin.jvm.PlatformType", "", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildAggregate", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseAggregate;", "buildExtension", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseExtension;", "buildRole", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;", "buildRoutine", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "buildRule", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRule;", "buildSequence", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSequence;", "buildSequenceIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "Lcom/intellij/psi/PsiElement;", "buildTrigger", "buildTypedType", "Lcom/intellij/database/model/basic/BasicModTypedElement;", "finalize", "finalizeTrigger", "findFunctionReference", "Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseObjectBuilder$Reference;", "findNumber", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Long;", "findReference", "type", "Lcom/intellij/sql/psi/SqlReferenceElementType;", "asReferenceData", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "Reference", "intellij.database.dialects.postgresgreenplumbase"})
public abstract class PgGPlumBaseObjectBuilder
extends PgBaseObjectBuilder {
    private final ConcurrentMap<PgGPlumBaseTrigger, String> triggerRoutines;

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof PgGPlumBaseRoutine) {
            this.buildRoutine((PgGPlumBaseRoutine)obj2, source);
        } else if (basicModElement instanceof PgGPlumBaseSequence) {
            this.buildSequence((PgGPlumBaseSequence)obj2, source);
        } else if (basicModElement instanceof PgGPlumBaseRole) {
            this.buildRole((PgGPlumBaseRole)obj2, source);
        } else if (basicModElement instanceof PgGPlumBaseRule) {
            this.buildRule((PgGPlumBaseRule)obj2, source);
        } else if (basicModElement instanceof PgGPlumBaseAggregate) {
            this.buildAggregate((PgGPlumBaseAggregate)obj2, source);
        } else if (basicModElement instanceof PgGPlumBaseTrigger) {
            this.buildTrigger((PgGPlumBaseTrigger)obj2, source);
        } else if (basicModElement instanceof PgGPlumBaseExtension) {
            this.buildExtension((PgGPlumBaseExtension)obj2, source);
        } else {
            super.build(obj2, source);
        }
    }

    protected final void buildRoutine(@NotNull PgGPlumBaseRoutine obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        super.buildRoutine(obj2, source);
        if (source instanceof SqlCreateProcedureStatement) {
            ArrayList<String> assignments = new ArrayList<String>();
            boolean isLeakproof = false;
            boolean isStrict = false;
            boolean isSecurityDefiner = false;
            float cost = 0.0f;
            String language = null;
            PgGPlumBaseObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgGPlumBaseObjectBuilder pgGPlumBaseObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement s;
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement = s = it2.getFirstChild();
                IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SET)) {
                    PgGPlumBaseObjectBuilder this_$iv2 = this;
                    boolean $i$f$forEachSibling2 = false;
                    for (PsiElement tmp$iv = s; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement sibling = tmp$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)this.getElementType(sibling), (Object)PgTypes.PG_SET_ASSIGNMENT)) continue;
                        assignments.add(sibling.getText());
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOT)) {
                    isLeakproof = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LEAKPROOF)) {
                    isLeakproof = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_STRICT)) {
                    isStrict = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SECURITY) || Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_EXTERNAL)) {
                    IElementType iElementType3 = PgTypes.PG_DEFINER;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_DEFINER");
                    isSecurityDefiner = this.findSibling(s, iElementType3) != null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_COST)) {
                    Float f = this.findNumberInSiblings(s);
                    cost = f != null ? f.floatValue() : 0.0f;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LANGUAGE)) continue;
                PsiElement psiElement2 = it2.getLastChild();
                language = psiElement2 != null ? this.extractName(psiElement2) : null;
            }
            obj2.setConfigurationParameters((List<String>)assignments);
            obj2.setLeakproof(isLeakproof);
            obj2.setStrict(isStrict);
            obj2.setSecurityDefiner(isSecurityDefiner);
            obj2.setCost(cost);
            obj2.setLanguageName(language);
            boolean isProcedure = !(source instanceof SqlCreateFunctionStatementImpl);
            obj2.setRoutineKind(isProcedure ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
            if (!isProcedure) {
                return;
            }
            BasicModArgument basicModArgument = obj2.createOrGetReturnArgument();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicModArgument, (String)"obj.createOrGetReturnArgument()");
            BasicModArgument returnArgument2 = basicModArgument;
            boolean hasOutParameters2 = obj2.getArguments().has(buildRoutine.hasOutParameters.1.INSTANCE);
            returnArgument2.setDataType(DataTypeFactory.of(hasOutParameters2 ? "record" : "void"));
        }
    }

    private final void buildSequence(PgGPlumBaseSequence obj2, DasObject source) {
        this.buildBasicElement(obj2, source);
        if (source instanceof SqlCreateSequenceStatementImpl) {
            obj2.setSequenceIdentity(this.buildSequenceIdentity((PsiElement)source));
            boolean cycle = false;
            boolean owned = false;
            long cacheSize = 1L;
            String dataType = null;
            PgGPlumBaseObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgGPlumBaseObjectBuilder pgGPlumBaseObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement type;
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                if (!(it2 instanceof SqlClause)) continue;
                PsiElement psiElement = ((SqlClause)it2).getFirstChild();
                if (psiElement == null || (psiElement = this.getElementType(psiElement)) == null) {
                    continue;
                }
                PsiElement psiElement2 = type = psiElement;
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_CYCLE)) {
                    cycle = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_OWNED)) {
                    SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlCompositeElementTypes.SQL_COLUMN_REFERENCE");
                    owned = this.findChild(it2, (IElementType)sqlReferenceElementType) != null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_CACHE)) {
                    Long l = this.findNumber(it2);
                    cacheSize = l != null ? l : 1L;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_AS)) continue;
                SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                PsiElement psiElement3 = this.findChild(it2, (IElementType)sqlCompositeElementType);
                if (!(psiElement3 instanceof SqlTypeElement)) {
                    psiElement3 = null;
                }
                SqlTypeElement sqlTypeElement = (SqlTypeElement)psiElement3;
                dataType = sqlTypeElement != null ? sqlTypeElement.getDisplayName() : null;
            }
            obj2.setCycled(cycle);
            obj2.setOwnedByColumn(owned);
            obj2.setCacheSize(cacheSize);
            obj2.setDataType(dataType);
        }
    }

    private final SequenceIdentity buildSequenceIdentity(PsiElement source) {
        Long startVal;
        Long maxVal;
        Long minVal;
        Long l;
        Long[] longArray;
        Long[] longArray2 = longArray = new Long[4];
        boolean bl = false;
        Long l2 = l = longArray2[0];
        longArray2 = longArray;
        bl = false;
        Long l3 = l = longArray2[1];
        longArray2 = longArray;
        bl = false;
        Long l4 = l = longArray2[2];
        longArray2 = longArray;
        bl = false;
        Long incVal = l = longArray2[3];
        PgGPlumBaseObjectBuilder this_$iv = this;
        boolean $i$f$forEachChild = false;
        PgGPlumBaseObjectBuilder pgGPlumBaseObjectBuilder = this_$iv;
        PsiElement psiElement = source;
        PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            PsiElement type;
            PsiElement it2 = tmp$iv$iv;
            boolean bl2 = false;
            if (!(it2 instanceof SqlClause)) continue;
            PsiElement psiElement2 = ((SqlClause)it2).getFirstChild();
            if (psiElement2 == null || (psiElement2 = this.getElementType(psiElement2)) == null) {
                continue;
            }
            PsiElement psiElement3 = type = psiElement2;
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_MINVALUE)) {
                minVal = this.findNumber(it2);
                continue;
            }
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_MAXVALUE)) {
                maxVal = this.findNumber(it2);
                continue;
            }
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_START)) {
                startVal = this.findNumber(it2);
                continue;
            }
            if (!Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_INCREMENT)) continue;
            incVal = this.findNumber(it2);
        }
        SequenceIdentity sequenceIdentity = SequenceIdentity.of(minVal, startVal, incVal, maxVal);
        Intrinsics.checkExpressionValueIsNotNull((Object)sequenceIdentity, (String)"SequenceIdentity.of(minV\u2026startVal, incVal, maxVal)");
        return sequenceIdentity;
    }

    @Nullable
    protected final Long findNumber(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toLongOrNull((String)object) : null;
    }

    protected final void buildRole(@NotNull PgGPlumBaseRole obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        boolean isSuper = false;
        boolean isInherit = true;
        boolean canCreateRole = false;
        boolean canCreateDb = false;
        boolean canLogin = source instanceof SqlCreateUserStatementImpl;
        long connectionLimit = -1L;
        String validUntil = null;
        if (source instanceof SqlCreateStatement) {
            PgGPlumBaseObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgGPlumBaseObjectBuilder pgGPlumBaseObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement c2;
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                if (!(it2 instanceof SqlClause)) continue;
                PsiElement psiElement = c2 = ((SqlClause)it2).getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"c");
                IElementType iElementType = this.getElementType(psiElement);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SUPERUSER)) {
                    isSuper = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOINHERIT)) {
                    isInherit = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CREATEROLE)) {
                    canCreateRole = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CREATEDB)) {
                    canCreateDb = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LOGIN)) {
                    canLogin = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOLOGIN)) {
                    canLogin = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CONNECTION)) {
                    IElementType iElementType2 = PgTypes.PG_LIMIT;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PG_LIMIT");
                    Float f = this.findNumberInSiblings(this.findSibling(c2, iElementType2));
                    connectionLimit = f != null ? (long)f.floatValue() : -1L;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VALID)) continue;
                IElementType iElementType3 = PgTypes.PG_UNTIL;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_UNTIL");
                validUntil = this.findString(this.findSibling(c2, iElementType3));
            }
        }
        obj2.setSuperRole(isSuper);
        obj2.setInherit(isInherit);
        obj2.setCreateRole(canCreateRole);
        obj2.setCreateDb(canCreateDb);
        obj2.setCanLogin(canLogin);
        obj2.setConnectionLimit(connectionLimit);
        obj2.setValidUntil(validUntil);
    }

    private final void buildRule(PgGPlumBaseRule obj2, DasObject source) {
        Object object;
        PgGPlumBaseRule pgGPlumBaseRule;
        String condition;
        block11: {
            block10: {
                this.buildBasicElement(obj2, source);
                TrigTurn turn = null;
                TrigEvent event = null;
                condition = null;
                if (source instanceof SqlCreateStatement) {
                    PgGPlumBaseObjectBuilder this_$iv = this;
                    boolean $i$f$forEachChild = false;
                    PgGPlumBaseObjectBuilder pgGPlumBaseObjectBuilder = this_$iv;
                    PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
                    boolean $i$f$forEachSibling = false;
                    for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        SqlExpression sqlExpression;
                        PsiElement psiElement;
                        block9: {
                            IElementType iElementType;
                            PsiElement it2 = tmp$iv$iv;
                            boolean bl = false;
                            IElementType iElementType2 = this.getElementType(it2);
                            if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlCompositeElementTypes.SQL_TRIGGER_TIME_CLAUSE)) {
                                PsiElement psiElement2 = it2.getFirstChild();
                                IElementType iElementType3 = iElementType = psiElement2 != null ? this.getElementType(psiElement2) : null;
                                turn = Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_INSTEAD) ? TrigTurn.INSTEAD_OF : (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_ALSO) ? TrigTurn.ALSO : null);
                                continue;
                            }
                            if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE)) {
                                PsiElement psiElement3 = it2.getLastChild();
                                IElementType iElementType4 = iElementType = psiElement3 != null ? this.getElementType(psiElement3) : null;
                                event = Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SELECT) ? TrigEvent.SELECT : (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_DELETE) ? TrigEvent.DELETE : (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_UPDATE) ? TrigEvent.UPDATE : (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_INSERT) ? TrigEvent.INSERT : null)));
                                continue;
                            }
                            if (!Intrinsics.areEqual((Object)iElementType2, (Object)SqlCompositeElementTypes.SQL_WHERE_CLAUSE)) continue;
                            PgGPlumBaseObjectBuilder this_$iv2 = this;
                            boolean $i$f$findChild = false;
                            PgGPlumBaseObjectBuilder pgGPlumBaseObjectBuilder2 = this_$iv2;
                            PsiElement element$iv$iv = it2.getFirstChild();
                            boolean $i$f$findSibling = false;
                            for (PsiElement tmp$iv$iv2 = element$iv$iv; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                                PsiElement it$iv = tmp$iv$iv2;
                                boolean bl2 = false;
                                if (!(it$iv instanceof SqlExpression)) continue;
                                psiElement = tmp$iv$iv2;
                                break block9;
                            }
                            psiElement = null;
                        }
                        SqlExpression sqlExpression2 = sqlExpression = (SqlExpression)psiElement;
                        condition = sqlExpression2 != null ? sqlExpression2.getText() : null;
                    }
                }
                obj2.setTurn(turn);
                pgGPlumBaseRule = obj2;
                object = event;
                if (object == null) break block10;
                TrigEvent trigEvent = object;
                PgGPlumBaseRule pgGPlumBaseRule2 = pgGPlumBaseRule;
                boolean bl = false;
                boolean bl3 = false;
                TrigEvent it3 = trigEvent;
                boolean bl4 = false;
                Set set = SetsKt.setOf((Object)event);
                pgGPlumBaseRule = pgGPlumBaseRule2;
                object = set;
                if (object != null) break block11;
            }
            object = SetsKt.emptySet();
        }
        pgGPlumBaseRule.setEvents((Set<TrigEvent>)object);
        obj2.setCondition(condition);
        ((BasicModModel)obj2.getModel()).writeSources(new Runnable(this, obj2, source){
            final /* synthetic */ PgGPlumBaseObjectBuilder this$0;
            final /* synthetic */ PgGPlumBaseRule $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateStatement)) {
                    dasObject = null;
                }
                this.$obj.setSourceText((object = (SqlCreateStatement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = pgGPlumBaseObjectBuilder;
                this.$obj = pgGPlumBaseRule;
                this.$source = dasObject;
            }
        });
    }

    protected final void buildAggregate(@NotNull PgGPlumBaseAggregate obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (source instanceof PgCreateAggregateStatementImpl) {
            String transitionFunction = null;
            DataType transitionType = DataType.UNKNOWN;
            String finalFunction = null;
            String initialCondition = null;
            String sortOperator = null;
            PgAggregateKind kind = PgAggregateKind.NORMAL;
            int directArgs = 0;
            PgGPlumBaseObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgGPlumBaseObjectBuilder pgGPlumBaseObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement tmp$iv$iv2;
                PsiElement child = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = this.getElementType(child);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_PARAMETER_LIST)) {
                    int index2;
                    block18: {
                        int n;
                        Object[] objectArray = child.getChildren();
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"child.children");
                        Sequence $this$indexOfFirst$iv = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)buildAggregate.1.index.1.INSTANCE);
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            boolean bl2 = false;
                            if (index$iv < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            PsiElement it2 = (PsiElement)item$iv;
                            boolean bl3 = false;
                            if (it2 instanceof SqlOrderByClause) {
                                n = index$iv;
                                break block18;
                            }
                            ++index$iv;
                        }
                        n = index2 = -1;
                    }
                    if (index2 <= 0) continue;
                    directArgs = index2;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE)) {
                    PgGPlumBaseObjectBuilder this_$iv2 = this;
                    boolean $i$f$forEachChild2 = false;
                    PgGPlumBaseObjectBuilder $i$f$indexOfFirst = this_$iv2;
                    PsiElement first$iv$iv2 = child.getFirstChild();
                    boolean $i$f$forEachSibling2 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement it3 = tmp$iv$iv2;
                        boolean bl4 = false;
                        IElementType iElementType2 = this.getElementType(it3);
                        if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_SFUNC)) {
                            Reference reference = this.findFunctionReference(it3);
                            transitionFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_INITCOND)) {
                            String string = this.findString(it3);
                            if (string == null) {
                                Float f = this.findNumberInSiblings(it3);
                                string = f != null ? String.valueOf((int)f.floatValue()) : null;
                            }
                            initialCondition = string;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_SORTOP)) {
                            SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_OPERATOR_REFERENCE;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_OPERATOR_REFERENCE");
                            Reference reference = this.findReference(it3, sqlReferenceElementType);
                            sortOperator = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_HYPOTHETICAL)) continue;
                        kind = PgAggregateKind.HYPO_SET;
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_RETURNS_CLAUSE))) continue;
                PgGPlumBaseObjectBuilder this_$iv3 = this;
                boolean $i$f$forEachChild3 = false;
                PgGPlumBaseObjectBuilder this_$iv$iv = this_$iv3;
                PsiElement first$iv$iv3 = child.getFirstChild();
                boolean $i$f$forEachSibling3 = false;
                for (tmp$iv$iv2 = first$iv$iv3; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    boolean bl5;
                    boolean bl6;
                    PsiElement psiElement;
                    PsiElement it4 = tmp$iv$iv2;
                    boolean bl7 = false;
                    IElementType iElementType3 = this.getElementType(it4);
                    if (Intrinsics.areEqual((Object)iElementType3, (Object)PgTypes.PG_STYPE)) {
                        SqlTypeElement sqlTypeElement;
                        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                        PsiElement psiElement2 = this.findSibling(it4, (IElementType)sqlCompositeElementType);
                        if (!(psiElement2 instanceof SqlTypeElement)) {
                            psiElement2 = null;
                        }
                        if ((sqlTypeElement = (SqlTypeElement)psiElement2) != null && (sqlTypeElement = sqlTypeElement.getDataType()) != null) {
                            psiElement = sqlTypeElement;
                            bl6 = false;
                            bl5 = false;
                            PsiElement it5 = psiElement;
                            boolean bl8 = false;
                            transitionType = it5;
                        }
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType3, (Object)PgTypes.PG_FINALFUNC)) continue;
                    SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_FUNCTION_CALL;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_FUNCTION_CALL");
                    if (this.findSibling(it4, (IElementType)sqlCompositeElementType) == null) continue;
                    bl6 = false;
                    bl5 = false;
                    PsiElement call2 = psiElement;
                    boolean bl9 = false;
                    PsiElement psiElement3 = call2;
                    if (!(psiElement3 instanceof SqlFunctionCallExpression)) {
                        psiElement3 = null;
                    }
                    SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement3;
                    Object object = sqlFunctionCallExpression != null ? sqlFunctionCallExpression.getCallableExpression() : null;
                    if (!(object instanceof SqlReferenceExpression)) {
                        object = null;
                    }
                    SqlReferenceExpression reference = (SqlReferenceExpression)object;
                    Reference reference2 = this.asReferenceData(reference);
                    finalFunction = reference2 != null ? reference2.getFullName() : null;
                }
            }
            obj2.setTransition(transitionFunction);
            obj2.setTransitionDataType(transitionType);
            obj2.setFinal(finalFunction);
            obj2.setInitialValue(initialCondition);
            obj2.setSortOperator(sortOperator);
            obj2.setAggregateKind(kind);
            obj2.setDirectArgs(directArgs);
        }
    }

    @Nullable
    protected final Reference findFunctionReference(@NotNull PsiElement source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_FUNCTION_REFERENCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_FUNCTION_REFERENCE");
        return this.findReference(source, sqlReferenceElementType);
    }

    private final Reference findReference(PsiElement source, SqlReferenceElementType type) {
        PsiElement psiElement = this.findSibling(source, (IElementType)type);
        if (!(psiElement instanceof SqlReferenceExpression)) {
            psiElement = null;
        }
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement;
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression reference = sqlReferenceExpression;
        return this.asReferenceData(reference);
    }

    @Nullable
    protected final Reference asReferenceData(@Nullable SqlReferenceExpression $this$asReferenceData) {
        if ($this$asReferenceData == null) {
            return null;
        }
        Object object = $this$asReferenceData.getIdentifier();
        if (object == null || (object = object.getName()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"identifier?.name ?: return null");
        Object name2 = object;
        SqlExpression sqlExpression = $this$asReferenceData.getQualifierExpression();
        String qualifier = sqlExpression != null ? sqlExpression.getName() : null;
        Object[] objectArray = new String[2];
        SqlExpression sqlExpression2 = $this$asReferenceData.getQualifierExpression();
        objectArray[0] = sqlExpression2 != null ? sqlExpression2.getText() : null;
        SqlIdentifier sqlIdentifier = $this$asReferenceData.getIdentifier();
        objectArray[1] = sqlIdentifier != null ? sqlIdentifier.getText() : null;
        String fullText2 = CollectionsKt.joinToString$default((Iterable)ArraysKt.filterNotNull((Object[])objectArray), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return new Reference(qualifier, (String)name2, fullText2);
    }

    private final void buildTrigger(PgGPlumBaseTrigger obj2, DasObject source) {
        String fooName;
        SqlFunctionCallExpression sqlFunctionCallExpression;
        PgGPlumBaseTrigger pgGPlumBaseTrigger = obj2;
        if (pgGPlumBaseTrigger == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        }
        this.buildTrigger((BasicModTrigger)pgGPlumBaseTrigger, source);
        DasObject dasObject = source;
        if (!(dasObject instanceof SqlCreateTriggerStatement)) {
            dasObject = null;
        }
        SqlCreateTriggerStatement sqlCreateTriggerStatement = (SqlCreateTriggerStatement)dasObject;
        Object object = sqlCreateTriggerStatement != null ? sqlCreateTriggerStatement.getTriggerProcedure() : null;
        if (!(object instanceof SqlFunctionCallExpression)) {
            object = null;
        }
        String string = (sqlFunctionCallExpression = (SqlFunctionCallExpression)object) != null && (sqlFunctionCallExpression = sqlFunctionCallExpression.getNameElement()) != null ? sqlFunctionCallExpression.getName() : (fooName = null);
        if (fooName == null) {
            obj2.setCallRoutineId(0L);
        } else {
            ((Map)this.triggerRoutines).put(obj2, fooName);
        }
    }

    @Override
    public void finalize(@NotNull BasicModElement obj2) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof PgGPlumBaseTrigger) {
            this.finalizeTrigger((PgGPlumBaseTrigger)obj2);
        } else {
            super.finalize(obj2);
        }
    }

    private final void finalizeTrigger(PgGPlumBaseTrigger obj2) {
        String string = (String)this.triggerRoutines.get(obj2);
        if (string == null) {
            return;
        }
        String fooName = string;
        PgGPlumBaseSchema pgGPlumBaseSchema = obj2.getSchema();
        if (pgGPlumBaseSchema == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pgGPlumBaseSchema, (String)"obj.schema!!");
        PgGPlumBaseRoutine r = (PgGPlumBaseRoutine)pgGPlumBaseSchema.getRoutines().get(fooName);
        if (r == null) {
            PgGPlumBaseSchema pgGPlumBaseSchema2 = obj2.getSchema();
            if (pgGPlumBaseSchema2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)pgGPlumBaseSchema2, (String)"obj.schema!!");
            Object e = pgGPlumBaseSchema2.getRoutines().createNewOne();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            r = (PgGPlumBaseRoutine)e;
            r.setName(fooName);
        }
        if (r.getObjectId() == Long.MIN_VALUE) {
            r.setObjectId(new Random().nextLong());
        }
        obj2.setCallRoutineId(r.getObjectId());
    }

    private final void buildExtension(PgGPlumBaseExtension obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            String schemaName = null;
            String version = null;
            PgGPlumBaseObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgGPlumBaseObjectBuilder pgGPlumBaseObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement child = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = this.getElementType(child);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    PgGPlumBaseObjectBuilder this_$iv2 = this;
                    boolean $i$f$forEachChild2 = false;
                    PgGPlumBaseObjectBuilder pgGPlumBaseObjectBuilder2 = this_$iv2;
                    PsiElement first$iv$iv2 = child.getFirstChild();
                    boolean $i$f$forEachSibling2 = false;
                    for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement it2 = tmp$iv$iv2;
                        boolean bl2 = false;
                        IElementType iElementType2 = this.getElementType(it2);
                        if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_VERSION)) continue;
                        version = this.findString(it2);
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SCHEMA)) continue;
                schemaName = this.findSchemaInSiblings(child);
            }
            obj2.setSchemaName(schemaName);
            obj2.setVersion(version);
            obj2.setAvailableUpdates(CollectionsKt.emptyList());
            obj2.setSchemaId(null);
        }
    }

    @Override
    protected void buildTypedType(@NotNull BasicModTypedElement obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(obj2 instanceof PgGPlumBaseLocalTableColumn)) {
            super.buildTypedType(obj2, source);
            return;
        }
        DataType type = this.extractType(source);
        boolean serial = false;
        if (StringsKt.equals((String)type.typeName, (String)"bigserial", (boolean)true) || StringsKt.equals((String)type.typeName, (String)"serial8", (boolean)true)) {
            DataType dataType = DataTypeFactory.of("bigint");
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(\"bigint\")");
            type = dataType;
            serial = true;
        } else if (StringsKt.equals((String)type.typeName, (String)"serial", (boolean)true) || StringsKt.equals((String)type.typeName, (String)"serial4", (boolean)true)) {
            DataType dataType = DataTypeFactory.of("int");
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(\"int\")");
            type = dataType;
            serial = true;
        } else if (StringsKt.equals((String)type.typeName, (String)"smallserial", (boolean)true) || StringsKt.equals((String)type.typeName, (String)"serial2", (boolean)true)) {
            DataType dataType = DataTypeFactory.of("smallint");
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(\"smallint\")");
            type = dataType;
            serial = true;
        }
        ((PgGPlumBaseLocalTableColumn)obj2).setDataType(type);
        ((PgGPlumBaseLocalTableColumn)obj2).setBelongingSequenceName(serial ? "unknown" : null);
    }

    public PgGPlumBaseObjectBuilder() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026lumBaseTrigger, String>()");
        this.triggerRoutines = concurrentMap;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseObjectBuilder$Reference;", "", "qualifier", "", "name", "fullName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFullName", "()Ljava/lang/String;", "getName", "getQualifier", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects.postgresgreenplumbase"})
    protected static final class Reference {
        @Nullable
        private final String qualifier;
        @NotNull
        private final String name;
        @NotNull
        private final String fullName;

        @Nullable
        public final String getQualifier() {
            return this.qualifier;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        public Reference(@Nullable String qualifier, @NotNull String name2, @NotNull String fullName) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
            this.qualifier = qualifier;
            this.name = name2;
            this.fullName = fullName;
        }

        @Nullable
        public final String component1() {
            return this.qualifier;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.fullName;
        }

        @NotNull
        public final Reference copy(@Nullable String qualifier, @NotNull String name2, @NotNull String fullName) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
            return new Reference(qualifier, name2, fullName);
        }

        public static /* synthetic */ Reference copy$default(Reference reference, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reference.qualifier;
            }
            if ((n & 2) != 0) {
                string2 = reference.name;
            }
            if ((n & 4) != 0) {
                string3 = reference.fullName;
            }
            return reference.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Reference(qualifier=" + this.qualifier + ", name=" + this.name + ", fullName=" + this.fullName + ")";
        }

        public int hashCode() {
            String string = this.qualifier;
            String string2 = this.name;
            String string3 = this.fullName;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Reference)) break block3;
                    Reference reference = (Reference)object;
                    if (!Intrinsics.areEqual((Object)this.qualifier, (Object)reference.qualifier) || !Intrinsics.areEqual((Object)this.name, (Object)reference.name) || !Intrinsics.areEqual((Object)this.fullName, (Object)reference.fullName)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

