/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.extensions.Clipboard;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.Files;
import com.intellij.database.extensions.Logger;
import com.intellij.database.extensions.SchemaScriptBindings;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaScripts {
    private SchemaScripts() {
    }

    @NotNull
    public static List<File> getScriptFiles(PluginId pluginId, String scriptsFolderName) {
        File scriptsDirectory = SchemaScripts.getScriptsDirectoryImpl(pluginId, scriptsFolderName);
        List list = JBIterable.of((Object[])(scriptsDirectory == null ? null : scriptsDirectory.listFiles())).filter(ExtensionsRootType.regularFileFilter()).toList();
        if (list == null) {
            SchemaScripts.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    private static File getScriptsDirectoryImpl(PluginId pluginId, String scriptsFolderName) {
        try {
            return ExtensionsRootType.getInstance().findResourceDirectory(pluginId, scriptsFolderName, true);
        }
        catch (IOException ignore) {
            com.intellij.openapi.diagnostic.Logger.getInstance(SchemaScripts.class).warn("Unable to find extension scripts directory", (Throwable)ignore);
            return null;
        }
    }

    public static boolean areAvailableIn(@NotNull DataContext context) {
        if (context == null) {
            SchemaScripts.$$$reportNull$$$0(1);
        }
        return !SchemaScripts.getSelection(context).isEmpty();
    }

    public static void runScript(@NotNull DataContext context, final @NotNull File scriptFile, @NotNull PluginId hostPluginId) {
        JBIterable<DasObject> selection;
        Project project;
        IdeScriptEngine engine;
        if (context == null) {
            SchemaScripts.$$$reportNull$$$0(2);
        }
        if (scriptFile == null) {
            SchemaScripts.$$$reportNull$$$0(3);
        }
        if (hostPluginId == null) {
            SchemaScripts.$$$reportNull$$$0(4);
        }
        if ((engine = SchemaScripts.prepareEngine(project = (Project)CommonDataKeys.PROJECT.getData(context), scriptFile, hostPluginId, selection = SchemaScripts.getSelection(context))) == null) {
            return;
        }
        ExtensionScriptsUtil.prepareScript(scriptFile);
        Task.Backgroundable task = new Task.Backgroundable(project, "Running '" + scriptFile.getName() + "'", true){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project != null && project.isDisposed() || selection.find(o -> !((DbElement)o).isValid()) != null) {
                    return;
                }
                try {
                    ExtensionScriptsUtil.evalScript(project, engine, scriptFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/extensions/SchemaScripts$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable
    private static IdeScriptEngine prepareEngine(@Nullable Project project, @NotNull File scriptFile, @NotNull PluginId hostPluginId, @NotNull JBIterable<DasObject> selection) {
        IdeScriptEngine engine;
        if (scriptFile == null) {
            SchemaScripts.$$$reportNull$$$0(5);
        }
        if (hostPluginId == null) {
            SchemaScripts.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            SchemaScripts.$$$reportNull$$$0(7);
        }
        if ((engine = ExtensionScriptsUtil.getEngineFor(project, hostPluginId, scriptFile)) != null) {
            ExtensionScriptsUtil.setBindings(engine).bind(SchemaScriptBindings.PROJECT, project).bind(SchemaScriptBindings.SELECTION, selection).bind(SchemaScriptBindings.CLIPBOARD, new ClipboardImpl()).bind(SchemaScriptBindings.LOG, new LoggerImpl(engine)).bind(SchemaScriptBindings.FILES, new FilesImpl(project, scriptFile));
        }
        return engine;
    }

    @NotNull
    private static JBIterable<DasObject> getSelection(@NotNull DataContext context) {
        if (context == null) {
            SchemaScripts.$$$reportNull$$$0(8);
        }
        JBIterable jBIterable = DatabaseView.getSelectedElements(context, (Condition<DatabaseStructure.Group>)Conditions.alwaysTrue()).filter(DasObject.class);
        if (jBIterable == null) {
            SchemaScripts.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extensions/SchemaScripts";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPluginId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extensions/SchemaScripts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "areAvailableIn";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runScript";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareEngine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilesImpl
    implements Files {
        private final Project myProject;
        private final File myScriptFile;

        private FilesImpl(@Nullable Project project, @NotNull File scriptFile) {
            if (scriptFile == null) {
                FilesImpl.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myScriptFile = scriptFile;
        }

        public void chooseFileAndSave(@NotNull String title, @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                FilesImpl.$$$reportNull$$$0(1);
            }
            if (description == null) {
                FilesImpl.$$$reportNull$$$0(2);
            }
            if (saveAction == null) {
                FilesImpl.$$$reportNull$$$0(3);
            }
            FileSaverDescriptor descriptor = new FileSaverDescriptor(title, description, new String[0]);
            this.chooseFileAndSaveImpl((FileChooserDescriptor)descriptor, saveAction);
        }

        public void chooseDirectoryAndSave(@NotNull String title, @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                FilesImpl.$$$reportNull$$$0(4);
            }
            if (description == null) {
                FilesImpl.$$$reportNull$$$0(5);
            }
            if (saveAction == null) {
                FilesImpl.$$$reportNull$$$0(6);
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(title).withDescription(description);
            this.chooseFileAndSaveImpl(descriptor, saveAction);
        }

        public void refresh(@NotNull File file) {
            VirtualFile virtualFile;
            if (file == null) {
                FilesImpl.$$$reportNull$$$0(7);
            }
            if ((virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true)) == null) {
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("", "<a href=\"generator\">" + PathUtil.getFileName((String)this.myScriptFile.getPath()) + "</a>: Generated to <a href=\"dir\">" + virtualFile.getPath() + "</a>.", NotificationType.INFORMATION, (notification, event) -> {
                if ("generator".equals(event.getDescription())) {
                    ExtensionScriptsUtil.navigateToFile(this.myProject, this.myScriptFile);
                } else if (!ExtensionScriptsUtil.navigateToFile(this.myProject, file)) {
                    notification.expire();
                }
            }).notify(this.myProject);
        }

        private void chooseFileAndSaveImpl(@NotNull FileChooserDescriptor descriptor, @NotNull Consumer<File> saveAction) {
            if (descriptor == null) {
                FilesImpl.$$$reportNull$$$0(8);
            }
            if (saveAction == null) {
                FilesImpl.$$$reportNull$$$0(9);
            }
            Ref fileRef = Ref.create();
            Runnable runnable = () -> FileChooserFactory.getInstance().createPathChooser(descriptor, this.myProject, null).choose(null, files -> fileRef.set(ContainerUtil.getFirstItem((List)files)));
            try {
                GuiUtils.runOrInvokeAndWait((Runnable)runnable);
                if (!fileRef.isNull()) {
                    VirtualFile virtualFile = (VirtualFile)fileRef.get();
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    saveAction.consume((Object)file);
                    this.refresh(file);
                }
            }
            catch (Throwable t) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptFile";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "saveAction";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/extensions/SchemaScripts$FilesImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseFileAndSave";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseDirectoryAndSave";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refresh";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseFileAndSaveImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LoggerImpl
    implements Logger {
        private final IdeScriptEngine myEngine;

        private LoggerImpl(@NotNull IdeScriptEngine engine) {
            if (engine == null) {
                LoggerImpl.$$$reportNull$$$0(0);
            }
            this.myEngine = engine;
        }

        public void print(@NotNull String message2) {
            if (message2 == null) {
                LoggerImpl.$$$reportNull$$$0(1);
            }
            try {
                this.myEngine.getStdOut().append(message2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void error(@NotNull String message2) {
            if (message2 == null) {
                LoggerImpl.$$$reportNull$$$0(2);
            }
            this.error(message2, null);
        }

        public void error(@NotNull String message2, @Nullable Throwable th) {
            if (message2 == null) {
                LoggerImpl.$$$reportNull$$$0(3);
            }
            try {
                Writer err = this.myEngine.getStdErr();
                err.append(message2).append("\n");
                if (th != null) {
                    err.append(ExceptionUtil.getThrowableText((Throwable)th));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/extensions/SchemaScripts$LoggerImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClipboardImpl
    implements Clipboard {
        private ClipboardImpl() {
        }

        @NotNull
        public String get() {
            String string;
            try {
                Transferable contents = CopyPasteManager.getInstance().getContents();
                string = contents != null ? (String)contents.getTransferData(DataFlavor.stringFlavor) : "";
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                ClipboardImpl.$$$reportNull$$$0(0);
            }
            return string;
            if ("" == null) {
                ClipboardImpl.$$$reportNull$$$0(1);
            }
            return "";
        }

        public void set(@Nullable String text2) {
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(StringUtil.notNullize((String)text2)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extensions/SchemaScripts$ClipboardImpl", "get"));
        }
    }
}

