/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModModelFun;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ModelReader;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseModel
implements BasicModModel {
    private static final AtomicInteger ourModelCounter = new AtomicInteger(0);
    private final int myModelInstanceNumber = ourModelCounter.incrementAndGet();
    @NotNull
    private ModelTextStorage myTextStorage = BlackHoleTextStorage.INSTANCE;
    @NotNull
    private final Logger log = Logger.getInstance(this.getClass());
    private final THashSet<BaseElement<?>> myLastCreatedElements = new THashSet();
    private final THashSet<BaseElement<?>> myLastModifiedElements = new THashSet();
    private final THashSet<BaseElement<?>> myLastRemovedElements = new THashSet();
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private volatile long myModificationThreadId = Long.MIN_VALUE;
    private final CopyOnWriteArrayList<BasicModelListener> myListeners = new CopyOnWriteArrayList();
    private boolean myFastMode;
    private boolean myFrozen;

    @Override
    @NotNull
    public abstract BasicRoot getRoot();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V read(@NotNull ModelReader<? super BasicModel, V> reader) {
        if (reader == null) {
            BaseModel.$$$reportNull$$$0(0);
        }
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            V v2 = reader.perform(this);
            return v2;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public <R extends BasicModRoot> void modify(@NotNull Class<R> rootClass, @NotNull ModelModifier<? super R> modifier) {
        if (rootClass == null) {
            BaseModel.$$$reportNull$$$0(1);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(2);
        }
        this.modify(this.getRoot(), rootClass, modifier);
    }

    @Override
    public <E extends BasicElement, M extends E> void modify(@NotNull E element2, @NotNull Class<M> clazz, @NotNull ModelModifier<? super M> modifier) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            BaseModel.$$$reportNull$$$0(4);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(5);
        }
        this.modify(element2, clazz, this.myFastMode, modifier);
    }

    public <E extends BasicElement, M extends E> void modify(@NotNull E element2, @NotNull Class<M> clazz, boolean fast, @NotNull ModelModifier<? super M> modifier) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(6);
        }
        if (clazz == null) {
            BaseModel.$$$reportNull$$$0(7);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(8);
        }
        if (element2.getModel() == null) {
            throw new IllegalArgumentException("Orphan element (the element doesn't belong to any model)");
        }
        if (!this.contains(element2)) {
            throw new IllegalArgumentException("Alien element (the element belong to another model)");
        }
        Class<?> elementClass = element2.getClass();
        if (!clazz.isAssignableFrom(elementClass)) {
            throw new IllegalArgumentException("Attempt to modify element of " + elementClass.getSimpleName() + " as an instance of " + clazz.getSimpleName());
        }
        E modElement = element2;
        this.modify(modElement, fast, modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BasicElement> void modify(@NotNull E element2, boolean fast, @NotNull ModelModifier<? super E> modifier) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(9);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(10);
        }
        long time1 = System.currentTimeMillis();
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        writeLock.lock();
        long time2 = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Model entered into modifying mode (lock delay was " + (time2 - time1) + " ms)");
        }
        boolean prevFast = this.myFastMode;
        try {
            this.myFastMode = fast;
            this.clearModifications();
            this.myModificationThreadId = Thread.currentThread().getId();
            long time3 = System.currentTimeMillis();
            modifier.perform(element2);
            long time4 = System.currentTimeMillis();
            this.compactListeners();
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("Model was modified during %d ms, %d created, %d updated, %d removed ", time4 - time3, this.myLastCreatedElements.size(), this.myLastModifiedElements.size(), this.myLastRemovedElements.size()));
            }
        }
        finally {
            this.myFastMode = prevFast;
            writeLock.unlock();
            this.myModificationThreadId = Integer.MIN_VALUE;
            long time5 = System.currentTimeMillis();
            this.notifyListeners();
            this.clearModifications();
            long time6 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Listeners took " + (time6 - time5) + " ms");
            }
            long time7 = System.currentTimeMillis();
            this.removeDroppedSources();
            long time8 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Dropping sources took " + (time8 - time7) + " ms");
            }
        }
    }

    void doingObjectCreate(@NotNull BaseElement<?> element2) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(11);
        }
        this.doingAnyModification();
        if (!this.myFastMode) {
            this.myLastCreatedElements.add(element2);
        }
    }

    void doingObjectModify(@NotNull BaseElement<?> element2) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(12);
        }
        this.doingAnyModification();
        if (!this.myFastMode) {
            this.myLastModifiedElements.add(element2);
        }
    }

    void doingObjectRemove(@NotNull BaseElement<?> element2) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(13);
        }
        this.doingAnyModification();
        if (element2 instanceof BasicModIdentifiedElement) {
            ((BasicModIdentifiedElement)((Object)element2)).setObjectId(Long.MIN_VALUE);
        }
        if (element2 instanceof BasicSourceAware || element2 instanceof BasicNamespace) {
            this.myTextStorage.queueDelete(element2);
        }
        if (!this.myFastMode) {
            this.myLastRemovedElements.add(element2);
        }
    }

    private void doingAnyModification() {
        if (this.myFrozen) {
            throw new IllegalStateException("Model is frozen");
        }
    }

    public void setFrozen(boolean frozen) {
        this.myFrozen = frozen;
    }

    @Override
    public void addListener(@NotNull BasicModelListener listener) {
        if (listener == null) {
            BaseModel.$$$reportNull$$$0(14);
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull BasicModelListener listener) {
        if (listener == null) {
            BaseModel.$$$reportNull$$$0(15);
        }
        this.myListeners.remove(listener);
    }

    @Override
    public void writeSources(@NotNull Runnable r) {
        if (r == null) {
            BaseModel.$$$reportNull$$$0(16);
        }
        this.myTextStorage.writeSession(r);
    }

    private void compactListeners() {
        this.myLastCreatedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastCreatedElements);
    }

    private void notifyListeners() {
        if (this.myLastCreatedElements.isEmpty() && this.myLastModifiedElements.isEmpty() && this.myLastRemovedElements.isEmpty()) {
            return;
        }
        Set<BasicElement> lastCreatedElements = Collections.unmodifiableSet(this.myLastCreatedElements);
        Set<BasicElement> lastModifiedElements = Collections.unmodifiableSet(this.myLastModifiedElements);
        Set<BasicElement> lastRemovedElements = Collections.unmodifiableSet(this.myLastRemovedElements);
        for (BasicModelListener listener : this.myListeners) {
            listener.modified(lastCreatedElements, lastModifiedElements, lastRemovedElements);
        }
    }

    private void removeDroppedSources() {
        this.myTextStorage.processDeleteQueue();
    }

    private void clearModifications() {
        this.myLastCreatedElements.clear();
        this.myLastModifiedElements.clear();
        this.myLastRemovedElements.clear();
    }

    @Override
    public void saveSourceText(@NotNull BasicSourceAware object, @Nullable CompositeText sourceText) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(17);
        }
        this.myTextStorage.save(object, sourceText);
    }

    @Override
    @Nullable
    public CompositeText loadSourceText(@NotNull BasicSourceAware object) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(18);
        }
        return this.myTextStorage.load(object);
    }

    @Override
    public void setSchemaSourcesVersion(@NotNull BasicSchema schema, @Nullable Long version) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(19);
        }
        this.myTextStorage.setVersion(schema, version);
    }

    @Override
    @Nullable
    public Long getSchemaSourcesVersion(@NotNull BasicSchema schema) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(20);
        }
        return this.myTextStorage.getVersion(schema);
    }

    @Override
    public void setTextStorage(@NotNull ModelTextStorage textStorage) {
        if (textStorage == null) {
            BaseModel.$$$reportNull$$$0(21);
        }
        this.myTextStorage = textStorage;
    }

    @Override
    @NotNull
    public ModelTextStorage getTextStorage() {
        ModelTextStorage modelTextStorage = this.myTextStorage;
        if (modelTextStorage == null) {
            BaseModel.$$$reportNull$$$0(22);
        }
        return modelTextStorage;
    }

    @NotNull
    static String deduplicate(@NotNull String str) {
        if (str == null) {
            BaseModel.$$$reportNull$$$0(23);
        }
        String string = str == ModelConsts.NO_NAME ? ModelConsts.NO_NAME : DbUtil.intern((String)str);
        if (string == null) {
            BaseModel.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    @Contract(value="null,_ -> null", pure=true)
    protected static <X> X findFirst(@Nullable Iterable<X> items, @NotNull Predicate<X> predicate) {
        if (predicate == null) {
            BaseModel.$$$reportNull$$$0(25);
        }
        if (items == null) {
            return null;
        }
        for (X item : items) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    protected static boolean eq(@Nullable Object value1, @Nullable Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public int hashCode() {
        return this.myModelInstanceNumber;
    }

    public String toString() {
        return String.format("%s model [instance %d]", this.getDbms().getName(), this.myModelInstanceNumber);
    }

    @Deprecated
    @NotNull
    public JBIterable<? extends BasicForeignKey> getExportedKeys(DasTable t) {
        BasicTable table = (BasicTable)ObjectUtils.tryCast((Object)(t instanceof DbTable ? ((DbTable)t).getDelegate() : t), BasicTable.class);
        JBIterable<BasicForeignKey> jBIterable = table != null ? ModModelFun.findReferencingForeignKeys(table) : JBIterable.empty();
        if (jBIterable == null) {
            BaseModel.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textStorage";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/BaseModel";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/BaseModel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStorage";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicate";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectCreate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectModify";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectRemove";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeSources";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveSourceText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadSourceText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setSchemaSourcesVersion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaSourcesVersion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setTextStorage";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deduplicate";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NullFamily<T extends BasicModNamedElement & BasicModArrangedElement>
    implements ModPositioningNamingFamily<T>,
    ModNamingIdentifyingFamily<T>,
    ModSingletonFamily<T> {
        public static final NullFamily INSTANCE = new NullFamily();

        @Override
        public void markChildrenAsSyncPending() {
        }

        @Override
        public void removeSyncPendingChildren() {
        }

        @Override
        @NotNull
        public BasicModModel getModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if ("null-family" == null) {
                NullFamily.$$$reportNull$$$0(0);
            }
            return "null-family";
        }

        @Override
        @NotNull
        public T first() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(@Nullable BasicElement element2) {
            return -1;
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        @NotNull
        public BasicMetaObject<T> getMetaObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T createNewOne() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(@NotNull Predicate condition) {
            if (condition == null) {
                NullFamily.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void sort() {
        }

        @Override
        public void clear() {
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator iterator = JBIterable.empty().iterator();
            if (iterator == null) {
                NullFamily.$$$reportNull$$$0(2);
            }
            return iterator;
        }

        @Override
        public T renewAt(short position, @NotNull String name2) {
            if (name2 == null) {
                NullFamily.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public T createOrGet(@NotNull String name2) {
            if (name2 == null) {
                NullFamily.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public T createOrGetAt(short position) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public T get() {
            return null;
        }

        @Override
        @NotNull
        public T createOrGet() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T renew(long objectId, String name2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T renew(long objectId, String name2, BiConsumer<String, String> renameHandler) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T createOrGet(long objectId) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$NullFamily";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$NullFamily";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "renewAt";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createOrGet";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BaseIdentifyingFamily<D extends BasicModIdentifiedElement, E extends BaseElement<D>>
    extends BaseFamily<D, E>
    implements ModIdentifyingFamily<E> {
        public BaseIdentifyingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BiFunction<BaseFamily<D, E>, D, E> factory) {
            if (owner == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            E e = BaseIdentifyingFamily.createOrGetImpl(objectId, this);
            if (e == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(3);
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            return BaseIdentifyingFamily.getByObjectIdImpl(objectId, this);
        }

        @NotNull
        static <E extends BaseElement<?>> E createOrGetImpl(long objectId, ModIdentifyingFamily<E> f) {
            BaseElement element2 = (BaseElement)f.getByObjectId(objectId);
            if (element2 == null) {
                element2 = (BaseElement)f.createNewOne();
                ((BasicModIdentifiedElement)((Object)element2)).setObjectId(objectId);
            } else {
                element2.resetSyncPending();
            }
            BaseElement baseElement = element2;
            if (baseElement == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(4);
            }
            return (E)baseElement;
        }

        @Nullable
        static <E extends BaseElement<?>> E getByObjectIdImpl(long objectId, BaseFamily<?, E> f) {
            List elements = f.myElements;
            if (elements == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                if (((BasicIdentifiedElement)((Object)element2)).getObjectId() != objectId) continue;
                return (E)element2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseIdentifyingFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseIdentifyingFamily";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGetImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BaseNamingIdentifyingFamily<D extends BasicModNamedElement & BasicModIdentifiedElement, E extends BaseElement<D> & BasicModIdentifiedElement>
    extends BaseNamingFamily<D, E>
    implements ModNamingIdentifyingFamily<E> {
        public BaseNamingIdentifyingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BiFunction<BaseFamily<D, E>, D, E> factory) {
            if (owner == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String string) {
            void name2;
            if (string == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(3);
            }
            E e = this.renew(objectId, (String)name2, (String s, String s2) -> {});
            if (e == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(4);
            }
            return e;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String name2, @NotNull BiConsumer<String, String> biConsumer) {
            E e;
            if (name2 == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(5);
            }
            if (biConsumer == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(6);
            }
            if (objectId != Long.MIN_VALUE && (e = this.getByObjectId(objectId)) != null) {
                String oldName = ((BasicNamedElement)e).getName();
                ((BasicModNamedElement)e).setName(name2);
                ((BaseElement)e).resetSyncPending();
                String newName = ((BasicNamedElement)e).getName();
                if (!Comparing.equal((String)oldName, (String)newName)) {
                    void renameHandler;
                    renameHandler.accept(oldName, newName);
                }
                E e2 = e;
                if (e2 == null) {
                    BaseNamingIdentifyingFamily.$$$reportNull$$$0(7);
                }
                return e2;
            }
            List elements = this.myElements;
            if (elements != null && name2 != ModelConsts.NO_NAME) {
                for (BaseElement e3 : elements) {
                    if (((BasicIdentifiedElement)((Object)e3)).getObjectId() != Long.MIN_VALUE || !((BasicNamedElement)((Object)e3)).getName().equals(name2)) continue;
                    ((BasicModIdentifiedElement)((Object)e3)).setObjectId(objectId);
                    e3.resetSyncPending();
                    BaseElement baseElement = e3;
                    if (baseElement == null) {
                        BaseNamingIdentifyingFamily.$$$reportNull$$$0(8);
                    }
                    return (E)baseElement;
                }
            }
            BasicModElement e4 = this.createNewOne();
            ((BasicModIdentifiedElement)e4).setObjectId(objectId);
            ((BasicModNamedElement)e4).setName(name2);
            BasicModElement basicModElement = e4;
            if (basicModElement == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(9);
            }
            return (E)basicModElement;
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            Object e = BaseIdentifyingFamily.createOrGetImpl(objectId, this);
            if (e == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(10);
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            return BaseIdentifyingFamily.getByObjectIdImpl(objectId, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renameHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "renew";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "renew";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BasePositioningNamingFamily<D extends BasicModArrangedElement & BasicModNamedElement, E extends BaseElement<D> & BasicModNamedElement>
    extends BaseNamingFamily<D, E>
    implements ModPositioningNamingFamily<E> {
        public BasePositioningNamingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BiFunction<BaseFamily<D, E>, D, E> factory) {
            if (owner == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        public E renewAt(short position, @NotNull String name2) {
            List elements;
            BasicModElement e;
            if (name2 == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(3);
            }
            if ((e = BaseModel.findFirst(elements = this.myElements, x -> ((DasPositioned)x).getPosition() == position && ((BasicNamedElement)((Object)x)).getName().equals(name2))) != null) {
                ((BaseElement)e).resetSyncPending();
                return (E)e;
            }
            e = BaseModel.findFirst(elements, x -> ((DasPositioned)x).getPosition() == position && ((BasicNamedElement)((Object)x)).getName() == ModelConsts.NO_NAME);
            if (e != null) {
                ((BasicModNamedElement)e).setName(name2);
                ((BaseElement)e).resetSyncPending();
                return (E)e;
            }
            if (!(position != 0 && name2.equals(ModelConsts.NO_NAME) || (e = BaseModel.findFirst(elements, x -> ((DasPositioned)x).getPosition() == 0 && ((BasicNamedElement)((Object)x)).getName().equals(name2))) == null)) {
                ((BasicModArrangedElement)e).setPosition(position);
                ((BaseElement)e).resetSyncPending();
                return (E)e;
            }
            e = this.createNewOne();
            ((BasicModArrangedElement)e).setPosition(position);
            ((BasicModNamedElement)e).setName(name2);
            return (E)e;
        }

        @Override
        public E createOrGetAt(short position) {
            List elements = this.myElements;
            if (elements == null) {
                BasicModElement element2 = this.createNewOne();
                ((BasicModArrangedElement)element2).setPosition(position);
                CopyOnWriteArrayList<BasicModElement> newElements = new CopyOnWriteArrayList<BasicModElement>();
                newElements.add(element2);
                this.myElements = newElements;
                return (E)element2;
            }
            for (BaseElement element3 : elements) {
                if (((DasPositioned)element3).getPosition() != position) continue;
                element3.resetSyncPending();
                return (E)element3;
            }
            BasicModElement element2 = this.createNewOne();
            ((BasicModArrangedElement)element2).setPosition(position);
            return (E)element2;
        }

        @Override
        @Nullable
        public E getByNaturalPosition(short position) {
            List elements = this.myElements;
            return (E)BaseModel.findFirst(elements, e -> ((DasPositioned)e).getPosition() == position);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/BaseModel$BasePositioningNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renewAt";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BaseNamingFamily<D extends BasicModNamedElement, E extends BaseElement<D>>
    extends BaseFamily<D, E>
    implements ModNamingFamily<E> {
        public BaseNamingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BiFunction<BaseFamily<D, E>, D, E> factory) {
            if (owner == null) {
                BaseNamingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseNamingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseNamingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        public E createOrGet(@NotNull String name2) {
            Object element2;
            if (name2 == null) {
                BaseNamingFamily.$$$reportNull$$$0(3);
            }
            if ((element2 = this.get(name2)) == null) {
                element2 = this.createNewOne();
                ((BasicModNamedElement)element2).setName(name2);
            } else {
                ((BaseElement)element2).resetSyncPending();
            }
            return element2;
        }

        @Override
        @Nullable
        public E get(@NotNull String name2) {
            if (name2 == null) {
                BaseNamingFamily.$$$reportNull$$$0(4);
            }
            return this.get(name2, true);
        }

        @Override
        @Nullable
        public E get(@NotNull String name2, boolean caseSensitive) {
            List elements;
            if (name2 == null) {
                BaseNamingFamily.$$$reportNull$$$0(5);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                boolean matched = caseSensitive ? ((BasicNamedElement)((Object)element2)).getName().equals(name2) : ((BasicNamedElement)((Object)element2)).getName().equalsIgnoreCase(name2);
                if (!matched) continue;
                return (E)element2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/BaseModel$BaseNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createOrGet";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BaseSingletonFamily<D extends BasicModElement, E extends BaseElement<D>>
    extends BaseFamily<D, E>
    implements ModSingletonFamily<E> {
        public BaseSingletonFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BiFunction<BaseFamily<D, E>, D, E> factory) {
            if (owner == null) {
                BaseSingletonFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseSingletonFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseSingletonFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        @Nullable
        public E get() {
            List elements = this.myElements;
            return (E)(elements == null ? null : (BaseElement)elements.get(0));
        }

        @Override
        @NotNull
        public E createNewOne(@Nullable D delegate) {
            this.owner.modifying(false);
            assert (this.myElements == null);
            Object newOne = this.instantiate(delegate);
            this.myElements = Collections.singletonList(newOne);
            Object e = newOne;
            if (e == null) {
                BaseSingletonFamily.$$$reportNull$$$0(3);
            }
            return e;
        }

        @Override
        @NotNull
        public E createOrGet() {
            if (this.isEmpty()) {
                BasicModElement basicModElement = this.createNewOne();
                if (basicModElement == null) {
                    BaseSingletonFamily.$$$reportNull$$$0(4);
                }
                return (E)basicModElement;
            }
            BasicElement basicElement = this.first();
            if (basicElement == null) {
                BaseSingletonFamily.$$$reportNull$$$0(5);
            }
            return (E)basicElement;
        }

        @Override
        public void sort() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseSingletonFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseSingletonFamily";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BaseFamily<D extends BasicModElement, E extends BaseElement<D>>
    implements ModFamily<E> {
        @NotNull
        public final BaseElement<?> owner;
        @Nullable
        protected volatile List<E> myElements;
        private final BasicMetaObject<D> myMeta;
        private final BiFunction<BaseFamily<D, E>, D, E> myFactory;

        public BaseFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BiFunction<BaseFamily<D, E>, D, E> factory) {
            if (owner == null) {
                BaseFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseFamily.$$$reportNull$$$0(2);
            }
            this(owner, (BasicMetaObject)ObjectUtils.notNull(BasicMetaUtils.findChild(owner.getMetaObject(), kind)), factory);
        }

        public BaseFamily(@NotNull BaseElement<?> owner, @NotNull BasicMetaObject<D> meta, @NotNull BiFunction<BaseFamily<D, E>, D, E> factory) {
            if (owner == null) {
                BaseFamily.$$$reportNull$$$0(3);
            }
            if (meta == null) {
                BaseFamily.$$$reportNull$$$0(4);
            }
            if (factory == null) {
                BaseFamily.$$$reportNull$$$0(5);
            }
            this.myElements = null;
            this.owner = owner;
            this.myMeta = meta;
            this.myFactory = factory;
        }

        @Override
        @NotNull
        public BasicMetaObject<D> getMetaObject() {
            BasicMetaObject<D> basicMetaObject = this.myMeta;
            if (basicMetaObject == null) {
                BaseFamily.$$$reportNull$$$0(6);
            }
            return basicMetaObject;
        }

        @Override
        public void removeSyncPendingChildren() {
            this.remove(BasicModElement::isSyncPending);
        }

        @Override
        public void markChildrenAsSyncPending() {
            for (BaseElement e : this) {
                e.setSyncPending(true);
            }
        }

        @NotNull
        protected E instantiate(@Nullable D delegate) {
            BaseElement baseElement = (BaseElement)this.myFactory.apply(this, delegate);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(7);
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E createNewOne() {
            E e = this.createNewOne(null);
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(8);
            }
            return e;
        }

        @NotNull
        public E createNewOne(@Nullable D delegate) {
            BaseModel model = this.owner.getModel();
            this.owner.modifying(false);
            E newOne = this.instantiate(delegate);
            if (this.myElements == null) {
                this.myElements = new CopyOnWriteArrayList();
            }
            this.myElements.add(newOne);
            model.doingObjectCreate((BaseElement<?>)newOne);
            E e = newOne;
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(9);
            }
            return e;
        }

        @Override
        @NotNull
        public BasicModModel getModel() {
            BaseModel baseModel = this.owner.getModel();
            if (baseModel == null) {
                BaseFamily.$$$reportNull$$$0(10);
            }
            return baseModel;
        }

        @Override
        @NotNull
        public E first() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(0);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(11);
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E last() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(elements.size() - 1);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(12);
            }
            return (E)baseElement;
        }

        @Override
        public int indexOf(@Nullable BasicElement element2) {
            if (element2 == null) {
                return -1;
            }
            List<E> elements = this.myElements;
            if (elements == null) {
                return -1;
            }
            return elements.indexOf(element2);
        }

        @Override
        public boolean hasChildren() {
            List<E> elements = this.myElements;
            return elements != null && !elements.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            List<E> elements = this.myElements;
            return elements == null || elements.isEmpty();
        }

        @Override
        public int size() {
            List<E> elements = this.myElements;
            return elements != null ? elements.size() : 0;
        }

        @Override
        @Nullable
        public E find(@NotNull Predicate<? super E> predicate) {
            List<E> elements;
            if (predicate == null) {
                BaseFamily.$$$reportNull$$$0(13);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                if (!predicate.test(element2)) continue;
                return (E)element2;
            }
            return null;
        }

        @Override
        public Iterator<E> iterator() {
            List<E> elements = this.myElements;
            if (elements != null) {
                return elements.iterator();
            }
            return Collections.emptyListIterator();
        }

        @Override
        public void remove(@NotNull Predicate<? super E> condition) {
            List<E> elements;
            if (condition == null) {
                BaseFamily.$$$reportNull$$$0(14);
            }
            if ((elements = this.myElements) == null) {
                return;
            }
            int n = elements.size();
            boolean modificationSent = false;
            for (int i2 = n - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                if (!condition.test(e)) continue;
                if (!modificationSent) {
                    modificationSent = true;
                    this.owner.modifying(false);
                }
                e.internalDrop(false);
                if (elements.size() >= 2) {
                    elements.remove(i2);
                    continue;
                }
                this.myElements = null;
            }
            if (elements.isEmpty()) {
                this.myElements = null;
            }
        }

        @Override
        public void sort() {
            List<E> elements = this.myElements;
            if (elements == null || elements.size() < 2) {
                return;
            }
            this.owner.modifying(false);
            if (!(elements instanceof ArrayList) && !(elements instanceof CopyOnWriteArrayList)) {
                throw new IllegalStateException("Unknown how to reorder elements inside a " + elements.getClass().getSimpleName());
            }
            Comparator<E> comparator = this.getElementsComparator();
            elements.sort(comparator);
        }

        protected Comparator<? super E> getElementsComparator() {
            return ModelUtil.DISPLAY_ORDER_COMPARATOR;
        }

        @Override
        public void clear() {
            List<E> elements = this.myElements;
            if (elements == null) {
                return;
            }
            this.owner.modifying(false);
            this.myElements = null;
            for (int i2 = elements.size() - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                e.internalDrop(false);
            }
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.myMeta.kind.code();
            if (string == null) {
                BaseFamily.$$$reportNull$$$0(15);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseFamily";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseFamily";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaObject";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instantiate";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "first";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "last";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseRegularNamedElement<D extends BasicModNamedElement>
    extends BaseRegularElement<D>
    implements BasicModNamedElement {
        public BaseRegularNamedElement(@NotNull BaseFamily<D, ? extends BaseElement<D>> parentFamily) {
            if (parentFamily == null) {
                BaseRegularNamedElement.$$$reportNull$$$0(0);
            }
            super(parentFamily);
        }

        public BaseRegularNamedElement(@NotNull BaseFamily<D, ? extends BaseElement<D>> parentFamily, @Nullable D delegate) {
            if (parentFamily == null) {
                BaseRegularNamedElement.$$$reportNull$$$0(1);
            }
            super(parentFamily, delegate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/BaseModel$BaseRegularNamedElement", "<init>"));
        }
    }

    public static abstract class LightBaseRegularNamedElement
    extends LightBaseRegularElement
    implements BasicModNamedElement {
        @NotNull
        private String myName = ModelConsts.NO_NAME;
        private short myFlags = 0;

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                LightBaseRegularNamedElement.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name2) {
            if (name2 == null) {
                LightBaseRegularNamedElement.$$$reportNull$$$0(1);
            }
            this.myName = BaseModel.deduplicate(name2);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.getFlag((short)1);
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            this.setFlagProperty((short)1, nameSurrogate);
        }

        @Override
        public boolean isNameScripted() {
            return this.getFlag((short)2);
        }

        @Override
        public void setNameScripted(boolean nameScripted) {
            this.setFlagProperty((short)2, nameScripted);
        }

        @Override
        public boolean isNameQuoted() {
            return this.getFlag((short)4);
        }

        @Override
        public void setNameQuoted(boolean nameQuoted) {
            this.setFlagProperty((short)4, nameQuoted);
        }

        @Override
        public boolean isOutdated() {
            return this.getFlag((short)8);
        }

        @Override
        public void setOutdated(boolean outdated) {
            this.setFlagProperty((short)8, outdated);
        }

        private void setFlagProperty(short flag, boolean value) {
            this.setFlag(flag, value);
        }

        private boolean getFlag(short flag) {
            return (this.myFlags & flag) != 0;
        }

        private void setFlag(short flag, boolean value) {
            this.myFlags = value ? (short)(this.myFlags | flag) : (short)(this.myFlags & ~flag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$LightBaseRegularNamedElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$LightBaseRegularNamedElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseRegularElement<D extends BasicModElement>
    extends BaseElement<D> {
        @NotNull
        protected final BaseFamily<D, ? extends BaseElement<D>> myParentFamily;
        @Nullable
        private transient String myDisplayOrder;
        private transient boolean myDropped;
        private transient boolean mySyncPending;

        public BaseRegularElement(@NotNull BaseFamily<D, ? extends BaseElement<D>> parentFamily) {
            if (parentFamily == null) {
                BaseRegularElement.$$$reportNull$$$0(0);
            }
            this(parentFamily, null);
        }

        public BaseRegularElement(@NotNull BaseFamily<D, ? extends BaseElement<D>> parentFamily, @Nullable D delegate) {
            if (parentFamily == null) {
                BaseRegularElement.$$$reportNull$$$0(1);
            }
            super(delegate);
            this.myDisplayOrder = null;
            this.myDropped = false;
            this.mySyncPending = false;
            this.myParentFamily = parentFamily;
            this.myDelegate = delegate == null ? this.getMetaObject().newDataObject() : delegate;
        }

        @NotNull
        public BaseFamily<D, ? extends BaseElement<D>> getParentFamily() {
            BaseFamily<D, ? extends BaseElement<D>> baseFamily = this.myParentFamily;
            if (baseFamily == null) {
                BaseRegularElement.$$$reportNull$$$0(2);
            }
            return baseFamily;
        }

        @Override
        @NotNull
        public BasicMetaObject<D> getMetaObject() {
            BasicMetaObject basicMetaObject = ((BaseFamily)this.getParentFamily()).getMetaObject();
            if (basicMetaObject == null) {
                BaseRegularElement.$$$reportNull$$$0(3);
            }
            return basicMetaObject;
        }

        @Override
        protected void modifying(boolean delegate) {
            super.modifying(delegate);
            this.myDisplayOrder = null;
        }

        @Override
        @NotNull
        public final String getDisplayOrder() {
            String o = this.myDisplayOrder;
            if (o == null) {
                this.myDisplayOrder = o = this.calculateDisplayOrder();
            }
            String string = o;
            if (string == null) {
                BaseRegularElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            this.mySyncPending = syncPending;
        }

        @Override
        public boolean isSyncPending() {
            return this.mySyncPending;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            this.getModel().doingObjectRemove(this);
            BasicModElement.dropChildren(this);
            if (removeFromParent) {
                ((BaseFamily)this.getParentFamily()).remove(e -> e == this);
            }
            this.myDropped = true;
        }

        @Override
        public boolean isDropped() {
            return this.myDropped;
        }

        public String toString() {
            return this.identity(true) + ": " + StringUtil.toLowerCase((String)this.getKind().name());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFamily";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseRegularElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseRegularElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentFamily";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaObject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class LightBaseRegularElement
    extends LightBaseElement {
        @Nullable
        public Family<?> getParentFamily() {
            return null;
        }

        @Override
        @NotNull
        public final String getDisplayOrder() {
            if ("\uffff" == null) {
                LightBaseRegularElement.$$$reportNull$$$0(0);
            }
            return "\uffff";
        }

        public String toString() {
            return this.identity(true) + ": " + this.getKind().name().toLowerCase(Locale.ROOT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/BaseModel$LightBaseRegularElement", "getDisplayOrder"));
        }
    }

    public static abstract class BaseRoot<D extends BasicModRoot>
    extends BaseElement<D>
    implements BasicModRoot {
        protected BaseRoot() {
            super(null);
            this.myDelegate = this.getMetaObject().newDataObject();
        }

        protected BaseRoot(@NotNull D delegate) {
            if (delegate == null) {
                BaseRoot.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @Nullable
        public BaseElement<?> getParent() {
            return null;
        }

        @Override
        @Nullable
        public BasicSchema getSchema() {
            return null;
        }

        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                BaseRoot.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDisplayOrder() {
            String string = this.calculateDisplayOrder();
            if (string == null) {
                BaseRoot.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            if (syncPending) {
                throw new IllegalStateException("Cannot set the root element as sync pending");
            }
        }

        @Override
        public boolean isSyncPending() {
            return false;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            throw new IllegalStateException("Cannot drop a root element");
        }

        @Override
        public boolean isDropped() {
            return false;
        }

        public String toString() {
            return "ROOT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class LightBaseRoot
    extends LightBaseElement
    implements BasicModRoot {
        @NotNull
        protected Dbms validateDbms(@NotNull Dbms dbms) {
            if (dbms == null) {
                LightBaseRoot.$$$reportNull$$$0(0);
            }
            if (this.getMetaObject().getModel() != DbImplUtil.getMetaModel(dbms)) {
                throw new AssertionError((Object)(dbms.getName() + " does not match " + this.getMetaObject().getModel().dbms));
            }
            Dbms dbms2 = dbms;
            if (dbms2 == null) {
                LightBaseRoot.$$$reportNull$$$0(1);
            }
            return dbms2;
        }

        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                LightBaseRoot.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDisplayOrder() {
            String string = this.calculateDisplayOrder();
            if (string == null) {
                LightBaseRoot.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String toString() {
            return "ROOT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$LightBaseRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$LightBaseRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validateDbms";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "validateDbms";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseElement<D extends BasicModElement>
    implements BasicModElement {
        protected D myDelegate;

        protected BaseElement(@Nullable D delegate) {
            this.myDelegate = delegate;
        }

        @NotNull
        public abstract BasicMetaObject<D> getMetaObject();

        @Override
        @NotNull
        public abstract BaseModel getModel();

        protected void modifying(boolean delegate) {
            this.getModel().doingObjectModify(this);
            if (delegate && this.isCow()) {
                D newDelegate = this.getMetaObject().newDataObject();
                BasicMetaUtils.copyProperties(this.myDelegate, newDelegate, false);
                this.myDelegate = newDelegate;
            }
        }

        public boolean isCow() {
            return !(this.myDelegate instanceof LightBaseElement);
        }

        public void substitute(@NotNull BasicElement e, boolean recursive) {
            if (e == null) {
                BaseElement.$$$reportNull$$$0(0);
            }
            assert (e instanceof BaseElement) : "Only for hierarchical objects";
            this.substituteImpl((BaseElement)e, recursive);
        }

        public void substituteChildren(@NotNull BasicElement e) {
            if (e == null) {
                BaseElement.$$$reportNull$$$0(1);
            }
            assert (e instanceof BaseElement) : "Only for hierarchical objects";
            for (ModFamily<? extends BasicModElement> modFamily : this.getFamilies()) {
                BaseElement.substituteFamily((BaseElement)e, modFamily);
            }
        }

        @NotNull
        private static <D extends BasicModElement, E extends BaseElement<D>> BaseFamily<D, E> sameFamily(BasicModElement e, BaseFamily<D, E> f) {
            BaseFamily baseFamily = (BaseFamily)ObjectUtils.notNull((Object)((BaseFamily)e.familyOf(f.getMetaObject().kind)));
            if (baseFamily == null) {
                BaseElement.$$$reportNull$$$0(2);
            }
            return baseFamily;
        }

        protected void substituteImpl(@NotNull BaseElement<D> what, boolean recursive) {
            if (what == null) {
                BaseElement.$$$reportNull$$$0(3);
            }
            assert (what.getMetaObject() == this.getMetaObject()) : "Wrong object";
            if (this.myDelegate == what) {
                return;
            }
            this.myDelegate = what.selfAsDelegate();
            if (recursive) {
                for (ModFamily<? extends BasicModElement> modFamily : this.getFamilies()) {
                    BaseElement.substituteFamily(what, modFamily);
                }
            }
        }

        D selfAsDelegate() {
            return (D)this;
        }

        private static void substituteFamily(@NotNull BaseElement<?> what, ModFamily<?> family) {
            if (what == null) {
                BaseElement.$$$reportNull$$$0(4);
            }
            BaseElement.substituteFamily(what, (BaseFamily)family);
        }

        private static <D extends BasicModElement, E extends BaseElement<D>> void substituteFamily(@NotNull BaseElement<?> what, BaseFamily<D, E> family) {
            if (what == null) {
                BaseElement.$$$reportNull$$$0(5);
            }
            BaseElement.substituteFamilies(BaseElement.sameFamily(what, family), family);
        }

        private static <D extends BasicModElement, E extends BaseElement<D>> void substituteFamilies(@NotNull BaseFamily<D, E> what, @NotNull BaseFamily<D, E> where) {
            if (what == null) {
                BaseElement.$$$reportNull$$$0(6);
            }
            if (where == null) {
                BaseElement.$$$reportNull$$$0(7);
            }
            assert (what.getMetaObject() == where.getMetaObject()) : "Wrong object";
            if (where.size() == what.size()) {
                Iterator<E> fromIt = what.iterator();
                Iterator<E> toIt = where.iterator();
                while (fromIt.hasNext() && toIt.hasNext()) {
                    ((BaseElement)toIt.next()).substituteImpl((BaseElement)fromIt.next(), true);
                }
            } else {
                where.clear();
                for (BaseElement element2 : what) {
                    ((BaseElement)where.createNewOne(element2)).substituteChildren(element2);
                }
            }
        }

        @Override
        public void drop() {
            this.internalDrop(true);
        }

        abstract void internalDrop(boolean var1);

        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public void resetSyncPending() {
            this.setOutdated(false);
            this.setSyncPending(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseElement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "what";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "where";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sameFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "substitute";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteChildren";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteImpl";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteFamily";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteFamilies";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class LightBaseElement
    implements BasicModElement {
        @Override
        public void drop() {
            throw new UnsupportedOperationException("Light object");
        }

        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public void resetSyncPending() {
        }

        @Override
        @Nullable
        public BasicModModel getModel() {
            return null;
        }

        @Override
        @NotNull
        public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
            List list = Collections.emptyList();
            if (list == null) {
                LightBaseElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @NotNull
        public JBIterable<? extends BasicModElement> getChildren() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                LightBaseElement.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public JBIterable<? extends BasicModElement> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                LightBaseElement.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        public @Nullable ModFamily<@NotNull ? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                LightBaseElement.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
        }

        @Override
        public boolean isSyncPending() {
            return false;
        }

        @Override
        public void setOutdated(boolean outdated) {
        }

        @Override
        public boolean isOutdated() {
            return false;
        }

        @Override
        public boolean isDropped() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$LightBaseElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$LightBaseElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "familyOf";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

