/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaUtils {
    public static final Comparator<BasicMetaProperty> PROPERTY_COMPARATOR = Comparator.comparing(p1 -> p1.name);

    @Nullable
    public static <T extends BasicModElement> BasicMetaObject<T> findChild(@Nullable BasicMetaObject<?> obj2, @NotNull ObjectKind kind) {
        if (kind == null) {
            BasicMetaUtils.$$$reportNull$$$0(0);
        }
        if (obj2 == null) {
            return null;
        }
        for (BasicMetaObject<?> child : obj2.children) {
            if (child.kind != kind) continue;
            return child;
        }
        return null;
    }

    public static void copyProperties(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(1);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(2);
        }
        BasicMetaObject<?> meta = to.getMetaObject();
        assert (meta.apiClass.isAssignableFrom(from.getClass())) : "Trying to copy " + from.getClass().getSimpleName() + " to " + to.getClass().getSimpleName();
        try {
            for (BasicMetaProperty p2 : meta.properties) {
                BasicMetaUtils.copyPropertyInner(from, p2, to, p2);
            }
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)throwable);
        }
        BasicMetaUtils.copySources(from, to, withSources);
    }

    public static void copySources(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(3);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(4);
        }
        if (to instanceof BasicModSourceAware) {
            BasicSourceAware o = withSources ? (BasicSourceAware)ObjectUtils.tryCast((Object)from, BasicSourceAware.class) : null;
            BasicModModel model = to.getModel();
            if (model != null) {
                model.writeSources(() -> ((BasicModSourceAware)to).setSourceText(o == null ? null : o.getSourceText()));
            }
        }
    }

    public static void copyMatchedProperties(@NotNull BasicElement from, @NotNull BasicModElement to, boolean resetOther, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(5);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(6);
        }
        BasicMetaObject<?> fromMeta = from.getMetaObject();
        BasicMetaObject<?> toMeta = to.getMetaObject();
        try {
            for (BasicMetaProperty p2 : toMeta.properties) {
                BasicMetaProperty p1 = BasicMetaUtils.findMatchingProperty(fromMeta.properties, p2);
                if (p1 != null) {
                    BasicMetaUtils.copyPropertyInner(from, p1, to, p2);
                    continue;
                }
                if (!resetOther) continue;
                p2.setter.invoke(to, p2.def);
            }
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)throwable);
        }
        if (to instanceof BasicModSourceAware) {
            BasicSourceAware o = (BasicSourceAware)ObjectUtils.tryCast((Object)from, BasicSourceAware.class);
            if (withSources && (o != null || resetOther)) {
                ((BasicModSourceAware)to).setSourceText(o == null ? null : o.getSourceText());
            }
        }
    }

    private static BasicMetaProperty findMatchingProperty(BasicMetaProperty[] properties2, BasicMetaProperty p2) {
        int i2 = Arrays.binarySearch(properties2, 0, properties2.length, p2, PROPERTY_COMPARATOR);
        if (i2 < 0) {
            return null;
        }
        BasicMetaProperty res2 = properties2[i2];
        if (!res2.getter.type().returnType().equals(p2.getter.type().returnType())) {
            return null;
        }
        return res2;
    }

    private static void copyPropertyInner(@NotNull BasicElement from, @NotNull BasicMetaProperty p1, @NotNull BasicModElement to, @NotNull BasicMetaProperty p2) throws Throwable {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(7);
        }
        if (p1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(8);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(9);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(10);
        }
        Object val = p1.getter.invoke(from);
        p2.setter.invoke(to, val);
    }

    public static int hashCode(@NotNull BasicElement e) {
        if (e == null) {
            BasicMetaUtils.$$$reportNull$$$0(11);
        }
        BasicMetaObject<?> meta = e.getMetaObject();
        int hash = meta.hashCode();
        try {
            for (BasicMetaProperty property : meta.properties) {
                hash = Comparing.hashcode((Object)hash, (Object)property.getter.invoke(e));
            }
        }
        catch (Throwable t) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return hash;
    }

    public static boolean equals(@NotNull BasicElement e1, @NotNull BasicElement e2) {
        BasicMetaObject<?> meta2;
        BasicMetaObject<?> meta1;
        if (e1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(12);
        }
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(13);
        }
        if ((meta1 = e1.getMetaObject()) != (meta2 = e2.getMetaObject())) {
            return false;
        }
        try {
            for (BasicMetaProperty property : meta1.properties) {
                if (Comparing.equal((Object)property.getter.invoke(e1), (Object)property.getter.invoke(e2))) continue;
                return false;
            }
        }
        catch (Throwable t) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/model/meta/BasicMetaUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findChild";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copyProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "copySources";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "copyMatchedProperties";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "copyPropertyInner";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "hashCode";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "equals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

