/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Function;

public class DbQualifiedNameProvider
implements QualifiedNameProvider {
    public PsiElement adjustElementToCopy(PsiElement element2) {
        return element2 instanceof DbElement ? element2 : null;
    }

    public String getQualifiedName(PsiElement element2) {
        if (!element2.isValid()) {
            return null;
        }
        Project project = element2.getProject();
        DbElement o = (DbElement)SqlPsiFacade.getInstance((Project)project).findRelatedDbElements(element2, true).first();
        return o == null ? null : QNameUtil.getQualifiedName(o);
    }

    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            DasObject result2 = (DasObject)QNameUtil.findByQName(dataSource.getModel(), fqn, (Function<? super DasObject, String>)DasUtil.TO_NAME).first();
            if (result2 == null) continue;
            return DbImplUtil.findElement(dataSource, result2);
        }
        return null;
    }

    public void insertQualifiedName(String fqn, PsiElement element2, Editor editor, Project project) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)fqn);
    }
}

