/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.session;

import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageBusSessionState
implements DatabaseSession.State {
    private final long myStart;
    private final long myActivation;
    private final boolean myAllowReset;
    private final List<DatabaseSession.State.Work> myWork;
    private final AtomicLong myDeactivation;

    public MessageBusSessionState() {
        this(0L, 0L, ContainerUtil.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private MessageBusSessionState(long start, long activation, @NotNull List<DatabaseSession.State.Work> list) {
        void work2;
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(0);
        }
        this(start, activation, (List<DatabaseSession.State.Work>)work2, false);
    }

    /*
     * WARNING - void declaration
     */
    private MessageBusSessionState(long start, long activation, @NotNull List<DatabaseSession.State.Work> list, boolean bl) {
        void allowReset;
        void work2;
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(1);
        }
        this.myStart = start;
        this.myWork = work2;
        this.myActivation = activation;
        this.myAllowReset = allowReset;
        this.myDeactivation = new AtomicLong(0L);
    }

    @Override
    public boolean isIdle() {
        return this.getNonFinishedWork().isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.myWork.isEmpty() || this.myActivation == 0L;
    }

    @Override
    public long getStartTime() {
        return this.myStart;
    }

    @Override
    public long getTimeSpentMs() {
        return this.isIdle() ? this.findLastFinishTime() - this.myActivation : System.currentTimeMillis() - (this.myActivation == 0L ? this.myStart : this.myActivation);
    }

    @Override
    @NotNull
    public List<DatabaseSession.State.Work> getWork() {
        List<DatabaseSession.State.Work> list = this.myWork;
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public MessageBusSessionState update() {
        MessageBusSessionState messageBusSessionState = new MessageBusSessionState(this.myStart, this.myActivation, this.myWork, this.isIdle());
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(3);
        }
        return messageBusSessionState;
    }

    @Override
    @Nullable
    public DatabaseSession.State.Work getWorkFor(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            MessageBusSessionState.$$$reportNull$$$0(4);
        }
        List workByOwner = ContainerUtil.filter(this.myWork, w -> w.getRequest().owner == owner);
        List sorted = ContainerUtil.sorted((Collection)workByOwner, (w1, w2) -> {
            DatabaseSession.State.WorkState s2;
            DatabaseSession.State.WorkState s1 = w1.getState();
            return s1 == (s2 = w2.getState()) ? Long.compare(((Work)w2).myFinished, ((Work)w1).myFinished) : (s1 == DatabaseSession.State.WorkState.RUNNING ? -1 : (s2 == DatabaseSession.State.WorkState.FINISHED ? -1 : 1));
        });
        return (DatabaseSession.State.Work)ContainerUtil.getFirstItem((List)sorted);
    }

    @NotNull
    public MessageBusSessionState resetIfEmpty() {
        MessageBusSessionState messageBusSessionState = this.myAllowReset ? new MessageBusSessionState(0L, 0L, ContainerUtil.emptyList()) : this;
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(5);
        }
        return messageBusSessionState;
    }

    @NotNull
    public MessageBusSessionState plus(@NotNull DataRequest request, long time) {
        if (request == null) {
            MessageBusSessionState.$$$reportNull$$$0(6);
        }
        MessageBusSessionState messageBusSessionState = this.plus(new Work(request, DatabaseSession.State.WorkState.SUBMITTED, time, 0L));
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(7);
        }
        return messageBusSessionState;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MessageBusSessionState activate(long startTime, @NotNull DataRequest dataRequest) {
        void request;
        if (dataRequest == null) {
            MessageBusSessionState.$$$reportNull$$$0(8);
        }
        long activation = this.myActivation == 0L ? startTime : this.myActivation;
        Work work2 = (Work)ContainerUtil.find(this.myWork, arg_0 -> MessageBusSessionState.lambda$activate$2((DataRequest)request, arg_0));
        MessageBusSessionState messageBusSessionState = work2 == null ? this : this.remove((DataRequest)request).add(work2.running(startTime)).withProperties(this.myStart, activation);
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(9);
        }
        return messageBusSessionState;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MessageBusSessionState deactivate(long finishTime, @NotNull DataRequest dataRequest) {
        void request;
        Work work2;
        if (dataRequest == null) {
            MessageBusSessionState.$$$reportNull$$$0(10);
        }
        MessageBusSessionState messageBusSessionState = (work2 = (Work)ContainerUtil.find(this.myWork, arg_0 -> MessageBusSessionState.lambda$deactivate$3((DataRequest)request, arg_0))) == null ? this : this.remove((DataRequest)request).add(work2.stopped(finishTime));
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(11);
        }
        return messageBusSessionState;
    }

    @NotNull
    private MessageBusSessionState withProperties(long startTime, long activation) {
        MessageBusSessionState messageBusSessionState = new MessageBusSessionState(startTime, activation, this.myWork);
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(12);
        }
        return messageBusSessionState;
    }

    private long findLastFinishTime() {
        long value = this.myDeactivation.get();
        if (value != 0L) {
            return value;
        }
        List sorted = ContainerUtil.sorted(this.myWork, Comparator.comparingLong(w -> ((Work)w).myFinished).reversed());
        Work first2 = (Work)ContainerUtil.getFirstItem((List)sorted);
        if (first2 != null) {
            this.myDeactivation.compareAndSet(0L, first2.myFinished);
        }
        return this.myDeactivation.get();
    }

    @NotNull
    private MessageBusSessionState remove(@NotNull DataRequest request) {
        if (request == null) {
            MessageBusSessionState.$$$reportNull$$$0(13);
        }
        List work2 = ContainerUtil.filter(this.myWork, w -> w.getRequest() != request);
        MessageBusSessionState messageBusSessionState = new MessageBusSessionState(this.myStart, this.myActivation, work2);
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(14);
        }
        return messageBusSessionState;
    }

    @NotNull
    private MessageBusSessionState plus(@NotNull Work newWork) {
        if (newWork == null) {
            MessageBusSessionState.$$$reportNull$$$0(15);
        }
        List work2 = ContainerUtil.concat(this.myWork, Collections.singletonList(newWork));
        MessageBusSessionState messageBusSessionState = new MessageBusSessionState(this.myWork.isEmpty() ? newWork.getStartTime() : this.myStart, this.myActivation, work2);
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(16);
        }
        return messageBusSessionState;
    }

    @NotNull
    private MessageBusSessionState add(@NotNull Work newWork) {
        if (newWork == null) {
            MessageBusSessionState.$$$reportNull$$$0(17);
        }
        List work2 = ContainerUtil.concat(this.myWork, Collections.singletonList(newWork));
        MessageBusSessionState messageBusSessionState = new MessageBusSessionState(this.myStart, this.myActivation, work2);
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(18);
        }
        return messageBusSessionState;
    }

    @NotNull
    private List<DatabaseSession.State.Work> getNonFinishedWork() {
        List list = ContainerUtil.filter(this.myWork, w -> !((Work)w).isFinished());
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ boolean lambda$deactivate$3(DataRequest request, DatabaseSession.State.Work w) {
        return w.getRequest() == request;
    }

    private static /* synthetic */ boolean lambda$activate$2(DataRequest request, DatabaseSession.State.Work w) {
        return w.getRequest() == request;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "work";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/session/MessageBusSessionState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newWork";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/session/MessageBusSessionState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWork";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resetIfEmpty";
                break;
            }
            case 7: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "activate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deactivate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withProperties";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonFinishedWork";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWorkFor";
                break;
            }
            case 6: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Work
    implements DatabaseSession.State.Work {
        private final long myStart;
        private final DataRequest myRequest;
        private final DatabaseSession.State.WorkState myState;
        private final long myFinished;

        /*
         * WARNING - void declaration
         */
        Work(@NotNull DataRequest request, @NotNull DatabaseSession.State.WorkState state2, long start, long l) {
            void finished;
            if (request == null) {
                Work.$$$reportNull$$$0(0);
            }
            if (state2 == null) {
                Work.$$$reportNull$$$0(1);
            }
            this.myStart = start;
            this.myRequest = request;
            this.myState = state2;
            this.myFinished = finished;
        }

        @Override
        @NotNull
        public DataRequest getRequest() {
            DataRequest dataRequest = this.myRequest;
            if (dataRequest == null) {
                Work.$$$reportNull$$$0(2);
            }
            return dataRequest;
        }

        @NotNull
        public Work running(long time) {
            Work work2 = new Work(this.myRequest, DatabaseSession.State.WorkState.RUNNING, time, 0L);
            if (work2 == null) {
                Work.$$$reportNull$$$0(3);
            }
            return work2;
        }

        @NotNull
        public Work stopped(long time) {
            Work work2 = new Work(this.myRequest, DatabaseSession.State.WorkState.FINISHED, this.myStart, this.myState == DatabaseSession.State.WorkState.FINISHED ? this.myFinished : time);
            if (work2 == null) {
                Work.$$$reportNull$$$0(4);
            }
            return work2;
        }

        @Override
        public long getTimeSpentMs() {
            return this.isFinished() ? this.myFinished - this.myStart : System.currentTimeMillis() - this.myStart;
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkState getState() {
            DatabaseSession.State.WorkState workState = this.myState;
            if (workState == null) {
                Work.$$$reportNull$$$0(5);
            }
            return workState;
        }

        boolean isFinished() {
            return this.myFinished != 0L;
        }

        long getStartTime() {
            return this.myStart;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/session/MessageBusSessionState$Work";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/session/MessageBusSessionState$Work";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequest";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "running";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stopped";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

