/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.FakeRangeFormatter;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.RangeFormatResolver;
import com.intellij.database.run.ui.grid.editors.lexers.PgRangeLexerAdapter;
import com.intellij.database.run.ui.grid.editors.lexers.PgRangeTokens;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.io.Serializable;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultRangeEditorFactory
extends FormatBasedGridCellEditorFactory {
    private static final char ELLIPSIS = '\u2026';

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(2);
        }
        DataConsumer.Column c2 = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column2));
        Dbms dbms = DataGridUtil.getDbms(grid);
        return dbms.isPostgres() && ObjectFormatter.isPostgresRangeType(c2) ? 1 : 0;
    }

    @Override
    @NotNull
    protected Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(3);
        }
        if (row == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(5);
        }
        DataConsumer.Column c2 = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column2));
        Dbms dbms = DataGridUtil.getDbms(grid);
        FakeRangeFormatter fakeRangeFormatter = RangeFormatResolver.resolveFormatter(grid.getObjectFormatter(), c2, dbms);
        if (fakeRangeFormatter == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(6);
        }
        return fakeRangeFormatter;
    }

    @Override
    protected boolean makeFormatterLenient(@NotNull DataGrid grid) {
        if (grid == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(7);
        }
        return false;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, final @NotNull DataGrid grid, final @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (project == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(8);
        }
        if (grid == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(9);
        }
        if (format == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(10);
        }
        if (column2 == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(11);
        }
        FormatBasedGridCellEditor.BoundedFormatBasedGridCellEditor<FakeRangeFormatter.ParsedRange> boundedFormatBasedGridCellEditor = new FormatBasedGridCellEditor.BoundedFormatBasedGridCellEditor<FakeRangeFormatter.ParsedRange>(project, grid, format, value, nullValue, initiator, column2, provider){
            private final FakeRangeFormatter myFormatter;
            {
                super(project, grid2, format2, value, nullValue, initiator, columnModelIndex, provider);
                this.myFormatter = (FakeRangeFormatter)format;
            }

            @Override
            @NotNull
            protected Object convertInternalValue(@NotNull FakeRangeFormatter.ParsedRange internalValue) {
                if (internalValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = this.myFormatter.rebuild(internalValue);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @Nullable
            protected FakeRangeFormatter.ParsedRange getInternalValue() {
                return this.myFormatter.parseHonestly(this.getTextField().getText());
            }

            @Override
            protected String getInfinityString(@NotNull FakeRangeFormatter.ParsedRange internalValue) {
                Pair<String, String> values2;
                if (internalValue == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (values2 = this.getRangeValues(internalValue)) == null ? null : this.buildRangeString(internalValue, values2);
            }

            @Override
            protected boolean isSameValueInEditor(@NotNull FakeRangeFormatter.ParsedRange internalValue, @NotNull String boundaryString) {
                if (internalValue == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (boundaryString == null) {
                    1.$$$reportNull$$$0(4);
                }
                PgRangeLexerAdapter lexer = new PgRangeLexerAdapter();
                Pair rangeValues = (Pair)ObjectUtils.assertNotNull(this.getRangeValues(internalValue));
                lexer.start(this.getTextField().getText());
                return !(this.hasNextSuitableToken((Lexer)lexer, PgRangeTokens.COMMA) && !this.itWasInfinity((String)rangeValues.getFirst(), (Lexer)lexer) || this.hasNextSuitableToken((Lexer)lexer, PgRangeTokens.RIGHT_BRACKET) && !this.itWasInfinity((String)rangeValues.getSecond(), (Lexer)lexer));
            }

            private boolean hasNextSuitableToken(@NotNull Lexer lexer, @NotNull IElementType endToken) {
                if (lexer == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (endToken == null) {
                    1.$$$reportNull$$$0(6);
                }
                while (lexer.getTokenType() != null && lexer.getTokenType() != PgRangeTokens.VALUE && lexer.getTokenType() != endToken) {
                    lexer.advance();
                }
                return lexer.getTokenType() == PgRangeTokens.VALUE;
            }

            private boolean itWasInfinity(String rangeValue, Lexer lexer) {
                GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
                BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(DataGridUtil.getDbms(grid), (DataConsumer.Column)model.getColumn(this.myColumnModelIndex));
                Object infinity = resolver.createFromInfinityString(lexer.getTokenText());
                lexer.advance();
                return infinity != null || rangeValue == null;
            }

            private String buildRangeString(@NotNull FakeRangeFormatter.ParsedRange internalValue, @NotNull Pair<String, String> rangeValues) {
                if (internalValue == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (rangeValues == null) {
                    1.$$$reportNull$$$0(8);
                }
                return internalValue.getLeftBrace() + (rangeValues.getFirst() == null ? Character.valueOf('\u2026') : (Serializable)rangeValues.getFirst()) + ',' + (rangeValues.getSecond() == null ? Character.valueOf('\u2026') : (Serializable)rangeValues.getSecond()) + internalValue.getRightBrace();
            }

            private Pair<String, String> getRangeValues(@NotNull FakeRangeFormatter.ParsedRange internalValue) {
                if (internalValue == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (internalValue == FakeRangeFormatter.ParsedRange.EMPTY) {
                    return null;
                }
                Object start = internalValue.getStart();
                Object end = internalValue.getEnd();
                GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
                BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(DataGridUtil.getDbms(grid), (DataConsumer.Column)model.getColumn(this.myColumnModelIndex));
                String startString = start == null ? null : resolver.resolve(start);
                String endString = end == null ? null : resolver.resolve(end);
                return startString == null && endString == null ? null : Pair.create((Object)startString, (Object)endString);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "internalValue";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "boundaryString";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endToken";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rangeValues";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertInternalValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertInternalValue";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getInfinityString";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "isSameValueInEditor";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "hasNextSuitableToken";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "buildRangeString";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangeValues";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (boundedFormatBasedGridCellEditor == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(12);
        }
        return boundedFormatBasedGridCellEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFormat";
                break;
            }
            case 6: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "makeFormatterLenient";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

