/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.lexers.PgRangeLexerAdapter;
import com.intellij.database.run.ui.grid.editors.lexers.PgRangeTokens;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.text.ParseException;
import java.text.ParsePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeRangeFormatter
implements Formatter {
    @NotNull
    private final Formatter myFormatter;

    public FakeRangeFormatter(@NotNull Formatter formatter) {
        if (formatter == null) {
            FakeRangeFormatter.$$$reportNull$$$0(0);
        }
        this.myFormatter = formatter;
    }

    @Override
    @Nullable
    public Object parse(@NotNull String value) throws ParseException {
        if (value == null) {
            FakeRangeFormatter.$$$reportNull$$$0(1);
        }
        try {
            return this.rebuild(this.parseInternal(value, new ParsePosition(0)));
        }
        catch (TokenizeException e) {
            throw new ParseException(value, e.getPosition());
        }
    }

    @Override
    @Nullable
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        if (value == null) {
            FakeRangeFormatter.$$$reportNull$$$0(2);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(3);
        }
        try {
            return this.rebuild(this.parseInternal(value, position));
        }
        catch (TokenizeException e) {
            position.setErrorIndex(e.getPosition());
            return null;
        }
    }

    public ParsedRange parseHonestly(@NotNull String value) {
        if (value == null) {
            FakeRangeFormatter.$$$reportNull$$$0(4);
        }
        return this.parseInternal(value, new ParsePosition(0));
    }

    @NotNull
    private ParsedRange parseInternal(@NotNull String value, @NotNull ParsePosition position) {
        if (value == null) {
            FakeRangeFormatter.$$$reportNull$$$0(5);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(6);
        }
        PgRangeLexerAdapter lexer = new PgRangeLexerAdapter();
        lexer.start(value);
        if (lexer.getTokenType() == PgRangeTokens.EMPTY) {
            ParsedRange parsedRange = ParsedRange.EMPTY;
            if (parsedRange == null) {
                FakeRangeFormatter.$$$reportNull$$$0(7);
            }
            return parsedRange;
        }
        String leftBrace = FakeRangeFormatter.getTokenText((Lexer)lexer, PgRangeTokens.LEFT_BRACKET, position);
        FakeRangeFormatter.advance((Lexer)lexer);
        Pair<Object, String> first2 = this.getValueAndNext((Lexer)lexer, position, PgRangeTokens.COMMA);
        FakeRangeFormatter.advance((Lexer)lexer);
        Pair<Object, String> second = this.getValueAndNext((Lexer)lexer, position, PgRangeTokens.RIGHT_BRACKET);
        FakeRangeFormatter.advance((Lexer)lexer);
        FakeRangeFormatter.checkType((Lexer)lexer, null, position);
        ParsedRange parsedRange = new ParsedRange(first2.getFirst(), second.getFirst(), leftBrace, (String)second.getSecond(), value);
        if (parsedRange == null) {
            FakeRangeFormatter.$$$reportNull$$$0(8);
        }
        return parsedRange;
    }

    @NotNull
    private Pair<Object, String> getValueAndNext(@NotNull Lexer lexer, @NotNull ParsePosition position, IElementType next) {
        Pair pair;
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(9);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(10);
        }
        try {
            FakeRangeFormatter.checkType(lexer, PgRangeTokens.VALUE, position, false);
            Object result2 = this.myFormatter.parse(StringUtil.replace((String)lexer.getTokenText(), (String)"\"", (String)""));
            FakeRangeFormatter.advance(lexer);
            pair = Pair.create((Object)result2, (Object)FakeRangeFormatter.getTokenText(lexer, next, position));
        }
        catch (TokenizeException | ParseException ignore) {
            Pair pair2 = Pair.create(null, (Object)FakeRangeFormatter.getTokenText(lexer, next, position));
            if (pair2 == null) {
                FakeRangeFormatter.$$$reportNull$$$0(12);
            }
            return pair2;
        }
        if (pair == null) {
            FakeRangeFormatter.$$$reportNull$$$0(11);
        }
        return pair;
    }

    private static void advance(@NotNull Lexer lexer) {
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(13);
        }
        lexer.advance();
        while (lexer.getTokenType() == TokenType.WHITE_SPACE) {
            lexer.advance();
        }
    }

    private static String getTokenText(@NotNull Lexer lexer, IElementType type, @NotNull ParsePosition position) {
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(14);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(15);
        }
        FakeRangeFormatter.checkType(lexer, type, position);
        return lexer.getTokenText();
    }

    private static void checkType(@NotNull Lexer lexer, IElementType type, @NotNull ParsePosition position) {
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(16);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(17);
        }
        FakeRangeFormatter.checkType(lexer, type, position, true);
    }

    private static void checkType(@NotNull Lexer lexer, IElementType type, @NotNull ParsePosition position, boolean updatePosition) {
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(18);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(19);
        }
        if (lexer.getTokenType() != type) {
            throw new TokenizeException(lexer.getCurrentPosition().getOffset());
        }
        if (updatePosition) {
            position.setIndex(lexer.getCurrentPosition().getOffset());
        }
    }

    @Override
    @NotNull
    public String format(@NotNull Object value) {
        if (value == null) {
            FakeRangeFormatter.$$$reportNull$$$0(20);
        }
        String string = (String)value;
        if (string == null) {
            FakeRangeFormatter.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String rebuild(@NotNull ParsedRange range) {
        if (range == null) {
            FakeRangeFormatter.$$$reportNull$$$0(22);
        }
        String stringValue = range.getString();
        if (range == ParsedRange.EMPTY) {
            String string = stringValue;
            if (string == null) {
                FakeRangeFormatter.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = range.getLeftBrace() + (range.getStart() != null ? this.myFormatter.format(range.getStart()) : "") + "," + (range.getEnd() != null ? this.myFormatter.format(range.getEnd()) : "") + range.getRightBrace();
        if (string == null) {
            FakeRangeFormatter.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.myFormatter.toString() + ", " + this.myFormatter.toString();
        if (string == null) {
            FakeRangeFormatter.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseInternal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAndNext";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuild";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseHonestly";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseInternal";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValueAndNext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "advance";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTokenText";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "rebuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TokenizeException
    extends RuntimeException {
        private final int myPosition;

        TokenizeException(int position) {
            this.myPosition = position;
        }

        public int getPosition() {
            return this.myPosition;
        }
    }

    public static class ParsedRange {
        public static final ParsedRange EMPTY = new ParsedRange(null, null, null, null, "empty");
        private final Object myStart;
        private final Object myEnd;
        private final String myString;
        private final String myLeftBrace;
        private final String myRightBrace;

        ParsedRange(Object start, Object end, String leftBrace, String rightBrace, String string) {
            this.myStart = start;
            this.myEnd = end;
            this.myLeftBrace = leftBrace;
            this.myRightBrace = rightBrace;
            this.myString = string;
        }

        public Object getStart() {
            return this.myStart;
        }

        public Object getEnd() {
            return this.myEnd;
        }

        public String getString() {
            return this.myString;
        }

        public String getLeftBrace() {
            return this.myLeftBrace;
        }

        public String getRightBrace() {
            return this.myRightBrace;
        }
    }
}

