/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.run.ui.grid.renderers.DefaultBooleanRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultNumericRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GridCellRendererFactories {
    private static final GridCellRendererFactories INSTANCE = new GridCellRendererFactories();
    private final List<GridCellRendererFactory> myDefaultFactories = Arrays.asList(new DefaultBooleanRendererFactory(), new DefaultNumericRendererFactory(), new DefaultTextRendererFactory());

    GridCellRendererFactories() {
    }

    public static GridCellRendererFactories getInstance() {
        return INSTANCE;
    }

    public ImmutableList<GridCellRendererFactory> getFactoriesFor(@NotNull DatabaseDialect dialect, @NotNull DataConsumer.Column column2) {
        if (dialect == null) {
            GridCellRendererFactories.$$$reportNull$$$0(0);
        }
        if (column2 == null) {
            GridCellRendererFactories.$$$reportNull$$$0(1);
        }
        return ContainerUtil.immutableList((List)ContainerUtil.filter(this.myDefaultFactories, factory -> factory.supportsDialect(dialect) && factory.supportsColumn(column2)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "column";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/grid/renderers/GridCellRendererFactories";
        objectArray[2] = "getFactoriesFor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

