/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAltNamesProvider;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlImplicitSymbol;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameChecker {
    public final String sourceText;
    public final boolean sourcePlain;
    @Nullable
    public final SqlLanguageDialect dialect;
    public final CasingProvider casingProvider;
    public final String[] actualCache;

    public NameChecker(@NotNull String name2, boolean quoted, @NotNull CasingProvider provider, @Nullable SqlLanguageDialect dialect) {
        if (name2 == null) {
            NameChecker.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            NameChecker.$$$reportNull$$$0(1);
        }
        this.actualCache = new String[2];
        this.dialect = dialect;
        this.sourcePlain = !quoted;
        this.sourceText = name2;
        this.casingProvider = provider;
    }

    public NameChecker(@NotNull DasObject object, @NotNull SqlLanguageDialect dialect) {
        if (object == null) {
            NameChecker.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            NameChecker.$$$reportNull$$$0(3);
        }
        this(object.getName(), DbSqlUtil.isQuoted(object), (CasingProvider)dialect, dialect);
    }

    public NameChecker(@NotNull SqlReferenceExpression ref, @NotNull SqlLanguageDialect dialect, CasingProvider provider) {
        if (ref == null) {
            NameChecker.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            NameChecker.$$$reportNull$$$0(5);
        }
        this(ref.getName(), DbSqlUtil.isQuoted((SqlNameElement)ref), provider, dialect);
    }

    @Nullable
    private static DasObject getDasContext(@Nullable SqlExpression qualifier) {
        PsiReference reference = qualifier == null ? null : qualifier.getReference();
        PsiElement target2 = reference == null ? null : reference.resolve();
        return target2 instanceof DasObject ? (DasObject)target2 : null;
    }

    @Nullable
    private static String getName(@NotNull Object target2) {
        if (target2 == null) {
            NameChecker.$$$reportNull$$$0(6);
        }
        if (target2 instanceof DasObject) {
            return ((DasObject)target2).getName();
        }
        if (target2 instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)target2).getName();
        }
        if (target2 instanceof PomNamedTarget) {
            return ((PomNamedTarget)target2).getName();
        }
        return null;
    }

    private static boolean isQuoted(@NotNull Object target2) {
        if (target2 == null) {
            NameChecker.$$$reportNull$$$0(7);
        }
        if (target2 instanceof DasObject) {
            return DbSqlUtil.isQuoted((DasObject)target2);
        }
        if (target2 instanceof SqlReferenceExpression) {
            return DbSqlUtil.isQuoted((SqlNameElement)((SqlReferenceExpression)target2));
        }
        return false;
    }

    public boolean checkName(@Nullable Object target2, @Nullable Boolean forcedCaseSens) {
        boolean caseSensitive;
        if (target2 == null) {
            return false;
        }
        String name2 = NameChecker.getName(target2);
        if (name2 == null) {
            throw new IllegalArgumentException(target2.getClass().getName());
        }
        if (!NameChecker.compareNames(target2, name2, this.sourceText, false) && (name2 = this.getAltName(target2)) == null) {
            return false;
        }
        boolean isBuiltInFunction = target2 instanceof BuiltinFunction;
        if (this.dialect != null) {
            Dbms dbms = this.dialect.getDbms();
            if (isBuiltInFunction && dbms.isSybase()) {
                return true;
            }
            if (isBuiltInFunction && dbms.isTransactSql() && ((BuiltinFunction)target2).getPostfixType() == null) {
                return this.sourcePlain;
            }
        }
        boolean targetIsPlain = !NameChecker.isQuoted(target2);
        Casing inPlaceCasing = NameChecker.getCasing(target2, this.casingProvider);
        Case targetCase = inPlaceCasing.choose(targetIsPlain);
        Case sourceCase = inPlaceCasing.choose(this.sourcePlain);
        String targetActual = NameChecker.getActualName(target2, name2, targetIsPlain, this.casingProvider);
        if (forcedCaseSens != null) {
            return this.compareWithSource(target2, targetActual, sourceCase, forcedCaseSens == Boolean.TRUE);
        }
        if (isBuiltInFunction) {
            return this.compareWithSource(target2, targetActual, sourceCase, sourceCase == Case.EXACT && !this.sourcePlain);
        }
        boolean targetCaseSensitive = targetCase != Case.MIXED;
        boolean sourceCaseSensitive = sourceCase != Case.MIXED;
        boolean bl = caseSensitive = sourceCaseSensitive && targetCaseSensitive;
        return this.compareWithSource(target2, targetActual, sourceCase, caseSensitive);
    }

    @Nullable
    protected String getAltName(@NotNull Object target2) {
        SqlAltNamesProvider altNames;
        if (target2 == null) {
            NameChecker.$$$reportNull$$$0(8);
        }
        if ((altNames = (SqlAltNamesProvider)ObjectUtils.tryCast((Object)target2, SqlAltNamesProvider.class)) == null) {
            return null;
        }
        for (String text2 : altNames.getAltNames()) {
            if (!NameChecker.compareNames(target2, text2, this.sourceText, false)) continue;
            return text2;
        }
        return null;
    }

    @NotNull
    private static Casing getCasing(@NotNull Object target2, CasingProvider casingProvider) {
        if (target2 == null) {
            NameChecker.$$$reportNull$$$0(9);
        }
        if (target2 instanceof PomTargetPsiElement) {
            PomTarget pomTarget = ((PomTargetPsiElement)target2).getTarget();
            if (pomTarget instanceof SqlImplicitSymbol) {
                PsiElement definition = ((SqlImplicitSymbol)pomTarget).getTargetDefinition();
                Casing casing = definition != null ? NameChecker.getCasing(definition, casingProvider) : Casing.EXACT;
                if (casing == null) {
                    NameChecker.$$$reportNull$$$0(10);
                }
                return casing;
            }
            Casing casing = Casing.EXACT;
            if (casing == null) {
                NameChecker.$$$reportNull$$$0(11);
            }
            return casing;
        }
        DasObject object = (DasObject)ObjectUtils.tryCast((Object)target2, DasObject.class);
        if (object != null) {
            Casing casing = casingProvider.getCasing(object.getKind(), object);
            if (casing == null) {
                NameChecker.$$$reportNull$$$0(12);
            }
            return casing;
        }
        ObjectKind kind = ((SqlReferenceExpression)target2).getReferenceElementType().getTargetKind();
        DasObject context = NameChecker.getDasContext(((SqlReferenceExpression)target2).getQualifierExpression());
        Casing casing = casingProvider.getCasing(kind, context);
        if (casing == null) {
            NameChecker.$$$reportNull$$$0(13);
        }
        return casing;
    }

    private boolean compareWithSource(Object target2, String targetActual, Case sourceCase, boolean caseSensitive) {
        String sourceActual = caseSensitive ? this.getSourceActual(sourceCase) : this.sourceText;
        return NameChecker.compareNames(target2, targetActual, sourceActual, caseSensitive);
    }

    private static boolean compareNames(Object target2, String targetActual, String sourceActual, boolean caseSensitive) {
        return Comparing.strEqual((String)targetActual, (String)sourceActual, (boolean)caseSensitive);
    }

    private String getSourceActual(Case sourceCase) {
        if (sourceCase == Case.EXACT || sourceCase == Case.MIXED) {
            return this.sourceText;
        }
        int i2 = sourceCase == Case.LOWER ? 0 : 1;
        return this.actualCache[i2] == null ? sourceCase.apply(this.sourceText) : this.actualCache[i2];
    }

    @Nullable
    private static String getActualName(Object o, @Nullable String name2, boolean isPlain, @NotNull CasingProvider casing) {
        ObjectKind kind;
        if (casing == null) {
            NameChecker.$$$reportNull$$$0(14);
        }
        if (name2 == null || name2 == DasUtil.NO_NAME) {
            return null;
        }
        ObjectKind objectKind = o instanceof DasObject ? ((DasObject)o).getKind() : (kind = o instanceof SqlReferenceExpression ? ((SqlReferenceExpression)o).getReferenceElementType().getTargetKind() : ObjectKind.TABLE);
        if (kind == ObjectKind.SCHEMA && StringUtil.isEmpty((String)name2) && o instanceof DbElement) {
            return QNameUtil.getQualifiedName((DbElement)o);
        }
        Casing casing1 = casing.getCasing(kind, (DasObject)ObjectUtils.tryCast((Object)o, DasObject.class));
        return casing1.choose(isPlain).apply(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/NameChecker";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/NameChecker";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isQuoted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAltName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getActualName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

