/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreePatternSerialization {
    private static final Logger LOG = Logger.getInstance(TreePatternSerialization.class);

    public static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePattern pattern, boolean compact) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            TreePatternSerialization.$$$reportNull$$$0(1);
        }
        if (pattern.root != null && pattern.root.groups.length != 0) {
            if (compact) {
                TreePatternSerialization.serializeRootCompact(writer, pattern.root);
            } else {
                TreePatternSerialization.serialize(writer, pattern.root, false, null);
            }
        }
    }

    @Nullable
    public static TreePattern deserialize(@NotNull HierarchicalStreamReader reader) {
        TreePatternNode node;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(2);
        }
        return (node = TreePatternSerialization.deserializeNode(reader, true, true)) == null ? null : new TreePattern(node);
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode<?> node, boolean compact, @Nullable TreePatternNode.Group parentGroup) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(3);
        }
        if (node == null) {
            TreePatternSerialization.$$$reportNull$$$0(4);
        }
        writer.startNode("node");
        if (compact) {
            if (parentGroup != null) {
                writer.addAttribute("kind", parentGroup.kind.code());
            }
            if (((TreePatternNode.BaseNaming)node.naming).names.length == 1) {
                TreePatternSerialization.serializeInner(writer, ((TreePatternNode.BaseNaming)node.naming).names[0]);
            }
        }
        if (node.naming instanceof TreePatternNode.NegativeNaming) {
            writer.addAttribute("negative", "1");
        }
        if (!compact || ((TreePatternNode.BaseNaming)node.naming).names.length > 1) {
            for (ObjectName objectName : ((TreePatternNode.BaseNaming)node.naming).names) {
                TreePatternSerialization.serialize(writer, objectName);
            }
        }
        if (compact) {
            TreePatternSerialization.serializeCompact(writer, node.groups);
        } else {
            for (TreePatternNode.Group group2 : node.groups) {
                TreePatternSerialization.serialize(writer, group2);
            }
        }
        writer.endNode();
    }

    private static void serializeRootCompact(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode<TreePatternNode.NegativeNaming> root2) {
        boolean compactRoot;
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(5);
        }
        if (root2 == null) {
            TreePatternSerialization.$$$reportNull$$$0(6);
        }
        boolean bl = compactRoot = root2.groups.length == 0 || root2.groups.length == 1 && root2.groups[0].size() < 2;
        if (compactRoot) {
            TreePatternSerialization.serializeCompact(writer, root2.groups);
        } else {
            TreePatternSerialization.serialize(writer, root2, true, null);
        }
    }

    private static void serializeCompact(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode.Group[] groups) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(7);
        }
        if (groups == null) {
            TreePatternSerialization.$$$reportNull$$$0(8);
        }
        for (TreePatternNode.Group group2 : groups) {
            if (group2.negativeChild != null) {
                TreePatternSerialization.serialize(writer, group2.negativeChild, true, group2);
            }
            if (group2.positiveChildren == null) continue;
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                TreePatternSerialization.serialize(writer, child, true, group2);
            }
        }
    }

    @Nullable
    private static TreePatternNode deserializeNode(@NotNull HierarchicalStreamReader reader, boolean negNaming, boolean root2) {
        ObjectKind kind;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(9);
        }
        if (!"node".equals(reader.getNodeName())) {
            TreePatternNode.Group group2;
            if (root2 && (group2 = TreePatternSerialization.deserializeGroup(reader)) != null) {
                return TreePatternSerialization.newRootNode(group2);
            }
            return null;
        }
        String rootCode = root2 ? TreePatternSerialization.getKind(reader) : null;
        boolean neg = TreePatternSerialization.isNegativeNode(reader);
        if (neg != negNaming && rootCode == null) {
            TreePatternSerialization.hardWarning("Unexpected naming type");
            return null;
        }
        List names = ContainerUtil.newSmartList();
        ContainerUtil.addIfNotNull((Collection)names, (Object)TreePatternSerialization.deserializeName(reader));
        TreePatternUtils.NodeBuilder builder = new TreePatternUtils.NodeBuilder();
        LinkedHashMap inlineGroups = new LinkedHashMap();
        while (reader.hasMoreChildren()) {
            String string;
            TreePatternUtils.GroupBuilder group3;
            reader.moveDown();
            String tag = reader.getNodeName();
            if ("name".equals(tag)) {
                ObjectName objectName = TreePatternSerialization.deserializeName(reader);
                if (objectName == null) {
                    return null;
                }
                names.add(objectName);
            } else if ("group".equals(tag)) {
                TreePatternNode.Group group2 = TreePatternSerialization.deserializeGroup(reader);
                if (group2 == null) {
                    return null;
                }
                builder.groups.add(group2);
            } else if ("node".equals(tag) && !TreePatternSerialization.deserializeGroupNode(reader, group3 = (TreePatternUtils.GroupBuilder)ContainerUtil.getOrCreate(inlineGroups, (Object)(string = TreePatternSerialization.getKind(reader)), TreePatternUtils.GroupBuilder::new))) {
                return null;
            }
            reader.moveUp();
        }
        for (Map.Entry entry : inlineGroups.entrySet()) {
            kind = TreePatternSerialization.findKind((String)entry.getKey());
            if (kind == null) {
                return null;
            }
            builder.groups.add(((TreePatternUtils.GroupBuilder)entry.getValue()).build(kind));
        }
        TreePatternNode.BaseNaming naming = TreePatternSerialization.instantiateNaming(neg, names);
        TreePatternNode<TreePatternNode.BaseNaming> treePatternNode = builder.build(naming);
        if (rootCode != null) {
            kind = TreePatternSerialization.findKind(rootCode);
            if (kind == null) {
                return null;
            }
            TreePatternUtils.GroupBuilder gb = new TreePatternUtils.GroupBuilder();
            if (neg) {
                gb.negative = treePatternNode;
            } else {
                gb.positives.add(treePatternNode);
            }
            return TreePatternSerialization.newRootNode(gb.build(kind));
        }
        return treePatternNode;
    }

    private static void hardWarning(String s) {
        Application a = ApplicationManager.getApplication();
        if (a == null || a.isUnitTestMode()) {
            LOG.error(s);
        } else {
            LOG.warn(s);
        }
    }

    @NotNull
    private static <T extends TreePatternNode.BaseNaming> TreePatternNode<T> newRootNode(TreePatternNode.Group group2) {
        TreePatternNode<TreePatternNode.NegativeNaming> treePatternNode = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{group2}));
        if (treePatternNode == null) {
            TreePatternSerialization.$$$reportNull$$$0(10);
        }
        return treePatternNode;
    }

    private static String getKind(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(11);
        }
        return reader.getAttribute("kind");
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode.Group group2) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(12);
        }
        if (group2 == null) {
            TreePatternSerialization.$$$reportNull$$$0(13);
        }
        writer.startNode("group");
        writer.addAttribute("kind", group2.kind.code());
        if (group2.negativeChild != null) {
            TreePatternSerialization.serialize(writer, group2.negativeChild, false, null);
        }
        if (group2.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                TreePatternSerialization.serialize(writer, child, false, null);
            }
        }
        writer.endNode();
    }

    @Nullable
    private static TreePatternNode.Group deserializeGroup(@NotNull HierarchicalStreamReader reader) {
        String code;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(14);
        }
        if ((code = TreePatternSerialization.getKind(reader)) == null) {
            return null;
        }
        ObjectKind kind = TreePatternSerialization.findKind(code);
        if (kind == null) {
            return null;
        }
        TreePatternUtils.GroupBuilder builder = new TreePatternUtils.GroupBuilder();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("node".equals(reader.getNodeName()) && !TreePatternSerialization.deserializeGroupNode(reader, builder)) {
                return null;
            }
            reader.moveUp();
        }
        return builder.build(kind);
    }

    @Nullable
    private static ObjectKind findKind(String code) {
        ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(code);
        if (kind == null && "data-source".equals(code)) {
            kind = ObjectKind.ROOT;
        }
        if (kind == null) {
            TreePatternSerialization.hardWarning("Unable to find kind: " + code);
            return null;
        }
        return kind;
    }

    private static boolean deserializeGroupNode(@NotNull HierarchicalStreamReader reader, TreePatternUtils.GroupBuilder builder) {
        boolean neg;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(15);
        }
        if (neg = TreePatternSerialization.isNegativeNode(reader)) {
            if (builder.negative != null) {
                TreePatternSerialization.hardWarning("Unexpected second negative naming");
                return false;
            }
            builder.negative = TreePatternSerialization.deserializeNode(reader, true, false);
            if (builder.negative == null) {
                return false;
            }
        } else {
            TreePatternNode node = TreePatternSerialization.deserializeNode(reader, false, false);
            if (node == null) {
                return false;
            }
            builder.positives.add(node);
        }
        return true;
    }

    private static boolean isNegativeNode(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(16);
        }
        return "1".equals(reader.getAttribute("negative"));
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull ObjectName name2) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(17);
        }
        if (name2 == null) {
            TreePatternSerialization.$$$reportNull$$$0(18);
        }
        writer.startNode("name");
        TreePatternSerialization.serializeInner(writer, name2);
        writer.endNode();
    }

    private static void serializeInner(@NotNull HierarchicalStreamWriter writer, @NotNull ObjectName name2) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(19);
        }
        if (name2 == null) {
            TreePatternSerialization.$$$reportNull$$$0(20);
        }
        writer.addAttribute(name2.quoted ? "qname" : "name", name2.name);
    }

    @Nullable
    private static ObjectName deserializeName(HierarchicalStreamReader reader) {
        boolean quoted = "1".equals(reader.getAttribute("quoted"));
        String name2 = reader.getAttribute("name");
        if (name2 == null) {
            name2 = reader.getAttribute("qname");
            quoted = true;
        }
        if (name2 == null) {
            return null;
        }
        return new ObjectName(name2, quoted);
    }

    @NotNull
    private static TreePatternNode.BaseNaming instantiateNaming(boolean neg, List<ObjectName> names) {
        TreePatternNode.BaseNaming baseNaming = neg ? new TreePatternNode.NegativeNaming(ObjectName.toArray(names)) : new TreePatternNode.PositiveNaming(ObjectName.toArray(names));
        if (baseNaming == null) {
            TreePatternSerialization.$$$reportNull$$$0(21);
        }
        return baseNaming;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/TreePatternSerialization";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/TreePatternSerialization";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newRootNode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateNaming";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeRootCompact";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serializeCompact";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserializeNode";
                break;
            }
            case 10: 
            case 21: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeGroup";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deserializeGroupNode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isNegativeNode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "serializeInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

