/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseObjectCommentEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DatabaseColumnEditor
extends DatabaseEditorBaseEx {
    private static final int CUSTOM_COMPONENT_COLUMN = 3;
    private static final int CUSTOM_COMPONENT_ROWS = 2;
    private static final int CUSTOM_COMPONENT_ROW = 0;
    private EditorTextField myNameField;
    private JPanel myMainPanel;
    private EditorTextField myTypeEditor;
    private JCheckBox myNotNullCheckBox;
    private EditorTextField myDefaultField;
    private JPanel myBoxesPanel;
    private JBCheckBox myAutoIncCheckBox;
    private JPanel myCommentHolder;
    private JBLabel myDefaultFieldLabel;
    private JPanel myDefaultFieldPanel;
    private final ColumnEditorModel myColumnModel;
    private final DatabaseEditorCapabilities.ColumnEditorCaps myCaps;

    public DatabaseColumnEditor(@NotNull DatabaseEditorState state2, @NotNull ColumnEditorModel model, @NotNull DatabaseEditorCapabilities.ColumnEditorCaps caps) {
        if (state2 == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(1);
        }
        if (caps == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(2);
        }
        super(state2);
        this.myColumnModel = model;
        this.myCaps = caps;
        this.$$$setupUI$$$();
        JButton commentBtn = DatabaseObjectCommentEditor.createButton(this.getContext(), this.myColumnModel, (JComponent)this.myDefaultField);
        this.myCommentHolder.add((Component)commentBtn, "Center");
        this.applyCaps();
        this.setupControls();
    }

    protected void applyCaps() {
        this.myCommentHolder.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentHolder.getComponent(0).setEnabled(this.myCaps.getComment().isAvailable());
        this.myNameField.setEnabled(this.myCaps.getRename().isAvailable());
        this.myTypeEditor.setEnabled(this.myCaps.getDataType().isAvailable());
        this.myDefaultField.setEnabled(this.myCaps.getDefault().isAvailable());
        if (!this.myCaps.getDefault().isSupported()) {
            this.myMainPanel.remove((Component)this.myDefaultFieldLabel);
            this.myMainPanel.remove(this.myDefaultFieldPanel);
        }
        this.myNotNullCheckBox.setVisible(this.myCaps.getNotNull().isSupported());
        this.myNotNullCheckBox.setEnabled(this.myCaps.getNotNull().isAvailable());
        this.myAutoIncCheckBox.setVisible(this.myCaps.getAutoInc().isSupported());
        this.myAutoIncCheckBox.setEnabled(this.myCaps.getAutoInc().isAvailable());
    }

    private void setupControls() {
        this.initSubscriptions();
        this.updateFromModel();
    }

    protected final void setCustomComponent(@NotNull JComponent component, @NotNull GridConstraints constraints) {
        if (component == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(3);
        }
        if (constraints == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(4);
        }
        GridConstraints cloned = (GridConstraints)constraints.clone();
        cloned.setColumn(3);
        cloned.setRow(0);
        cloned.setRowSpan(2);
        this.myMainPanel.add((Component)component, cloned);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myNameField.getFocusTarget();
        if (jComponent == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = (JComponent[])ArrayUtil.mergeArrays((Object[])this.getEditorFocusableComponents(), (Object[])this.getOtherFocusableComponents());
        if (jComponentArray == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(7);
        }
        return jComponentArray;
    }

    @NotNull
    protected JComponent[] getEditorFocusableComponents() {
        JComponent[] jComponentArray = (JComponent[])ContainerUtil.ar((Object[])new JComponent[]{this.myNameField.getFocusTarget(), this.myTypeEditor.getFocusTarget(), this.myDefaultField.getFocusTarget()});
        if (jComponentArray == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(8);
        }
        return jComponentArray;
    }

    @NotNull
    protected JComponent[] getOtherFocusableComponents() {
        JComponent[] jComponentArray = (JComponent[])ContainerUtil.ar((Object[])new JCheckBox[]{this.myNotNullCheckBox, this.myAutoIncCheckBox});
        if (jComponentArray == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(9);
        }
        return jComponentArray;
    }

    protected void createUIComponents() {
        this.myBoxesPanel = new JPanel();
        this.myBoxesPanel.setLayout(new BoxLayout(this.myBoxesPanel, 0));
        SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)this.getContext().getProject());
        SqlLanguageDialect sqlDialect = this.getContext().getSqlDialect();
        this.myNameField = new EditorTextField(this.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        DbDataSource dataSource = this.getContext().getDataSource();
        SearchPath searchPath = this.getContext().getSearchPath();
        this.myTypeEditor = DatabaseDialogsHelper.createLanguageEditorField((PsiFile)psiFacade.createTypeElementFragment((Language)sqlDialect, dataSource, searchPath, ""));
        this.myDefaultField = DatabaseDialogsHelper.createLanguageEditorField((PsiFile)psiFacade.createExpressionFragment((Language)sqlDialect, dataSource, searchPath, ""));
        this.myNameField.addSettingsProvider(RefactoringUIUtil.SELECT_ALL_ON_FOCUS);
        this.myTypeEditor.addSettingsProvider(RefactoringUIUtil.SELECT_ALL_ON_FOCUS);
        this.myDefaultField.addSettingsProvider(RefactoringUIUtil.SELECT_ALL_ON_FOCUS);
    }

    @NotNull
    public ColumnEditorModel getColumnModel() {
        ColumnEditorModel columnEditorModel = this.myColumnModel;
        if (columnEditorModel == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(10);
        }
        return columnEditorModel;
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeColumn> getModel() {
        ColumnEditorModel columnEditorModel = this.getColumnModel();
        if (columnEditorModel == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(11);
        }
        return columnEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseColumnEditor.setValue(this.myNameField, this.myColumnModel.getName());
        DatabaseColumnEditor.setValue(this.myTypeEditor, this.myColumnModel.getDataType());
        DatabaseColumnEditor.setValue(this.myDefaultField, StringUtil.notNullize((String)this.myColumnModel.getDefault()));
        DatabaseColumnEditor.setValue(this.myNotNullCheckBox, this.myColumnModel.isNotNull());
        DatabaseColumnEditor.setValue((JCheckBox)this.myAutoIncCheckBox, this.myColumnModel.isAutoInc());
    }

    private void initSubscriptions() {
        this.myColumnModel.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseColumnEditor.this.updateFromModel();
            }
        }, this);
        this.myTypeEditor.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!DatabaseColumnEditor.this.myUpdating) {
                    DatabaseColumnEditor.this.myColumnModel.setDataType(e.getDocument().getText());
                    DatabaseColumnEditor.this.myColumnModel.commit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseColumnEditor$2", "documentChanged"));
            }
        });
        this.myNameField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!DatabaseColumnEditor.this.myUpdating) {
                    DatabaseColumnEditor.this.myColumnModel.setName(e.getDocument().getText());
                    DatabaseColumnEditor.this.myColumnModel.commit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseColumnEditor$3", "documentChanged"));
            }
        });
        this.myDefaultField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!DatabaseColumnEditor.this.myUpdating) {
                    DatabaseColumnEditor.this.myColumnModel.setDefault(StringUtil.nullize((String)e.getDocument().getText()));
                    DatabaseColumnEditor.this.myColumnModel.commit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseColumnEditor$4", "documentChanged"));
            }
        });
        this.myNotNullCheckBox.addItemListener(e -> {
            if (!this.myUpdating) {
                this.myColumnModel.setNotNull(this.myNotNullCheckBox.isSelected());
                this.myColumnModel.commit();
            }
        });
        this.myAutoIncCheckBox.addItemListener(e -> {
            if (!this.myUpdating) {
                this.myColumnModel.setAutoInc(this.myAutoIncCheckBox.isSelected());
                this.myColumnModel.commit();
            }
        });
    }

    public void addToBoxesPanel(@NotNull JComponent component) {
        if (component == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(12);
        }
        this.myBoxesPanel.add(component);
    }

    @NotNull
    public JCheckBox getNotNullCheckBox() {
        JCheckBox jCheckBox = this.myNotNullCheckBox;
        if (jCheckBox == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(13);
        }
        return jCheckBox;
    }

    @NotNull
    public JCheckBox getAutoIncCheckBox() {
        JBCheckBox jBCheckBox = this.myAutoIncCheckBox;
        if (jBCheckBox == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(14);
        }
        return jBCheckBox;
    }

    @NotNull
    public EditorTextField getTypeEditor() {
        EditorTextField editorTextField = this.myTypeEditor;
        if (editorTextField == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(15);
        }
        return editorTextField;
    }

    @NotNull
    public EditorTextField getNameEditor() {
        EditorTextField editorTextField = this.myNameField;
        if (editorTextField == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(16);
        }
        return editorTextField;
    }

    @NotNull
    public EditorTextField getDefaultEditor() {
        EditorTextField editorTextField = this.myDefaultField;
        if (editorTextField == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(17);
        }
        return editorTextField;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ColumnEditorCaps getCaps() {
        DatabaseEditorCapabilities.ColumnEditorCaps columnEditorCaps = this.myCaps;
        if (columnEditorCaps == null) {
            DatabaseColumnEditor.$$$reportNull$$$0(18);
        }
        return columnEditorCaps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseColumnEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseColumnEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusableComponents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFocusableComponents";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherFocusableComponents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullCheckBox";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoIncCheckBox";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeEditor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameEditor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultEditor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCustomComponent";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addToBoxesPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name:");
        jBLabel2.setDisplayedMnemonic('A');
        jBLabel2.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        EditorTextField editorTextField = this.myNameField;
        editorTextField.setEnabled(true);
        editorTextField.setText("");
        jPanel3.add((Component)editorTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 7, 0, null, new Dimension(100, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Type:");
        jBLabel3.setDisplayedMnemonic('Y');
        jBLabel3.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myTypeEditor;
        editorTextField2.setText("");
        jPanel3.add((Component)editorTextField2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(100, -1), null));
        JPanel jPanel4 = this.myBoxesPanel;
        jPanel4.setLayout(new FlowLayout(1, 5, 5));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 4, 4, 0, 3, 3, null, null, null));
        this.myNotNullCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        jCheckBox.setText("Not null");
        jCheckBox.setMnemonic('N');
        jCheckBox.setDisplayedMnemonicIndex(4);
        Component component = jPanel4.add(jCheckBox);
        this.myAutoIncCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Auto inc");
        jBCheckBox.setMnemonic('I');
        jBCheckBox.setDisplayedMnemonicIndex(5);
        Component component2 = jPanel4.add((Component)jBCheckBox);
        this.myDefaultFieldLabel = jBLabel = new JBLabel();
        jBLabel.setText("Default:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDefaultFieldPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 0, null, new Dimension(100, -1), null));
        EditorTextField editorTextField3 = this.myDefaultField;
        editorTextField3.setText("");
        jPanel2.add((Component)editorTextField3, "Center");
        this.myCommentHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "East");
        jBLabel2.setLabelFor((Component)editorTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

