/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Insets;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseScriptDialog
extends DialogWrapper {
    protected final Project myProject;
    protected final DbDataSource mySource;
    protected final SearchPath mySearchPath;
    protected final SqlPreviewPanel myPreviewPanel;

    public DatabaseScriptDialog(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String title) {
        if (project == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.mySource = dataSource;
        this.mySearchPath = searchPath;
        this.myPreviewPanel = new SqlPreviewPanel(this.myProject, this.mySource, this.mySearchPath, "", this.getDimensionServiceKey(), false, () -> this.close(1)){

            @Override
            @NotNull
            public List<AnAction> createActions(@NotNull DbDataSource delegate) {
                if (delegate == null) {
                    1.$$$reportNull$$$0(0);
                }
                List<AnAction> res2 = super.createActions(delegate);
                res2.add(0, DatabaseScriptDialog.createSettingsPopupAction((Getter<ScriptingTask>)((Getter)() -> DatabaseScriptDialog.this.getTask()), (Consumer<ScriptingOptions>)((Consumer)o -> DatabaseScriptDialog.this.settingsChanged((ScriptingOptions)o))));
                List<AnAction> list = res2;
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "delegate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createActions";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.setTitle(title);
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected abstract ScriptingTask getTask();

    public static JBPopup showSettingsPopup(ScriptingTask task, Consumer<ScriptingOptions> callback) {
        Ref panel = Ref.create();
        panel.set((Object)new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> {
            callback.consume((Object)((ScriptOptionsPanel)panel.get()).gatherOptions());
            return Unit.INSTANCE;
        })));
        ((ScriptOptionsPanel)panel.get()).adjustOptionsUI(task, task.getOptions());
        JComponent component = ((ScriptOptionsPanel)panel.get()).getComponent();
        UIUtil.addInsets((JComponent)component, (Insets)UIUtil.PANEL_REGULAR_INSETS);
        return JBPopupFactory.getInstance().createComponentPopupBuilder(component, component).setRequestFocus(true).createPopup();
    }

    public static AnAction createSettingsPopupAction(final Getter<ScriptingTask> task, final Consumer<ScriptingOptions> callback) {
        return new ActionGroup("Settings", null, AllIcons.General.GearPlain){
            {
                super(arg0, arg1, arg2);
                this.setPopup(true);
            }

            public boolean isDumbAware() {
                return true;
            }

            public boolean canBePerformed(@NotNull DataContext context) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            public boolean disableIfNoVisibleChildren() {
                return false;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                JBPopup popup = DatabaseScriptDialog.showSettingsPopup((ScriptingTask)task.get(), (Consumer<ScriptingOptions>)callback);
                DbUIUtil.showPopup(popup, null, e);
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                if (AnAction.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(2);
                }
                return AnAction.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "canBePerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static JComponent createSettingsPopupButton(Getter<ScriptingTask> task, Consumer<ScriptingOptions> callback) {
        return DbUIUtil.createActionComponent(DatabaseScriptDialog.createSettingsPopupAction(task, callback));
    }

    protected abstract void settingsChanged(ScriptingOptions var1);

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPreviewPanel;
    }

    public String getStatement() {
        return this.myPreviewPanel.getQuery();
    }

    protected void doOKAction() {
        this.runScript();
        super.doOKAction();
    }

    @NotNull
    public CompletionStage<?> runScript() {
        DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(this.myProject, DbImplUtil.getLocalDataSource((DasDataSource)this.mySource), this.mySearchPath).setStatement(this.getStatement());
        this.fillContext(handler);
        CompletionStage<?> completionStage = handler.runStatements(false);
        if (completionStage == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(4);
        }
        return completionStage;
    }

    protected void fillContext(DatabaseRefactoringHandler handler) {
    }

    protected void updateText(ScriptingResult script) {
        this.updateText(script.getScriptText());
    }

    protected void updateText(String script) {
        this.myPreviewPanel.setQuery(script);
    }

    public void initAndShow() {
        this.init();
        this.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

