/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import icons.DatabaseIcons;
import org.jetbrains.annotations.NotNull;

public class DbSchemasTree
extends DbCheckBoxTree<MyNode> {
    public DbSchemasTree(@NotNull CheckedTreeNode root2) {
        if (root2 == null) {
            DbSchemasTree.$$$reportNull$$$0(0);
        }
        super(root2, new MyTreeCellRenderer());
    }

    public static CheckedTreeNode createNode(MyNode node) {
        return new CheckedTreeNode(node){

            public boolean isChecked() {
                return ((MyNode)this.getUserObject()).isChecked();
            }

            public void setChecked(boolean checked) {
                ((MyNode)this.getUserObject()).setChecked(checked);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/view/ui/DbSchemasTree", "<init>"));
    }

    public static class MyNode
    extends DbCheckBoxTree.MyNode<MyNode> {
        public MyNode(String name2, ObjectKind kind, Object object) {
            super(name2, kind, object);
        }

        @Override
        @NotNull
        protected MyNode createAll() {
            MyNode myNode = new MyNode("All", this.getAllKind(), "*");
            if (myNode == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            return myNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbSchemasTree$MyNode", "createAll"));
        }
    }

    private static class MyTreeCellRenderer
    extends DbCheckBoxTree.CellWithUnderlinedAllRenderer<MyNode> {
        private MyTreeCellRenderer() {
        }

        @Override
        protected void customizeCheckboxRenderer(MyNode node) {
            if (node.getParent() == null) {
                return;
            }
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (node.getObject() instanceof LocalDataSource) {
                renderer.setIcon(((LocalDataSource)node.getObject()).getBaseIcon());
            } else if (node.getObject() instanceof SqlDataSource) {
                renderer.setIcon(DatabaseIcons.DdlDbms);
            }
            this.renderText(node, (ColoredTextContainer)renderer);
        }

        @Override
        protected void renderText(MyNode node, ColoredTextContainer renderer) {
            String name2 = node.getName();
            if (node.getObject() instanceof DasObject || node.getObject() instanceof DasDataSource) {
                if (StringUtil.isEmpty((String)name2)) {
                    renderer.append("<Unnamed>", SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    renderer.append(name2, node.isShadow() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            } else if (node.getObject() == "*") {
                ObjectKind kind = node.getKind();
                String pluralized = StringUtil.toLowerCase((String)StringUtil.pluralize((String)(kind == ObjectKind.ROOT ? "data source" : kind.name())));
                renderer.append("All " + StringUtil.capitalizeWords((String)pluralized, (boolean)true), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                renderer.append(StringUtil.isEmpty((String)name2) ? "<Unnamed>" : name2, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            }
        }
    }
}

