/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.exasol.ExaDdlParsing;
import com.intellij.sql.dialects.exasol.ExaDialect;
import com.intellij.sql.dialects.exasol.ExaDmlParsing;
import com.intellij.sql.dialects.exasol.ExaExpressionParsing;
import com.intellij.sql.dialects.exasol.ExaGeneratedParser;
import com.intellij.sql.injection.SqlSuggestedInjection;
import org.jetbrains.annotations.Nullable;

public class ExaParser
extends SqlParser {
    public static final SqlSuggestedInjection EXASOL_INJECTION = new SqlSuggestedInjection("Exa");

    public ExaParser() {
        super(ExaDialect.INSTANCE);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return ExaGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return ExaGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return ExaDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = ExaExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        return ExaGeneratedParser.parse_extra_roots_(root2, builder, level);
    }

    @Override
    protected boolean parseExternalParameterImpl(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        if (builder.getTokenType() == SQL_OP_BITWISE_AND && this.isIdentifierToken(builder, builder.rawLookup(1), true, false)) {
            PsiBuilder.Marker mark2 = builder.mark();
            if (builder.rawLookup(2) == SQL_PERIOD) {
                builder.advanceLexer();
            }
            builder.advanceLexer();
            builder.advanceLexer();
            mark2.done((IElementType)SQL_PARAMETER_REFERENCE);
            this.myExternalReferenceJustParsed = true;
            return true;
        }
        return super.parseExternalParameterImpl(builder, checkStart, checkEnd);
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, ExaExpressionParsing::parenthesized_values_expr, ExaDmlParsing::top_query_expression, ExaParser::parseTopQueryExpressionTail, ExaExpressionParsing::row_element_list, (b2, l) -> ExaExpressionParsing.root_expr_0(b2, l, -1) && ExaExpressionParsing.row_element_list_separator(b2, l) && ExaExpressionParsing.row_element_list(b2, l));
    }

    @Override
    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return EXASOL_INJECTION;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, ExaExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ExaDdlParsing.type_element(builder, level);
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first2) {
        return SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_STRING_TOKEN);
    }

    @Override
    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean res2 = super.parseFunctionArgument(builder, level, optional, allowBoolean);
        if (res2) {
            ExaDmlParsing.order_by_clause(builder, level);
        }
        return res2;
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        ExaGeneratedParser.within_group_clause(builder, level);
        ExaGeneratedParser.analytic_clause(builder, level);
        ExaGeneratedParser.emits_clause(builder, level);
        return true;
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return ExaGeneratedParser.table_opt_column_list(builder, level);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        ExaDmlParsing.query_expression_0(builder, level, -1);
        return ExaDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

