/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.mssql.MsDdlParsing;
import com.intellij.sql.dialects.mssql.MsDialect;
import com.intellij.sql.dialects.mssql.MsDmlParsing;
import com.intellij.sql.dialects.mssql.MsElementTypes;
import com.intellij.sql.dialects.mssql.MsExpressionParsing;
import com.intellij.sql.dialects.mssql.MsGeneratedParser;
import com.intellij.sql.dialects.mssql.MsOptionalKeywords;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsParser
extends SqlParser {
    private static final GeneratedParserUtilBase.Parser NOT_GO = (b2, l) -> {
        if (b2.getTokenType() == SQL_OP_NOT2 && b2.rawLookup(1) == SQL_OP_NOT2 && b2.rawLookup(2) == SQL_COLON && b2.rawLookup(3) == MsOptionalKeywords.TSQL_GO) {
            return false;
        }
        return b2.getTokenType() != SQL_GO;
    };
    private static final GeneratedParserUtilBase.Parser PARSE_GO = (b2, l) -> {
        if (NOT_GO.parse(b2, l)) {
            return false;
        }
        if (b2.getTokenType() == SQL_OP_NOT2) {
            b2.advanceLexer();
            b2.advanceLexer();
            b2.advanceLexer();
        }
        GeneratedParserUtilBase.consumeToken((PsiBuilder)b2, (IElementType)MsOptionalKeywords.TSQL_GO);
        return true;
    };

    public MsParser() {
        super(MsDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b2) {
        return false;
    }

    @Override
    public void parseScriptDefault(PsiBuilder builder) {
        SqlGeneratedParserUtil.parseAsTree(builder, 0, SQL_DUMMY_BLOCK, false, new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder builder, int level) {
                return MsParser.this.parseBatchBlock(builder, MsElementTypes.Misc.MSSQL_BATCH_BLOCK, PARSE_GO, NOT_GO);
            }
        }, GeneratedParserUtilBase.TRUE_CONDITION);
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        return MsGeneratedParser.parse_extra_roots_(root2, builder, level);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        boolean result2;
        boolean bl = result2 = MsDdlParsing.sqlcmd_statement(builder, level) || MsGeneratedParser.statement(builder, level);
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_SEMICOLON)) {
            this.statementSeparatorParsed(builder);
        }
        return result2;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, MsExpressionParsing::evaluable_expression);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return MsGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return MsDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return MsDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = MsExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    @Override
    @Nullable
    protected IElementType getOdbcTokenType(@Nullable String text2) {
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"guid")) {
            return ODBC_GENERIC;
        }
        return super.getOdbcTokenType(text2);
    }

    @Override
    protected boolean allowNoStatementSeparator() {
        return true;
    }

    @Override
    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType resultType) {
        String tokenText = builder.getTokenText();
        String string = tokenText = tokenText == null ? null : StringUtil.toUpperCase((String)tokenText);
        if (this.getLanguage().getSupportedFunctions().contains(tokenText)) {
            return false;
        }
        return super.parseParameterReferenceInner(builder, resultType);
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        LighterASTNode refMarker = (LighterASTNode)ObjectUtils.assertNotNull((Object)builder.getLatestDoneMarker());
        Pair<String, Boolean> name2 = this.extractString(builder, refMarker.getStartOffset(), refMarker.getEndOffset());
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        if ("openjson".equalsIgnoreCase(((String)name2.first).trim())) {
            MsDmlParsing.json_columns_clause(builder, level);
        }
        if ("openxml".equalsIgnoreCase(((String)name2.first).trim())) {
            MsDmlParsing.openxml_with_clause(builder, level);
        }
        MsDmlParsing.within_group_clause(builder, level);
        MsDmlParsing.analytic_clause(builder, level);
        return true;
    }

    @Override
    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_ALL)) {
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_ALL);
        } else if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_DISTINCT)) {
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_DISTINCT);
        }
        return super.parseFunctionArgument(builder, level, optional, allowBoolean);
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, MsExpressionParsing::parenthesized_values_expr, MsExpressionParsing::subquery, MsParser::parseTopQueryExpressionTail, MsExpressionParsing::row_element_list, (b2, l) -> MsExpressionParsing.root_expr_0(b2, l, -1) && MsExpressionParsing.row_element_list_separator(b2, l) && MsExpressionParsing.row_element_list(b2, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, MsDmlParsing::parenthesized_aliased_join_expression, MsDmlParsing::parenthesized_query_join_expression_inner, MsParser::parseTopQueryExpressionTail, (b2, l) -> MsDmlParsing.join_expression(b2, l, -1), (b2, l) -> MsDmlParsing.join_expression_0(b2, l, -1));
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return MsGeneratedParser.table_opt_column_list(builder, level);
    }

    private static boolean is(@Nullable SqlFunctionDefinition def, @NotNull String type) {
        if (type == null) {
            MsParser.$$$reportNull$$$0(0);
        }
        if (def == null) {
            return false;
        }
        return "true".equals(def.getDialectAttribute(type));
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        MsDmlParsing.query_expression_0(builder, level, -1);
        return MsDmlParsing.left_inner_table_op_tail(builder, level);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/dialects/mssql/MsParser", "is"));
    }
}

