/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.dataFlow.PgDFABuildingVisitor;
import com.intellij.sql.dialects.postgres.dataFlow.PgErrorSpecHelper;
import com.intellij.sql.dialects.postgres.psi.PgCreatePreparedStatement;
import com.intellij.sql.dialects.postgres.refactoring.PgExtractFunctionHelper;
import com.intellij.sql.dialects.postgres.refactoring.PgExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Pg83Dialect
extends PgDialectBase {
    public Pg83Dialect(@NotNull String id) {
        if (id == null) {
            Pg83Dialect.$$$reportNull$$$0(0);
        }
        super(id);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        Object preparedStatement;
        String nameUC;
        if (element2 == null) {
            Pg83Dialect.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            Pg83Dialect.$$$reportNull$$$0(2);
        }
        if (!super.processReservedEntitiesWithType(name2, element2, resolve, processor)) {
            return false;
        }
        String string = nameUC = name2 == null ? null : StringUtil.toUpperCase((String)name2);
        if (resolve && name2 != null && LazyData.ARG_PATTERN.matcher(name2).matches() && (preparedStatement = (PgCreatePreparedStatement)PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{PgCreatePreparedStatement.class})) != null && !processor.executeTarget(((PgCreatePreparedStatement)((Object)preparedStatement)).getArgument(name2), element2, (SqlType)SqlType.UNKNOWN, null, ResolveState.initial())) {
            return false;
        }
        if (this.inPl(element2) && this.getQualifier(element2) == null) {
            if (SqlImplUtil.equalsInsensitiveOrTrue(LazyData.RE_FOUND.name, name2, resolve) && !processor.executeTarget(LazyData.RE_FOUND, element2, this.booleanType(), false, ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue(LazyData.SQLSTATE.name, name2, resolve) && Pg83Dialect.raiseStatement(element2) && !processor.executeTarget(LazyData.SQLSTATE, element2, this.integerType(), false, ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue(LazyData.SQLERRM.name, name2, resolve) && Pg83Dialect.raiseStatement(element2) && !processor.executeTarget(LazyData.SQLERRM, element2, this.stringType(), false, ResolveState.initial())) {
                return false;
            }
        }
        if (processor.isExpected(PgElementTypes.Kinds.OPERATOR_CLASS)) {
            if (!resolve) {
                for (DasObject target2 : LazyData.RE_OPS.values()) {
                    if (processor.executeTarget(target2, element2, SqlTypeFactory.REFERENCE, false, ResolveState.initial())) continue;
                    return false;
                }
            } else if (LazyData.RE_OPS.containsKey(nameUC) && !processor.executeTarget(LazyData.RE_OPS.get(nameUC), element2, SqlTypeFactory.REFERENCE, false, ResolveState.initial())) {
                return false;
            }
        }
        if (processor.isExpected(SqlDbElementType.ACCESS_METHOD)) {
            for (ReservedEntity am : LazyData.RE_PG_AMS) {
                if (Pg83Dialect.processReservedEntitiesWithTypeSimple(am, SqlTypeFactory.REFERENCE, name2, element2, resolve, processor, false, null)) continue;
                return false;
            }
        }
        if (processor.isExpected(SqlDbElementType.COLUMN)) {
            SqlExpression expression;
            boolean process2 = true;
            if (!resolve && (expression = this.getQualifier(element2)) != null && expression.getSqlType() == SqlType.UNKNOWN) {
                process2 = false;
            }
            if (process2) {
                for (DasObject entity : LazyData.RESERVED_INTEGER_ENTITIES.values()) {
                    if (Pg83Dialect.processReservedEntitiesWithTypeSimple(entity, this.integerType(), name2, element2, resolve, processor, true, false)) continue;
                    return false;
                }
            }
        }
        if (element2 instanceof SqlReferenceExpression) {
            SqlReferenceElementType type = ((SqlReferenceExpression)element2).getReferenceElementType();
            if (type == SqlCompositeElementTypes.SQL_TABLESPACE_REFERENCE) {
                if (!Pg83Dialect.processReservedEntitiesWithTypeSimple(LazyData.RE_PG_DEFAULT, SqlTypeFactory.REFERENCE, name2, element2, resolve, processor, false, false)) {
                    return false;
                }
                if (!Pg83Dialect.processReservedEntitiesWithTypeSimple(LazyData.RE_PG_GLOBAL, SqlTypeFactory.REFERENCE, name2, element2, resolve, processor, false, false)) {
                    return false;
                }
            }
            if (((SqlReferenceExpression)element2).getQualifierExpression() == null) {
                for (ReservedEntity object : this.getReservedObjects()) {
                    if (processor.executeTarget(object, element2, null, false, ResolveState.initial())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new PgExtractVariableHelper(this);
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return PgExtractFunctionHelper.INSTANCE;
    }

    @NotNull
    protected abstract List<ReservedEntity> getReservedObjects();

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == PgElementTypes.Kinds.OPERATOR_CLASS || type == PgElementTypes.Kinds.OPERATOR_FAMILY || type == PgElementTypes.Kinds.TEXT_SEARCH_PARSER || type == PgElementTypes.Kinds.TEXT_SEARCH_DICTIONARY || type == PgElementTypes.Kinds.TEXT_SEARCH_CONFIGURATION || type == PgElementTypes.Kinds.TEXT_SEARCH_TEMPLATE || type == PgElementTypes.Kinds.LANGUAGE) {
            result2.add((ObjectKind)SqlDbElementType.SCHEMA);
        }
        return super.getParentDbTypes(result2, type);
    }

    @Override
    @NotNull
    public SqlType getDefinitionType(@NotNull SqlTypedDefinition definition, @Nullable PsiElement usage) {
        if (definition == null) {
            Pg83Dialect.$$$reportNull$$$0(3);
        }
        int usageOffset = usage == null ? Integer.MAX_VALUE : usage.getTextOffset();
        SqlType defined = definition.getSqlType();
        if (SqlType.Category.RECORD.is(defined) && this.inPl((PsiElement)definition)) {
            SqlExpression right;
            SqlBlockStatementImpl block = (SqlBlockStatementImpl)PsiTreeUtil.getTopmostParentOfType((PsiElement)definition, SqlBlockStatementImpl.class);
            Query search2 = block == null ? ReferencesSearch.search((PsiElement)definition) : ReferencesSearch.search((PsiElement)definition, (SearchScope)new LocalSearchScope((PsiElement)block));
            Ref targetUsage = Ref.create();
            search2.forEach(ref -> {
                PsiElement element2 = ref.getElement();
                PsiElement parent2 = element2.getParent();
                if (parent2 instanceof SqlSelectIntoClause || parent2 instanceof SqlSetAssignment && ((SqlSetAssignment)parent2).getLValue() == element2) {
                    targetUsage.set((Object)parent2);
                } else if (parent2 instanceof SqlBinaryExpression) {
                    SqlExpression operand = ((SqlBinaryExpression)parent2).getLOperand();
                    IElementType sign = ((SqlBinaryExpression)parent2).getOpSign();
                    if (operand == element2 && (sign == SqlCommonTokens.SQL_OP_ASSIGN || sign == SqlCommonTokens.SQL_OP_EQ)) {
                        targetUsage.set((Object)parent2);
                    }
                }
                int offset = element2.getTextOffset();
                return offset < usageOffset;
            });
            if (targetUsage.get() instanceof SqlSelectIntoClause) {
                SqlType type;
                SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)targetUsage.get()), SqlQueryExpression.class);
                if (query != null) {
                    SqlType sqlType = query.getSqlType();
                    if (sqlType == null) {
                        Pg83Dialect.$$$reportNull$$$0(4);
                    }
                    return sqlType;
                }
                SqlReturningClause returningClause = (SqlReturningClause)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)targetUsage.get()), SqlReturningClause.class);
                SqlType sqlType = type = returningClause != null ? returningClause.getSqlType() : null;
                if (type != null) {
                    SqlType sqlType2 = type;
                    if (sqlType2 == null) {
                        Pg83Dialect.$$$reportNull$$$0(5);
                    }
                    return sqlType2;
                }
            } else if (targetUsage.get() instanceof SqlBinaryExpression) {
                SqlExpression right2 = ((SqlBinaryExpression)targetUsage.get()).getROperand();
                if (right2 != null) {
                    SqlType sqlType = right2.getSqlType();
                    if (sqlType == null) {
                        Pg83Dialect.$$$reportNull$$$0(6);
                    }
                    return sqlType;
                }
            } else if (targetUsage.get() instanceof SqlSetAssignment && (right = (SqlExpression)ObjectUtils.tryCast((Object)((SqlSetAssignment)targetUsage.get()).getRValue(), SqlExpression.class)) != null) {
                SqlType sqlType = right.getSqlType();
                if (sqlType == null) {
                    Pg83Dialect.$$$reportNull$$$0(7);
                }
                return sqlType;
            }
        }
        SqlType sqlType = super.getDefinitionType(definition, usage);
        if (sqlType == null) {
            Pg83Dialect.$$$reportNull$$$0(8);
        }
        return sqlType;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectName dbName = Pg83Dialect.getDbName(dataSource);
        DasNamespace namespace = Pg83Dialect.getDefaultNamespace(dataSource, dbName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == SqlDbElementType.SCHEMA ? null : TreePatternUtils.create(PgDialect.LazyData.PUBLIC_NAME, SqlDbElementType.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                Pg83Dialect.$$$reportNull$$$0(9);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbName, TreePatternUtils.create(PgDialect.LazyData.PUBLIC_NAME, SqlDbElementType.SCHEMA, new TreePatternNode.Group[0])))));
        if (treePattern == null) {
            Pg83Dialect.$$$reportNull$$$0(10);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            Pg83Dialect.$$$reportNull$$$0(11);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(ObjectName.quoted((String)"pg_catalog")), true, SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA);
        if (treePattern == null) {
            Pg83Dialect.$$$reportNull$$$0(12);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public SqlTableType createSequenceType(@NotNull PsiElement element2, @Nullable PsiElement object) {
        if (element2 == null) {
            Pg83Dialect.$$$reportNull$$$0(13);
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(ContainerUtil.newArrayList((Object[])new SqlImplUtil.Column[]{SqlDialectImplUtil.col(element2, object, "sequence_name", this.stringType()), SqlDialectImplUtil.col(element2, object, "last_value", this.integerType()), SqlDialectImplUtil.col(element2, object, "start_value", this.integerType()), SqlDialectImplUtil.col(element2, object, "increment_by", this.integerType()), SqlDialectImplUtil.col(element2, object, "max_value", this.integerType()), SqlDialectImplUtil.col(element2, object, "min_value", this.integerType()), SqlDialectImplUtil.col(element2, object, "cache_value", this.integerType()), SqlDialectImplUtil.col(element2, object, "long_cnt", this.integerType()), SqlDialectImplUtil.col(element2, object, "is_cycled", this.booleanType()), SqlDialectImplUtil.col(element2, object, "is_called", this.booleanType())}), element2);
        if (sqlTableType == null) {
            Pg83Dialect.$$$reportNull$$$0(14);
        }
        return sqlTableType;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable PsiElement element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            Pg83Dialect.$$$reportNull$$$0(15);
        }
        if (type == SqlDbElementType.OBJECT_ATTRIBUTE && expectedTypes.contains(SqlDbElementType.COLUMN)) {
            return true;
        }
        if (strict) {
            return false;
        }
        if (SqlDialectImplUtil.isLabelOrRoutineQualification(element2, type, place, isCompletion)) {
            return true;
        }
        if (expectedTypes.contains(SqlDbElementType.COLUMN) || expectedTypes.contains(SqlDbElementType.ANY)) {
            boolean isTable;
            boolean bl = isTable = type == SqlDbElementType.TABLE;
            if (type == SqlDbElementType.LOCAL_ALIAS) {
                if (element2 == null) {
                    isTable = true;
                } else {
                    PsiElement parent2 = element2.getParent();
                    boolean bl2 = isTable = parent2 instanceof SqlFromClause || parent2 instanceof SqlJoinExpression;
                }
            }
            if (isTable) {
                SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
                return ref == null || ref.getQualifierExpression() == null;
            }
        }
        if (type == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element2, type, expectedTypes, place, false, isCompletion);
    }

    @Override
    public boolean isAutoIncrementColumn(@NotNull DasColumn column2) {
        if (column2 == null) {
            Pg83Dialect.$$$reportNull$$$0(16);
        }
        if (super.isAutoIncrementColumn(column2)) {
            return true;
        }
        String type = column2.getDataType().getSpecification();
        return LazyData.SERIAL_PATTERN.matcher(type).matches();
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            Pg83Dialect.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != SqlDbElementType.CURSOR && super.shallResolve(o, type);
    }

    @Nullable
    protected SqlExpression getQualifier(@NotNull PsiElement element2) {
        SqlReferenceExpression ref;
        if (element2 == null) {
            Pg83Dialect.$$$reportNull$$$0(18);
        }
        return (ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)element2, SqlReferenceExpression.class)) == null ? null : ref.getQualifierExpression();
    }

    @Override
    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        PgDFABuildingVisitor pgDFABuildingVisitor = new PgDFABuildingVisitor(this);
        if (pgDFABuildingVisitor == null) {
            Pg83Dialect.$$$reportNull$$$0(19);
        }
        return pgDFABuildingVisitor;
    }

    @Override
    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        PgErrorSpecHelper pgErrorSpecHelper = PgErrorSpecHelper.INSTANCE;
        if (pgErrorSpecHelper == null) {
            Pg83Dialect.$$$reportNull$$$0(20);
        }
        return pgErrorSpecHelper;
    }

    public boolean inPl(PsiElement element2) {
        return SqlFileElementType.isInPl(element2);
    }

    private static boolean raiseStatement(@NotNull PsiElement element2) {
        SqlStatement statement;
        if (element2 == null) {
            Pg83Dialect.$$$reportNull$$$0(21);
        }
        return (statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class)) != null && statement.getNode().getElementType() == PgElementTypes.Misc.PG_RAISE_STATEMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 13: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/Pg83Dialect";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/Pg83Dialect";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSequenceType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDFAVisitor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSequenceType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "raiseStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        static final Pattern ARG_PATTERN = Pattern.compile("\\$\\d+");
        static final Pattern SERIAL_PATTERN = Pattern.compile("(?i)(?:big|small)?serial|serial[248]");
        static final List<ReservedEntity> RE_PG_AMS = Arrays.asList(new ReservedEntity("btree", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("hash", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("gist", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("spgist", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("gin", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("brin", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("bloom", SqlDbElementType.ACCESS_METHOD));
        static final Map<String, DasObject> RESERVED_INTEGER_ENTITIES = SqlDialectImplUtil.buildEntities(SqlDbElementType.COLUMN, "OID", "TABLEOID", "XMIN", "CMIN", "XMAX", "CMAX", "CTID");
        static final ReservedEntity RE_PG_DEFAULT = new ReservedEntity("pg_default", SqlDbElementType.TABLESPACE);
        static final ReservedEntity RE_PG_GLOBAL = new ReservedEntity("pg_global", SqlDbElementType.TABLESPACE);
        static final ReservedEntity RE_FOUND = new ReservedEntity("FOUND", SqlDbElementType.COLUMN);
        static final ReservedEntity SQLSTATE = new ReservedEntity("SQLSTATE", SqlDbElementType.COLUMN);
        static final ReservedEntity SQLERRM = new ReservedEntity("SQLERRM", SqlDbElementType.COLUMN);
        static final Map<String, DasObject> RE_OPS = SqlDialectImplUtil.buildEntities(PgElementTypes.Kinds.OPERATOR_CLASS, "INTEGER_OPS", "TEXT_PATTERN_OPS", "INT8_OPS", "INT4_OPS", "INT2_OPS", "VARCHAR_PATTERN_OPS", "BPCHAR_PATTERN_OPS", "JSONB_PATH_OPS");
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_IF, SqlCommonTokens.SQL_SEMICOLON}).mask(true, true, false))));
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(SqlDbElementType.KEY, SqlDbElementType.INDEX, SqlDbElementType.TRIGGER, SqlDbElementType.RULE, SqlDbElementType.POLICY);

        private LazyData() {
        }
    }
}

