/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.PsiColumn;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInsertIntoGeneratedColumnInspection$WhenMappings;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertOverridingClause;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlInsertIntoGeneratedColumnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "ComputedInsertPolicy", "IdentityInsertPolicy", "intellij.database.sql.impl"})
public final class SqlInsertIntoGeneratedColumnInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        IdentityInsertPolicy identityPolicy;
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        ComputedInsertPolicy computedPolicy = dbms2.isClickHouse() || dbms2.isTransactSql() ? ComputedInsertPolicy.NEVER : (dbms2.isDb2() || dbms2.isDerby() || dbms2.isHsqldb() || dbms2.isMysql() || dbms2.isOracle() || dbms2.isPostgres() ? ComputedInsertPolicy.DEFAULT_ONLY : null);
        IdentityInsertPolicy identityInsertPolicy = dbms2.isDb2() || dbms2.isDerby() || dbms2.isHsqldb() || dbms2.isOracle() || Intrinsics.areEqual((Object)dbms2, (Object)Dbms.POSTGRES) ? IdentityInsertPolicy.DEFAULT_OR_OVERRIDE : (dbms2.isVertica() ? IdentityInsertPolicy.NEVER : (identityPolicy = dbms2.isTransactSql() ? IdentityInsertPolicy.BY_SET_IDENTITY_INSERT : null));
        if (computedPolicy == null && identityPolicy == null) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(computedPolicy, identityPolicy, onTheFly, manager, dialect, result2, manager, dialect, result2){
            final /* synthetic */ ComputedInsertPolicy $computedPolicy;
            final /* synthetic */ IdentityInsertPolicy $identityPolicy;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            /*
             * WARNING - void declaration
             */
            public void visitSqlInsertStatement(@NotNull SqlInsertStatement o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                SqlInsertDmlInstruction sqlInsertDmlInstruction = o.getDmlInstruction();
                if (sqlInsertDmlInstruction == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlInsertDmlInstruction, (String)"o.dmlInstruction ?: return");
                SqlInsertDmlInstruction dmlInstruction = sqlInsertDmlInstruction;
                SqlTableColumnsList columnsList = dmlInstruction.getColumnsList();
                SqlTableType targetType = dmlInstruction.getTargetType();
                int n = 0;
                SqlTableType sqlTableType = targetType;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlTableType, (String)"targetType");
                int n2 = sqlTableType.getColumnCount();
                while (n < n2) {
                    PsiColumn column2;
                    PsiElement psiElement;
                    SqlReferenceExpression columnRef;
                    Object object;
                    void index2;
                    PsiElement psiElement2 = targetType.getColumnElement((int)index2);
                    if (!(psiElement2 instanceof SqlReferenceExpression)) {
                        psiElement2 = null;
                    }
                    if ((SqlReferenceExpression)psiElement2 != null) {
                        SqlReferenceExpression sqlReferenceExpression;
                        boolean bl = false;
                        boolean bl2 = false;
                        SqlReferenceExpression it2 = sqlReferenceExpression;
                        boolean bl3 = false;
                        object = PsiTreeUtil.isAncestor((PsiElement)((PsiElement)columnsList), (PsiElement)((PsiElement)it2), (boolean)true) ? sqlReferenceExpression : null;
                    } else {
                        object = columnRef = null;
                    }
                    if (!((psiElement = targetType.getSourceColumnElement((int)index2)) instanceof PsiColumn)) {
                        psiElement = null;
                    }
                    if ((PsiColumn)psiElement == null) {
                    } else if (SqlImplUtil.isComputedVal(column2)) {
                        this.checkComputed(columnRef, dmlInstruction, (int)index2);
                    } else if (SqlImplUtil.isAutoVal(column2)) {
                        this.checkIdentity(column2, columnRef, dmlInstruction, (int)index2);
                    }
                    ++index2;
                }
            }

            private final void checkComputed(SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction, int index2) {
                ComputedInsertPolicy computedInsertPolicy = this.$computedPolicy;
                if (computedInsertPolicy != null) {
                    switch (SqlInsertIntoGeneratedColumnInspection$WhenMappings.$EnumSwitchMapping$0[computedInsertPolicy.ordinal()]) {
                        case 1: {
                            this.reportOnColumnOrTableRef("Insertion into generated column is not supported", columnRef, dmlInstruction);
                            break;
                        }
                        case 2: {
                            this.checkDefault("Only DEFAULT may be inserted into generated column", dmlInstruction, index2, columnRef);
                        }
                    }
                }
            }

            private final void checkDefault(String message2, SqlInsertDmlInstruction dmlInstruction, int index2, SqlReferenceExpression columnRef) {
                SqlValuesExpression sqlValuesExpression = dmlInstruction.getValuesExpression();
                if (sqlValuesExpression != null && (sqlValuesExpression = sqlValuesExpression.getExpressions()) != null) {
                    Iterable $this$forEach$iv = (Iterable)sqlValuesExpression;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        boolean isDefaultExpr;
                        Object object;
                        SqlExpression it2 = (SqlExpression)element$iv;
                        boolean bl = false;
                        SqlExpression sqlExpression = it2;
                        if (!(sqlExpression instanceof SqlExpressionList)) {
                            sqlExpression = null;
                        }
                        SqlExpression columnExpr = (object = (SqlExpressionList)sqlExpression) != null && (object = object.getExpressionList()) != null ? (SqlExpression)CollectionsKt.getOrNull((List)object, (int)index2) : null;
                        boolean bl2 = isDefaultExpr = columnExpr instanceof SqlLiteralExpression && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)((SqlLiteralExpression)columnExpr).getFirstChild()), (Object)SqlCommonKeywords.SQL_DEFAULT);
                        if (columnExpr == null || isDefaultExpr) continue;
                        this.reportIssue((SqlElement)columnExpr, message2, ProblemHighlightType.GENERIC_ERROR);
                    }
                }
                if (columnRef != null) {
                    this.reportIssue((SqlElement)columnRef, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private final void checkIdentity(PsiColumn column2, SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction, int index2) {
                String errorMessage = "Insertion into identity/autoincrement column is not supported";
                IdentityInsertPolicy identityInsertPolicy = this.$identityPolicy;
                if (identityInsertPolicy != null) {
                    switch (SqlInsertIntoGeneratedColumnInspection$WhenMappings.$EnumSwitchMapping$1[identityInsertPolicy.ordinal()]) {
                        case 1: {
                            this.reportOnColumnOrTableRef(errorMessage, columnRef, dmlInstruction);
                            break;
                        }
                        case 2: {
                            if (columnRef == null || this.hasSetIdentityInsert(dmlInstruction)) {
                                return;
                            }
                            this.reportIssue((SqlElement)columnRef, errorMessage, ProblemHighlightType.GENERIC_ERROR);
                            break;
                        }
                        case 3: {
                            if (PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)dmlInstruction), SqlInsertOverridingClause.class) != null) {
                                return;
                            }
                            if (!this.isForcedAutoVal(column2)) {
                                return;
                            }
                            this.checkDefault("Only DEFAULT may be inserted into identity/autoincrement column", dmlInstruction, index2, columnRef);
                        }
                    }
                }
            }

            private final boolean isForcedAutoVal(@NotNull PsiColumn $this$isForcedAutoVal) {
                boolean bl;
                block7: {
                    Object v1;
                    PsiElement it2;
                    block6: {
                        if (!($this$isForcedAutoVal instanceof SqlColumnDefinition)) {
                            return false;
                        }
                        JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)$this$isForcedAutoVal);
                        Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"SqlImplUtil\n          .sqlChildren(this)");
                        Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it2 = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE)) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    PsiElement psiElement = v1;
                    if (psiElement == null) {
                        return false;
                    }
                    PsiElement identityClause = psiElement;
                    JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren(identityClause);
                    Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"SqlImplUtil.sqlChildren(identityClause)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it2 = (PsiElement)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_ALWAYS)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final boolean hasSetIdentityInsert(SqlInsertDmlInstruction dmlInstruction) {
                for (PsiElement currentContext = dmlInstruction.getParent(); currentContext != null && !(currentContext instanceof SqlBatchBlock) && !(currentContext instanceof SqlFile); currentContext = currentContext.getParent()) {
                    Object v2;
                    block2: {
                        JBIterable<PsiElement> jBIterable = SqlImplUtil.revSiblings(currentContext);
                        Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"SqlImplUtil.revSiblings(currentContext)");
                        Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl = false;
                            PsiElement psiElement = it2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
                            if (!this.isSetIdentityInsert(psiElement, dmlInstruction)) continue;
                            v2 = element$iv;
                            break block2;
                        }
                        v2 = null;
                    }
                    PsiElement setClause = v2;
                    if (setClause == null) continue;
                    return Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)setClause.getLastChild()), (Object)SqlCommonKeywords.SQL_ON);
                }
                return false;
            }

            private final boolean isSetIdentityInsert(PsiElement element2, SqlInsertDmlInstruction dmlInstruction) {
                if (!(element2 instanceof SqlSetStatement)) {
                    return false;
                }
                PsiElement psiElement = ((SqlSetStatement)element2).getFirstChild();
                if (psiElement == null) {
                    return false;
                }
                PsiElement anchor = psiElement;
                PsiElement psiElement2 = PsiTreeUtil.findSiblingForward((PsiElement)anchor, (IElementType)((IElementType)SqlCommonKeywords.SQL_IDENTITY_INSERT), (boolean)true, null);
                if (psiElement2 == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"PsiTreeUtil.findSiblingF\u2026          ?: return false");
                PsiElement identityInsert = psiElement2;
                PsiElement psiElement3 = PsiTreeUtil.findSiblingForward((PsiElement)identityInsert, (IElementType)((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE), (boolean)true, null);
                if (!(psiElement3 instanceof SqlReferenceExpression)) {
                    psiElement3 = null;
                }
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement3;
                if (sqlReferenceExpression == null) {
                    return false;
                }
                SqlReferenceExpression tableRef = sqlReferenceExpression;
                SqlExpression sqlExpression = dmlInstruction.getTargetExpression();
                if (!(sqlExpression instanceof SqlReferenceExpression)) {
                    sqlExpression = null;
                }
                SqlReferenceExpression sqlReferenceExpression2 = (SqlReferenceExpression)sqlExpression;
                if (sqlReferenceExpression2 == null) {
                    return false;
                }
                SqlReferenceExpression insertTableRef = sqlReferenceExpression2;
                PsiElement psiElement4 = tableRef.resolve();
                if (psiElement4 == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"tableRef.resolve() ?: return false");
                PsiElement affectedTable = psiElement4;
                PsiElement psiElement5 = insertTableRef.resolve();
                if (psiElement5 == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"insertTableRef.resolve() ?: return false");
                PsiElement insertTable = psiElement5;
                return Intrinsics.areEqual((Object)affectedTable, (Object)insertTable);
            }

            private final void reportOnColumnOrTableRef(String message2, SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction) {
                SqlExpression anchor;
                SqlReferenceExpression sqlReferenceExpression = columnRef;
                SqlExpression sqlExpression = anchor = sqlReferenceExpression != null ? (SqlExpression)sqlReferenceExpression : dmlInstruction.getTargetExpression();
                if (anchor != null) {
                    this.reportIssue((SqlElement)anchor, message2, ProblemHighlightType.GENERIC_ERROR);
                }
            }

            private final void reportIssue(SqlElement element2, String message2, ProblemHighlightType level) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)element2, message2, true, level, this.$onTheFly, new LocalQuickFix[0]));
            }
            {
                this.$computedPolicy = $captured_local_variable$0;
                this.$identityPolicy = $captured_local_variable$1;
                this.$onTheFly = $captured_local_variable$2;
                this.$manager = $captured_local_variable$3;
                this.$dialect = $captured_local_variable$4;
                this.$result = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        };
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/inspections/SqlInsertIntoGeneratedColumnInspection$ComputedInsertPolicy;", "", "(Ljava/lang/String;I)V", "DEFAULT_ONLY", "NEVER", "intellij.database.sql.impl"})
    private static final class ComputedInsertPolicy
    extends Enum<ComputedInsertPolicy> {
        public static final /* enum */ ComputedInsertPolicy DEFAULT_ONLY;
        public static final /* enum */ ComputedInsertPolicy NEVER;
        private static final /* synthetic */ ComputedInsertPolicy[] $VALUES;

        static {
            ComputedInsertPolicy[] computedInsertPolicyArray = new ComputedInsertPolicy[2];
            ComputedInsertPolicy[] computedInsertPolicyArray2 = computedInsertPolicyArray;
            computedInsertPolicyArray[0] = DEFAULT_ONLY = new ComputedInsertPolicy();
            computedInsertPolicyArray[1] = NEVER = new ComputedInsertPolicy();
            $VALUES = computedInsertPolicyArray;
        }

        public static ComputedInsertPolicy[] values() {
            return (ComputedInsertPolicy[])$VALUES.clone();
        }

        public static ComputedInsertPolicy valueOf(String string) {
            return Enum.valueOf(ComputedInsertPolicy.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/inspections/SqlInsertIntoGeneratedColumnInspection$IdentityInsertPolicy;", "", "(Ljava/lang/String;I)V", "DEFAULT_OR_OVERRIDE", "BY_SET_IDENTITY_INSERT", "NEVER", "intellij.database.sql.impl"})
    private static final class IdentityInsertPolicy
    extends Enum<IdentityInsertPolicy> {
        public static final /* enum */ IdentityInsertPolicy DEFAULT_OR_OVERRIDE;
        public static final /* enum */ IdentityInsertPolicy BY_SET_IDENTITY_INSERT;
        public static final /* enum */ IdentityInsertPolicy NEVER;
        private static final /* synthetic */ IdentityInsertPolicy[] $VALUES;

        static {
            IdentityInsertPolicy[] identityInsertPolicyArray = new IdentityInsertPolicy[3];
            IdentityInsertPolicy[] identityInsertPolicyArray2 = identityInsertPolicyArray;
            identityInsertPolicyArray[0] = DEFAULT_OR_OVERRIDE = new IdentityInsertPolicy();
            identityInsertPolicyArray[1] = BY_SET_IDENTITY_INSERT = new IdentityInsertPolicy();
            identityInsertPolicyArray[2] = NEVER = new IdentityInsertPolicy();
            $VALUES = identityInsertPolicyArray;
        }

        public static IdentityInsertPolicy[] values() {
            return (IdentityInsertPolicy[])$VALUES.clone();
        }

        public static IdentityInsertPolicy valueOf(String string) {
            return Enum.valueOf(IdentityInsertPolicy.class, string);
        }
    }
}

