/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLimitClause;
import com.intellij.sql.psi.SqlOffsetClause;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantLimitInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlRedundantLimitInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        SqlFunctionDefinition sqlFunctionDefinition;
        String functionName;
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        String string = functionName = dbms2.isCassandra() || dbms2.isClickHouse() || dbms2.isHive() || dbms2.isSpark() ? null : (dbms2.isPostgres() ? "exists" : "EXISTS");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it2 = string2;
            boolean bl3 = false;
            sqlFunctionDefinition = dialect.getSupportedFunctions().get(it2);
        } else {
            sqlFunctionDefinition = null;
        }
        SqlFunctionDefinition existsFunction = sqlFunctionDefinition;
        return new SqlInspectionBase.SqlAnnotationVisitor(existsFunction, onTheFly, manager, dialect, result2, manager, dialect, result2){
            final /* synthetic */ SqlFunctionDefinition $existsFunction;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                super.visitSqlQueryExpression(o);
                PsiElement parent2 = o.getParent();
                if (parent2 instanceof SqlParenthesizedExpression) {
                    PsiElement psiElement = ((SqlParenthesizedExpression)parent2).getParent();
                    if (!(psiElement instanceof SqlUnaryExpression)) {
                        psiElement = null;
                    }
                    SqlUnaryExpression sqlUnaryExpression = (SqlUnaryExpression)psiElement;
                    if (sqlUnaryExpression == null) {
                        return;
                    }
                    SqlUnaryExpression unaryExpr = sqlUnaryExpression;
                    if (Intrinsics.areEqual((Object)unaryExpr.getOpSign(), (Object)SqlCommonKeywords.SQL_EXISTS)) {
                        this.reportQuery(o);
                    }
                } else if (parent2 instanceof SqlExpressionList) {
                    if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)parent2), (Object)SqlCompositeElementTypes.SQL_ARGUMENT_LIST) ^ true) {
                        return;
                    }
                    PsiElement psiElement = ((SqlExpressionList)parent2).getParent();
                    if (!(psiElement instanceof SqlFunctionCallExpression)) {
                        psiElement = null;
                    }
                    SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement;
                    if (sqlFunctionCallExpression == null) {
                        return;
                    }
                    SqlFunctionCallExpression call2 = sqlFunctionCallExpression;
                    if (Intrinsics.areEqual((Object)call2.getFunctionDefinition(), (Object)((Object)this.$existsFunction))) {
                        this.reportQuery(o);
                    }
                }
            }

            private final void reportQuery(SqlQueryExpression query) {
                JBIterable jBIterable = query.getLimitClauses();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"query.limitClauses");
                SqlLimitClause sqlLimitClause = (SqlLimitClause)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
                if (sqlLimitClause == null) {
                    return;
                }
                SqlLimitClause limitClause = sqlLimitClause;
                JBIterable jBIterable2 = query.getOffsetClauses();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"query.offsetClauses");
                SqlOffsetClause sqlOffsetClause = (SqlOffsetClause)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable2));
                if ((sqlOffsetClause != null ? sqlOffsetClause.getOffsetExpression() : null) == null) {
                    PsiElement psiElement = limitClause.getFirstChild();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"limitClause.firstChild");
                    String string = psiElement.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"limitClause.firstChild.text");
                    String string2 = string;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toUpperCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
                    String keyword = string4;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)limitClause, (PsiElement)limitClause, keyword + " clause is redundant here", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[]{DropPsiFix.INSTANCE}));
                }
            }
            {
                this.$existsFunction = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$dialect = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }
}

