/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlConvertEqualityToInIntention;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0004H\u0016J#\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\u0016\u001a\u00020\u0015*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u0017\u001a\u00020\u0015*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0019*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention;", "Lcom/intellij/codeInsight/intention/BaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "getInfo", "Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention$Info;", "element", "Lcom/intellij/psi/PsiElement;", "getLeftmostOrExpression", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "dbms", "Lcom/intellij/database/Dbms;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "isEquality", "isOr", "split", "Lkotlin/Pair;", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "Lcom/intellij/sql/psi/SqlExpression;", "Info", "intellij.database.sql.impl"})
public final class SqlConvertEqualityToInIntention
extends BaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Replace equality checks with IN expression";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    private final boolean isEquality(@NotNull SqlBinaryExpression $this$isEquality, Dbms dbms) {
        IElementType iElementType = $this$isEquality.getOpSign();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_EQ)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_EQEQ) && (dbms.isClickHouse() || dbms.isHive() || dbms.isSpark() || dbms.isSqlite());
    }

    private final boolean isOr(@NotNull SqlBinaryExpression $this$isOr, Dbms dbms) {
        IElementType iElementType = $this$isOr.getOpSign();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_OR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_LOGICAL_OR) && dbms.isMysql();
    }

    private final kotlin.Pair<SqlReferenceExpression, SqlExpression> split(@NotNull SqlBinaryExpression $this$split, Dbms dbms) {
        if (!this.isEquality($this$split, dbms)) {
            return null;
        }
        SqlExpression sqlExpression = $this$split.getLOperand();
        if (!(sqlExpression instanceof SqlReferenceExpression)) {
            sqlExpression = null;
        }
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression left = sqlReferenceExpression;
        SqlExpression sqlExpression2 = $this$split.getROperand();
        if (sqlExpression2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression2, (String)"rOperand ?: return null");
        SqlExpression right = sqlExpression2;
        return TuplesKt.to((Object)left, (Object)right);
    }

    private final SqlBinaryExpression getLeftmostOrExpression(PsiElement element2, Dbms dbms) {
        Object v2;
        block5: {
            JBIterable jBIterable = SqlImplUtil.sqlParents(element2).filter(SqlBinaryExpression.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SqlImplUtil\n        .sql\u2026ryExpression::class.java)");
            Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlBinaryExpression it2 = (SqlBinaryExpression)element$iv;
                boolean bl = false;
                SqlBinaryExpression sqlBinaryExpression = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlBinaryExpression, (String)"it");
                if (!this.isOr(sqlBinaryExpression, dbms)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        SqlBinaryExpression sqlBinaryExpression = v2;
        if (sqlBinaryExpression == null) {
            return null;
        }
        SqlBinaryExpression currentOrExpr = sqlBinaryExpression;
        while (true) {
            SqlBinaryExpression lOperand;
            SqlExpression sqlExpression;
            if (!((sqlExpression = currentOrExpr.getLOperand()) instanceof SqlBinaryExpression)) {
                sqlExpression = null;
            }
            if ((SqlBinaryExpression)sqlExpression == null) {
                break;
            }
            if (!this.isOr(lOperand, dbms)) break;
            currentOrExpr = lOperand;
        }
        return currentOrExpr;
    }

    /*
     * WARNING - void declaration
     */
    private final Info getInfo(PsiElement element2) {
        void subject;
        kotlin.Pair<SqlReferenceExpression, SqlExpression> pair;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(element)");
        Dbms dbms = sqlLanguageDialectEx.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"SqlImplUtil.getSqlDialectSafe(element).dbms");
        Dbms dbms2 = dbms;
        SqlBinaryExpression sqlBinaryExpression = this.getLeftmostOrExpression(element2, dbms2);
        if (sqlBinaryExpression == null) {
            return null;
        }
        SqlBinaryExpression currentOrExpr = sqlBinaryExpression;
        SqlBinaryExpression lastOrExpr = null;
        SqlExpression sqlExpression = currentOrExpr.getLOperand();
        if (!(sqlExpression instanceof SqlBinaryExpression)) {
            sqlExpression = null;
        }
        if ((pair = (kotlin.Pair<SqlReferenceExpression, SqlExpression>)sqlExpression) == null || (pair = this.split((SqlBinaryExpression)pair, dbms2)) == null) {
            return null;
        }
        kotlin.Pair<SqlReferenceExpression, SqlExpression> pair2 = pair;
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)pair2.component1();
        SqlExpression firstValue = (SqlExpression)pair2.component2();
        List<Pair<PsiElement, PsiElement>> list = SqlImplUtil.resolveQualified((SqlReferenceExpression)subject);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"SqlImplUtil.resolveQualified(subject)");
        List<Pair<PsiElement, PsiElement>> resolvedSubject = list;
        SqlReferenceExpression sqlReferenceExpression2 = new ArrayList();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$apply = sqlReferenceExpression2;
        boolean bl3 = false;
        Collection collection = (Collection)$this$apply;
        SqlExpression sqlExpression2 = firstValue;
        boolean bl4 = false;
        collection.add(sqlExpression2);
        SqlReferenceExpression values2 = sqlReferenceExpression2;
        while (true) {
            List<Pair<PsiElement, PsiElement>> resolvedCurrentSubject;
            void currentSubject;
            kotlin.Pair<SqlReferenceExpression, SqlExpression> pair3;
            SqlExpression sqlExpression3;
            if (!((sqlExpression3 = currentOrExpr.getROperand()) instanceof SqlBinaryExpression)) {
                sqlExpression3 = null;
            }
            if ((pair3 = (kotlin.Pair<SqlReferenceExpression, SqlExpression>)sqlExpression3) == null || (pair3 = this.split((SqlBinaryExpression)pair3, dbms2)) == null) {
                return null;
            }
            kotlin.Pair<SqlReferenceExpression, SqlExpression> pair4 = pair3;
            sqlReferenceExpression2 = (SqlReferenceExpression)pair4.component1();
            SqlExpression currentValue = (SqlExpression)pair4.component2();
            Intrinsics.checkExpressionValueIsNotNull(SqlImplUtil.resolveQualified((SqlReferenceExpression)currentSubject), (String)"SqlImplUtil.resolveQualified(currentSubject)");
            if (Intrinsics.areEqual(resolvedCurrentSubject, resolvedSubject) ^ true || resolvedSubject.isEmpty() && Intrinsics.areEqual((Object)currentSubject.getText(), (Object)subject.getText()) ^ true) break;
            $this$apply = (Collection)values2;
            boolean bl5 = false;
            $this$apply.add(currentValue);
            lastOrExpr = currentOrExpr;
            PsiElement parent2 = currentOrExpr.getParent();
            if (!(parent2 instanceof SqlBinaryExpression) || !this.isOr((SqlBinaryExpression)parent2, dbms2)) break;
            currentOrExpr = (SqlBinaryExpression)parent2;
        }
        if (lastOrExpr == null) {
            return null;
        }
        return new Info((SqlExpression)lastOrExpr, (SqlReferenceExpression)subject, (List)values2);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.getInfo(element2) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Info info = this.getInfo(element2);
        if (info == null) {
            return;
        }
        Info info2 = info;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)info2.getExpressionToReplace());
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialec\u2026info.expressionToReplace)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect()).plain(info2.getSubject().getText()).keyword(" in ").plain(CollectionsKt.joinToString$default((Iterable)info2.getValues(), null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)invoke.inExprText.1.INSTANCE, (int)25, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"DdlBuilder()\n      .conf\u2026stfix = \")\") { it.text })");
        String string = ddlBuilder.getStatement();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DdlBuilder()\n      .conf\u2026.text })\n      .statement");
        String inExprText2 = string;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(inExprText2, dialect, project, null);
        if (sqlExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression, (String)"SqlPsiElementFactory.cre\u2026dialect, project, null)!!");
        SqlExpression inExpr = sqlExpression;
        info2.getExpressionToReplace().replace((PsiElement)inExpr);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention$Info;", "", "expressionToReplace", "Lcom/intellij/sql/psi/SqlExpression;", "subject", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "values", "", "(Lcom/intellij/sql/psi/SqlExpression;Lcom/intellij/sql/psi/SqlReferenceExpression;Ljava/util/List;)V", "getExpressionToReplace", "()Lcom/intellij/sql/psi/SqlExpression;", "getSubject", "()Lcom/intellij/sql/psi/SqlReferenceExpression;", "getValues", "()Ljava/util/List;", "intellij.database.sql.impl"})
    private static final class Info {
        @NotNull
        private final SqlExpression expressionToReplace;
        @NotNull
        private final SqlReferenceExpression subject;
        @NotNull
        private final List<SqlExpression> values;

        @NotNull
        public final SqlExpression getExpressionToReplace() {
            return this.expressionToReplace;
        }

        @NotNull
        public final SqlReferenceExpression getSubject() {
            return this.subject;
        }

        @NotNull
        public final List<SqlExpression> getValues() {
            return this.values;
        }

        public Info(@NotNull SqlExpression expressionToReplace, @NotNull SqlReferenceExpression subject, @NotNull List<? extends SqlExpression> values2) {
            Intrinsics.checkParameterIsNotNull((Object)expressionToReplace, (String)"expressionToReplace");
            Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
            Intrinsics.checkParameterIsNotNull(values2, (String)"values");
            this.expressionToReplace = expressionToReplace;
            this.subject = subject;
            this.values = values2;
        }
    }
}

