/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.actions;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.gist.GistManager;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import com.jetbrains.performancePlugin.ui.ConfigureAsyncRunParametersDialog;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ProfileIndexingAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ProfileIndexingAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null) {
            if ((e.getModifiers() & 1) != 0 && !SystemInfo.isWindows) {
                PropertiesComponent.getInstance((Project)project).setValue("performancePlugin.isProfileIndexingWithAsync", true);
                ConfigureAsyncRunParametersDialog dialog = new ConfigureAsyncRunParametersDialog(project);
                dialog.show();
            }
            String product = ApplicationNamesInfo.getInstance().getProductName();
            int result = Messages.showOkCancelDialog((String)("To profile indexing caches should be invalidated and " + product + " restarted."), (String)"Profile Indexing", (String)"Invalidate and Restart", (String)"Cancel", (Icon)Messages.getWarningIcon());
            if (result == 0) {
                if (!(YourKitProfilerHandler.canProfilerBeAttached() || YourKitProfilerHandler.isProfilerInVMFileEnabled() || PropertiesComponent.getInstance((Project)project).getBoolean("performancePlugin.isProfileIndexingWithAsync"))) {
                    try {
                        YourKitProfilerHandler.enablePersistentProfiler();
                    }
                    catch (IOException ex) {
                        Messages.showWarningDialog((Project)project, (String)"Please hold shift to profile indexing with async", (String)"Profiling with YourKit Is Not Supported");
                        return;
                    }
                }
                PropertiesComponent.getInstance((Project)project).setValue("performancePlugin.isProfileIndexing", true);
                FileBasedIndex.getInstance().invalidateCaches();
                GistManager.getInstance().invalidateData();
                for (CachesInvalidator invalidater : (CachesInvalidator[])CachesInvalidator.EP_NAME.getExtensions()) {
                    invalidater.invalidateCaches();
                }
                ApplicationManager.getApplication().restart();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/performancePlugin/actions/ProfileIndexingAction", "actionPerformed"));
    }
}

